/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.datasource.indicator;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.datasource.DefaultDataSourceProvider;
import com.seeyon.cap4.bizportal.datasource.bean.Command;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetResult;
import com.seeyon.cap4.bizportal.datasource.bean.DefaultDataSetList;
import com.seeyon.cap4.bizportal.datasource.indicator.IndicatorDataSetResult;
import com.seeyon.cap4.bizportal.manager.BizPortalReportAdapterManager;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.report.bizportal.bean.ReportDesignDefinition;
import com.seeyon.ctp.report.engine.bean.ReportIndexResult;
import com.seeyon.ctp.report.engine.po.ReportIndex;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class DefaultReportIndicatorDataSourceProvider
extends DefaultDataSourceProvider {
    private BizPortalReportAdapterManager bizPortalReportAdapterManager;

    public int getSortOrder() {
        return 0;
    }

    @Override
    public BizPortalConstants.DataFormat dataFormat() {
        return BizPortalConstants.DataFormat.INDICATOR;
    }

    @Override
    public String uuid() {
        return "ec18b5ba-2125-410c-89be-5429c53c5810";
    }

    @Override
    public String name() {
        return "\u5e94\u7528\u62a5\u8868\u6307\u6807";
    }

    @Override
    public DefaultDataSetList getDataSetList(ContextParam contextParam, DataSetMetadata dataSetMetadata, String[] versions) throws BusinessException {
        DefaultDataSetList dataSetList = new DefaultDataSetList();
        BizConfigBean configBean = this.bizPortalExternAdapterManager.getBizConfigBean(this.getMultiStepId(dataSetMetadata));
        Long bizId = configBean.getId();
        DefaultDataSetList.Node rootNode = dataSetList.createBranchNode(bizId.toString(), this.name());
        dataSetList.addNode(rootNode);
        List<ReportIndex> list = this.bizPortalReportAdapterManager.findReportIndex(ApplicationCategoryEnum.cap4biz.name(), bizId.toString());
        if (CollectionUtils.isNotEmpty(list)) {
            ImmutableListMultimap multimap = Multimaps.index(list, (Function)new Function<ReportIndex, Long>(){

                public Long apply(ReportIndex input) {
                    return input.getReportDesignId();
                }
            });
            List<ReportDesignDefinition> reportConfigs = this.bizPortalReportAdapterManager.findReportDesignDefinition(Lists.newArrayList((Iterable)multimap.keySet()));
            for (ReportDesignDefinition definition : reportConfigs) {
                DefaultDataSetList.Node configNode = dataSetList.createBranchNode(definition.getDesignId().toString(), definition.getTitle(), rootNode.getId());
                dataSetList.addNode(configNode);
                Function<String, String> fullNameFunction = this.getFullNameFunction(configBean, definition);
                for (ReportIndex ri : multimap.get((Object)definition.getDesignId())) {
                    DataSetMetadata metadata = new DataSetMetadata(this.uuid()).attr("bizId", bizId).attr("designId", definition.getDesignId()).attr("indexId", ri.getId());
                    dataSetList.addNode(dataSetList.createLeafNode(this.getNodeId(ri.getId()), ri.getTitle(), (String)fullNameFunction.apply((Object)ri.getTitle()), configNode.getId(), metadata));
                }
            }
        }
        return dataSetList;
    }

    private Function<String, String> getFullNameFunction(final BizConfigBean bizConfigBean, final ReportDesignDefinition designDefinition) {
        return new Function<String, String>(){

            public String apply(String input) {
                return bizConfigBean.getName() + "-" + designDefinition.getTitle() + "-" + input;
            }
        };
    }

    @Override
    public boolean isAllow(ContextParam contextParam, DataSetMetadata metadata, Command command) throws BusinessException {
        return this.bizPortalReportAdapterManager.checkAuth(this.attrRealLong(command, metadata, "designId"), contextParam.getUserId());
    }

    @Override
    public DataSetResult executeQuery(ContextParam contextParam, DataSetMetadata metadata, String[] versions, Command command) throws BusinessException {
        ReportIndexResult indexResult = this.bizPortalReportAdapterManager.getReportIndexResult(this.attrRealLong(command, metadata, "indexId"));
        if (indexResult != null) {
            IndicatorDataSetResult dataSetResult = new IndicatorDataSetResult();
            dataSetResult.setFieldType(indexResult.getOriginalField().getDbType());
            dataSetResult.setSource(indexResult.getRealValue());
            dataSetResult.setValue(indexResult.getDisplay());
            return dataSetResult;
        }
        return null;
    }

    @Override
    public DataSetMetadata beforeDataSetMetaBind(String dataId, DataSetMetadata metadata) throws BusinessException {
        Long bizId = this.getBizId(metadata);
        metadata.attr("designId", this.createBizPortalDataRelation(bizId, dataId, metadata.attrLong("designId")));
        metadata.attr("indexId", this.createBizPortalDataRelation(bizId, dataId, metadata.attrLong("indexId")));
        return metadata;
    }

    @Override
    protected String getId(Command command, DataSetMetadata metadata) throws BusinessException {
        return this.attrRealLong(command, metadata, "indexId").toString();
    }

    public void setBizPortalReportAdapterManager(BizPortalReportAdapterManager bizPortalReportAdapterManager) {
        this.bizPortalReportAdapterManager = bizPortalReportAdapterManager;
    }
}

