/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.datasource.link;

import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.datasource.DefaultDataSourceProvider;
import com.seeyon.cap4.bizportal.datasource.bean.Command;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetResult;
import com.seeyon.cap4.bizportal.datasource.bean.DefaultDataSetList;
import com.seeyon.cap4.bizportal.manager.BizPortalLinkFactoryManager;
import com.seeyon.cap4.bizportal.manager.BizPortalSpaceManager;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.po.CAPPortalSpace;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.ctp.common.exceptions.BusinessException;
import java.util.List;

public class DefaultBizPortalLinkDataSourceProvider
extends DefaultDataSourceProvider {
    private BizPortalSpaceManager bizPortalSpaceManager;
    private BizPortalLinkFactoryManager bizPortalLinkFactoryManager;

    public int getSortOrder() {
        return 2;
    }

    @Override
    public BizPortalConstants.DataFormat dataFormat() {
        return BizPortalConstants.DataFormat.LINK;
    }

    @Override
    public String uuid() {
        return "8503093f-fc93-486e-8eac-ccf75caf77e9";
    }

    @Override
    public String name() {
        return "\u4e1a\u52a1\u7a7a\u95f4";
    }

    @Override
    public DefaultDataSetList getDataSetList(ContextParam contextParam, DataSetMetadata dataSetMetadata, String[] versions) throws BusinessException {
        DefaultDataSetList dataSetList = new DefaultDataSetList();
        BizConfigBean bizConfigBean = this.bizPortalExternAdapterManager.getBizConfigBean(this.getMultiStepId(dataSetMetadata));
        DefaultDataSetList.Node bizNode = dataSetList.createBranchNode(bizConfigBean.getId().toString(), this.name());
        dataSetList.addNode(bizNode);
        List<CAPPortalSpace> list = this.bizPortalSpaceManager.findCAPPortalSpaceByBizId(bizConfigBean.getId(), contextParam.getPlatform());
        for (CAPPortalSpace portalSpace : list) {
            Long spaceId = portalSpace.getId();
            String name = portalSpace.getName();
            DataSetMetadata metadata = new DataSetMetadata(this.uuid()).attr("bizId", bizConfigBean.getId()).attr("spaceId", spaceId);
            dataSetList.addNode(dataSetList.createLeafNode(this.getNodeId(spaceId.toString()), name, bizConfigBean.getName() + "-" + name, bizNode.getId(), metadata));
        }
        return dataSetList;
    }

    @Override
    public boolean isAllow(ContextParam contextParam, DataSetMetadata metadata, Command command) throws BusinessException {
        return this.bizPortalSpaceManager.checkAuth(this.attrRealLong(command, metadata, "spaceId"), contextParam.getUser());
    }

    @Override
    public DataSetResult executeQuery(ContextParam contextParam, DataSetMetadata metadata, String[] versions, Command command) throws BusinessException {
        return this.bizPortalLinkFactoryManager.viewBizPortalSpace(contextParam, this.attrRealLong(command, metadata, "spaceId"));
    }

    @Override
    public DataSetMetadata beforeDataSetMetaBind(String dataId, DataSetMetadata metadata) throws BusinessException {
        return metadata.attr("spaceId", this.createBizPortalDataRelation(this.getBizId(metadata), dataId, metadata.attrLong("spaceId")));
    }

    @Override
    protected String getId(Command command, DataSetMetadata metadata) throws BusinessException {
        return this.attrRealLong(command, metadata, "spaceId").toString();
    }

    public void setBizPortalSpaceManager(BizPortalSpaceManager bizPortalSpaceManager) {
        this.bizPortalSpaceManager = bizPortalSpaceManager;
    }

    public void setBizPortalLinkFactoryManager(BizPortalLinkFactoryManager bizPortalLinkFactoryManager) {
        this.bizPortalLinkFactoryManager = bizPortalLinkFactoryManager;
    }
}

