/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.datasource.link;

import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.datasource.DefaultBizAndFormDataSourceProvider;
import com.seeyon.cap4.bizportal.datasource.bean.Command;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetResult;
import com.seeyon.cap4.bizportal.datasource.bean.DefaultDataSetList;
import com.seeyon.cap4.bizportal.datasource.enums.FormListSignType;
import com.seeyon.cap4.bizportal.datasource.link.LinkDataSetResult;
import com.seeyon.cap4.bizportal.manager.BizPortalLinkFactoryManager;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.utils.BizPortalUtils;
import com.seeyon.cap4.bizportal.utils.EnumCode;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormFlowBusinessBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultFormLinkDataSourceProvider
extends DefaultBizAndFormDataSourceProvider {
    private BizPortalLinkFactoryManager bizPortalLinkFactoryManager;

    public int getSortOrder() {
        return 0;
    }

    @Override
    public BizPortalConstants.DataFormat dataFormat() {
        return BizPortalConstants.DataFormat.LINK;
    }

    @Override
    public String uuid() {
        return "ea77249a-bba9-4750-96c1-bef3337c26c1";
    }

    @Override
    public String name() {
        return "\u8868\u5355\u5e94\u7528";
    }

    @Override
    public DefaultDataSetList getDataSetList(ContextParam contextParam, DataSetMetadata dataSetMetadata, String[] versions) throws BusinessException {
        DefaultDataSetList dataSetList = new DefaultDataSetList();
        if (StringUtils.equals((CharSequence)dataSetMetadata.getSign(), (CharSequence)String.valueOf(ApplicationCategoryEnum.cap4biz.getKey()))) {
            BizConfigBean bizConfigBean = this.bizPortalExternAdapterManager.getBizConfigBean(this.getMultiStepId(dataSetMetadata));
            Long bizId = bizConfigBean.getId();
            DefaultDataSetList.Node bNode = dataSetList.createBranchNode(bizId.toString(), this.name(), "0");
            List<FormBean> formBeans = this.bizPortalExternAdapterManager.findFormBeanByBizId(bizId);
            for (FormBean formBean : formBeans) {
                if (this.bizPortalExternAdapterManager.isFlowBean(formBean)) {
                    this.addFormBeanNode(formBean, bizConfigBean, bNode.getId(), dataSetList);
                    continue;
                }
                for (Map.Entry entry : formBean.getBind().getUnFlowTemplateMap().entrySet()) {
                    FormBindAuthBean bindAuthBean = (FormBindAuthBean)entry.getValue();
                    DefaultDataSetList.Node mNode = dataSetList.createBranchNode(bindAuthBean.getId().toString(), bindAuthBean.getName(), bNode.getId());
                    dataSetList.addNode(mNode);
                    this.addUnFlowTemplateNode(bizConfigBean, formBean.getId(), bindAuthBean, ListAction.New, mNode.getId(), dataSetList);
                    this.addUnFlowTemplateNode(bizConfigBean, formBean.getId(), bindAuthBean, ListAction.List, mNode.getId(), dataSetList);
                }
            }
            if (dataSetList.existChildren(bNode.getId())) {
                dataSetList.addNode(bNode);
            }
        } else {
            DefaultDataSetList.Node fNode = dataSetList.createBranchNode(String.valueOf(ApplicationCategoryEnum.cap4Form.getKey()), this.name(), "0");
            List<FormBean> formBeans = this.bizPortalExternAdapterManager.findFormBeanByOwner(contextParam.getUser());
            if (CollectionUtils.isNotEmpty(formBeans)) {
                for (FormBean formBean : formBeans) {
                    this.addFormBeanNode(formBean, fNode.getId(), dataSetList);
                }
            }
        }
        return dataSetList;
    }

    private void addFormBeanNode(FormBean formBean, BizConfigBean bizConfigBean, String parentId, DefaultDataSetList dataSetList) throws BusinessException {
        List<CtpTemplate> templates = this.bizPortalExternAdapterManager.findCtpTemplateByFormId(formBean.getId());
        for (CtpTemplate ctpTemplate : templates) {
            Long templateId = ctpTemplate.getId();
            DefaultDataSetList.Node tNode = dataSetList.createBranchNode(templateId.toString(), ctpTemplate.getSubject(), parentId);
            dataSetList.addNode(tNode);
            this.addFlowTemplateNode(ctpTemplate, ListAction.New, tNode.getId(), dataSetList, bizConfigBean);
            this.addFlowTemplateNode(ctpTemplate, ListAction.List, tNode.getId(), dataSetList, bizConfigBean);
        }
        for (Map.Entry entry : formBean.getBind().getFlowBusinessMap().entrySet()) {
            FormFlowBusinessBean flowBusinessBean = (FormFlowBusinessBean)entry.getValue();
            if (!Enums.FlowBusinessType.PENDING.getKey().equals(flowBusinessBean.getType())) continue;
            Long moduleId = flowBusinessBean.getId();
            String name = flowBusinessBean.getName();
            int code = ListAction.List.getCode();
            FormListSignType signType = FormListSignType.PENDING_FLOW;
            DataSetMetadata metadata = new DataSetMetadata(this.uuid(), signType.name()).attr("bizId", bizConfigBean.getId()).attr("formId", formBean.getId()).attr("action", code).attr("code", ApplicationCategoryEnum.cap4biz.getKey()).attr("moduleId", moduleId);
            dataSetList.addNode(dataSetList.createLeafNode(this.getNodeId(this.getNodeKey(moduleId, code)), name, bizConfigBean.getName() + "-" + name + "-" + signType.getDisplay(), name + "(" + signType.getDisplay() + ")", parentId, metadata));
        }
    }

    private void addFlowTemplateNode(CtpTemplate template, ListAction listAction, String parentId, DefaultDataSetList dataSetList, BizConfigBean bizConfigBean) {
        Long templateId = template.getId();
        String name = listAction.getName();
        String subject = template.getSubject();
        DataSetMetadata metadata = new DataSetMetadata(this.uuid(), FormListSignType.FLOW.name()).attr("bizId", bizConfigBean.getId()).attr("templateId", templateId).attr("action", listAction.getCode()).attr("code", ApplicationCategoryEnum.cap4biz.getKey());
        dataSetList.addNode(dataSetList.createLeafNode(this.getNodeId(this.getNodeKey(templateId, listAction.getCode())), name, bizConfigBean.getName() + "-" + subject + "-" + name, subject + "(" + name + ")", parentId, metadata));
    }

    private void addFormBeanNode(FormBean formBean, String parentId, DefaultDataSetList dataSetList) throws BusinessException {
        String prefix = "\u8868\u5355\u7ba1\u7406";
        List<CtpTemplate> templates = this.bizPortalExternAdapterManager.findCtpTemplateByFormId(formBean.getId());
        for (CtpTemplate ctpTemplate : templates) {
            Long templateId = ctpTemplate.getId();
            DefaultDataSetList.Node tNode = dataSetList.createBranchNode(templateId.toString(), ctpTemplate.getSubject(), parentId);
            dataSetList.addNode(tNode);
            this.addFlowTemplateNode(ctpTemplate, ListAction.New, tNode.getId(), dataSetList, prefix, formBean.getId());
            this.addFlowTemplateNode(ctpTemplate, ListAction.List, tNode.getId(), dataSetList, prefix, formBean.getId());
        }
        for (Map.Entry entry : formBean.getBind().getFlowBusinessMap().entrySet()) {
            FormFlowBusinessBean flowBusinessBean = (FormFlowBusinessBean)entry.getValue();
            if (!Enums.FlowBusinessType.PENDING.getKey().equals(flowBusinessBean.getType())) continue;
            Long moduleId = flowBusinessBean.getId();
            String name = flowBusinessBean.getName();
            int code = ListAction.List.getCode();
            FormListSignType signType = FormListSignType.PENDING_FLOW;
            DataSetMetadata metadata = new DataSetMetadata(this.uuid(), signType.name()).attr("formId", formBean.getId()).attr("action", code).attr("code", ApplicationCategoryEnum.cap4Form.getKey()).attr("moduleId", moduleId);
            dataSetList.addNode(dataSetList.createLeafNode(this.getNodeId(this.getNodeKey(moduleId, code)), name, prefix + "-" + name + "-" + signType.getDisplay(), name + "(" + signType.getDisplay() + ")", parentId, metadata));
        }
    }

    private void addFlowTemplateNode(CtpTemplate template, ListAction listAction, String parentId, DefaultDataSetList dataSetList, String prefix, Long bizId) {
        Long templateId = template.getId();
        String name = listAction.getName();
        DataSetMetadata metadata = new DataSetMetadata(this.uuid(), FormListSignType.FLOW.name()).attr("bizId", bizId).attr("templateId", templateId).attr("action", listAction.getCode()).attr("code", ApplicationCategoryEnum.cap4Form.getKey());
        String subject = template.getSubject();
        dataSetList.addNode(dataSetList.createLeafNode(this.getNodeId(this.getNodeKey(templateId, listAction.getCode())), name, prefix + "-" + subject + "-" + name, subject + "(" + name + ")", parentId, metadata));
    }

    private void addUnFlowTemplateNode(BizConfigBean bizConfigBean, Long formId, FormBindAuthBean authBean, ListAction listAction, String parentId, DefaultDataSetList dataSetList) {
        Long bizId = bizConfigBean.getId();
        Long moduleId = authBean.getId();
        String name = listAction.getName();
        String authName = authBean.getName();
        DataSetMetadata metadata = new DataSetMetadata(this.uuid(), FormListSignType.UNFLOW.name()).attr("bizId", bizId).attr("formId", formId).attr("action", listAction.getCode()).attr("code", ApplicationCategoryEnum.cap4biz.getKey()).attr("moduleId", moduleId);
        dataSetList.addNode(dataSetList.createLeafNode(this.getNodeId(this.getNodeKey(moduleId, listAction.getCode())), name, bizConfigBean.getName() + "-" + authName + "-" + name, authName + "(" + name + ")", parentId, metadata));
    }

    private String getNodeKey(Long moduleId, Integer action) {
        return moduleId + "_" + action;
    }

    @Override
    public boolean isAllow(ContextParam contextParam, DataSetMetadata metadata, Command command) throws BusinessException {
        FormListSignType formListSignType = this.getFormListSignType(metadata);
        boolean hasRight = false;
        if (FormListSignType.FLOW.equals((Object)formListSignType)) {
            Long templateId = this.getTemplateId(command, metadata);
            hasRight = this.bizPortalExternAdapterManager.isTemplateEnabled(templateId, contextParam.getUserId());
        } else if (FormListSignType.PENDING_FLOW.equals((Object)formListSignType)) {
            FormFlowBusinessBean flowBusinessBean;
            FormBean formBean = this.bizPortalExternAdapterManager.getFormBean(this.getFormId(command, metadata));
            if (formBean != null && formBean.isEnabled() && (flowBusinessBean = formBean.getBind().getFlowBusinessById(this.getModuleId(command, metadata))) != null) {
                hasRight = flowBusinessBean.checkRight(contextParam.getUserId().longValue());
            }
        } else if (FormListSignType.UNFLOW.equals((Object)formListSignType)) {
            Long bizId = this.getBizId(metadata);
            Long formId = this.getFormId(command, metadata);
            Long moduleId = this.getModuleId(command, metadata);
            FormBean formBean = this.bizPortalExternAdapterManager.getFormBean(formId);
            if (formBean != null && formBean.isEnabled()) {
                ListAction listAction;
                FormBindAuthBean bindAuthBean = formBean.getBind().getUnFlowTemplateById(moduleId);
                if (bindAuthBean != null) {
                    hasRight = bindAuthBean.checkRight(contextParam.getUserId().longValue());
                }
                if (hasRight && ListAction.New.equals(listAction = BizPortalUtils.getEnumByCode(ListAction.class, metadata.attrInt("action")))) {
                    hasRight = this.bizPortalLinkFactoryManager.newUnflow(contextParam, bizId, formId, moduleId) != null;
                }
            }
        }
        return hasRight;
    }

    @Override
    public DataSetResult executeQuery(ContextParam contextParam, DataSetMetadata metadata, String[] versions, Command command) throws BusinessException {
        FormListSignType formListSignType = this.getFormListSignType(metadata);
        LinkDataSetResult linkDataSetResult = null;
        if (FormListSignType.FLOW.equals((Object)formListSignType)) {
            ListAction action = BizPortalUtils.getEnumByCode(ListAction.class, metadata.attrInt("action"));
            Long templateId = this.getTemplateId(command, metadata);
            linkDataSetResult = ListAction.New.equals(action) ? this.bizPortalLinkFactoryManager.newCollaboration(contextParam, templateId) : this.bizPortalLinkFactoryManager.listPendingCollaboration(contextParam, templateId);
        } else if (FormListSignType.PENDING_FLOW.equals((Object)formListSignType)) {
            Long bizId = this.getBizId(metadata);
            Long formId = this.getFormId(command, metadata);
            if (ApplicationCategoryEnum.cap4Form.equals((Object)this.getCategoryEnum(metadata))) {
                bizId = formId;
            }
            Long moduleId = this.getModuleId(command, metadata);
            linkDataSetResult = this.bizPortalLinkFactoryManager.listPendingFlow(contextParam, bizId, formId, moduleId);
        } else if (FormListSignType.UNFLOW.equals((Object)formListSignType)) {
            ListAction action = BizPortalUtils.getEnumByCode(ListAction.class, metadata.attrInt("action"));
            Long bizId = this.getBizId(metadata);
            Long formId = this.getFormId(command, metadata);
            Long moduleId = this.getModuleId(command, metadata);
            linkDataSetResult = ListAction.New.equals(action) ? this.bizPortalLinkFactoryManager.newUnflow(contextParam, bizId, formId, moduleId) : this.bizPortalLinkFactoryManager.listUnflow(contextParam, bizId, formId, moduleId);
        }
        return linkDataSetResult;
    }

    private FormListSignType getFormListSignType(DataSetMetadata metadata) {
        return FormListSignType.valueOf(metadata.getSign());
    }

    @Override
    public DataSetMetadata beforeDataSetMetaBind(String dataId, DataSetMetadata metadata) throws BusinessException {
        FormListSignType formListSignType = this.getFormListSignType(metadata);
        if (ApplicationCategoryEnum.cap4biz.equals((Object)this.getCategoryEnum(metadata))) {
            Long bizId = this.getBizId(metadata);
            if (FormListSignType.FLOW.equals((Object)formListSignType)) {
                Long templateId = metadata.attrLong("templateId");
                metadata.attr("templateId", this.createBizPortalDataRelation(bizId, dataId, templateId));
            } else {
                Long formId = metadata.attrLong("formId");
                Long moduleId = metadata.attrLong("moduleId");
                metadata.attr("formId", this.createBizPortalDataRelation(bizId, dataId, formId));
                metadata.attr("moduleId", this.createBizPortalDataRelation(bizId, dataId, moduleId));
            }
        }
        return metadata;
    }

    @Override
    protected String getId(Command command, DataSetMetadata metadata) throws BusinessException {
        FormListSignType formListSignType = this.getFormListSignType(metadata);
        Long moduleId = FormListSignType.FLOW.equals((Object)formListSignType) ? this.getTemplateId(command, metadata) : this.getModuleId(command, metadata);
        return this.getNodeKey(moduleId, metadata.attrInt("action"));
    }

    private Long getTemplateId(Command command, DataSetMetadata metadata) throws BusinessException {
        if (ApplicationCategoryEnum.cap4Form.equals((Object)this.getCategoryEnum(metadata))) {
            return metadata.attrLong("templateId");
        }
        return this.attrRealLong(command, metadata, "templateId");
    }

    private Long getModuleId(Command command, DataSetMetadata metadata) throws BusinessException {
        if (ApplicationCategoryEnum.cap4Form.equals((Object)this.getCategoryEnum(metadata))) {
            return metadata.attrLong("moduleId");
        }
        return this.attrRealLong(command, metadata, "moduleId");
    }

    private Long getFormId(Command command, DataSetMetadata metadata) throws BusinessException {
        if (ApplicationCategoryEnum.cap4Form.equals((Object)this.getCategoryEnum(metadata))) {
            return metadata.attrLong("formId");
        }
        return this.attrRealLong(command, metadata, "formId");
    }

    public void setBizPortalLinkFactoryManager(BizPortalLinkFactoryManager bizPortalLinkFactoryManager) {
        this.bizPortalLinkFactoryManager = bizPortalLinkFactoryManager;
    }

    static enum ListAction implements EnumCode
    {
        New(0, "\u65b0\u5efa"),
        List(1, "\u5217\u8868");

        int code;
        String name;

        private ListAction(int code, String name) {
            this.code = code;
            this.name = name;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

