/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.datasource.link;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.datasource.DefaultDataSourceProvider;
import com.seeyon.cap4.bizportal.datasource.bean.Command;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetResult;
import com.seeyon.cap4.bizportal.datasource.bean.DefaultDataSetList;
import com.seeyon.cap4.bizportal.manager.BizPortalLinkFactoryManager;
import com.seeyon.cap4.bizportal.manager.BizPortalReportAdapterManager;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.report.bizportal.bean.ReportDesignDefinition;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DefaultReportLinkDataSourceProvider
extends DefaultDataSourceProvider {
    private BizPortalReportAdapterManager bizPortalReportAdapterManager;
    private BizPortalLinkFactoryManager bizPortalLinkFactoryManager;

    @Override
    public BizPortalConstants.DataFormat dataFormat() {
        return BizPortalConstants.DataFormat.LINK;
    }

    public int getSortOrder() {
        return 1;
    }

    @Override
    public String uuid() {
        return "318de7b1-e89b-4f2b-a9ab-6c60eb64fed3";
    }

    @Override
    public String name() {
        return "\u5e94\u7528\u62a5\u8868";
    }

    @Override
    public DefaultDataSetList getDataSetList(ContextParam contextParam, DataSetMetadata dataSetMetadata, String[] versions) throws BusinessException {
        DefaultDataSetList dataSetList = new DefaultDataSetList();
        BizConfigBean bizConfigBean = this.bizPortalExternAdapterManager.getBizConfigBean(this.getMultiStepId(dataSetMetadata));
        String bizId = bizConfigBean.getId().toString();
        DefaultDataSetList.Node bizNode = dataSetList.createBranchNode(bizId, this.name());
        dataSetList.addNode(bizNode);
        List<ReportDesignDefinition> definitions = this.bizPortalReportAdapterManager.findReportDesignDefinition(ApplicationCategoryEnum.cap4biz.name(), bizId);
        ImmutableListMultimap multimap = Multimaps.index(definitions, (Function)new Function<ReportDesignDefinition, ReportConstants.DesignType>(){

            public ReportConstants.DesignType apply(ReportDesignDefinition input) {
                return ReportConstants.DesignType.valueOf((String)input.getDesignType());
            }
        });
        ArrayList designTypes = Lists.newArrayList((Iterable)multimap.keySet());
        Collections.sort(designTypes, new Comparator<ReportConstants.DesignType>(){

            @Override
            public int compare(ReportConstants.DesignType o1, ReportConstants.DesignType o2) {
                return o1.ordinal() - o2.ordinal();
            }
        });
        for (ReportConstants.DesignType designType : designTypes) {
            DefaultDataSetList.Node branchNode = dataSetList.createBranchNode(bizId + "_" + designType, ResourceUtil.getString((String)designType.getI18n()), bizNode.getId());
            dataSetList.addNode(branchNode);
            Function<String, String> fullNameFunction = this.getFullNameFunction(bizConfigBean, designType);
            for (ReportDesignDefinition definition : multimap.get((Object)designType)) {
                Long designId = definition.getDesignId();
                String name = definition.getTitle();
                DataSetMetadata metadata = new DataSetMetadata(this.uuid(), designType.name()).attr("designType", designType.name()).attr("bizId", bizConfigBean.getId()).attr("designId", designId);
                dataSetList.addNode(dataSetList.createLeafNode(this.getNodeId(designId), name, (String)fullNameFunction.apply((Object)name), branchNode.getId(), metadata));
            }
        }
        return dataSetList;
    }

    private Function<String, String> getFullNameFunction(final BizConfigBean bizConfigBean, final ReportConstants.DesignType designType) {
        return new Function<String, String>(){

            public String apply(String input) {
                return bizConfigBean.getName() + "-" + ResourceUtil.getString((String)designType.getI18n()) + "-" + input;
            }
        };
    }

    @Override
    public boolean isAllow(ContextParam contextParam, DataSetMetadata metadata, Command command) throws BusinessException {
        return this.bizPortalReportAdapterManager.checkAuth(this.attrRealLong(command, metadata, "designId"), contextParam.getUserId());
    }

    @Override
    public DataSetResult executeQuery(ContextParam contextParam, DataSetMetadata metadata, String[] versions, Command command) throws BusinessException {
        Long bizId = this.getBizId(metadata);
        Long designId = this.attrRealLong(command, metadata, "designId");
        ReportDesignDefinition definition = this.bizPortalReportAdapterManager.getReportDesignDefinition(designId);
        if (StringUtils.equals((CharSequence)definition.getDesignType(), (CharSequence)ReportConstants.DesignType.QUERY.name())) {
            return this.bizPortalLinkFactoryManager.listCap4Query(contextParam, bizId, designId);
        }
        return this.bizPortalLinkFactoryManager.listCap4Stats(contextParam, bizId, designId, ReportConstants.DesignType.valueOf((String)definition.getDesignType()));
    }

    @Override
    public DataSetMetadata beforeDataSetMetaBind(String dataId, DataSetMetadata metadata) throws BusinessException {
        return metadata.attr("designId", this.createBizPortalDataRelation(this.getBizId(metadata), dataId, metadata.attrLong("designId")));
    }

    @Override
    protected String getId(Command command, DataSetMetadata metadata) throws BusinessException {
        return this.attrRealLong(command, metadata, "designId").toString();
    }

    public void setBizPortalReportAdapterManager(BizPortalReportAdapterManager bizPortalReportAdapterManager) {
        this.bizPortalReportAdapterManager = bizPortalReportAdapterManager;
    }

    public void setBizPortalLinkFactoryManager(BizPortalLinkFactoryManager bizPortalLinkFactoryManager) {
        this.bizPortalLinkFactoryManager = bizPortalLinkFactoryManager;
    }
}

