/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.datasource.list;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.datasource.DefaultBizAndFormDataSourceProvider;
import com.seeyon.cap4.bizportal.datasource.InvokeHandler;
import com.seeyon.cap4.bizportal.datasource.bean.Command;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetResult;
import com.seeyon.cap4.bizportal.datasource.bean.DefaultDataSetList;
import com.seeyon.cap4.bizportal.datasource.bean.PaginationParam;
import com.seeyon.cap4.bizportal.datasource.enums.FormListSignType;
import com.seeyon.cap4.bizportal.datasource.link.LinkDataSetResult;
import com.seeyon.cap4.bizportal.datasource.list.ListDataSetResult;
import com.seeyon.cap4.bizportal.datasource.list.MultiLinkDataSetResult;
import com.seeyon.cap4.bizportal.datasource.list.ViewDetailInvokeHandler;
import com.seeyon.cap4.bizportal.manager.BizPortalLinkFactoryManager;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormBindBean;
import com.seeyon.cap4.form.bean.FormFlowBusinessBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.bean.FormDataListParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPFlowToDoManager;
import com.seeyon.cap4.template.manager.CAPUnFlowManager;
import com.seeyon.cap4.template.vo.FlowListVO;
import com.seeyon.cap4.template.vo.ListFieldVO;
import com.seeyon.cap4.template.vo.ListVO;
import com.seeyon.cap4.template.vo.UnFlowListVO;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.report.bizportal.Constants;
import com.seeyon.ctp.report.bizportal.bean.ListDataResult;
import com.seeyon.ctp.report.bizportal.bean.ListField;
import com.seeyon.ctp.report.bizportal.bean.ListRowData;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.beans.factory.InitializingBean;

public class DefaultFormListDataSourceProvider
extends DefaultBizAndFormDataSourceProvider
implements InitializingBean {
    private static final String AFFAIR_ID = "affairId";
    private static final String SUMMARY_ID = "summaryId";
    private Map<String, InvokeHandler> handlerMap = Maps.newHashMap();
    private CAP4FormManager cap4FormManager;
    private CAPUnFlowManager capUnFlowManager;
    private CAPFlowToDoManager capFlowToDoManager;
    private BizPortalLinkFactoryManager bizPortalLinkFactoryManager;

    public void afterPropertiesSet() throws Exception {
        this.handlerMap.put("default", new DefaultInvokeHandler());
        this.handlerMap.put(Constants.Action.VIEW_DETAIL.getCode(), new DefaultViewDetailInvokeHandler());
    }

    @Override
    public BizPortalConstants.DataFormat dataFormat() {
        return BizPortalConstants.DataFormat.LIST;
    }

    public int getSortOrder() {
        return 0;
    }

    @Override
    public String uuid() {
        return "4b23e87e-b33d-45ba-b46c-5ed6a48bad17";
    }

    @Override
    public String name() {
        return "\u8868\u5355\u5e94\u7528";
    }

    @Override
    public DefaultDataSetList getDataSetList(ContextParam contextParam, DataSetMetadata dataSetMetadata, String[] versions) throws BusinessException {
        DefaultDataSetList dataSetList;
        block8: {
            block7: {
                dataSetList = new DefaultDataSetList();
                if (!StringUtils.equals((String)String.valueOf(ApplicationCategoryEnum.cap4biz.getKey()), (String)dataSetMetadata.getSign())) break block7;
                Long bizId = this.getMultiStepId(dataSetMetadata);
                DefaultDataSetList.Node rootNode = dataSetList.createBranchNode(bizId.toString(), this.name());
                dataSetList.addNode(rootNode);
                BizConfigBean configBean = this.bizPortalExternAdapterManager.getBizConfigBean(bizId);
                List<FormBean> formBeans = this.bizPortalExternAdapterManager.findFormBeanByBizId(bizId);
                for (FormBean formBean : formBeans) {
                    DefaultDataSetList.Node formNode = dataSetList.createBranchNode(formBean.getId().toString(), formBean.getFormName(), rootNode.getId());
                    Function<String, String> fullNameFunction = this.getFullNameFunction(configBean.getName(), formBean);
                    if (this.bizPortalExternAdapterManager.isFlowBean(formBean)) {
                        Map flowBusinessMap = formBean.getBind().getFlowBusinessMap();
                        if (MapUtils.isEmpty((Map)flowBusinessMap)) continue;
                        for (Map.Entry entry : flowBusinessMap.entrySet()) {
                            FormFlowBusinessBean flowBusinessBean = (FormFlowBusinessBean)entry.getValue();
                            Long moduleId = flowBusinessBean.getId();
                            String name = flowBusinessBean.getName();
                            FormListSignType signType = Enums.FlowBusinessType.PENDING.getKey().equals(flowBusinessBean.getType()) ? FormListSignType.PENDING_FLOW : FormListSignType.INTEGRATED_FLOW;
                            DefaultDataSetList.Node leafNode = dataSetList.createLeafNode(this.getNodeId(moduleId), name, (String)fullNameFunction.apply((Object)name), formNode.getId(), new DataSetMetadata(this.uuid(), signType.name()).attr("code", ApplicationCategoryEnum.cap4biz.getKey()).attr("bizId", bizId).attr("formId", formBean.getId()).attr("moduleId", moduleId));
                            dataSetList.addNode(leafNode);
                        }
                    } else {
                        Map unFlowTemplateMap = formBean.getBind().getUnFlowTemplateMap();
                        if (MapUtils.isEmpty((Map)unFlowTemplateMap)) continue;
                        for (FormBindAuthBean bindAuthBean : unFlowTemplateMap.values()) {
                            Long moduleId = bindAuthBean.getId();
                            String name = bindAuthBean.getName();
                            DefaultDataSetList.Node leafNode = dataSetList.createLeafNode(this.getNodeId(moduleId), name, (String)fullNameFunction.apply((Object)name), formNode.getId(), new DataSetMetadata(this.uuid(), FormListSignType.UNFLOW.name()).attr("code", ApplicationCategoryEnum.cap4biz.getKey()).attr("bizId", bizId).attr("formId", formBean.getId()).attr("moduleId", moduleId));
                            dataSetList.addNode(leafNode);
                        }
                    }
                    if (!dataSetList.existChildren(formNode.getId())) continue;
                    dataSetList.addNode(formNode);
                }
                break block8;
            }
            DefaultDataSetList.Node rootNode = dataSetList.createBranchNode(String.valueOf(ApplicationCategoryEnum.cap4Form.getKey()), this.name());
            dataSetList.addNode(rootNode);
            List<FormBean> formBeans = this.bizPortalExternAdapterManager.findFormBeanByOwner(contextParam.getUser());
            if (!CollectionUtils.isNotEmpty(formBeans)) break block8;
            for (FormBean formBean : formBeans) {
                DefaultDataSetList.Node formNode = dataSetList.createBranchNode(formBean.getId().toString(), formBean.getFormName(), rootNode.getId());
                Function<String, String> fullNameFunction = this.getFullNameFunction("\u8868\u5355\u7ba1\u7406", formBean);
                Map flowBusinessMap = formBean.getBind().getFlowBusinessMap();
                if (MapUtils.isEmpty((Map)flowBusinessMap)) continue;
                for (Map.Entry entry : flowBusinessMap.entrySet()) {
                    FormFlowBusinessBean flowBusinessBean = (FormFlowBusinessBean)entry.getValue();
                    Long moduleId = flowBusinessBean.getId();
                    String name = flowBusinessBean.getName();
                    FormListSignType signType = Enums.FlowBusinessType.PENDING.getKey().equals(flowBusinessBean.getType()) ? FormListSignType.PENDING_FLOW : FormListSignType.INTEGRATED_FLOW;
                    DefaultDataSetList.Node leafNode = dataSetList.createLeafNode(this.getNodeId(moduleId), name, (String)fullNameFunction.apply((Object)name), formNode.getId(), new DataSetMetadata(this.uuid(), signType.name()).attr("code", ApplicationCategoryEnum.cap4Form.getKey()).attr("formId", formBean.getId()).attr("moduleId", moduleId));
                    dataSetList.addNode(leafNode);
                }
                if (!dataSetList.existChildren(formNode.getId())) continue;
                dataSetList.addNode(formNode);
            }
        }
        return dataSetList;
    }

    private Function<String, String> getFullNameFunction(final String prefix, final FormBean formBean) {
        return new Function<String, String>(){

            public String apply(String input) {
                return prefix + "-" + formBean.getFormName() + "-" + input;
            }
        };
    }

    @Override
    public boolean isAllow(ContextParam contextParam, DataSetMetadata metadata, Command command) throws BusinessException {
        FormFlowBusinessBean formFlowBusinessBean;
        Triple<Long, FormListSignType, Long> triple = this.parseMetadata(command, metadata);
        FormBean formBean = this.cap4FormManager.getForm((Long)triple.getLeft(), false);
        FormBindBean bind = formBean.getBind();
        FormListSignType signType = (FormListSignType)((Object)triple.getMiddle());
        if (FormListSignType.UNFLOW.equals((Object)signType)) {
            FormBindAuthBean formBindAuthBean = bind.getUnFlowTemplateById((Long)triple.getRight());
            if (formBindAuthBean != null) {
                return formBindAuthBean.checkRight(contextParam.getUserId().longValue());
            }
        } else if (FormListSignType.PENDING_FLOW.equals((Object)signType) && (formFlowBusinessBean = bind.getFlowBusinessById((Long)triple.getRight())) != null) {
            return formFlowBusinessBean.checkRight(contextParam.getUserId().longValue());
        }
        return false;
    }

    @Override
    public DataSetResult executeQuery(ContextParam contextParam, DataSetMetadata metadata, String[] versions, Command command) throws BusinessException {
        return this.getInvokeHandler(command).executeQuery(contextParam, metadata, versions, command);
    }

    @Override
    public DataSetMetadata beforeDataSetMetaBind(String dataId, DataSetMetadata metadata) throws BusinessException {
        if (ApplicationCategoryEnum.cap4biz.equals((Object)this.getCategoryEnum(metadata))) {
            Long bizId = metadata.attrLong("bizId");
            metadata.attr("formId", this.createBizPortalDataRelation(bizId, dataId, metadata.attrLong("formId")));
            metadata.attr("moduleId", this.createBizPortalDataRelation(bizId, dataId, metadata.attrLong("moduleId")));
        }
        return metadata;
    }

    @Override
    protected String getId(Command command, DataSetMetadata metadata) throws BusinessException {
        return this.attrRealLong(command, metadata, "moduleId").toString();
    }

    private InvokeHandler getInvokeHandler(Command command) {
        return this.handlerMap.get(command.getOp());
    }

    private Triple<Long, FormListSignType, Long> parseMetadata(Command command, DataSetMetadata metadata) throws BusinessException {
        FormListSignType signType = FormListSignType.valueOf(metadata.getSign());
        if (ApplicationCategoryEnum.cap4biz.equals((Object)this.getCategoryEnum(metadata))) {
            Long formId = this.attrRealLong(command, metadata, "formId");
            Long moduleId = this.attrRealLong(command, metadata, "moduleId");
            return Triple.of((Object)formId, (Object)((Object)signType), (Object)moduleId);
        }
        return Triple.of((Object)metadata.attrLong("formId"), (Object)((Object)signType), (Object)metadata.attrLong("moduleId"));
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setCapUnFlowManager(CAPUnFlowManager capUnFlowManager) {
        this.capUnFlowManager = capUnFlowManager;
    }

    public void setCapFlowToDoManager(CAPFlowToDoManager capFlowToDoManager) {
        this.capFlowToDoManager = capFlowToDoManager;
    }

    public void setHandlerMap(Map<String, InvokeHandler> handlerMap) {
        this.handlerMap.putAll(handlerMap);
    }

    public void setBizPortalLinkFactoryManager(BizPortalLinkFactoryManager bizPortalLinkFactoryManager) {
        this.bizPortalLinkFactoryManager = bizPortalLinkFactoryManager;
    }

    private class DefaultViewDetailInvokeHandler
    implements ViewDetailInvokeHandler {
        private DefaultViewDetailInvokeHandler() {
        }

        @Override
        public MultiLinkDataSetResult executeQuery(ContextParam contextParam, DataSetMetadata metadata, String[] versions, Command command) throws BusinessException {
            Triple triple = DefaultFormListDataSourceProvider.this.parseMetadata(command, metadata);
            FormListSignType signType = (FormListSignType)((Object)triple.getMiddle());
            LinkDataSetResult linkDataSetResult = null;
            if (FormListSignType.UNFLOW.equals((Object)signType)) {
                Long formId = (Long)triple.getLeft();
                Long formTemplateId = (Long)triple.getRight();
                Long moduleId = Long.parseLong(command.getAttributes().get("identifier").toString());
                linkDataSetResult = DefaultFormListDataSourceProvider.this.bizPortalLinkFactoryManager.viewUnflow(contextParam, formId, formTemplateId, moduleId);
            } else if (FormListSignType.PENDING_FLOW.equals((Object)signType)) {
                Map identifier = (Map)JSONUtil.parseJSONString((String)command.getAttributes().get("identifier").toString(), Map.class);
                Long affairId = MapUtils.getLong((Map)identifier, (Object)DefaultFormListDataSourceProvider.AFFAIR_ID);
                Long summaryId = MapUtils.getLong((Map)identifier, (Object)DefaultFormListDataSourceProvider.SUMMARY_ID);
                linkDataSetResult = DefaultFormListDataSourceProvider.this.bizPortalLinkFactoryManager.listPending(contextParam, summaryId, affairId);
            }
            return MultiLinkDataSetResult.of(linkDataSetResult);
        }
    }

    public class DefaultInvokeHandler
    implements InvokeHandler {
        @Override
        public DataSetResult executeQuery(ContextParam contextParam, DataSetMetadata metadata, String[] versions, Command command) throws BusinessException {
            Triple triple = DefaultFormListDataSourceProvider.this.parseMetadata(command, metadata);
            FormListSignType signType = (FormListSignType)((Object)triple.getMiddle());
            if (FormListSignType.UNFLOW.equals((Object)signType)) {
                UnFlowListVO unFlowListVO = (UnFlowListVO)DefaultFormListDataSourceProvider.this.capUnFlowManager.getList(this.getFormDataListParamBean(contextParam, command, (Triple<Long, FormListSignType, Long>)triple));
                ListDataResult dataResult = this.getListDataResult(unFlowListVO.getFields(), unFlowListVO, new Function<Map<String, Object>, String>(){

                    public String apply(Map<String, Object> rowData) {
                        return MapUtils.getString(rowData, (Object)"id");
                    }
                });
                ListDataSetResult dataSetResult = new ListDataSetResult();
                dataSetResult.setListDataResult(dataResult);
                return dataSetResult;
            }
            if (FormListSignType.PENDING_FLOW.equals((Object)signType)) {
                FlowListVO flowListVO = (FlowListVO)DefaultFormListDataSourceProvider.this.capFlowToDoManager.getList(this.getFormDataListParamBean(contextParam, command, (Triple<Long, FormListSignType, Long>)triple));
                ListDataResult dataResult = this.getListDataResult(flowListVO.getFields(), flowListVO, new Function<Map<String, Object>, String>(){

                    public String apply(Map<String, Object> rowData) {
                        Map fixedField = MapUtils.getMap(rowData, (Object)"fixedField");
                        Long affairId = MapUtils.getLong((Map)fixedField, (Object)DefaultFormListDataSourceProvider.AFFAIR_ID);
                        Long summaryId = MapUtils.getLong((Map)fixedField, (Object)DefaultFormListDataSourceProvider.SUMMARY_ID);
                        return JSONUtil.toJSONString((Object)ImmutableMap.of((Object)DefaultFormListDataSourceProvider.AFFAIR_ID, (Object)affairId, (Object)DefaultFormListDataSourceProvider.SUMMARY_ID, (Object)summaryId));
                    }
                });
                ListDataSetResult dataSetResult = new ListDataSetResult();
                dataSetResult.setListDataResult(dataResult);
                return dataSetResult;
            }
            return null;
        }

        private FormDataListParamBean getFormDataListParamBean(ContextParam contextParam, Command command, Triple<Long, FormListSignType, Long> triple) {
            FormDataListParamBean paramBean = new FormDataListParamBean();
            paramBean.setFormId((Long)triple.getLeft());
            paramBean.setInit(CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
            paramBean.setFormTemplateId((Long)triple.getRight());
            paramBean.setClient(String.valueOf(contextParam.getPlatform().getCode()));
            PaginationParam paginationParam = PaginationParam.of(command);
            paramBean.setPage(paginationParam.getPage());
            paramBean.setPageSize(paginationParam.getPageSize());
            return paramBean;
        }

        private ListDataResult getListDataResult(List<ListFieldVO> fieldVOs, ListVO listVO, Function<Map<String, Object>, String> identifier) {
            ListDataResult listResult = new ListDataResult();
            for (ListFieldVO listFieldVO : fieldVOs) {
                ListField listField = new ListField();
                listField.setKey(listFieldVO.getFieldName());
                listField.setName(listFieldVO.getDisplay());
                listField.setInputType(listFieldVO.getInputType());
                listField.setFieldType(listFieldVO.getFieldType());
                listResult.addListField(listField);
            }
            listResult.setPage(Integer.parseInt(listVO.getPage()));
            listResult.setSize(Integer.parseInt(listVO.getPageSize()));
            listResult.setTotal(Integer.parseInt(listVO.getTotal()));
            listResult.setPages(Integer.parseInt(listVO.getPages()));
            listResult.setExecuteTime(new Date());
            for (Map map : listVO.getDatas()) {
                ListRowData listRowData = listResult.newListRowData();
                listRowData.setIdentifier((String)identifier.apply((Object)map));
                listRowData.getActions().add(Constants.Action.VIEW_DETAIL.getCode());
                for (ListField listField : listResult.getFields()) {
                    String key = listField.getKey();
                    Object value = MapUtils.getMap((Map)map, (Object)key).get("value");
                    listResult.putListRowData(listRowData, key, new ListRowData.Data(value));
                }
            }
            return listResult;
        }
    }
}

