/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.datasource.list;

import com.google.common.collect.Maps;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.datasource.DefaultDataSourceProvider;
import com.seeyon.cap4.bizportal.datasource.InvokeHandler;
import com.seeyon.cap4.bizportal.datasource.bean.Command;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetResult;
import com.seeyon.cap4.bizportal.datasource.bean.DefaultDataSetList;
import com.seeyon.cap4.bizportal.datasource.bean.PaginationParam;
import com.seeyon.cap4.bizportal.datasource.list.ListDataSetResult;
import com.seeyon.cap4.bizportal.datasource.list.MultiLinkDataSetResult;
import com.seeyon.cap4.bizportal.datasource.list.ViewDetailInvokeHandler;
import com.seeyon.cap4.bizportal.manager.BizPortalReportAdapterManager;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.report.bizportal.bean.ListDataResult;
import com.seeyon.ctp.report.bizportal.bean.ReportDesignDefinition;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import com.seeyon.ctp.report.engine.bean.UserConditions;
import com.seeyon.ctp.util.FlipInfo;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.InitializingBean;

public class DefaultReportListDataSourceProvider
extends DefaultDataSourceProvider
implements InitializingBean {
    private Map<String, InvokeHandler> invokeHandlerMap = Maps.newHashMap();
    private BizPortalReportAdapterManager bizPortalReportAdapterManager;

    public void setInvokeHandlerMap(Map<String, InvokeHandler> invokeHandlerMap) {
        this.invokeHandlerMap = invokeHandlerMap;
    }

    public void setBizPortalReportAdapterManager(BizPortalReportAdapterManager bizPortalReportAdapterManager) {
        this.bizPortalReportAdapterManager = bizPortalReportAdapterManager;
    }

    public void afterPropertiesSet() throws Exception {
        this.invokeHandlerMap.put("default", new DefaultInvokeHandler());
        this.invokeHandlerMap.put("viewDetail", new DefaultViewDetailInvokeHandler());
    }

    @Override
    public BizPortalConstants.DataFormat dataFormat() {
        return BizPortalConstants.DataFormat.LIST;
    }

    public int getSortOrder() {
        return 1;
    }

    @Override
    public String uuid() {
        return "56abc264-6cd6-48a8-8967-96b1fd89f2d3";
    }

    @Override
    public String name() {
        return "\u5e94\u7528\u62a5\u8868";
    }

    @Override
    public DefaultDataSetList getDataSetList(ContextParam contextParam, DataSetMetadata dataSetMetadata, String[] versions) throws BusinessException {
        DefaultDataSetList dataSetList = new DefaultDataSetList();
        BizConfigBean configBean = this.bizPortalExternAdapterManager.getBizConfigBean(this.getMultiStepId(dataSetMetadata));
        Long bizId = configBean.getId();
        DefaultDataSetList.Node rootNode = dataSetList.createBranchNode(bizId.toString(), this.name());
        dataSetList.addNode(rootNode);
        List<ReportDesignDefinition> reportConfigs = this.bizPortalReportAdapterManager.findReportDesignDefinition(ApplicationCategoryEnum.cap4biz.name(), bizId.toString(), ReportConstants.DesignType.QUERY);
        if (CollectionUtils.isNotEmpty(reportConfigs)) {
            for (ReportDesignDefinition config : reportConfigs) {
                DefaultDataSetList.Node leafNode = dataSetList.createLeafNode(this.getNodeId(config.getDesignId()), config.getTitle(), configBean.getName() + "-" + config.getTitle(), rootNode.getId(), new DataSetMetadata(this.uuid()).attr("bizId", bizId).attr("bizId", bizId).attr("designId", config.getDesignId()));
                dataSetList.addNode(leafNode);
            }
        }
        return dataSetList;
    }

    @Override
    public boolean isAllow(ContextParam contextParam, DataSetMetadata metadata, Command command) throws BusinessException {
        return this.bizPortalReportAdapterManager.checkAuth(this.getDesignId(command, metadata), contextParam.getUserId());
    }

    @Override
    public DataSetResult executeQuery(ContextParam contextParam, DataSetMetadata metadata, String[] versions, Command command) throws BusinessException {
        return this.getInvokeHandler(command).executeQuery(contextParam, metadata, versions, command);
    }

    @Override
    public DataSetMetadata beforeDataSetMetaBind(String dataId, DataSetMetadata metadata) throws BusinessException {
        return metadata.attr("designId", this.createBizPortalDataRelation(this.getBizId(metadata), dataId, metadata.attrLong("designId")));
    }

    @Override
    protected String getId(Command command, DataSetMetadata metadata) throws BusinessException {
        return this.getDesignId(command, metadata).toString();
    }

    private Long getDesignId(Command command, DataSetMetadata metadata) throws BusinessException {
        return this.attrRealLong(command, metadata, "designId");
    }

    private InvokeHandler getInvokeHandler(Command command) {
        return this.invokeHandlerMap.get(command.getOp());
    }

    private class DefaultViewDetailInvokeHandler
    implements ViewDetailInvokeHandler {
        private DefaultViewDetailInvokeHandler() {
        }

        @Override
        public MultiLinkDataSetResult executeQuery(ContextParam contextParam, DataSetMetadata metadata, String[] versions, Command command) throws BusinessException {
            Long designId = DefaultReportListDataSourceProvider.this.getDesignId(command, metadata);
            String extendParams = command.getAttributes().get("identifier").toString();
            return DefaultReportListDataSourceProvider.this.bizPortalReportAdapterManager.getQueryPenetrateInfo(contextParam, designId, extendParams);
        }
    }

    private class DefaultInvokeHandler
    implements InvokeHandler {
        private DefaultInvokeHandler() {
        }

        @Override
        public DataSetResult executeQuery(ContextParam contextParam, DataSetMetadata metadata, String[] versions, Command command) throws BusinessException {
            Long designId = DefaultReportListDataSourceProvider.this.getDesignId(command, metadata);
            FlipInfo fi = new FlipInfo();
            PaginationParam paginationParam = PaginationParam.of(command);
            fi.setPage(paginationParam.getPage().intValue());
            fi.setSize(paginationParam.getPageSize().intValue());
            fi.setNeedTotal(true);
            UserConditions userConditions = new UserConditions();
            ListDataResult list = DefaultReportListDataSourceProvider.this.bizPortalReportAdapterManager.findQueryDataResult(designId, userConditions, fi);
            return ListDataSetResult.of(list);
        }
    }
}

