/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.datasource.list;

import com.google.common.collect.Lists;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetResult;
import com.seeyon.cap4.bizportal.datasource.link.LinkDataSetResult;
import com.seeyon.cap4.bizportal.datasource.link.MobileLinkDataSetResult;
import com.seeyon.cap4.bizportal.utils.BizPortalUtils;
import java.util.List;

public class MultiLinkDataSetResult
implements DataSetResult {
    private List<WithLabelLinkDataSet> links = Lists.newArrayList();

    @Override
    public Integer getDataFormat() {
        return BizPortalConstants.DataFormat.LINK.getCode();
    }

    @Override
    public String getVersion() {
        return BizPortalConstants.Version.V1.name();
    }

    public static MultiLinkDataSetResult of(LinkDataSetResult link) {
        MultiLinkDataSetResult that = new MultiLinkDataSetResult();
        that.links.add(MultiLinkDataSetResult.create(link));
        return that;
    }

    public static MultiLinkDataSetResult of(String href) {
        return MultiLinkDataSetResult.of(LinkDataSetResult.of(href));
    }

    public static WithLabelLinkDataSet create(LinkDataSetResult linkDataSetResult, String label) {
        WithLabelLinkDataSet withLabelLinkDataSet = new WithLabelLinkDataSet();
        BizPortalUtils.copyProperties(withLabelLinkDataSet, linkDataSetResult);
        withLabelLinkDataSet.label = label;
        return withLabelLinkDataSet;
    }

    public static WithLabelLinkDataSet create(LinkDataSetResult linkDataSetResult) {
        return MultiLinkDataSetResult.create(linkDataSetResult, "");
    }

    public List<WithLabelLinkDataSet> getLinks() {
        return this.links;
    }

    public void setLinks(List<WithLabelLinkDataSet> links) {
        this.links = links;
    }

    public static class WithLabelLinkDataSet
    extends MobileLinkDataSetResult {
        private String label;

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }
    }
}

