/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.datasource.memberinfo;

import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.bean.BizPortalSectionElement;
import com.seeyon.cap4.bizportal.datasource.ElementDefaultValueConstruct;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetResult;
import com.seeyon.cap4.bizportal.datasource.memberinfo.MemberInfoDataSetResult;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.bo.V3xOrgPost;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import java.text.MessageFormat;
import java.util.Date;

public class MemberInfoDataSourceProvider
implements ElementDefaultValueConstruct {
    private OrgManager orgManager;

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    @Override
    public BizPortalConstants.DataFormat dataFormat() {
        return BizPortalConstants.DataFormat.MemberInfo;
    }

    private DataSetResult getDataSetResult(ContextParam contextParam) throws BusinessException {
        Long memberId = contextParam.getUserId();
        MemberInfoDataSetResult result = new MemberInfoDataSetResult();
        V3xOrgMember member = this.orgManager.getMemberById(memberId);
        result.setMemberId(memberId);
        result.setMemberName(member.getName());
        V3xOrgPost orgPost = this.orgManager.getPostById(member.getOrgPostId());
        result.setPostId(orgPost.getId());
        result.setPostName(orgPost.getName());
        result.setAvatarUrl(MessageFormat.format("{0}/rest/orgMember/avatar/{1}?d={2}", SystemEnvironment.getContextPath(), memberId.toString(), DateUtil.formatDateTime((Date)new Date())));
        return result;
    }

    @Override
    public DataSetResult constructDataSetResult(BizPortalSectionElement element, ContextParam contextParam) throws BusinessException {
        return this.getDataSetResult(contextParam);
    }
}

