/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.datasource.menu;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.LinkSupport;
import com.seeyon.cap4.bizportal.datasource.AbstractDataSourceProviderImportAndExportable;
import com.seeyon.cap4.bizportal.datasource.bean.Command;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetList;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetResult;
import com.seeyon.cap4.bizportal.datasource.bean.DefaultDataSetList;
import com.seeyon.cap4.bizportal.datasource.link.LinkDataSetResult;
import com.seeyon.cap4.bizportal.datasource.link.MobileLinkDataSetResult;
import com.seeyon.cap4.bizportal.datasource.menu.MenuDataSetResult;
import com.seeyon.cap4.bizportal.manager.BizPortalExternAdapterManager;
import com.seeyon.cap4.bizportal.manager.BizPortalLinkFactoryManager;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.login.bo.MenuBO;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class DefaultMenuDataSourceProvider
extends AbstractDataSourceProviderImportAndExportable {
    private static final Log logger = CtpLogFactory.getLog(DefaultMenuDataSourceProvider.class);
    private String contextPath;
    private Function<MenuBO, String> iconFunction = new Function<MenuBO, String>(){

        public String apply(MenuBO input) {
            return "cap-icon-" + input.getIcon();
        }
    };
    private Comparator<MenuBO> menuBOComparator = new Comparator<MenuBO>(){

        @Override
        public int compare(MenuBO o1, MenuBO o2) {
            return o1.privSortid() - o2.privSortid();
        }
    };
    private BizPortalExternAdapterManager bizPortalExternAdapterManager;
    private BizPortalLinkFactoryManager bizPortalLinkFactoryManager;

    public int getSortOrder() {
        return 0;
    }

    @Override
    public BizPortalConstants.DataFormat dataFormat() {
        return BizPortalConstants.DataFormat.MENU;
    }

    @Override
    public String uuid() {
        return "21a20b56-d769-4858-b7d0-e18f4112594d";
    }

    @Override
    public String name() {
        return "\u4e1a\u52a1\u83dc\u5355";
    }

    @Override
    public DataSetList getDataSetList(ContextParam contextParam, String[] versions) throws BusinessException {
        DefaultDataSetList dataSetList = new DefaultDataSetList();
        DefaultDataSetList.Node rootNode = dataSetList.createBranchNode("1", this.name());
        dataSetList.addNode(rootNode);
        List<BizConfigBean> bizConfigBeans = this.bizPortalExternAdapterManager.findBizConfigBeanByOwner(contextParam.getUserId());
        for (BizConfigBean bizConfigBean : bizConfigBeans) {
            Optional<Long> optional = this.getMenuId(bizConfigBean);
            if (!optional.isPresent()) continue;
            Long bizId = bizConfigBean.getId();
            DefaultDataSetList.Node branchNode = dataSetList.createBranchNode(bizId.toString(), bizConfigBean.getName(), rootNode.getId());
            dataSetList.addNode(branchNode);
            Function<String, String> fillNameFunction = this.getFillNameFunction(bizConfigBean);
            Function<String, String> fullNameFunction = this.getFullNameFunction(bizConfigBean);
            Long menuId = (Long)optional.get();
            String name = this.name();
            DefaultDataSetList.Node leafNode = dataSetList.createLeafNode(this.getNodeId(menuId), name, (String)fullNameFunction.apply((Object)name), (String)fillNameFunction.apply((Object)name), branchNode.getId(), new DataSetMetadata(this.uuid(), String.valueOf(ApplicationCategoryEnum.cap4biz.getKey())).attr("bizId", bizId).attr("menuId", menuId));
            dataSetList.addNode(leafNode);
        }
        return dataSetList;
    }

    @Override
    public boolean isAllow(ContextParam contextParam, DataSetMetadata metadata, Command command) throws BusinessException {
        MenuBO menuBO = this.getMenuBO(contextParam, command, metadata);
        if (menuBO == null) {
            logger.error((Object)("\u65e0\u6cd5\u83b7\u53d6\u5230\u83dc\u5355\uff0c\u8868\u793a\u7528\u6237\u65e0\u6743\u9650, contexParam:" + JSONUtil.toJSONString((Object)contextParam) + ", metadata=" + JSONUtil.toJSONString((Object)metadata)));
        }
        return menuBO != null;
    }

    @Override
    public DataSetResult executeQuery(ContextParam contextParam, DataSetMetadata metadata, String[] versions, Command command) throws BusinessException {
        MenuBO menuBO = this.getMenuBO(contextParam, command, metadata);
        MenuDataSetResult dataSetResult = new MenuDataSetResult();
        dataSetResult.setId(menuBO.getId());
        dataSetResult.setName(menuBO.getName());
        if (this.isImgMenu(menuBO)) {
            dataSetResult.setImgSrc(menuBO.getIcon());
        } else {
            dataSetResult.setIcon((String)this.iconFunction.apply((Object)menuBO));
        }
        List items1 = menuBO.getItems();
        if (this.isCAP4BizMenu(metadata) && this.bizPortalExternAdapterManager.isCAPPortalMenuChecked(this.getBizId(metadata))) {
            items1 = items1.subList(1, items1.size());
        }
        this.recursiveMenuItem(items1, menuBO, dataSetResult, contextParam);
        List<MenuDataSetResult.MenuItem> items = dataSetResult.getItems();
        ImmutableListMultimap multimap = Multimaps.index(items, (Function)new Function<MenuDataSetResult.MenuItem, Long>(){

            public Long apply(MenuDataSetResult.MenuItem input) {
                return input.getParentId();
            }
        });
        Iterator<MenuDataSetResult.MenuItem> iterator = items.iterator();
        while (iterator.hasNext()) {
            MenuDataSetResult.MenuItem next = iterator.next();
            if (next.getHref() != null || multimap.containsKey((Object)next.getId())) continue;
            iterator.remove();
        }
        return dataSetResult;
    }

    private void recursiveMenuItem(List<MenuBO> items, MenuBO parent, MenuDataSetResult dataSetResult, ContextParam contextParam) throws BusinessException {
        Collections.sort(items, this.menuBOComparator);
        for (MenuBO item : items) {
            List children = item.getItems();
            if (CollectionUtils.isEmpty((Collection)children)) {
                LinkDataSetResult mobileLink;
                if (StringUtils.isEmpty((CharSequence)item.getUrl())) {
                    logger.error((Object)("\u5b50\u83dc\u5355[" + item.getId() + "]\u7684URL\u4e22\u5931\uff01"));
                    continue;
                }
                LinkSupport linkSupport = this.bizPortalLinkFactoryManager.chooseLinkSupport(item.getUrl());
                if (!linkSupport.support(contextParam.getPlatform())) continue;
                MenuDataSetResult.MenuItem menuItem = dataSetResult.addItem(item.getId(), item.getName(), parent.getId());
                if (this.isImgMenu(item)) {
                    menuItem.setImgSrc(item.getIcon());
                } else {
                    menuItem.setIcon((String)this.iconFunction.apply((Object)item));
                }
                menuItem.setTarget(StringUtils.defaultString((String)linkSupport.getTarget(), (String)this.getTarget(item)));
                menuItem.setHref(this.getContextPath() + item.getUrl());
                if (!BizPortalConstants.Platform.MOBILE.equals(contextParam.getPlatform()) || !((mobileLink = linkSupport.mobileLink(item.getUrl(), contextParam)) instanceof MobileLinkDataSetResult)) continue;
                MobileLinkDataSetResult mobileLinkDataSetResult = (MobileLinkDataSetResult)mobileLink;
                menuItem.setAppId(mobileLinkDataSetResult.getAppId());
                menuItem.setOpenApi(mobileLinkDataSetResult.getOpenApi());
                menuItem.setParams(mobileLinkDataSetResult.getParams());
                continue;
            }
            MenuDataSetResult.MenuItem menuItem = dataSetResult.addItem(item.getId(), item.getName(), parent.getId());
            if (this.isImgMenu(item)) {
                menuItem.setImgSrc(item.getIcon());
            } else {
                menuItem.setIcon((String)this.iconFunction.apply((Object)item));
            }
            this.recursiveMenuItem(children, item, dataSetResult, contextParam);
        }
    }

    private boolean isImgMenu(MenuBO menuBO) {
        return menuBO.getIcon().contains("fileUpload.do");
    }

    private String getTarget(MenuBO menuBO) {
        return StringUtils.equals((CharSequence)menuBO.getTarget(), (CharSequence)"newWindow") || StringUtils.equals((CharSequence)menuBO.getTarget(), (CharSequence)"link") ? "newWindow" : "mainfrm";
    }

    private Optional<Long> getMenuId(BizConfigBean bizConfigBean) {
        List menuList = bizConfigBean.getMenuList();
        if (CollectionUtils.isNotEmpty((Collection)menuList) && menuList.size() > 1) {
            return Optional.of((Object)bizConfigBean.getMenuId());
        }
        return Optional.absent();
    }

    @Override
    public DataSetMetadata beforeDataSetMetaBind(String dataId, DataSetMetadata metadata) throws BusinessException {
        return this.isCAP4BizMenu(metadata) ? metadata.attr("menuId", this.createBizPortalDataRelation(this.getBizId(metadata), dataId, metadata.attrLong("menuId"))) : metadata;
    }

    @Override
    protected String getId(Command command, DataSetMetadata metadata) throws BusinessException {
        return this.attrRealLong(command, metadata, "menuId").toString();
    }

    private Function<String, String> getFillNameFunction(final BizConfigBean bizConfigBean) {
        return new Function<String, String>(){

            public String apply(String input) {
                return bizConfigBean.getName() + "(" + input + ")";
            }
        };
    }

    private Function<String, String> getFullNameFunction(final BizConfigBean bizConfigBean) {
        return new Function<String, String>(){

            public String apply(String input) {
                return bizConfigBean.getName() + "-" + input;
            }
        };
    }

    private MenuBO getMenuBO(ContextParam contextParam, Command command, DataSetMetadata metadata) throws BusinessException {
        if (this.isCAP4BizMenu(metadata)) {
            Long bizId = this.getBizId(metadata);
            Long menuId = this.attrRealLong(command, metadata, "menuId");
            return this.bizPortalExternAdapterManager.getBizMenu(contextParam.getUser(), bizId, menuId);
        }
        return this.bizPortalExternAdapterManager.getMultiMenu(contextParam.getUser(), metadata.attrLong("menuId"));
    }

    private boolean isCAP4BizMenu(DataSetMetadata metadata) {
        return StringUtils.equals((CharSequence)String.valueOf(ApplicationCategoryEnum.cap4biz.getKey()), (CharSequence)metadata.getSign());
    }

    public void setIconFunction(Function<MenuBO, String> iconFunction) {
        this.iconFunction = iconFunction;
    }

    private String getContextPath() {
        if (this.contextPath == null) {
            this.contextPath = SystemEnvironment.getContextPath();
        }
        return this.contextPath;
    }

    public void setBizPortalExternAdapterManager(BizPortalExternAdapterManager bizPortalExternAdapterManager) {
        this.bizPortalExternAdapterManager = bizPortalExternAdapterManager;
    }

    public void setBizPortalLinkFactoryManager(BizPortalLinkFactoryManager bizPortalLinkFactoryManager) {
        this.bizPortalLinkFactoryManager = bizPortalLinkFactoryManager;
    }
}

