/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.datasource.statistic;

import com.google.common.collect.Sets;
import com.seeyon.cap4.bizportal.datasource.InvokeHandler;
import com.seeyon.cap4.bizportal.datasource.bean.Command;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetResult;
import com.seeyon.cap4.bizportal.datasource.bean.PaginationParam;
import com.seeyon.cap4.bizportal.datasource.statistic.PaginationHandler;
import com.seeyon.cap4.bizportal.datasource.statistic.StatisticDataSetResult;
import com.seeyon.cap4.bizportal.function.Predicate;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.utils.Predicates;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.report.bizportal.bean.ListDataResult;
import com.seeyon.ctp.report.bizportal.bean.ListField;
import com.seeyon.ctp.report.bizportal.bean.ListRowData;
import com.seeyon.ctp.report.bizportal.bean.StatisticsListField;
import com.seeyon.ctp.report.bizportal.bean.StatisticsListRowData;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractInvokeHandler
implements InvokeHandler {
    private Map<String, PaginationHandler> paginationHandlers;

    public AbstractInvokeHandler(Map<String, PaginationHandler> paginationHandlers) {
        this.paginationHandlers = paginationHandlers;
    }

    @Override
    public DataSetResult executeQuery(ContextParam contextParam, DataSetMetadata metadata, String[] versions, Command command) throws BusinessException {
        ListDataResult dataResult = this.doExecuteQuery(contextParam, metadata, command);
        PaginationParam param = PaginationParam.of(command);
        Predicate<ListField> listFieldPredicate = Predicates.and(this.newFieldKeyPredicate(command), this.newFieldTypePredicate(command));
        Predicate<ListRowData> dataPredicate = this.newRowTypePredicate(command);
        PaginationHandler paginationHandler = this.getPaginationHandler(param);
        return StatisticDataSetResult.of(paginationHandler.pagination(param, listFieldPredicate, dataPredicate, dataResult));
    }

    public abstract ListDataResult doExecuteQuery(ContextParam var1, DataSetMetadata var2, Command var3) throws BusinessException;

    protected Predicate<ListField> newFieldKeyPredicate(Command command) {
        List fields = (List)command.getAttributes().get("fields");
        if (CollectionUtils.isEmpty((Collection)fields)) {
            return Predicates.alwaysTrue();
        }
        final HashSet fieldKeys = Sets.newHashSet((Iterable)fields);
        return new Predicate<ListField>(){

            @Override
            public boolean apply(ListField listField) {
                if (fieldKeys.contains(listField.getKey())) {
                    return true;
                }
                if (listField instanceof StatisticsListField) {
                    ListField parentField = ((StatisticsListField)listField).getParentField();
                    if (parentField == null) {
                        return false;
                    }
                    return this.apply(parentField);
                }
                return false;
            }
        };
    }

    protected Predicate<ListField> newFieldTypePredicate(Command command) {
        List fieldTypes = (List)command.getAttributes().get("fieldTypes");
        if (CollectionUtils.isEmpty((Collection)fieldTypes)) {
            return Predicates.alwaysTrue();
        }
        Predicate<ListField> predicate = Predicates.alwaysTrue();
        if (fieldTypes.contains("headerField")) {
            predicate = Predicates.or(predicate, new Predicate<ListField>(){

                @Override
                public boolean apply(ListField listField) {
                    if (listField instanceof StatisticsListField) {
                        return ((StatisticsListField)listField).isHeaderField();
                    }
                    return false;
                }
            });
        }
        if (fieldTypes.contains("statisticsField")) {
            predicate = Predicates.or(predicate, new Predicate<ListField>(){

                @Override
                public boolean apply(ListField listField) {
                    if (listField instanceof StatisticsListField) {
                        StatisticsListField statField = (StatisticsListField)listField;
                        return !statField.isHeaderField() && !statField.isFormulaField();
                    }
                    return false;
                }
            });
        }
        if (fieldTypes.contains("formulaField")) {
            predicate = Predicates.or(predicate, new Predicate<ListField>(){

                @Override
                public boolean apply(ListField listField) {
                    if (listField instanceof StatisticsListField) {
                        StatisticsListField statField = (StatisticsListField)listField;
                        return statField.isFormulaField();
                    }
                    return false;
                }
            });
        }
        return predicate;
    }

    protected Predicate<ListRowData> newRowTypePredicate(Command command) {
        List rowTypes = (List)command.getAttributes().get("rowTypes");
        if (CollectionUtils.isEmpty((Collection)rowTypes)) {
            return Predicates.alwaysTrue();
        }
        Predicate<ListRowData> predicate = Predicates.alwaysFalse();
        if (rowTypes.contains("normal")) {
            predicate = Predicates.or(predicate, new Predicate<ListRowData>(){

                @Override
                public boolean apply(ListRowData listRowData) {
                    StatisticsListRowData rowData = (StatisticsListRowData)listRowData;
                    return !rowData.isSubTotal() && !rowData.isTotal();
                }
            });
        }
        if (rowTypes.contains("subtotal")) {
            predicate = Predicates.or(predicate, new Predicate<ListRowData>(){

                @Override
                public boolean apply(ListRowData listRowData) {
                    return ((StatisticsListRowData)listRowData).isSubTotal();
                }
            });
        }
        if (rowTypes.contains("total")) {
            predicate = Predicates.or(predicate, new Predicate<ListRowData>(){

                @Override
                public boolean apply(ListRowData listRowData) {
                    return ((StatisticsListRowData)listRowData).isTotal();
                }
            });
        }
        return predicate;
    }

    protected PaginationHandler getPaginationHandler(PaginationParam param) {
        return this.paginationHandlers.get(param.getOp());
    }
}

