/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.datasource.statistic;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.datasource.DefaultDataSourceProvider;
import com.seeyon.cap4.bizportal.datasource.InvokeHandler;
import com.seeyon.cap4.bizportal.datasource.bean.Command;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetResult;
import com.seeyon.cap4.bizportal.datasource.bean.DefaultDataSetList;
import com.seeyon.cap4.bizportal.datasource.bean.PaginationParam;
import com.seeyon.cap4.bizportal.datasource.memberinfo.MemberInfoDataSetResult;
import com.seeyon.cap4.bizportal.datasource.statistic.AbstractInvokeHandler;
import com.seeyon.cap4.bizportal.datasource.statistic.PaginationHandler;
import com.seeyon.cap4.bizportal.datasource.statistic.pagination.DefaultPaginationHandler;
import com.seeyon.cap4.bizportal.datasource.statistic.pagination.LineNumberPaginationHandler;
import com.seeyon.cap4.bizportal.manager.BizPortalReportAdapterManager;
import com.seeyon.cap4.bizportal.manager.BizPortalReportAdapterManagerImpl;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.bo.V3xOrgPost;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.report.bizportal.ListDataConverter;
import com.seeyon.ctp.report.bizportal.bean.ListDataResult;
import com.seeyon.ctp.report.bizportal.bean.ListRowData;
import com.seeyon.ctp.report.bizportal.bean.ReportDesignDefinition;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import com.seeyon.ctp.report.engine.bean.DisplayField;
import com.seeyon.ctp.report.engine.bean.Field;
import com.seeyon.ctp.util.DateUtil;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.beans.factory.InitializingBean;

public class DefaultStatisticDataSourceProvider
extends DefaultDataSourceProvider
implements InitializingBean {
    private Map<String, InvokeHandler> systemHandlers = Maps.newHashMap();
    private Map<String, PaginationHandler> paginationHandlers = Maps.newHashMap();
    private BizPortalReportAdapterManager bizPortalReportAdapterManager;
    private EnumManager enumManager;
    private OrgManager orgManager;
    private AttachmentManager attachmentManager;

    public int getSortOrder() {
        return 0;
    }

    @Override
    public BizPortalConstants.DataFormat dataFormat() {
        return BizPortalConstants.DataFormat.STATISTIC;
    }

    @Override
    public String uuid() {
        return "372fb53b-11d4-4ba2-9190-0ca09a11518d";
    }

    @Override
    public String name() {
        return "\u5e94\u7528\u62a5\u8868";
    }

    @Override
    public DefaultDataSetList getDataSetList(ContextParam contextParam, DataSetMetadata dataSetMetadata, String[] versions) throws BusinessException {
        DefaultDataSetList dataSetList = new DefaultDataSetList();
        DefaultDataSetList.Node rootNode = dataSetList.createBranchNode("-1", this.name());
        dataSetList.addNode(rootNode);
        BizConfigBean bizConfigBean = this.bizPortalExternAdapterManager.getBizConfigBean(this.getMultiStepId(dataSetMetadata));
        this.addReportNode(bizConfigBean, ReportConstants.DesignType.STATISTICS, dataSetList, rootNode);
        this.addReportNode(bizConfigBean, ReportConstants.DesignType.MULTSTATS, dataSetList, rootNode);
        this.addReportNode(bizConfigBean, ReportConstants.DesignType.SCHEDULEDSTATS, dataSetList, rootNode);
        return dataSetList;
    }

    private void addReportNode(BizConfigBean bizConfigBean, ReportConstants.DesignType designType, DefaultDataSetList dataSetList, DefaultDataSetList.Node parentNode) throws BusinessException {
        Long bizId = bizConfigBean.getId();
        List<ReportDesignDefinition> list = this.findReportDesignDefinition(bizId, designType);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        DefaultDataSetList.Node branchNode = dataSetList.createBranchNode(bizId + "-" + designType.name(), ResourceUtil.getString((String)designType.getI18n()), parentNode.getId());
        dataSetList.addNode(branchNode);
        Function<String, String> function = this.getFullNameFunction(bizConfigBean, designType);
        for (ReportDesignDefinition definition : list) {
            Long designId = definition.getDesignId();
            DataSetMetadata metadata = new DataSetMetadata(this.uuid(), designType.name()).attr("bizId", bizId).attr("designId", designId);
            DefaultDataSetList.Node leafNode = dataSetList.createLeafNode(this.getNodeId(designId), definition.getTitle(), (String)function.apply((Object)definition.getTitle()), branchNode.getId(), metadata);
            dataSetList.addNode(leafNode);
        }
    }

    private Function<String, String> getFullNameFunction(final BizConfigBean bizConfigBean, final ReportConstants.DesignType designType) {
        return new Function<String, String>(){

            public String apply(String input) {
                return bizConfigBean.getName() + "-" + ResourceUtil.getString((String)designType.getI18n()) + "-" + input;
            }
        };
    }

    private List<ReportDesignDefinition> findReportDesignDefinition(Long bizId, ReportConstants.DesignType designType) throws BusinessException {
        return this.bizPortalReportAdapterManager.findReportDesignDefinition(ApplicationCategoryEnum.cap4biz.name(), bizId.toString(), designType);
    }

    @Override
    public boolean isAllow(ContextParam contextParam, DataSetMetadata metadata, Command command) throws BusinessException {
        return this.bizPortalReportAdapterManager.checkAuth(this.getDesignId(command, metadata), contextParam.getUserId());
    }

    @Override
    public DataSetResult executeQuery(ContextParam contextParam, DataSetMetadata metadata, String[] versions, Command command) throws BusinessException {
        return this.getInvokeHandler(command).executeQuery(contextParam, metadata, versions, command);
    }

    @Override
    public DataSetMetadata beforeDataSetMetaBind(String dataId, DataSetMetadata metadata) throws BusinessException {
        return metadata.attr("designId", this.createBizPortalDataRelation(this.getBizId(metadata), dataId, metadata.attrLong("designId")));
    }

    public void afterPropertiesSet() throws Exception {
        this.paginationHandlers.put("default", new DefaultPaginationHandler());
        this.paginationHandlers.put("lineNum", new LineNumberPaginationHandler());
        this.systemHandlers.put("default", new AbstractInvokeHandler(this.paginationHandlers){

            @Override
            public ListDataResult doExecuteQuery(ContextParam contextParam, DataSetMetadata metadata, Command command) throws BusinessException {
                return DefaultStatisticDataSourceProvider.this.bizPortalReportAdapterManager.findStatisticsDataResult(DefaultStatisticDataSourceProvider.this.getDesignId(command, metadata), contextParam.getUser());
            }
        });
        this.systemHandlers.put("defaultMember", new AbstractInvokeHandler(this.paginationHandlers){

            @Override
            public ListDataResult doExecuteQuery(ContextParam contextParam, DataSetMetadata metadata, Command command) throws BusinessException {
                return DefaultStatisticDataSourceProvider.this.bizPortalReportAdapterManager.findStatisticsDataResult(DefaultStatisticDataSourceProvider.this.getDesignId(command, metadata), contextParam.getUser(), (ListDataConverter)new DefaulMemberDataConverter(DefaultStatisticDataSourceProvider.this.enumManager, DefaultStatisticDataSourceProvider.this.attachmentManager));
            }
        });
    }

    @Override
    protected String getId(Command command, DataSetMetadata metadata) throws BusinessException {
        return this.getDesignId(command, metadata).toString();
    }

    private Long getDesignId(Command command, DataSetMetadata metadata) throws BusinessException {
        return this.attrRealLong(command, metadata, "designId");
    }

    private InvokeHandler getInvokeHandler(Command command) {
        return this.systemHandlers.get(command.getOp());
    }

    private PaginationHandler getPaginationHandler(PaginationParam param) {
        return this.paginationHandlers.get(param.getOp());
    }

    public void setBizPortalReportAdapterManager(BizPortalReportAdapterManager bizPortalReportAdapterManager) {
        this.bizPortalReportAdapterManager = bizPortalReportAdapterManager;
    }

    public void setEnumManagerNew(EnumManager enumManager) {
        this.enumManager = enumManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setPaginationHandlers(Map<String, PaginationHandler> paginationHandlers) {
        this.paginationHandlers = paginationHandlers;
    }

    class DefaulMemberDataConverter
    extends BizPortalReportAdapterManagerImpl.DefaultListDataConverter {
        DefaulMemberDataConverter(EnumManager enumManager, AttachmentManager attachmentManager) {
            super(enumManager, attachmentManager);
        }

        @Override
        public ListRowData.Data format(DisplayField displayField, Object sValue, Field field, Supplier<ListRowData.Data> format) throws BusinessException {
            if (sValue == null) {
                return new ListRowData.Data();
            }
            ListRowData.Data data = super.format(displayField, sValue, field, format);
            String fieldComType = field.getFieldComType();
            if (ObjectUtils.equals((Object)fieldComType, (Object)ReportConstants.FieldComType.MEMBER.getComName())) {
                Long memberId = Long.parseLong(sValue.toString());
                MemberInfoDataSetResult result = new MemberInfoDataSetResult();
                V3xOrgMember member = DefaultStatisticDataSourceProvider.this.orgManager.getMemberById(memberId);
                result.setMemberId(memberId);
                result.setMemberName(member.getName());
                V3xOrgPost orgPost = DefaultStatisticDataSourceProvider.this.orgManager.getPostById(member.getOrgPostId());
                result.setPostId(orgPost.getId());
                result.setPostName(orgPost.getName());
                result.setAvatarUrl(MessageFormat.format("{0}/rest/orgMember/avatar/{1}?d={2}", SystemEnvironment.getContextPath(), memberId.toString(), DateUtil.formatDateTime((Date)new Date())));
                data = new ListRowData.Data(data.getS(), (Object)result);
            }
            return data;
        }
    }
}

