/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.datasource.statistic.pagination;

import com.google.common.collect.Lists;
import com.seeyon.cap4.bizportal.datasource.bean.PaginationParam;
import com.seeyon.cap4.bizportal.datasource.statistic.pagination.DefaultPaginationHandler;
import com.seeyon.cap4.bizportal.function.Predicate;
import com.seeyon.ctp.report.bizportal.bean.ListDataResult;
import com.seeyon.ctp.report.bizportal.bean.ListField;
import com.seeyon.ctp.report.bizportal.bean.ListRowData;
import java.util.ArrayList;
import java.util.List;

public class LineNumberPaginationHandler
extends DefaultPaginationHandler {
    @Override
    public ListDataResult pagination(PaginationParam param, Predicate<ListField> predicate, Predicate<ListRowData> rowDataPredicate, ListDataResult listDataResult) {
        ListDataResult target = new ListDataResult();
        target.setExecuteTime(listDataResult.getExecuteTime());
        this.applyListFields(listDataResult.getFields(), predicate, target);
        List data = listDataResult.getData();
        int page = param.getPage();
        int size = param.getPageSize();
        boolean needTotal = param.isNeedTotal();
        int count = data.size();
        if (count == 0) {
            target.setPage(page);
            target.setPages(1);
            target.setSize(size);
            target.setTotal(count);
            target.setData(data);
            return target;
        }
        ArrayList tempAll = Lists.newArrayListWithCapacity((int)data.size());
        int start = (page - 1) * size;
        int end = page * size;
        int i = 0;
        for (ListRowData rowData : data) {
            if (!rowDataPredicate.apply(rowData)) continue;
            tempAll.add(rowData);
            if (++i >= start && i < end) {
                this.addRowData(listDataResult, target, rowData);
            }
            if (needTotal || i != end) continue;
            break;
        }
        int pages = 0;
        if (needTotal) {
            pages = (int)Math.ceil(1.0 * (double)i / (double)size);
        }
        if (i < end) {
            if (page > pages) {
                page = pages;
            }
            start = (page - 1) * size;
            end = page * size;
            if (end > count) {
                end = count;
            }
            target.getData().clear();
            for (ListRowData rowData : data.subList(start, end)) {
                this.addRowData(listDataResult, target, rowData);
            }
        }
        target.setPage(page);
        target.setPages(pages);
        target.setSize(size);
        target.setTotal(count);
        target.setData(data);
        return target;
    }
}

