/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.manager;

import com.seeyon.cap4.bizportal.dao.BizPortalDataRelationDao;
import com.seeyon.cap4.bizportal.manager.BizPortalDataRelationManager;
import com.seeyon.cap4.bizportal.po.CAPPortalDataRelation;
import com.seeyon.ctp.common.exceptions.BusinessException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class BizPortalDataRelationManagerImpl
implements BizPortalDataRelationManager {
    private BizPortalDataRelationDao bizPortalDataRelationDao;

    @Override
    public Long createBizPortalDataRelation(Long bizId, String dataId, Long sourceId) throws BusinessException {
        CAPPortalDataRelation dataRelation = this.bizPortalDataRelationDao.getCAPPortalDataRelation(bizId, dataId, sourceId);
        if (dataRelation == null) {
            dataRelation = new CAPPortalDataRelation();
            dataRelation.setNewId();
            dataRelation.setBizId(bizId);
            dataRelation.setDataId(dataId);
            dataRelation.setSourceId(sourceId);
            dataRelation.setTargetId(dataRelation.getId());
            this.bizPortalDataRelationDao.saveCAPPortalDataRelation(dataRelation);
        }
        return dataRelation.getTargetId();
    }

    @Override
    public Long getBizPortalDataSourceId(Long bizId, String dataId, Long targetId) throws BusinessException {
        CAPPortalDataRelation relation = this.bizPortalDataRelationDao.getCAPPortalDataRelationByTargetId(bizId, dataId, targetId);
        return relation != null ? relation.getSourceId() : null;
    }

    @Override
    public List<CAPPortalDataRelation> findCAPPortalDataRelationByBizId(Long bizId) throws BusinessException {
        return this.bizPortalDataRelationDao.findCAPPortalDataRelationByBizId(bizId);
    }

    @Override
    public void createCAPPortalDataRelation(List<CAPPortalDataRelation> list) throws BusinessException {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.bizPortalDataRelationDao.createCAPPortalDataRelation(list);
    }

    @Override
    public List<CAPPortalDataRelation> findCAPPortalDataRelation(Long bizId, List<String> dataIds) throws BusinessException {
        if (CollectionUtils.isEmpty(dataIds)) {
            return Collections.emptyList();
        }
        return this.bizPortalDataRelationDao.findCAPPortalDataRelation(bizId, dataIds);
    }

    @Override
    public void updateCAPPortalDataRelation(List<CAPPortalDataRelation> list) throws BusinessException {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.bizPortalDataRelationDao.updateCAPPortalDataRelation(list);
    }

    @Override
    public void deleteCAPPortalDataRelationByBizId(Long bizId) throws BusinessException {
        this.bizPortalDataRelationDao.deleteCAPPortalDataRelationByBizId(bizId);
    }

    public void setBizPortalDataRelationDao(BizPortalDataRelationDao bizPortalDataRelationDao) {
        this.bizPortalDataRelationDao = bizPortalDataRelationDao;
    }
}

