/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.manager;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.function.Predicate;
import com.seeyon.cap4.bizportal.manager.BizPortalExternAdapterManager;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.form.modules.bizmap.BizMapBo;
import com.seeyon.ctp.form.modules.bizmap.manager.BizMapManager;
import com.seeyon.ctp.form.po.CtpBizMap;
import com.seeyon.ctp.login.bo.MenuBO;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.portal.api.PortalApi;
import com.seeyon.ctp.portal.po.PortalCustomizeMenu;
import com.seeyon.ctp.privilege.bo.PrivMenuBO;
import com.seeyon.ctp.util.FlipInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;

public class BizPortalExternAdapterManagerImpl
implements BizPortalExternAdapterManager {
    private static final Log logger = CtpLogFactory.getLog(BizPortalExternAdapterManagerImpl.class);
    private BusinessManager businessManager4;
    private TemplateManager templateManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private PortalApi portalApi;
    private CAPBusinessTemplateManager capBusinessTemplateManager;
    private BizMapManager bizMapManager;
    private OrgManager orgManager;

    @Override
    public List<FormBean> findFormBeanByOwner(User user) throws BusinessException {
        HashMap params = Maps.newHashMap();
        params.put("ownerId", user.getId());
        params.put("orgAccountId", user.getLoginAccount());
        FlipInfo fi = new FlipInfo(-1, -1);
        fi.setNeedTotal(false);
        List<Map<String, Object>> list = this.cap4FormCacheManager.getCap4FormDefinitionDAO().showFormList(fi, params);
        return Lists.transform(list, (Function)new Function<Map<String, Object>, FormBean>(){

            public FormBean apply(Map<String, Object> input) {
                return BizPortalExternAdapterManagerImpl.this.cap4FormCacheManager.getForm(MapUtils.getLong(input, (Object)"id"));
            }
        });
    }

    @Override
    public boolean isTemplateEnabled(Long templateId, Long memberId) throws BusinessException {
        return this.templateManager.isTemplateEnabled(templateId, memberId);
    }

    @Override
    public FormBean getFormBean(Long formId) {
        return this.cap4FormCacheManager.getForm(formId);
    }

    @Override
    public List<PortalCustomizeMenu> findCapCustomizeMenuList(User user) throws BusinessException {
        FlipInfo fi = new FlipInfo(1, Integer.MAX_VALUE);
        fi.setNeedTotal(false);
        FlipInfo flipInfo = this.portalApi.capCustomizeMenuList(fi, new HashMap());
        return flipInfo.getData();
    }

    @Override
    public MenuBO getBizMenu(User user, Long bizId, Long menuId) throws BusinessException {
        List menus = this.portalApi.getMenusOfMember(user);
        Predicate<MenuBO> predicate = this.getMenuPredicate(menuId);
        for (MenuBO menuBO : menus) {
            if (!predicate.apply(menuBO)) continue;
            return menuBO;
        }
        return null;
    }

    @Override
    public MenuBO getMultiMenu(User user, Long menuId) throws BusinessException {
        try {
            List menuList = (List)MethodUtils.invokeMethod((Object)AppContext.getBean((String)"portalCustomizeMenuManager"), (String)"getAllCanSeeMenusInMem", null);
            if (menuList == null) {
                return null;
            }
            int i = 0;
            HashMap<Long, Integer> menuIdsSet = new HashMap<Long, Integer>();
            for (PortalCustomizeMenu customizeMenu : menuList) {
                menuIdsSet.put(customizeMenu.getId(), i);
                ++i;
            }
            List menus = (List)MethodUtils.invokeMethod((Object)AppContext.getBean((String)"portalCacheManager"), (String)"getPortalCustomizeMenuFirstLevelList", menuIdsSet);
            Predicate<MenuBO> predicate = this.getMenuPredicate(menuId);
            for (MenuBO menuBO : menus) {
                if (!predicate.apply(menuBO)) continue;
                return menuBO;
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u7efc\u5408\u4e1a\u52a1\u83dc\u5355\u51fa\u9519:", (Throwable)e);
        }
        return null;
    }

    @Override
    public Long getUserAcessMainPortalId(User user) throws BusinessException {
        return Long.parseLong(this.portalApi.getUserAcessMainPortalIdFromCache());
    }

    @Override
    public Long getTemplatePathId(Long bizId, Long pathId, BizPortalConstants.Platform platform) {
        if (!this.capBusinessTemplateManager.isUseCustomTemplate(bizId, pathId, platform.getCode())) {
            pathId = 0L;
        }
        return pathId;
    }

    @Override
    public List<CtpBizMap> findCtpBizMap(Long bizId) throws BusinessException {
        return this.bizMapManager.getBizMapByBizId(bizId);
    }

    @Override
    public boolean checkBizMapAuth(Long mapId, User user) throws BusinessException {
        CtpBizMap bizMap = this.bizMapManager.getBizMap(mapId);
        if (bizMap == null) {
            return false;
        }
        return bizMap.checkRight(this.orgManager.getAllUserDomainIDs(user.getId()));
    }

    @Override
    public BizMapBo findBizMapAndItem(Long id) throws BusinessException {
        return this.bizMapManager.getBizMapAndItem(id, true);
    }

    @Override
    public boolean isCAPPortalMenuChecked(Long bizId) throws BusinessException {
        BizConfigBean bizConfigBean = this.getBizConfigBean(bizId);
        List menuList = bizConfigBean.getMenuList();
        if (CollectionUtils.isNotEmpty((Collection)menuList)) {
            for (PrivMenuBO privMenuBO : menuList) {
                if (privMenuBO.getExt12().intValue() != Enums.SourceType.SOURCE_TYPE_BIZHOMEPAGE.getKey()) continue;
                return true;
            }
        }
        return false;
    }

    private Predicate<MenuBO> getMenuPredicate(final Long menuId) {
        return new Predicate<MenuBO>(){

            @Override
            public boolean apply(MenuBO input) {
                return ObjectUtils.equals((Object)input.getId(), (Object)menuId);
            }
        };
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setPortalApi(PortalApi portalApi) {
        this.portalApi = portalApi;
    }

    public void setCapBusinessTemplateManager(CAPBusinessTemplateManager capBusinessTemplateManager) {
        this.capBusinessTemplateManager = capBusinessTemplateManager;
    }

    public void setBizMapManager(BizMapManager bizMapManager) {
        this.bizMapManager = bizMapManager;
    }

    @Override
    public List<BizConfigBean> findBizConfigBeanByOwner(Long memberId) throws BusinessException {
        HashMap params = Maps.newHashMap();
        params.put("businessType", 0);
        params.put("condition", "name");
        params.put("nameSearch", "");
        params.put("activeTab", "mineapp");
        params.put("showInvalid", false);
        Map<String, Object> map = this.businessManager4.listBusiness(new FlipInfo(-1, -1), params);
        FlipInfo fi = (FlipInfo)map.get("validBusiness");
        List validBusiness = fi.getData();
        ArrayList list = Lists.newArrayListWithCapacity((int)validBusiness.size());
        for (Map business : validBusiness) {
            CollectionUtils.addIgnoreNull((Collection)list, (Object)this.getBizConfigBean(MapUtils.getLong((Map)business, (Object)"id")));
        }
        return list;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    @Override
    public BizConfigBean getBizConfigBean(Long bizId) throws BusinessException {
        return this.businessManager4.findBizConfigById(bizId);
    }

    @Override
    public List<FormBean> findFormBeanByBizId(Long bizId) throws BusinessException {
        return this.businessManager4.getFormBeanListByBizId(bizId);
    }

    @Override
    public boolean isFlowBean(FormBean formBean) {
        return formBean.getFormType() == Enums.FormType.processesForm.getKey();
    }

    @Override
    public List<CtpTemplate> findCtpTemplateByFormId(Long formId) throws BusinessException {
        return this.templateManager.getCtpTemplates(formId.longValue(), false);
    }
}

