/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.manager;

import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.bean.BizPortalSectionConfigJson;
import com.seeyon.cap4.bizportal.dao.BizPortalFileDao;
import com.seeyon.cap4.bizportal.exception.NotAcceptablePlatformException;
import com.seeyon.cap4.bizportal.manager.BizPortalFileManager;
import com.seeyon.cap4.bizportal.manager.BizPortalGoodSnapshotManagerImpl;
import com.seeyon.cap4.bizportal.param.BizPortalFileListParam;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.po.CAPPortalFile;
import com.seeyon.cap4.bizportal.utils.BizPortalUtils;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.FlipInfo;
import java.io.File;
import java.util.Date;

public class BizPortalFileManagerImpl
implements BizPortalFileManager {
    private BizPortalFileDao bizPortalFileDao;

    public void setBizPortalFileDao(BizPortalFileDao bizPortalFileDao) {
        this.bizPortalFileDao = bizPortalFileDao;
    }

    @Override
    public CAPPortalFile createCAPPortalSectionFile(ContextParam contextParam, File zipFile) throws BusinessException {
        File tempDir = BizPortalUtils.createDirIfAbsent(this.getLocalDir(), String.valueOf(new Date().getTime()));
        BizPortalUtils.unzip(zipFile, tempDir);
        BizPortalSectionConfigJson configJson = BizPortalUtils.get(new File(tempDir, "config.json"), BizPortalSectionConfigJson.class);
        if (configJson.getUUID() == null) {
            throw new BusinessException("\u680f\u76ee\u5305\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        BizPortalConstants.Platform platform = BizPortalUtils.getEnumByCode(BizPortalConstants.Platform.class, configJson.getPlatform());
        if (platform == null || !platform.contains(contextParam.getPlatform())) {
            throw new NotAcceptablePlatformException("\u4e0a\u4f20\u7684\u672c\u5730\u680f\u76ee\u6240\u5c5e\u7ec8\u7aef\u4e0d\u5339\u914d\uff01");
        }
        CAPPortalFile capPortalFile = new CAPPortalFile();
        capPortalFile.setIdIfNew();
        capPortalFile.setClassType(BizPortalConstants.GoodsClassKey.PORTAL_SPACE_Section.getKey());
        capPortalFile.setDeleteFlag(false);
        capPortalFile.setCreateTime(new Date());
        capPortalFile.setCreateMember(contextParam.getUserId());
        capPortalFile.setCreateAccountId(contextParam.getAccountId());
        capPortalFile.setName(configJson.getName());
        capPortalFile.setPlatform(configJson.getPlatform());
        this.bizPortalFileDao.saveCAPPortalFile(capPortalFile);
        BizPortalUtils.deleteDirectory(tempDir);
        BizPortalUtils.copyFile(zipFile, this.getZipFile(capPortalFile.getId()));
        return capPortalFile;
    }

    @Override
    public FlipInfo findCAPPortalFile(ContextParam contextParam, BizPortalConstants.GoodsClassKey goodsClassKey, BizPortalFileListParam listParam, BizPortalConstants.Platform ... platform) throws BusinessException {
        return this.bizPortalFileDao.findCAPPortalFile(contextParam.getUserId(), goodsClassKey, listParam, platform);
    }

    @Override
    public FlipInfo findCAPPortalFileExcludeMember(ContextParam contextParam, BizPortalConstants.GoodsClassKey goodsClassKey, BizPortalFileListParam listParam, BizPortalConstants.Platform ... platform) throws BusinessException {
        return this.bizPortalFileDao.findCAPPortalFileExcludeMember(contextParam.getUserId(), goodsClassKey, listParam, platform);
    }

    @Override
    public CAPPortalFile getCAPPortalFile(Long id) {
        return this.bizPortalFileDao.getCAPPortalFile(id);
    }

    @Override
    public void deleteCAPPortalFile(Long id) {
        CAPPortalFile capPortalFile = this.getCAPPortalFile(id);
        if (capPortalFile == null) {
            return;
        }
        capPortalFile.setDeleteFlag(true);
        this.bizPortalFileDao.updateCAPPortalFile(capPortalFile);
    }

    @Override
    public File getBizPortalZipFile(Long id) throws BusinessException {
        return this.getZipFile(id);
    }

    private File getLocalDir() throws BusinessException {
        return BizPortalUtils.createDirIfAbsent(BizPortalGoodSnapshotManagerImpl.getCAPBizPortalBaseFile(), "local");
    }

    private File getZipFile(Long id) throws BusinessException {
        return new File(this.getLocalDir(), String.valueOf(id));
    }
}

