/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.manager;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.bean.BizPortalGoodSnapshotMeta;
import com.seeyon.cap4.bizportal.bean.DownloadGoodInfo;
import com.seeyon.cap4.bizportal.bean.SimpleManifestFile;
import com.seeyon.cap4.bizportal.dao.BizPortalGoodSnapshotDao;
import com.seeyon.cap4.bizportal.exception.NetworkErrorException;
import com.seeyon.cap4.bizportal.manager.BizPortalGoodSnapshotManager;
import com.seeyon.cap4.bizportal.manager.BizPortalGoodsDownloadCallback;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.po.CAPPortalGoodSnapshot;
import com.seeyon.cap4.bizportal.utils.BizPortalUtils;
import com.seeyon.cap4.template.util.HttpClientUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class BizPortalGoodSnapshotManagerImpl
implements BizPortalGoodSnapshotManager {
    private volatile Map<Long, Object> appIdCache = new ConcurrentHashMap<Long, Object>(100);
    private LoadingCache<Long, Optional<CAPPortalGoodSnapshot>> loadingCache = CacheBuilder.newBuilder().concurrencyLevel(50).expireAfterAccess(30L, TimeUnit.MINUTES).initialCapacity(100).maximumSize(1000L).build((CacheLoader)new CacheLoader<Long, Optional<CAPPortalGoodSnapshot>>(){

        public Optional<CAPPortalGoodSnapshot> load(Long key) throws Exception {
            CAPPortalGoodSnapshot snapshot = BizPortalGoodSnapshotManagerImpl.this.bizPortalGoodSnapshotDao.getCAPPortalGoodSnapshot(key);
            return snapshot == null ? Optional.absent() : Optional.of((Object)((Object)snapshot));
        }
    });
    private BizPortalGoodSnapshotDao bizPortalGoodSnapshotDao;
    private static final Log logger = CtpLogFactory.getLog(BizPortalGoodSnapshotManagerImpl.class);

    @Override
    public <T> T getBizPortalConfigJson(CAPPortalGoodSnapshot snapshot, Class<T> clazz) throws BusinessException {
        return this.getBizPortalConfigJson(snapshot.getId(), clazz);
    }

    @Override
    public <T> T getBizPortalConfigJson(Long snapshotId, Class<T> clazz) throws BusinessException {
        File file = new File(this.getGoodSnapshotFile(snapshotId, false), "config.json");
        if (!file.exists()) {
            return null;
        }
        return BizPortalUtils.get(file, clazz);
    }

    @Override
    public Resource getRelativeResource(Long snapshotId, String relativePath) throws BusinessException {
        File goodDir = this.getBizPortalGoodSnapshotDir(snapshotId);
        File file = new File(goodDir, relativePath);
        try {
            if (!file.getCanonicalPath().startsWith(goodDir.getCanonicalPath())) {
                throw new IllegalAccessError("\u975e\u6cd5\u8bbf\u95ee");
            }
            return new FileSystemResource(file);
        }
        catch (IOException e) {
            logger.error((Object)"\u83b7\u53d6\u8d44\u6e90\u51fa\u9519:", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
    }

    @Override
    public Long createGoodSnapshot(ContextParam contextParam, String goodsKey, DownloadGoodInfo downloadGoodInfo) throws BusinessException {
        Date goodUpdateTime = this.parseDate(downloadGoodInfo.getGoodUpdateTime());
        CAPPortalGoodSnapshot snapshot = this.bizPortalGoodSnapshotDao.getCAPPortalGoodSnapshot(downloadGoodInfo.getGoodsId(), goodUpdateTime);
        if (snapshot == null) {
            File zipFile = new File(this.getDownloadsDir(), String.valueOf(UUIDLong.longUUID()));
            if (!HttpClientUtil.doHttpFileDownload(downloadGoodInfo.getUrl(), zipFile)) {
                throw new NetworkErrorException("\u4e0b\u8f7d\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u7f51\u7edc\u8bbe\u7f6e!");
            }
            BizPortalGoodSnapshotMeta metadata = new BizPortalGoodSnapshotMeta();
            metadata.setGoodsKey(goodsKey);
            metadata.setSubGoodsKey(downloadGoodInfo.getGoodsTypeKey());
            metadata.setGoodsId(downloadGoodInfo.getGoodsId());
            metadata.setGoodsName(downloadGoodInfo.getGoodsName());
            metadata.setInfoUrl(downloadGoodInfo.getInfoUrl());
            metadata.setGoodUpdateTime(goodUpdateTime);
            metadata.setSourceType(BizPortalConstants.SourceType.CLOUD_CENTER.getCode());
            metadata.setCreateTime(new Date());
            metadata.setVersionNo(downloadGoodInfo.getVersionNo());
            metadata.setVersionDesc(downloadGoodInfo.getVersionDesc());
            snapshot = this.createGoodSnapshot(metadata, zipFile, contextParam);
        } else {
            File goodFile = this.getGoodSnapshotFile(snapshot.getId(), false);
            if (!goodFile.exists()) {
                goodFile = this.getGoodSnapshotFile(snapshot.getId(), true);
                File zipFile = new File(this.getDownloadsDir(), String.valueOf(UUIDLong.longUUID()));
                if (!HttpClientUtil.doHttpFileDownload(downloadGoodInfo.getUrl(), zipFile)) {
                    throw new NetworkErrorException("\u4e0b\u8f7d\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u7f51\u7edc\u8bbe\u7f6e!");
                }
                BizPortalUtils.unzip(zipFile, goodFile);
            }
            snapshot.setSourceType(BizPortalConstants.SourceType.CLOUD_CENTER.getCode());
            this.bizPortalGoodSnapshotDao.updateCAPPortalGoodSnapshot(snapshot);
        }
        return this.getDownloadAndCreateCallback(goodsKey).doExecute(contextParam, snapshot, downloadGoodInfo);
    }

    @Override
    public CAPPortalGoodSnapshot getCAPPortalGoodSnapshot(Long snapshotId) throws BusinessException {
        try {
            Optional optional = (Optional)this.loadingCache.get((Object)snapshotId);
            return optional.isPresent() ? (CAPPortalGoodSnapshot)((Object)optional.get()) : null;
        }
        catch (ExecutionException e) {
            logger.error((Object)"\u7f13\u5b58\u5f02\u5e38\uff1a", (Throwable)e);
            return this.bizPortalGoodSnapshotDao.getCAPPortalGoodSnapshot(snapshotId);
        }
    }

    @Override
    public File getBizPortalGoodSnapshotDir(Long snapshotId) throws BusinessException {
        return this.getGoodSnapshotFile(snapshotId, false);
    }

    @Override
    public CAPPortalGoodSnapshot getCAPPortalGoodSnapshot(String goodsId, Date goodsUpdateTime) {
        if (StringUtils.isEmpty((CharSequence)goodsId) || goodsUpdateTime == null) {
            return null;
        }
        return this.bizPortalGoodSnapshotDao.getCAPPortalGoodSnapshot(goodsId, goodsUpdateTime);
    }

    @Override
    public CAPPortalGoodSnapshot createGoodSnapshot(SimpleManifestFile manifestFile, File parentDir, ContextParam contextParam) throws BusinessException {
        BizPortalGoodSnapshotMeta metadata = new BizPortalGoodSnapshotMeta();
        metadata.setGoodsKey(manifestFile.getGoodsKey());
        metadata.setSubGoodsKey(manifestFile.getSubGoodsKey());
        metadata.setGoodsId(manifestFile.getGoodsId());
        metadata.setGoodsName(manifestFile.getGoodsName());
        metadata.setInfoUrl(manifestFile.getInfoUrl());
        metadata.setGoodUpdateTime(manifestFile.getGoodUpdateTime());
        metadata.setSourceType(manifestFile.getSourceType());
        metadata.setCreateTime(new Date());
        metadata.setVersionNo(manifestFile.getVersionNo());
        metadata.setVersionDesc(manifestFile.getVersionDesc());
        return this.createGoodSnapshot(metadata, BizPortalUtils.getRelative(parentDir, manifestFile.getFile()), contextParam);
    }

    @Override
    public CAPPortalGoodSnapshot createGoodSnapshot(BizPortalGoodSnapshotMeta metadata, File zipFile, ContextParam contextParam) throws BusinessException {
        CAPPortalGoodSnapshot snapshot = this.createGoodSnapshot(metadata, contextParam);
        File goodFile = this.getGoodSnapshotFile(snapshot.getId(), true);
        BizPortalUtils.unzip(zipFile, goodFile);
        return snapshot;
    }

    @Override
    public void copyGoodsSnapshotPackage(Long snapshotId, File target) throws BusinessException {
        File zipFile = this.getZipFile(snapshotId);
        if (!zipFile.exists()) {
            BizPortalUtils.zip(this.getBizPortalGoodSnapshotDir(snapshotId), zipFile);
        }
        BizPortalUtils.copyFile(zipFile, target);
    }

    @Override
    public CAPPortalGoodSnapshot createGoodSnapshot(BizPortalGoodSnapshotMeta metadata, ContextParam contextParam) throws BusinessException {
        CAPPortalGoodSnapshot snapshot = new CAPPortalGoodSnapshot();
        snapshot.setIdIfNew();
        snapshot.setGoodsKey(metadata.getGoodsKey());
        snapshot.setSubGoodsKey(metadata.getSubGoodsKey());
        snapshot.setGoodsId(metadata.getGoodsId());
        snapshot.setGoodsName(metadata.getGoodsName());
        snapshot.setInfoUrl(metadata.getInfoUrl());
        snapshot.setGoodUpdateTime(metadata.getGoodUpdateTime());
        snapshot.setSourceType(metadata.getSourceType());
        snapshot.setSourceId(metadata.getSourceId());
        snapshot.setCreateTime(metadata.getCreateTime());
        snapshot.setVersionNo(metadata.getVersionNo());
        snapshot.setVersionDesc(metadata.getVersionDesc());
        this.bizPortalGoodSnapshotDao.saveCAPPortalGoodSnapshot(snapshot);
        return snapshot;
    }

    @Override
    public List<CAPPortalGoodSnapshot> findCAPPortalGoodSnapshot(String goodsId) throws BusinessException {
        if (StringUtils.isEmpty((CharSequence)goodsId)) {
            return Collections.emptyList();
        }
        return this.bizPortalGoodSnapshotDao.findCAPPortalGoodSnapshotBySourceId(goodsId);
    }

    @Override
    public List<CAPPortalGoodSnapshot> findCAPPortalGoodSnapshot(Long sourceId) throws BusinessException {
        if (sourceId == null) {
            return Collections.emptyList();
        }
        return this.bizPortalGoodSnapshotDao.findCAPPortalGoodSnapshotBySourceId(sourceId);
    }

    @Override
    public CAPPortalGoodSnapshot createGoodSnapshotIfNotExist(SimpleManifestFile manifestFile, File parentDir, ContextParam contextParam) throws BusinessException {
        CAPPortalGoodSnapshot goodSnapshot;
        if (ObjectUtils.equals((Object)manifestFile.getSourceType(), (Object)BizPortalConstants.SourceType.CLOUD_CENTER.getCode())) {
            goodSnapshot = this.getCAPPortalGoodSnapshot(manifestFile.getGoodsId(), manifestFile.getGoodUpdateTime());
            if (goodSnapshot == null) {
                goodSnapshot = this.createGoodSnapshot(manifestFile, parentDir, contextParam);
            }
        } else {
            goodSnapshot = this.createGoodSnapshot(manifestFile, parentDir, contextParam);
        }
        return goodSnapshot;
    }

    @Override
    public void deleteCAPPortalGoodSnapshot(final Long snapshotId) throws BusinessException {
        CAPPortalGoodSnapshot snapshot = this.getCAPPortalGoodSnapshot(snapshotId);
        if (snapshot == null) {
            return;
        }
        this.bizPortalGoodSnapshotDao.deleteCAPPortalGoodSnapshot(snapshot);
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    try {
                        BizPortalUtils.deleteDirectory(BizPortalGoodSnapshotManagerImpl.this.getBizPortalGoodSnapshotDir(snapshotId));
                    }
                    catch (BusinessException e) {
                        logger.error((Object)("\u5220\u9664\u5feb\u7167[id=" + snapshotId + "]\u5931\u8d25"), (Throwable)e);
                    }
                }
            });
        } else {
            BizPortalUtils.deleteDirectory(this.getBizPortalGoodSnapshotDir(snapshotId));
        }
    }

    @Override
    public File createAppFile(Long snapshotId) throws BusinessException {
        if (this.appIdCache.containsKey(snapshotId)) {
            return null;
        }
        this.appIdCache.put(snapshotId, "");
        File appFile = new File(this.getAppDir(), snapshotId + ".zip");
        File dir = this.getBizPortalGoodSnapshotDir(snapshotId);
        File file = new File(dir, "manifest.json");
        CAPPortalGoodSnapshot snapshot = this.getCAPPortalGoodSnapshot(snapshotId);
        ManifestJSON manifestJSON = new ManifestJSON(snapshotId.toString(), snapshot.getGoodsName());
        BizPortalUtils.write(file, JSONUtil.toJSONString((Object)manifestJSON));
        BizPortalUtils.zip(dir.listFiles(), appFile);
        return appFile;
    }

    private BizPortalGoodsDownloadCallback getDownloadAndCreateCallback(String goodClass) {
        Map beansOfType = AppContext.getBeansOfType(BizPortalGoodsDownloadCallback.class);
        for (BizPortalGoodsDownloadCallback callback : beansOfType.values()) {
            if (!StringUtils.equals((CharSequence)goodClass, (CharSequence)callback.goodsClass())) continue;
            return callback;
        }
        return null;
    }

    static File getCAPBizPortalBaseFile() throws BusinessException {
        return SystemEnvironment.getClusterPublicFolder((String)"capBizPortal");
    }

    private File getDownloadsDir() throws BusinessException {
        return BizPortalUtils.createDirIfAbsent(BizPortalGoodSnapshotManagerImpl.getCAPBizPortalBaseFile(), "downloads");
    }

    private File getZipFile() throws BusinessException {
        return BizPortalUtils.createDirIfAbsent(BizPortalGoodSnapshotManagerImpl.getCAPBizPortalBaseFile(), "zipFiles");
    }

    private File getAppDir() throws BusinessException {
        return BizPortalUtils.createDirIfAbsent(BizPortalGoodSnapshotManagerImpl.getCAPBizPortalBaseFile(), "apps");
    }

    private File getGoodSnapshotFile(Long id, boolean mkdir) throws BusinessException {
        File baseFile = BizPortalGoodSnapshotManagerImpl.getCAPBizPortalBaseFile();
        File goodFile = new File(baseFile, id.toString());
        if (mkdir && !goodFile.exists()) {
            goodFile.mkdir();
        }
        return goodFile;
    }

    private File getZipFile(Long id) throws BusinessException {
        return new File(this.getZipFile(), id.toString());
    }

    private Date parseDate(String dateStr) {
        try {
            return DateUtil.parse((String)dateStr);
        }
        catch (ParseException e) {
            logger.error((Object)("\u8f6c\u6362\u4e3a\u65e5\u671f\u51fa\u9519\uff0cdateStr=" + dateStr), (Throwable)e);
            return null;
        }
    }

    public void setBizPortalGoodSnapshotDao(BizPortalGoodSnapshotDao bizPortalGoodSnapshotDao) {
        this.bizPortalGoodSnapshotDao = bizPortalGoodSnapshotDao;
    }

    public static class ManifestJSON
    implements Serializable {
        private String appId;
        private String appName;

        ManifestJSON(String appId, String appName) {
            this.appId = appId;
            this.appName = appName;
        }

        public String getPackageType() {
            return "APP";
        }

        public List<String> getCompatibleVersion() {
            return Lists.newArrayList((Object[])new String[]{"1.0.0", "1.0.1", "2.0.0"});
        }

        public Map<String, String> getUpdate() {
            return ImmutableMap.of((Object)"checkUpdateUrl", (Object)"");
        }

        public String getBuildVersion() {
            return "com.seeyon.v5." + this.appId;
        }

        public String getAppName() {
            return this.appName;
        }

        public Map<String, String> getCmpShellVersion() {
            return ImmutableMap.of((Object)"ios", (Object)"1.0.0", (Object)"android", (Object)"1.0.0");
        }

        public String getDesc() {
            return this.appName;
        }

        public Map<String, String> getEntry() {
            return ImmutableMap.of((Object)"phone", (Object)"dist/index.html");
        }

        public List<String> getSupportedPlatforms() {
            return Lists.newArrayList((Object[])new String[]{"iOS_6.0", "android_4.0"});
        }

        public List<String> getSplashscreen() {
            return Collections.emptyList();
        }

        public String getVersion() {
            return "1.0.0";
        }

        public String getAppType() {
            return "default";
        }

        public String getAppId() {
            return this.appId;
        }

        private String getServiceProvidear() {
            return "seeyon";
        }

        public String getTeam() {
            return "v5";
        }

        public Map<String, ?> getIconFiles() {
            return ImmutableMap.of((Object)"default", (Object)"", (Object)"multi", Collections.emptyList());
        }

        public String getUrlSchemes() {
            return this.appId + ".v5.cmp";
        }

        public String getBundleName() {
            return this.appId;
        }
    }
}

