/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.ConfigJson;
import com.seeyon.cap4.bizportal.bean.BizPortalLayoutConfig;
import com.seeyon.cap4.bizportal.dao.BizPortalLayoutDao;
import com.seeyon.cap4.bizportal.exception.DuplicateKeyException;
import com.seeyon.cap4.bizportal.manager.BizPortalLayoutManager;
import com.seeyon.cap4.bizportal.param.BizPortalCollectLayoutParam;
import com.seeyon.cap4.bizportal.po.CAPPortalLayout;
import com.seeyon.cap4.bizportal.utils.BizPortalUtils;
import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class BizPortalLayoutManagerImpl
extends AbstractSystemInitializer
implements BizPortalLayoutManager {
    private static final Log logger = CtpLogFactory.getLog(BizPortalLayoutManagerImpl.class);
    private List<CAPPortalLayout> systemLayouts = Lists.newArrayList();
    private Map<Long, CAPPortalLayout> systemLayoutMapping = Maps.newLinkedHashMap();
    private BizPortalLayoutDao bizPortalLayoutDao;

    public void initialize() {
        File directory = this.getLayoutDirectory();
        logger.info((Object)("\u4e1a\u52a1\u7a7a\u95f4-\u7cfb\u7edf\u9884\u7f6e\u5e03\u5c40\u76ee\u5f55:" + directory.getAbsolutePath()));
        if (!directory.exists()) {
            logger.error((Object)"\u4e1a\u52a1\u7a7a\u95f4-\u7cfb\u7edf\u9884\u7f6e\u5e03\u5c40\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!");
            return;
        }
        Object[] files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (ArrayUtils.isEmpty((Object[])files)) {
            logger.error((Object)"\u4e1a\u52a1\u7a7a\u95f4-\u7cfb\u7edf\u9884\u7f6e\u5e03\u5c40\u6ca1\u6709\uff0c\u8bf7\u68c0\u67e5!");
            return;
        }
        ArrayList list = Lists.newArrayList();
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (Object file : files) {
            BizPortalLayoutConfigJson configJson = BizPortalUtils.get(new File((File)file, "config.json"), BizPortalLayoutConfigJson.class);
            CAPPortalLayout layout = new CAPPortalLayout();
            layout.setId(configJson.getId());
            layout.setName(configJson.getName());
            layout.setPlatform(BizPortalConstants.Platform.PC.getCode());
            layout.setType(BizPortalConstants.LayoutType.SYSTEM.getCode());
            layout.setLayoutInfo(configJson.getLayout());
            layout.setImageId(FilenameUtils.normalize((String)(((File)file).getAbsolutePath() + File.separator + configJson.getCover())));
            list.add(layout);
            map.put(layout.getId(), layout);
        }
        this.systemLayouts = Collections.unmodifiableList(list);
        this.systemLayoutMapping = Collections.unmodifiableMap(map);
    }

    private File getLayoutDirectory() {
        String application = SystemEnvironment.getApplicationFolder();
        return new File(application, FilenameUtils.normalize((String)"common\\cap4\\template\\designPortalSpace\\layout"));
    }

    @Override
    public CAPPortalLayout getCAPPortalLayout(Long layoutId) throws BusinessException {
        CAPPortalLayout layout = this.systemLayoutMapping.get(layoutId);
        if (layout == null) {
            layout = this.bizPortalLayoutDao.getCAPPortalLayout(layoutId);
        }
        return layout;
    }

    @Override
    public List<CAPPortalLayout> findCAPPortalLayout(User user) throws BusinessException {
        List<CAPPortalLayout> collectedLayouts = this.bizPortalLayoutDao.findCAPPortalLayoutByCreateMember(user.getId());
        if (CollectionUtils.isNotEmpty(collectedLayouts)) {
            ArrayList list = Lists.newArrayListWithCapacity((int)(this.systemLayouts.size() + collectedLayouts.size()));
            list.addAll(this.systemLayouts);
            list.addAll(collectedLayouts);
            return list;
        }
        return this.systemLayouts;
    }

    @Override
    public Resource getBizPortalLayoutCover(Long layoutId) throws BusinessException {
        CAPPortalLayout layout = this.getCAPPortalLayout(layoutId);
        if (layout != null) {
            Integer type = layout.getType();
            if (type.intValue() == BizPortalConstants.LayoutType.SYSTEM.getCode()) {
                return new FileSystemResource(layout.getImageId());
            }
            return new FileSystemResource(new File(this.getLayoutDirectory(), "default.png"));
        }
        return null;
    }

    @Override
    public CAPPortalLayout createCAPPortalLayout(BizPortalCollectLayoutParam layoutParam, User user) throws DuplicateKeyException, BusinessException {
        if (this.bizPortalLayoutDao.existCAPPortalLayout(layoutParam.getName(), user.getId())) {
            throw new DuplicateKeyException("\u7cfb\u7edf\u5185\u5df2\u6709\u8be5\u7a7a\u95f4\u5e03\u5c40\u540d\u79f0\uff01");
        }
        CAPPortalLayout portalLayout = new CAPPortalLayout();
        portalLayout.setIdIfNew();
        portalLayout.setName(layoutParam.getName());
        portalLayout.setCreateMember(user.getId());
        portalLayout.setCreateTime(new Date());
        portalLayout.setPlatform(layoutParam.getPlatform());
        portalLayout.setType(BizPortalConstants.LayoutType.Collected.getCode());
        BizPortalLayoutConfig layoutConfig = new BizPortalLayoutConfig(layoutParam.getLayout());
        layoutConfig.erasecolumnGroups();
        String layout = JSONUtil.toJSONString((Object)layoutConfig);
        portalLayout.setLayoutInfo(layout);
        portalLayout.setDeleteFlag(false);
        this.bizPortalLayoutDao.saveCAPPortalLayout(portalLayout);
        return portalLayout;
    }

    @Override
    public void removeCAPPortalLayout(Long layoutId, User user) throws BusinessException {
        this.bizPortalLayoutDao.removeCAPPortalLayout(layoutId);
    }

    public void setBizPortalLayoutDao(BizPortalLayoutDao bizPortalLayoutDao) {
        this.bizPortalLayoutDao = bizPortalLayoutDao;
    }

    public static class BizPortalLayoutConfigJson
    implements ConfigJson {
        private Long id;
        private String name;
        private String layout;
        private String cover;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLayout() {
            return this.layout;
        }

        public void setLayout(String layout) {
            this.layout = layout;
        }

        public String getCover() {
            return this.cover;
        }

        public void setCover(String cover) {
            this.cover = cover;
        }
    }
}

