/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.manager;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.apps.collaboration.api.CollaborationApi;
import com.seeyon.apps.collaboration.po.ColSummary;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.LinkSupport;
import com.seeyon.cap4.bizportal.datasource.link.LinkDataSetResult;
import com.seeyon.cap4.bizportal.datasource.link.MobileLinkDataSetResult;
import com.seeyon.cap4.bizportal.manager.BizPortalExternAdapterManager;
import com.seeyon.cap4.bizportal.manager.BizPortalLinkFactoryManager;
import com.seeyon.cap4.bizportal.manager.BizPortalSpaceManager;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.po.CAPPortalSpace;
import com.seeyon.cap4.bizportal.po.CAPPortalSpaceConfig;
import com.seeyon.cap4.bizportal.utils.LinkSupportUtil;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.ReflectionUtils;

public class BizPortalLinkFactoryManagerImpl
implements BizPortalLinkFactoryManager,
InitializingBean {
    private static final Log logger = CtpLogFactory.getLog(BizPortalLinkFactoryManagerImpl.class);
    private static final String NEW_COLLABORATION_PATTERN = "/collaboration/collaboration.do?method=newColl&from=bizconfig&firstName={0}&secondName={1}&menuId={3}&templateId={templateId}";
    private static final String LIST_PENDING_COLLABORATION_PATTERN = "/form/business.do?method=listBizColList&srcFrom=bizconfig&firstName={0}&secondName={1}&menuId={2}&templeteId={templateId}";
    private static final String LIST_PENDING_FLOW_PATTERN = "/cap4/businessTemplateController.do?method=capFlowListNew&srcFrom=bizconfig&businessId={bizId}&moduleId={moduleId}&formId={formId}";
    private static final String LIST_UNFLOW_PATTERN = "/cap4/businessTemplateController.do?method=capUnflowList&srcFrom=bizconfig&businessId={bizId}&moduleId={moduleId}&formId={formId}&type=baseInfo&tag={tag}";
    private static final String LIST_CAP4_REPORT_PATTERN = "/report4Result.do?method=showResult&designType={designType}&designId={designId}&businessId={bizId}";
    private static final String DOC_HOME_PAGE_INDEX_PATTERN = "/doc.do?method=docHomepageIndex&srcFrom=bizconfig&firstName={0}&secondName={1}&docResId={docResId}";
    private static final String BUL_INDEX_PATTERN = "/bulData.do?method=bulIndex&typeId={typeId}";
    private static final String NEWS_INDEX_PATTERN = "/newsData.do?method=newsIndex&boardId={boardId}";
    private static final String BBS_INDEX_PATTERN = "/bbs.do?method=bbsIndex&boardId={boardId}";
    private static final String INQUIRY_BOARDINDEX_PATTERN = "/inquiryData.do?method=inquiryBoardIndex&boardId={boardId}";
    private static final String VIEW_BIZPORTAL_SPACE_PATTERN = "/cap4/bizportal.do?method=viewBizPortalSpace&spaceId={spaceId}";
    private static final String BLOG_HOME_PATTERN = "/blog.do?method=blogHome";
    private Map<String, LinkSupport> linkSupportMap = Maps.newHashMap();
    private AntPathMatcher antPathMatcher = new AntPathMatcher();
    private BizPortalExternAdapterManager bizPortalExternAdapterManager;
    private BizPortalSpaceManager bizPortalSpaceManager;
    private CollaborationApi collaborationApi;

    @Override
    public LinkDataSetResult newCollaboration(ContextParam contextParam, Long templateId) {
        LinkDataSetResult dataSetResult = this.isMobile(contextParam) ? MobileLinkDataSetResult.of(this.getAppId(ApplicationCategoryEnum.collaboration), "newColl", ImmutableMap.of((Object)"templateId", (Object)templateId, (Object)"newWebView", (Object)true)) : LinkDataSetResult.of(this.replaceURL(NEW_COLLABORATION_PATTERN, (Map)ImmutableMap.of((Object)"templateId", (Object)templateId)));
        return dataSetResult;
    }

    @Link(value="/collaboration/collaboration.do?method=newColl&from=bizconfig&firstName={0}&secondName={1}&menuId={3}&templateId={templateId}")
    private LinkDataSetResult newCollaboration(ContextParam contextParam, Map<String, String> params) {
        return this.newCollaboration(contextParam, Long.parseLong(params.get("templateId")));
    }

    @Override
    public LinkDataSetResult listPendingCollaboration(ContextParam contextParam, Long templateId) {
        LinkDataSetResult dataSetResult = this.isMobile(contextParam) ? MobileLinkDataSetResult.of(this.getAppId(ApplicationCategoryEnum.collaboration), "openList", ImmutableMap.of((Object)"templeteIds", (Object)templateId, (Object)"newWebView", (Object)true, (Object)"openFrom", (Object)"listPending")) : LinkDataSetResult.of(this.replaceURL(LIST_PENDING_COLLABORATION_PATTERN, (Map)ImmutableMap.of((Object)"templateId", (Object)templateId)));
        return dataSetResult;
    }

    @Link(value="/form/business.do?method=listBizColList&srcFrom=bizconfig&firstName={0}&secondName={1}&menuId={2}&templeteId={templateId}")
    private LinkDataSetResult listPendingCollaboration(ContextParam contextParam, Map<String, String> params) {
        return this.listPendingCollaboration(contextParam, Long.parseLong(params.get("templateId")));
    }

    @Override
    public LinkDataSetResult listPendingFlow(ContextParam contextParam, Long bizId, Long formId, Long moduleId) {
        LinkDataSetResult dataSetResult;
        if (this.isMobile(contextParam)) {
            ImmutableMap params = ImmutableMap.of((Object)"bussId", (Object)bizId, (Object)"formId", (Object)formId, (Object)"appId", (Object)moduleId);
            dataSetResult = MobileLinkDataSetResult.of(this.getAppId(ApplicationCategoryEnum.cap4todolist), "openTodoList", params);
        } else {
            ImmutableMap map = ImmutableMap.of((Object)"bizId", (Object)bizId, (Object)"moduleId", (Object)moduleId, (Object)"formId", (Object)formId);
            dataSetResult = LinkDataSetResult.of(this.replaceURL(LIST_PENDING_FLOW_PATTERN, (Map)map));
        }
        return dataSetResult;
    }

    @Link(value="/cap4/businessTemplateController.do?method=capFlowListNew&srcFrom=bizconfig&businessId={bizId}&moduleId={moduleId}&formId={formId}")
    private LinkDataSetResult listPendingFlow(ContextParam contextParam, Map<String, String> params) {
        return this.listPendingFlow(contextParam, MapUtils.getLong(params, (Object)"bizId"), MapUtils.getLong(params, (Object)"formId"), MapUtils.getLong(params, (Object)"moduleId"));
    }

    @Override
    public LinkDataSetResult listPending(ContextParam contextParam, Long summaryId, Long affairId) throws BusinessException {
        LinkDataSetResult dataSetResult;
        if (this.isMobile(contextParam)) {
            ColSummary summary = this.collaborationApi.getColSummary(summaryId);
            ImmutableMap params = ImmutableMap.of((Object)"affairId", (Object)affairId, (Object)"summaryId", (Object)summaryId, (Object)"openFrom", (Object)"listPending", (Object)"title", (Object)summary.getSubject());
            dataSetResult = MobileLinkDataSetResult.of(this.getAppId(ApplicationCategoryEnum.collaboration), "openSummary", params);
        } else {
            String pattern = "{0}/collaboration/collaboration.do?method=summary&openFrom=listPending&affairId={1}";
            String href = MessageFormat.format(pattern, this.getContextPath(), String.valueOf(affairId));
            dataSetResult = LinkDataSetResult.of(href);
        }
        return dataSetResult;
    }

    @Override
    public LinkDataSetResult listUnflow(ContextParam contextParam, Long bizId, Long formId, Long moduleId) {
        LinkDataSetResult dataSetResult;
        if (this.isMobile(contextParam)) {
            ImmutableMap params = ImmutableMap.of((Object)"bussId", (Object)bizId, (Object)"formId", (Object)formId, (Object)"appId", (Object)moduleId);
            dataSetResult = MobileLinkDataSetResult.of(this.getAppId(ApplicationCategoryEnum.cap4unflow), "openUnFlowList", params);
        } else {
            ImmutableMap map = ImmutableMap.of((Object)"bizId", (Object)bizId, (Object)"moduleId", (Object)moduleId, (Object)"formId", (Object)formId);
            dataSetResult = LinkDataSetResult.of(this.replaceURL(LIST_UNFLOW_PATTERN, (Map)map));
        }
        return dataSetResult;
    }

    @Link(value="/cap4/businessTemplateController.do?method=capUnflowList&srcFrom=bizconfig&businessId={bizId}&moduleId={moduleId}&formId={formId}&type=baseInfo&tag={tag}")
    private LinkDataSetResult listUnflow(ContextParam contextParam, Map<String, String> params) {
        return this.listUnflow(contextParam, Long.parseLong(params.get("bizId")), Long.parseLong(params.get("formId")), Long.parseLong(params.get("moduleId")));
    }

    @Override
    public LinkDataSetResult newUnflow(ContextParam contextParam, Long bizId, Long formId, Long moduleId) {
        LinkDataSetResult dataSetResult = null;
        if (this.isMobile(contextParam)) {
            ImmutableMap params = ImmutableMap.of((Object)"bussId", (Object)bizId, (Object)"formId", (Object)formId, (Object)"moduleId", (Object)moduleId, (Object)"formTemplateId", (Object)moduleId, (Object)"rightId", (Object)"-1");
            dataSetResult = MobileLinkDataSetResult.of(this.getAppId(ApplicationCategoryEnum.cap4Form), "newUnflow", params);
        } else {
            try {
                FormBean formBean = this.bizPortalExternAdapterManager.getFormBean(formId);
                FormBindAuthBean bindAuthBean = formBean.getBind().getUnFlowTemplateById(moduleId);
                List<Map<String, String>> buttons = this.getAllBtnListByBtnOrder(Enums.ViewType.SeeyonForm, bindAuthBean, FormBindAuthBean.ShowPosition.ToolBar);
                for (Map<String, String> map : buttons) {
                    if (!StringUtils.equals((CharSequence)FormBindAuthBean.AuthName.ADD.getKey(), (CharSequence)map.get("name"))) continue;
                    String pattern = "{0}/cap4/businessTemplateController.do?method=formContent#/create?rightId={1}&moduleId={2}&formTemplateId={2}&moduleType=42";
                    String href = MessageFormat.format(pattern, this.getContextPath(), map.get("value"), String.valueOf(moduleId));
                    dataSetResult = LinkDataSetResult.of(href);
                    break;
                }
            }
            catch (BusinessException e) {
                logger.error((Object)"\u83b7\u53d6\u65e0\u6d41\u7a0b\u65b0\u5efa\u94fe\u63a5\u51fa\u9519:", (Throwable)e);
            }
        }
        return dataSetResult;
    }

    @Override
    public LinkDataSetResult viewUnflow(ContextParam contextParam, Long formId, Long formTemplateId, Long moduleId) throws BusinessException {
        FormBean formBean = this.bizPortalExternAdapterManager.getFormBean(formId);
        FormBindAuthBean formBindAuthBean = formBean.getBind().getUnFlowTemplateById(formTemplateId);
        String rightId = this.getUnflowRightId(contextParam, formBindAuthBean);
        return this.viewUnflow(contextParam, formId, formTemplateId, moduleId, rightId);
    }

    @Override
    public LinkDataSetResult viewUnflow(ContextParam contextParam, Long formId, Long formTemplateId, Long moduleId, String rightId) throws BusinessException {
        LinkDataSetResult dataSetResult;
        if (this.isMobile(contextParam)) {
            FormViewBean formView;
            FormBean formBean = this.bizPortalExternAdapterManager.getFormBean(formId);
            String formType = "origin";
            String[] split = StringUtils.split((String)rightId, (String)".");
            if (split.length > 1 && (formView = formBean.getFormView(Long.parseLong(split[0]))).isPhone() && formView.hasFields()) {
                formType = "light";
            }
            HashMap params = Maps.newHashMap();
            params.put("formType", formType);
            params.put("type", "browse");
            params.put("title", formBean.getFormName());
            if (ObjectUtils.equals((Object)-1L, (Object)formTemplateId)) {
                params.put("params", ImmutableMap.of((Object)"moduleId", (Object)moduleId, (Object)"moduleType", (Object)"42", (Object)"operateType", (Object)"2", (Object)"rightId", (Object)rightId));
            } else {
                params.put("params", ImmutableMap.of((Object)"formTemplateId", (Object)formTemplateId, (Object)"moduleId", (Object)moduleId, (Object)"moduleType", (Object)"42", (Object)"operateType", (Object)"2", (Object)"rightId", (Object)rightId));
            }
            dataSetResult = MobileLinkDataSetResult.of(this.getAppId(ApplicationCategoryEnum.cap4Form), "viewUnflow", params);
        } else {
            String pattern = "/cap4/businessTemplateController.do?method=formContent#/browse?rightId={rightId}&moduleId={moduleId}&formTemplateId={formTemplateId}&moduleType=42&fromModuleType=5";
            dataSetResult = LinkDataSetResult.of(this.replaceURL(pattern, (Map)ImmutableMap.of((Object)"rightId", (Object)rightId, (Object)"moduleId", (Object)moduleId, (Object)"formTemplateId", (Object)formTemplateId)));
        }
        return dataSetResult;
    }

    private String getUnflowRightId(ContextParam contextParam, FormBindAuthBean formBindAuthBean) {
        SimpleObjectBean simpleObjectBean = formBindAuthBean.getAuthObjByName(FormBindAuthBean.AuthName.BROWSE.getKey());
        String rightIdStr = this.getRightId(simpleObjectBean.getValue());
        if (contextParam.getPlatform().equals(BizPortalConstants.Platform.MOBILE)) {
            rightIdStr = StringUtils.isNotEmpty((CharSequence)rightIdStr) ? rightIdStr + "_" + this.getRightId(simpleObjectBean.getPhoneValue()) : this.getRightId(simpleObjectBean.getPhoneValue());
        }
        return rightIdStr;
    }

    private String getRightId(String valueStr) {
        String string = valueStr = valueStr.endsWith("|") ? valueStr.substring(0, valueStr.length() - 1) : valueStr;
        if (valueStr.contains("|")) {
            valueStr = valueStr.replaceAll("[|]", "\\.");
        }
        return valueStr;
    }

    private List<Map<String, String>> getAllBtnListByBtnOrder(Enums.ViewType viewType, FormBindAuthBean formBindAuthBean, FormBindAuthBean.ShowPosition showPosition) {
        return formBindAuthBean.getAllBtnListByBtnOrder(viewType, showPosition);
    }

    @Override
    public LinkDataSetResult listCap4Query(ContextParam contextParam, Long bizId, Long designId) {
        return this.isMobile(contextParam) ? this.listCap4Report(contextParam, bizId, designId, ApplicationCategoryEnum.cap4query) : this.listCap4Report(bizId, designId, ReportConstants.DesignType.QUERY);
    }

    @Override
    public LinkDataSetResult listCap4Stats(ContextParam contextParam, Long bizId, Long designId, ReportConstants.DesignType designType) {
        return this.isMobile(contextParam) ? this.listCap4Report(contextParam, bizId, designId, ApplicationCategoryEnum.cap4report) : this.listCap4Report(bizId, designId, designType);
    }

    private LinkDataSetResult listCap4Report(Long bizId, Long designId, ReportConstants.DesignType designType) {
        return LinkDataSetResult.of(this.replaceURL(LIST_CAP4_REPORT_PATTERN, (Map)ImmutableMap.of((Object)"designType", (Object)designType.name(), (Object)"designId", (Object)designId, (Object)"bizId", (Object)bizId)));
    }

    private MobileLinkDataSetResult listCap4Report(ContextParam contextParam, Long bizId, Long designId, ApplicationCategoryEnum categoryEnum) {
        Long pathId = this.bizPortalExternAdapterManager.getTemplatePathId(bizId, designId, contextParam.getPlatform());
        ImmutableMap params = ImmutableMap.of((Object)"bussId", (Object)bizId, (Object)"designId", (Object)designId, (Object)"pathId", (Object)pathId);
        return MobileLinkDataSetResult.of(this.getAppId(categoryEnum), "open", params);
    }

    @Link(value="/report4Result.do?method=showResult&designType={designType}&designId={designId}&businessId={bizId}")
    private LinkDataSetResult listCap4Report(ContextParam contextParam, Map<String, String> params) {
        ApplicationCategoryEnum categoryEnum = ReportConstants.DesignType.QUERY.name().equals(params.get("designType")) ? ApplicationCategoryEnum.cap4query : ApplicationCategoryEnum.cap4report;
        Long bizId = Long.parseLong(params.get("bizId"));
        Long designId = Long.parseLong(params.get("designId"));
        return this.listCap4Report(contextParam, bizId, designId, categoryEnum);
    }

    @Override
    public LinkDataSetResult docHomepageIndex(ContextParam contextParam, Long docResId) {
        LinkDataSetResult dataSetResult = this.isMobile(contextParam) ? MobileLinkDataSetResult.of(this.getAppId(ApplicationCategoryEnum.cap4Form), "docHomepageIndex", ImmutableMap.of((Object)"docResId", (Object)docResId)) : LinkDataSetResult.of(this.replaceURL(DOC_HOME_PAGE_INDEX_PATTERN, (Map)ImmutableMap.of((Object)"docResId", (Object)docResId)));
        return dataSetResult;
    }

    @Link(value="/doc.do?method=docHomepageIndex&srcFrom=bizconfig&firstName={0}&secondName={1}&docResId={docResId}")
    private LinkDataSetResult docHomepageIndex(ContextParam contextParam, Map<String, String> params) {
        return this.docHomepageIndex(contextParam, Long.parseLong(params.get("docResId")));
    }

    @Override
    public LinkDataSetResult bulIndex(ContextParam contextParam, Long typeId) {
        LinkDataSetResult dataSetResult = this.isMobile(contextParam) ? MobileLinkDataSetResult.of(this.getAppId(ApplicationCategoryEnum.cap4Form), "bulIndex", ImmutableMap.of((Object)"typeId", (Object)typeId)) : LinkDataSetResult.of(this.replaceURL(BUL_INDEX_PATTERN, (Map)ImmutableMap.of((Object)"typeId", (Object)typeId)));
        return dataSetResult;
    }

    @Link(value="/bulData.do?method=bulIndex&typeId={typeId}")
    private LinkDataSetResult bulIndex(ContextParam contextParam, Map<String, String> params) {
        return this.bulIndex(contextParam, Long.parseLong(params.get("typeId")));
    }

    @Override
    public LinkDataSetResult newsIndex(ContextParam contextParam, Long boardId) {
        LinkDataSetResult dataSetResult = this.isMobile(contextParam) ? MobileLinkDataSetResult.of(this.getAppId(ApplicationCategoryEnum.cap4Form), "newsIndex", ImmutableMap.of((Object)"boardId", (Object)boardId)) : LinkDataSetResult.of(this.replaceURL(NEWS_INDEX_PATTERN, (Map)ImmutableMap.of((Object)"boardId", (Object)boardId)));
        return dataSetResult;
    }

    @Link(value="/newsData.do?method=newsIndex&boardId={boardId}")
    private LinkDataSetResult newsIndex(ContextParam contextParam, Map<String, String> params) {
        return this.newsIndex(contextParam, Long.parseLong(params.get("boardId")));
    }

    @Override
    public LinkDataSetResult bbsIndex(ContextParam contextParam, Long boardId) {
        LinkDataSetResult dataSetResult = this.isMobile(contextParam) ? MobileLinkDataSetResult.of(this.getAppId(ApplicationCategoryEnum.cap4Form), "bbsIndex", ImmutableMap.of((Object)"boardId", (Object)boardId)) : LinkDataSetResult.of(this.replaceURL(BBS_INDEX_PATTERN, (Map)ImmutableMap.of((Object)"boardId", (Object)boardId)));
        return dataSetResult;
    }

    @Link(value="/bbs.do?method=bbsIndex&boardId={boardId}")
    private LinkDataSetResult bbsIndex(ContextParam contextParam, Map<String, String> params) {
        return this.bbsIndex(contextParam, Long.parseLong(params.get("boardId")));
    }

    @Override
    public LinkDataSetResult inquiryBoardIndex(ContextParam contextParam, Long boardId) {
        LinkDataSetResult dataSetResult = this.isMobile(contextParam) ? MobileLinkDataSetResult.of(this.getAppId(ApplicationCategoryEnum.cap4Form), "inquiryBoardIndex", ImmutableMap.of((Object)"boardId", (Object)boardId)) : LinkDataSetResult.of(this.replaceURL(INQUIRY_BOARDINDEX_PATTERN, (Map)ImmutableMap.of((Object)"boardId", (Object)boardId)));
        return dataSetResult;
    }

    @Link(value="/inquiryData.do?method=inquiryBoardIndex&boardId={boardId}")
    private LinkDataSetResult inquiryBoardIndex(ContextParam contextParam, Map<String, String> params) {
        return this.inquiryBoardIndex(contextParam, Long.parseLong(params.get("boardId")));
    }

    @Override
    public LinkSupport chooseLinkSupport(String url) {
        LinkSupport support;
        ArrayList patterns = Lists.newArrayList();
        for (String pattern : this.linkSupportMap.keySet()) {
            if (!this.antPathMatcher.match(pattern, url)) continue;
            patterns.add(pattern);
        }
        if (patterns.size() > 0) {
            Collections.sort(patterns, this.antPathMatcher.getPatternComparator(url));
            support = this.linkSupportMap.get(patterns.get(0));
        } else {
            support = new DefaultLinkSupport();
        }
        return support;
    }

    @Override
    public LinkDataSetResult viewBizPortalSpace(ContextParam contextParam, Long spaceId) throws BusinessException {
        LinkDataSetResult dataSetResult;
        if (this.isMobile(contextParam)) {
            CAPPortalSpace portalSpace = this.bizPortalSpaceManager.getCAPPortalSpace(spaceId);
            CAPPortalSpaceConfig spaceConfig = this.bizPortalSpaceManager.getBizPortalSpaceConfig(spaceId, BizPortalConstants.ConfigStatus.RUNNING);
            ImmutableMap map = ImmutableMap.of((Object)"bizId", (Object)portalSpace.getBizId(), (Object)"spaceId", (Object)spaceId, (Object)"configId", (Object)spaceConfig.getId());
            dataSetResult = MobileLinkDataSetResult.of(this.getAppId(ApplicationCategoryEnum.cap4Form), "openBizInfoBySpaceId", map);
        } else {
            dataSetResult = LinkDataSetResult.of(this.replaceURL(VIEW_BIZPORTAL_SPACE_PATTERN, (Map)ImmutableMap.of((Object)"spaceId", (Object)spaceId)));
        }
        return dataSetResult;
    }

    private String replaceURL(String pattern, Map valueMap) {
        StrSubstitutor strSubstitutor = new StrSubstitutor((StrLookup)new MapStrLookup(valueMap), "{", "}", '$');
        return this.getContextPath() + strSubstitutor.replace(pattern);
    }

    private String getContextPath() {
        return SystemEnvironment.getContextPath();
    }

    private boolean isMobile(ContextParam contextParam) {
        return BizPortalConstants.Platform.MOBILE.equals(contextParam.getPlatform());
    }

    private String getAppId(ApplicationCategoryEnum categoryEnum) {
        return String.valueOf(categoryEnum.getKey());
    }

    public void afterPropertiesSet() throws Exception {
        Method[] declaredMethods;
        Class clazz = this.getClass();
        if (AopUtils.isAopProxy((Object)this)) {
            clazz = AopUtils.getTargetClass((Object)this);
        }
        for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
            Link link = method.getAnnotation(Link.class);
            if (link == null) continue;
            String pattern = link.value();
            BizPortalConstants.Platform platform = link.platform();
            String target = StringUtils.isEmpty((CharSequence)link.target()) ? null : link.target();
            this.linkSupportMap.put(pattern, new LinkSupportAdatper(pattern, platform, method, target));
        }
        Map beansOfType = AppContext.getBeansOfType(LinkSupport.class);
        for (Map.Entry entry : beansOfType.entrySet()) {
            LinkSupport support = (LinkSupport)entry.getValue();
            this.linkSupportMap.put(support.pattern(), support);
        }
    }

    @Link(value="/form/bizMap.do?method=viewBizMap&srcFrom=bizconfig&mapId={mapId}", platform=BizPortalConstants.Platform.PC)
    private LinkDataSetResult viewBizMap(ContextParam contextParam, Map<String, String> params) {
        throw new UnsupportedOperationException("\u79fb\u52a8\u7aef\u4e0d\u652f\u6301\uff01");
    }

    @Link(value="/blog.do?method=blogHome", platform=BizPortalConstants.Platform.PC, target="newWindow")
    private LinkDataSetResult blogHome(ContextParam contextParam, Map<String, String> params) {
        throw new UnsupportedOperationException("\u79fb\u52a8\u7aef\u4e0d\u652f\u6301\uff01");
    }

    public void setBizPortalExternAdapterManager(BizPortalExternAdapterManager bizPortalExternAdapterManager) {
        this.bizPortalExternAdapterManager = bizPortalExternAdapterManager;
    }

    public void setBizPortalSpaceManager(BizPortalSpaceManager bizPortalSpaceManager) {
        this.bizPortalSpaceManager = bizPortalSpaceManager;
    }

    public void setCollaborationApi(CollaborationApi collaborationApi) {
        this.collaborationApi = collaborationApi;
    }

    static class MapStrLookup
    extends StrLookup {
        private final Map map;

        MapStrLookup(Map map) {
            this.map = map;
        }

        public String lookup(String key) {
            if (this.map == null) {
                return null;
            }
            Object obj = this.map.get(key);
            if (obj == null) {
                return "";
            }
            return obj.toString();
        }
    }

    static class DefaultLinkSupport
    implements LinkSupport {
        DefaultLinkSupport() {
        }

        @Override
        public String pattern() {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u65b9\u6cd5");
        }

        @Override
        public boolean support(BizPortalConstants.Platform platform) {
            return true;
        }

        @Override
        public LinkDataSetResult mobileLink(String url, ContextParam contextParam) throws BusinessException {
            return LinkDataSetResult.of(url);
        }

        @Override
        public String getTarget() {
            return null;
        }
    }

    class LinkSupportAdatper
    implements LinkSupport {
        private String pattern;
        private BizPortalConstants.Platform platform;
        private Method method;
        private String target;

        LinkSupportAdatper(String pattern, BizPortalConstants.Platform platform, Method method, String target) {
            ReflectionUtils.makeAccessible((Method)method);
            this.pattern = pattern;
            this.platform = platform;
            this.method = method;
            this.target = target;
        }

        @Override
        public String pattern() {
            return this.pattern;
        }

        @Override
        public boolean support(BizPortalConstants.Platform platform) {
            return this.platform.contains(platform);
        }

        @Override
        public LinkDataSetResult mobileLink(String url, ContextParam contextParam) throws BusinessException {
            try {
                return (LinkDataSetResult)this.method.invoke((Object)BizPortalLinkFactoryManagerImpl.this, contextParam, LinkSupportUtil.extractUriTemplateVariables(this.pattern, url, (PathMatcher)BizPortalLinkFactoryManagerImpl.this.antPathMatcher));
            }
            catch (Exception e) {
                logger.error((Object)"\u6839\u636eURL\u83b7\u53d6\u79fb\u52a8\u7aef\u53c2\u6570\uff1a", (Throwable)e);
                throw new BusinessException((Throwable)e);
            }
        }

        @Override
        public String getTarget() {
            return this.target;
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Link {
        public String value();

        public BizPortalConstants.Platform platform() default BizPortalConstants.Platform.ALL;

        public String target() default "";
    }
}

