/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.manager;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.datasource.link.LinkDataSetResult;
import com.seeyon.cap4.bizportal.datasource.list.MultiLinkDataSetResult;
import com.seeyon.cap4.bizportal.manager.BizPortalLinkFactoryManager;
import com.seeyon.cap4.bizportal.manager.BizPortalReportAdapterManager;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.utils.BizPortalUtils;
import com.seeyon.cap4.bizportal.utils.LinkSupportUtil;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.report.bizportal.Constants;
import com.seeyon.ctp.report.bizportal.ListDataConverter;
import com.seeyon.ctp.report.bizportal.api.ReportFacadeManagerApi;
import com.seeyon.ctp.report.bizportal.bean.ListDataResult;
import com.seeyon.ctp.report.bizportal.bean.ListField;
import com.seeyon.ctp.report.bizportal.bean.ListRowData;
import com.seeyon.ctp.report.bizportal.bean.ReportDesignConfig;
import com.seeyon.ctp.report.bizportal.bean.ReportDesignDefinition;
import com.seeyon.ctp.report.bizportal.bean.StatisticsListField;
import com.seeyon.ctp.report.bizportal.exception.NoContentException;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import com.seeyon.ctp.report.engine.api.bo.ReportConfig;
import com.seeyon.ctp.report.engine.api.bo.ReportQueryParams;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.report.engine.bean.DisplayField;
import com.seeyon.ctp.report.engine.bean.Field;
import com.seeyon.ctp.report.engine.bean.HeaderField;
import com.seeyon.ctp.report.engine.bean.ReportIndexResult;
import com.seeyon.ctp.report.engine.bean.UserConditions;
import com.seeyon.ctp.report.engine.po.ReportIndex;
import com.seeyon.ctp.report.engine.po.ScheduleStatsLog;
import com.seeyon.ctp.util.FlipInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class BizPortalReportAdapterManagerImpl
implements BizPortalReportAdapterManager {
    private static final Log logger = CtpLogFactory.getLog(BizPortalReportAdapterManagerImpl.class);
    private ReportFacadeManagerApi reportFacadeManagerApi;
    private EnumManager enumManager;
    private AttachmentManager attachmentManager;
    private ReportApi reportApi;
    private BizPortalLinkFactoryManager bizPortalLinkFactoryManager;

    @Override
    public List<ReportIndex> findReportIndex(String category, String categoryId) throws BusinessException {
        return this.reportFacadeManagerApi.findReportIndex(category, categoryId);
    }

    @Override
    public List<ReportDesignDefinition> findReportDesignDefinition(List<Long> designIds) throws BusinessException {
        return this.reportFacadeManagerApi.findReportDesignDefinition(designIds);
    }

    @Override
    public ReportDesignDefinition getReportDesignDefinition(Long designId) throws BusinessException {
        List<ReportDesignDefinition> list = this.findReportDesignDefinition(Lists.newArrayList((Object[])new Long[]{designId}));
        return CollectionUtils.isEmpty(list) ? null : list.get(0);
    }

    @Override
    public boolean checkAuth(Long designId, Long memberId) throws BusinessException {
        return this.reportFacadeManagerApi.checkAuth(designId, memberId);
    }

    @Override
    public ReportIndexResult getReportIndexResult(Long indexId) throws BusinessException {
        return this.reportFacadeManagerApi.getReportIndexResult(indexId);
    }

    @Override
    public List<ReportDesignDefinition> findReportDesignDefinition(String category, String categoryId) throws BusinessException {
        return this.reportFacadeManagerApi.findReportDesignDefinition(category, categoryId);
    }

    @Override
    public List<ReportDesignDefinition> findReportDesignDefinition(String category, String categoryId, ReportConstants.DesignType designType) throws BusinessException {
        return this.reportFacadeManagerApi.findReportDesignDefinition(category, categoryId, designType);
    }

    @Override
    public ListDataResult findQueryDataResult(Long designId, UserConditions userConditions, FlipInfo fi) throws BusinessException {
        return this.reportFacadeManagerApi.findQueryDataResult(designId, userConditions, fi, (ListDataConverter)new DefaultListDataConverter(this.enumManager, this.attachmentManager));
    }

    @Override
    public ListDataResult findStatisticsDataResult(Long designId, User user) throws BusinessException {
        return this.findStatisticsDataResult(designId, user, (ListDataConverter)new DefaultListDataConverter(this.enumManager, this.attachmentManager));
    }

    @Override
    public ListDataResult findStatisticsDataResult(Long designId, User user, ListDataConverter converter) throws BusinessException {
        ArrayList conditions = Lists.newArrayList();
        ListDataResult dataResult = new ListDataResult();
        try {
            dataResult = this.reportFacadeManagerApi.findStatisticsDataResult(designId, (List)conditions, converter);
        }
        catch (NoContentException e) {
            logger.error((Object)("\u9759\u6001\u62a5\u8868id=" + designId + "\u8fd8\u672a\u8c03\u5ea6"));
        }
        ReportConfig report = this.reportApi.getReport(designId);
        ReportConstants.DesignType designType = ReportConstants.DesignType.valueOf((String)MapUtils.getString((Map)report, (Object)"designType"));
        if (designType.equals((Object)ReportConstants.DesignType.SCHEDULEDSTATS)) {
            List schStatsList = this.reportApi.findSchStatsList((Map)ImmutableMap.of((Object)"designId", (Object)designId));
            if (CollectionUtils.isNotEmpty((Collection)schStatsList)) {
                List<ScheduleStatsLog> scheduleStatsLogs = BizPortalUtils.create(schStatsList, ScheduleStatsLog.class);
                Collections.sort(scheduleStatsLogs, new Comparator<ScheduleStatsLog>(){

                    @Override
                    public int compare(ScheduleStatsLog o1, ScheduleStatsLog o2) {
                        return o2.getEndDate().compareTo(o1.getEndDate());
                    }
                });
                dataResult.setExecuteTime(scheduleStatsLogs.get(0).getEndDate());
            }
        } else {
            List statsFields = (List)report.get((Object)"statsFields");
            HashMap penetrate = Maps.newHashMap();
            for (DisplayField displayField : statsFields) {
                if (!displayField.isPenetrateEnable()) continue;
                penetrate.put(displayField.key(), displayField);
            }
            for (ListField listField : dataResult.getFields()) {
                ListField parentField;
                String key;
                if (!(listField instanceof StatisticsListField)) continue;
                String string = key = listField.getDisplayField() != null ? listField.getDisplayField().key() : listField.getKey();
                if (penetrate.containsKey(key)) {
                    for (ListRowData rowData : dataResult.getData()) {
                        StatisticsData sData = new StatisticsData(dataResult.getData(rowData, listField));
                        sData.getActions().add(Constants.Action.VIEW_DETAIL.getCode());
                        dataResult.putListRowData(rowData, listField.getKey(), (ListRowData.Data)sData);
                    }
                }
                if ((parentField = ((StatisticsListField)listField).getParentField()) == null) continue;
                HeaderField headerField = (HeaderField)report.get((Object)"colHeaders");
                parentField.setKey(headerField.key());
                listField.getAttributes().put("key", listField.getDisplayField().key());
            }
            dataResult.setExecuteTime(new Date());
            dataResult.setId(designId.toString());
        }
        return dataResult;
    }

    @Override
    public ReportDesignConfig getReportDesignConfig(Long designId) throws BusinessException {
        return this.reportFacadeManagerApi.getReportDesignConfig(designId);
    }

    @Override
    public MultiLinkDataSetResult getQueryPenetrateInfo(ContextParam contextParam, Long designId, String extendParams) throws BusinessException {
        if (BizPortalConstants.Platform.PC.equals(contextParam.getPlatform())) {
            StrSubstitutor strSubstitutor = new StrSubstitutor((Map)ImmutableMap.of((Object)"designId", (Object)designId, (Object)"extendParams", (Object)BizPortalUtils.encode(extendParams)));
            String href = strSubstitutor.replace("/report4Result.do?method=reportPenetrate&rptDesignId=${designId}&extendParams=${extendParams}");
            return MultiLinkDataSetResult.of(SystemEnvironment.getContextPath() + href);
        }
        MultiLinkDataSetResult multiLinkDataSetResult = new MultiLinkDataSetResult();
        HashMap params = Maps.newHashMap();
        params.put("rptDesignId", designId);
        params.put("extendParams", extendParams);
        List queryPenetrates = this.reportApi.getQueryPenetrate((Map)params);
        for (Map penetrateInfo : queryPenetrates) {
            int formType = MapUtils.getIntValue((Map)penetrateInfo, (Object)"formType");
            if (Enums.FormType.processesForm.getKey() == formType) {
                MultiLinkDataSetResult.WithLabelLinkDataSet withLabelLinkDataSet = new MultiLinkDataSetResult.WithLabelLinkDataSet();
                withLabelLinkDataSet.setLabel(MapUtils.getString((Map)penetrateInfo, (Object)"formName"));
                withLabelLinkDataSet.setAppId(String.valueOf(ApplicationCategoryEnum.collaboration.getKey()));
                withLabelLinkDataSet.setOpenApi("openSummary");
                HashMap openParams = Maps.newHashMap();
                String pattern = "/seeyon/collaboration/collaboration.do?method=summary&openFrom=capQuery&summaryId={summaryId}&operationId={operationId}&formId={formId}";
                Map<String, String> variables = LinkSupportUtil.extractUriTemplateVariables(pattern, MapUtils.getString((Map)penetrateInfo, (Object)"baseUrl"));
                openParams.putAll(variables);
                openParams.put("openFrom", "capStatistical");
                openParams.put("designId", designId);
                withLabelLinkDataSet.setParams(openParams);
                multiLinkDataSetResult.getLinks().add(withLabelLinkDataSet);
                continue;
            }
            String pattern = "/seeyon/cap4/businessTemplateController.do?method=formContent#/browse?&rightId={rightId}&moduleId={moduleId}&moduleType=42&fromModuleType=5";
            Map<String, String> variables = LinkSupportUtil.extractUriTemplateVariables(pattern, MapUtils.getString((Map)penetrateInfo, (Object)"baseUrl"));
            Long formId = MapUtils.getLong((Map)penetrateInfo, (Object)"formId");
            String rightId = MapUtils.getString(variables, (Object)"rightId");
            Long moduleId = MapUtils.getLong(variables, (Object)"moduleId");
            LinkDataSetResult linkDataSetResult = this.bizPortalLinkFactoryManager.viewUnflow(contextParam, formId, -1L, moduleId, rightId);
            multiLinkDataSetResult.getLinks().add(MultiLinkDataSetResult.create(linkDataSetResult, MapUtils.getString((Map)penetrateInfo, (Object)"formName")));
        }
        return multiLinkDataSetResult;
    }

    @Override
    public ReportApi.ExportExcelInfo exportReportExcel(Long designId, Long userId, List<Map<String, Object>> userConditions) throws BusinessException {
        ReportQueryParams reportQueryParams = new ReportQueryParams();
        reportQueryParams.put((Object)"designId", (Object)designId);
        reportQueryParams.put((Object)"userId", (Object)userId);
        if (userConditions != null) {
            reportQueryParams.put((Object)"userConditions", userConditions);
        }
        return this.reportApi.exportExcel(reportQueryParams);
    }

    public void setReportFacadeManagerApi(ReportFacadeManagerApi reportFacadeManagerApi) {
        this.reportFacadeManagerApi = reportFacadeManagerApi;
    }

    public void setEnumManagerNew(EnumManager enumManager) {
        this.enumManager = enumManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setReportApi(ReportApi reportApi) {
        this.reportApi = reportApi;
    }

    public void setBizPortalLinkFactoryManager(BizPortalLinkFactoryManager bizPortalLinkFactoryManager) {
        this.bizPortalLinkFactoryManager = bizPortalLinkFactoryManager;
    }

    public static class StatisticsData
    extends ListRowData.Data {
        private List<String> actions = new ArrayList<String>();

        public StatisticsData(ListRowData.Data data) {
            super(data.getS(), data.getV());
        }

        public List<String> getActions() {
            return this.actions;
        }

        public void setActions(List<String> actions) {
            this.actions = actions;
        }
    }

    public static class DefaultListDataConverter
    extends com.seeyon.ctp.report.bizportal.DefaultListDataConverter {
        protected EnumManager enumManager;
        protected AttachmentManager attachmentManager;
        String contextPath = SystemEnvironment.getContextPath();

        public DefaultListDataConverter(EnumManager enumManager, AttachmentManager attachmentManager) {
            this.enumManager = enumManager;
            this.attachmentManager = attachmentManager;
        }

        public ListRowData.Data format(DisplayField displayField, Object sValue, Field field, Supplier<ListRowData.Data> format) throws BusinessException {
            if (sValue == null) {
                return new ListRowData.Data();
            }
            String fieldComType = field.getFieldComType();
            if (StringUtils.equals((CharSequence)ReportConstants.FieldComType.IMAGEENUM.getComName(), (CharSequence)fieldComType)) {
                CtpEnumItem enumItem = this.enumManager.getEnumItem(Long.valueOf(Long.parseLong(sValue.toString())));
                HashMap value = Maps.newHashMap();
                if (enumItem != null) {
                    if (displayField.getFormatType().equals("showName")) {
                        value.put("formatType", "showName");
                        value.put("value", enumItem.getShowvalue());
                    } else {
                        value.put("formatType", "showImage");
                        if (enumItem.getImageId() != null) {
                            value.put("value", String.format("%s/fileUpload.do?method=showRTE&type=image&fileId=%s", this.contextPath, enumItem.getImageId().toString()));
                            value.put("imageId", enumItem.getImageId());
                        }
                    }
                    value.put("enumItem", enumItem);
                }
                return new ListRowData.Data(sValue, (Object)value);
            }
            if (ReportConstants.FieldComType.IMAGE.getComName().equals(fieldComType)) {
                List value = null;
                List list = this.attachmentManager.getBySubReference((List)Lists.newArrayList((Object[])new Long[]{Long.valueOf(sValue.toString())}));
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    value = list;
                }
                return new ListRowData.Data(sValue, (Object)value);
            }
            if (ReportConstants.FieldComType.SELECT.getComName().equals(fieldComType) || ReportConstants.FieldComType.RADIO.getComName().equals(fieldComType)) {
                CtpEnumItem enumItem = this.enumManager.getEnumItem(Long.valueOf(Long.parseLong(sValue.toString())));
                if (enumItem != null) {
                    return new ListRowData.Data(sValue, (Object)enumItem.getShowvalue());
                }
                return new ListRowData.Data(sValue, sValue);
            }
            return (ListRowData.Data)format.get();
        }
    }
}

