/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.manager;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.bean.BizPortalGoodSnapshotMeta;
import com.seeyon.cap4.bizportal.bean.BizPortalSectionConfigJson;
import com.seeyon.cap4.bizportal.bean.BizPortalSectionElement;
import com.seeyon.cap4.bizportal.bean.BizPortalSpaceLayoutConfig;
import com.seeyon.cap4.bizportal.bean.DownloadGoodInfo;
import com.seeyon.cap4.bizportal.bean.SimpleElementConfig;
import com.seeyon.cap4.bizportal.bean.SimpleManifestFile;
import com.seeyon.cap4.bizportal.dao.BizPortalElementConfigDao;
import com.seeyon.cap4.bizportal.dao.BizPortalSectionDao;
import com.seeyon.cap4.bizportal.datasource.ElementDefaultValueConstruct;
import com.seeyon.cap4.bizportal.datasource.bean.Command;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.datasource.bean.DefaultDataResult;
import com.seeyon.cap4.bizportal.exception.NotAcceptablePlatformException;
import com.seeyon.cap4.bizportal.manager.BizPortalFileManager;
import com.seeyon.cap4.bizportal.manager.BizPortalGoodSnapshotManager;
import com.seeyon.cap4.bizportal.manager.BizPortalGoodsDownloadCallback;
import com.seeyon.cap4.bizportal.manager.BizPortalSectionManager;
import com.seeyon.cap4.bizportal.manager.BizPortalSpaceManager;
import com.seeyon.cap4.bizportal.manager.DataSourceContextManager;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.param.ElementDataSetBinding;
import com.seeyon.cap4.bizportal.po.CAPPortalElementConfig;
import com.seeyon.cap4.bizportal.po.CAPPortalFile;
import com.seeyon.cap4.bizportal.po.CAPPortalGoodSnapshot;
import com.seeyon.cap4.bizportal.po.CAPPortalSection;
import com.seeyon.cap4.bizportal.po.CAPPortalSpaceConfig;
import com.seeyon.cap4.bizportal.utils.BizPortalUtils;
import com.seeyon.cap4.bizportal.vo.BizPortalSectionResult;
import com.seeyon.cap4.bizportal.vo.ServiceResult;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.springframework.core.io.Resource;

public class BizPortalSectionManagerImpl
implements BizPortalSectionManager,
BizPortalGoodsDownloadCallback {
    private static final Log logger = CtpLogFactory.getLog(BizPortalSectionManagerImpl.class);
    private BizPortalGoodSnapshotManager bizPortalGoodSnapshotManager;
    private BizPortalSectionDao bizPortalSectionDao;
    private BizPortalElementConfigDao bizPortalElementConfigDao;
    private DataSourceContextManager dataSourceContextManager;
    private BizPortalSpaceManager bizPortalSpaceManager;
    private BizPortalFileManager bizPortalFileManager;

    @Override
    public String goodsClass() {
        return BizPortalConstants.GoodsClassKey.PORTAL_SPACE_Section.getKey();
    }

    @Override
    public Long doExecute(ContextParam contextParam, CAPPortalGoodSnapshot goodSnapshot, DownloadGoodInfo downloadGoodInfo) throws BusinessException {
        BizPortalSectionConfigJson configJson = this.bizPortalGoodSnapshotManager.getBizPortalConfigJson(goodSnapshot, BizPortalSectionConfigJson.class);
        BizPortalConstants.Platform platform = BizPortalUtils.getEnumByCode(BizPortalConstants.Platform.class, configJson.getPlatform());
        if (platform == null || !platform.contains(contextParam.getPlatform())) {
            throw new NotAcceptablePlatformException("\u680f\u76ee\u7684\u9002\u914d\u7ec8\u7aef\u4e0d\u5339\u914d\uff01");
        }
        return this.createCAPPortalSection(goodSnapshot, contextParam).getId();
    }

    @Override
    public Resource getBizPortalSectionRelativeResource(Long sectionId, String relativePath) throws BusinessException {
        CAPPortalSection section = this.getCAPPortalSection(sectionId);
        if (section == null) {
            return null;
        }
        return this.bizPortalGoodSnapshotManager.getRelativeResource(section.getSourceId(), relativePath);
    }

    @Override
    public SimpleManifestFile createBizPortalManifestFile(Long sectionId, File directory) throws BusinessException {
        CAPPortalSection portalSection = this.getCAPPortalSection(sectionId);
        CAPPortalGoodSnapshot goodSnapshot = this.bizPortalGoodSnapshotManager.getCAPPortalGoodSnapshot(portalSection.getSourceId());
        Pair<String, File> paths = this.createPathIfNotExists(directory, goodSnapshot.getId());
        SimpleManifestFile manifestFile = new SimpleManifestFile();
        manifestFile.setId(goodSnapshot.getId());
        manifestFile.setUuid(portalSection.getUuidInfo());
        manifestFile.setSourceType(goodSnapshot.getSourceType());
        manifestFile.setGoodsKey(goodSnapshot.getGoodsKey());
        manifestFile.setSubGoodsKey(goodSnapshot.getSubGoodsKey());
        manifestFile.setGoodsId(goodSnapshot.getGoodsId());
        manifestFile.setGoodsName(goodSnapshot.getGoodsName());
        manifestFile.setGoodUpdateTime(goodSnapshot.getGoodUpdateTime());
        manifestFile.setInfoUrl(goodSnapshot.getInfoUrl());
        manifestFile.setFile((String)paths.getLeft());
        manifestFile.setRelateIds(Lists.newArrayList((Object[])new Long[]{sectionId}));
        this.bizPortalGoodSnapshotManager.copyGoodsSnapshotPackage(goodSnapshot.getId(), (File)paths.getRight());
        return manifestFile;
    }

    @Override
    public CAPPortalSection createCAPPortalSection(CAPPortalFile portalFile, ContextParam contextParam) throws BusinessException {
        CAPPortalGoodSnapshot goodSnapshot;
        List<CAPPortalGoodSnapshot> list = this.bizPortalGoodSnapshotManager.findCAPPortalGoodSnapshot(portalFile.getId());
        if (CollectionUtils.isEmpty(list)) {
            BizPortalGoodSnapshotMeta metadata = new BizPortalGoodSnapshotMeta();
            metadata.setGoodsName(portalFile.getName());
            metadata.setSourceType(BizPortalConstants.SourceType.Local.getCode());
            metadata.setSourceId(portalFile.getId());
            metadata.setCreateTime(new Date());
            goodSnapshot = this.bizPortalGoodSnapshotManager.createGoodSnapshot(metadata, this.bizPortalFileManager.getBizPortalZipFile(portalFile.getId()), contextParam);
        } else {
            goodSnapshot = list.get(0);
        }
        return this.createCAPPortalSection(goodSnapshot, contextParam);
    }

    @Override
    public CAPPortalSection createCAPPortalSection(CAPPortalGoodSnapshot goodSnapshot, ContextParam contextParam) throws BusinessException {
        return this.createCAPPortalSection(goodSnapshot, contextParam, new Function<BizPortalSectionConfigJson, BizPortalSectionConfigJson>(){

            public BizPortalSectionConfigJson apply(BizPortalSectionConfigJson configJson) {
                for (BizPortalSectionElement element : configJson.getElements()) {
                    element.setId(UUIDLong.longUUID());
                    element.remove("_index_");
                }
                return configJson;
            }
        });
    }

    private CAPPortalSection createCAPPortalSection(CAPPortalGoodSnapshot goodSnapshot, ContextParam contextParam, Function<BizPortalSectionConfigJson, BizPortalSectionConfigJson> function) throws BusinessException {
        CAPPortalSection portalSection = new CAPPortalSection();
        portalSection.setIdIfNew();
        BizPortalSectionConfigJson configJson = this.bizPortalGoodSnapshotManager.getBizPortalConfigJson(goodSnapshot, BizPortalSectionConfigJson.class);
        portalSection.setUuidInfo(configJson.getUUID());
        portalSection.setName(configJson.getName());
        portalSection.setSourceId(goodSnapshot.getId());
        portalSection.setCreateMember(contextParam.getUserId());
        portalSection.setCreateTime(new Date());
        portalSection.setDeleteFlag(false);
        portalSection.setConfigInfo(JSONUtil.toJSONString((Object)function.apply((Object)configJson)));
        this.bizPortalSectionDao.saveCAPPortalSection(portalSection);
        return portalSection;
    }

    private Pair<String, File> createPathIfNotExists(File directory, Long id) {
        String path = "./column/" + id + ".zip";
        File file = new File(directory, path);
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdir();
        }
        return Pair.of((Object)path, (Object)file);
    }

    @Override
    public Map<Long, CAPPortalSection> createCAPPortalSection(SimpleManifestFile manifestFile, File parentDir, ContextParam contextParam) throws BusinessException {
        HashMap map = Maps.newHashMap();
        CAPPortalGoodSnapshot goodSnapshot = this.bizPortalGoodSnapshotManager.createGoodSnapshotIfNotExist(manifestFile, parentDir, contextParam);
        for (Long relateId : manifestFile.getRelateIds()) {
            CAPPortalSection section = this.createCAPPortalSection(goodSnapshot, contextParam, new Function<BizPortalSectionConfigJson, BizPortalSectionConfigJson>(){

                public BizPortalSectionConfigJson apply(BizPortalSectionConfigJson input) {
                    return input;
                }
            });
            map.put(relateId, section);
        }
        return map;
    }

    @Override
    public String getBizPortalSectionIndexJs(Long bizId, Long configId, Long sectionId) throws BusinessException {
        CAPPortalSection section = this.getCAPPortalSection(sectionId);
        return "/seeyon/rest/cap4/bizportal/" + bizId + "/" + configId + "/section/" + section.getSourceId() + "/js/index.umd.min.js";
    }

    private List<Map<String, Object>> getBizPortalSectionPresetData(Long sectionId) throws BusinessException {
        Resource resource = this.getBizPortalSectionRelativeResource(sectionId, "eg.json");
        if (resource.exists()) {
            try {
                return BizPortalUtils.get(resource.getFile(), List.class);
            }
            catch (IOException e) {
                logger.error((Object)"\u8bfb\u53d6\u9884\u7f6e\u6570\u636e\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void createOrUpdateCAPPortalElementConfig(Long configId, Long sectionId, List<ElementDataSetBinding> bindings, ContextParam contextParam) throws BusinessException {
        ArrayList elementIds = Lists.newArrayListWithCapacity((int)bindings.size());
        for (ElementDataSetBinding binding : bindings) {
            elementIds.add(binding.getElementId());
        }
        List<CAPPortalElementConfig> elementConfigs = this.bizPortalElementConfigDao.findCAPPortalElementConfig(configId, sectionId, elementIds);
        ImmutableMap elementConfigMap = Maps.uniqueIndex(elementConfigs, (Function)new Function<CAPPortalElementConfig, Long>(){

            public Long apply(CAPPortalElementConfig input) {
                return input.getElementId();
            }
        });
        ArrayList updates = Lists.newArrayList();
        ArrayList adds = Lists.newArrayList();
        for (ElementDataSetBinding binding : bindings) {
            CAPPortalElementConfig elementConfig = (CAPPortalElementConfig)((Object)elementConfigMap.get(binding.getElementId()));
            String dataId = binding.getDataId();
            DataSetMetadata metadata = this.dataSourceContextManager.saveBizPortalDataRelation(dataId, binding.getMetadata());
            if (elementConfig != null) {
                elementConfig.setDataId(dataId);
                elementConfig.setMetadataInfo(JSONUtil.toJSONString((Object)metadata));
                elementConfig.setUpdateMember(contextParam.getUserId());
                elementConfig.setUpdateTime(new Date());
                updates.add(elementConfig);
                continue;
            }
            elementConfig = new CAPPortalElementConfig();
            elementConfig.setIdIfNew();
            elementConfig.setConfigId(configId);
            elementConfig.setSectionId(sectionId);
            elementConfig.setElementId(binding.getElementId());
            elementConfig.setDataId(dataId);
            elementConfig.setMetadataInfo(JSONUtil.toJSONString((Object)metadata));
            elementConfig.setCreateMember(contextParam.getUserId());
            elementConfig.setCreateTime(new Date());
            adds.add(elementConfig);
        }
        this.saveCAPPortalElementConfig(adds);
        this.updateCAPPortalElementConfig(updates);
    }

    @Override
    public List<CAPPortalElementConfig> createCAPPortalElementConfig(Long configId, Long sectionId, List<SimpleElementConfig> elementConfigs, ContextParam contextParam) throws BusinessException {
        ArrayList list = Lists.newArrayListWithCapacity((int)elementConfigs.size());
        for (SimpleElementConfig simpleElementConfig : elementConfigs) {
            CAPPortalElementConfig eConfig = new CAPPortalElementConfig();
            eConfig.setIdIfNew();
            eConfig.setConfigId(configId);
            eConfig.setSectionId(sectionId);
            eConfig.setDataId(simpleElementConfig.getDataId());
            eConfig.setElementId(simpleElementConfig.getElementId());
            eConfig.setMetadataInfo(simpleElementConfig.getMetadataInfo());
            eConfig.setCreateTime(new Date());
            eConfig.setCreateMember(contextParam.getUserId());
            list.add(eConfig);
        }
        this.saveCAPPortalElementConfig(list);
        return list;
    }

    @Override
    public void removeCAPPortalElementConfig(Long configId, Long sectionId, List<Long> elementIds, ContextParam contextParam) throws BusinessException {
        List<CAPPortalElementConfig> list = this.bizPortalElementConfigDao.findCAPPortalElementConfig(configId, sectionId, elementIds);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.bizPortalElementConfigDao.removeCAPPortalElementConfig(list);
    }

    @Override
    public void removeCAPPortalElementConfig(Long configId, ContextParam contextParam) throws BusinessException {
        List<CAPPortalElementConfig> list = this.findCAPPortalElementConfig(configId);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.bizPortalElementConfigDao.removeCAPPortalElementConfig(list);
    }

    @Override
    public void cloneCAPPortalElementConfig(Long sourceConfigId, Long targetConfigId) throws BusinessException {
        List<CAPPortalElementConfig> list = this.findCAPPortalElementConfig(sourceConfigId);
        ArrayList clonedList = Lists.newArrayListWithCapacity((int)list.size());
        for (CAPPortalElementConfig config : list) {
            CAPPortalElementConfig elementConfig = BizPortalUtils.clone(config);
            elementConfig.setId(UUIDLong.longUUID());
            elementConfig.setConfigId(targetConfigId);
            clonedList.add(elementConfig);
        }
        this.saveCAPPortalElementConfig(clonedList);
    }

    @Override
    public List<CAPPortalElementConfig> findCAPPortalElementConfigByDataId(List<String> dataIds) throws BusinessException {
        if (CollectionUtils.isEmpty(dataIds)) {
            return Collections.emptyList();
        }
        return this.bizPortalElementConfigDao.findCAPPortalElementConfigByDataId(dataIds);
    }

    @Override
    public List<CAPPortalElementConfig> findCAPPortalElementConfig(Long configId) throws BusinessException {
        return this.bizPortalElementConfigDao.findCAPPortalElementConfig(configId);
    }

    @Override
    public List<CAPPortalElementConfig> findCAPPortalElementConfig(Long configId, Long sectionId) throws BusinessException {
        List<CAPPortalElementConfig> list = this.findCAPPortalElementConfig(configId);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList candidates = Lists.newArrayListWithCapacity((int)list.size());
        for (CAPPortalElementConfig config : list) {
            if (!ObjectUtils.equals((Object)config.getSectionId(), (Object)sectionId)) continue;
            candidates.add(config);
        }
        return candidates;
    }

    @Override
    public List<CAPPortalSection> findCAPPortalSection(List<Long> sectionIds) throws BusinessException {
        if (CollectionUtils.isEmpty(sectionIds)) {
            return Collections.emptyList();
        }
        return this.bizPortalSectionDao.findCAPPortalSection(sectionIds);
    }

    @Override
    public List<CAPPortalSection> findCAPPortalSection(CAPPortalSpaceConfig spaceConfig) throws BusinessException {
        BizPortalSpaceLayoutConfig layoutConfig = new BizPortalSpaceLayoutConfig(spaceConfig);
        List sectionIds = Lists.transform(layoutConfig.listSections(), (Function)new Function<BizPortalSectionConfigJson, Long>(){

            public Long apply(BizPortalSectionConfigJson input) {
                return input.getId();
            }
        });
        return this.findCAPPortalSection(sectionIds);
    }

    @Override
    public void updateCAPPortalSection(List<CAPPortalSection> list) throws BusinessException {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.bizPortalSectionDao.updateCAPPortalSection(list);
    }

    @Override
    public void saveCAPPortalElementConfig(List<CAPPortalElementConfig> list) throws BusinessException {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.bizPortalElementConfigDao.saveCAPPortalElementConfig(list);
    }

    @Override
    public void updateCAPPortalElementConfig(List<CAPPortalElementConfig> list) throws BusinessException {
        this.bizPortalElementConfigDao.updateCAPPortalElementConfig(list);
    }

    @Override
    public CAPPortalElementConfig getCAPPortalElementConfig(Long configId, Long sectionId, Long elementId) {
        List<CAPPortalElementConfig> list = this.bizPortalElementConfigDao.findCAPPortalElementConfig(configId, sectionId, Lists.newArrayList((Object[])new Long[]{elementId}));
        return CollectionUtils.isNotEmpty(list) ? list.get(0) : null;
    }

    @Override
    public BizPortalSectionResult getBizPortalSectionResult(Long configId, Long sectionId, ContextParam contextParam) throws BusinessException {
        BizPortalSectionResult sectionResult = new BizPortalSectionResult();
        BizPortalSectionConfigJson configJson = this.getBizPortalSectionConfigJson(configId, sectionId);
        List<BizPortalSectionElement> elements = configJson.getElements();
        for (BizPortalSectionElement element : elements) {
            Long elementId = element.getId();
            sectionResult.putResult(elementId, this.getElementDataResult(configId, sectionId, contextParam, element, Command.of(element.getCondition())));
        }
        return sectionResult;
    }

    @Override
    public ServiceResult getElementDataSetResult(Long configId, Long sectionId, Long elementId, ContextParam contextParam, Command command) throws BusinessException {
        BizPortalSectionConfigJson bizPortalSectionConfigJson = this.getBizPortalSectionConfigJson(configId, sectionId);
        BizPortalSectionElement element = bizPortalSectionConfigJson.getElement(elementId);
        return this.getElementDataResult(configId, sectionId, contextParam, element, command);
    }

    private ServiceResult getElementDataResult(Long configId, Long sectionId, ContextParam contextParam, BizPortalSectionElement element, Command command) throws BusinessException {
        ServiceResult serviceResult = null;
        CAPPortalElementConfig elementConfig = this.getCAPPortalElementConfig(configId, sectionId, element.getId());
        if (elementConfig == null) {
            ElementDefaultValueConstruct construct = this.getDefaultValueConstruct(element);
            if (construct != null) {
                serviceResult = ServiceResult.success(construct.constructDataSetResult(element, contextParam));
            } else {
                List<Map<String, Object>> presetData = this.getBizPortalSectionPresetData(sectionId);
                if (presetData != null) {
                    int size = presetData.size();
                    Integer index = element.getIndex();
                    if (index >= 0 && index < size) {
                        serviceResult = ServiceResult.presetData(new DefaultDataResult(presetData.get(index)));
                    }
                }
            }
        } else {
            DataSetMetadata metadata = (DataSetMetadata)JSONUtil.parseJSONString((String)elementConfig.getMetadataInfo(), DataSetMetadata.class);
            String dataVersion = element.getDataVersion();
            command.setDataId(elementConfig.getDataId());
            serviceResult = this.dataSourceContextManager.getDataSetResult(contextParam, metadata, dataVersion.split(","), command);
        }
        return serviceResult;
    }

    private ElementDefaultValueConstruct getDefaultValueConstruct(BizPortalSectionElement element) {
        Map constructMap = AppContext.getBeansOfType(ElementDefaultValueConstruct.class);
        for (ElementDefaultValueConstruct construct : constructMap.values()) {
            if (!ObjectUtils.equals((Object)construct.dataFormat().getCode(), (Object)element.getDataFormat())) continue;
            return construct;
        }
        return null;
    }

    private BizPortalSectionConfigJson getBizPortalSectionConfigJson(Long configId, Long sectionId) throws BusinessException {
        BizPortalSectionConfigJson sectionConfigJson = this.bizPortalSpaceManager.getBizPortalSpaceConfig(configId).getSectionConfigJson(sectionId);
        if (sectionConfigJson == null) {
            CAPPortalSection capPortalSection = this.getCAPPortalSection(sectionId);
            sectionConfigJson = (BizPortalSectionConfigJson)JSONUtil.parseJSONString((String)capPortalSection.getConfigInfo(), BizPortalSectionConfigJson.class);
        }
        return sectionConfigJson;
    }

    @Override
    public CAPPortalSection getCAPPortalSection(Long sectionId) {
        return this.bizPortalSectionDao.getCAPPortalSection(sectionId);
    }

    public void setBizPortalGoodSnapshotManager(BizPortalGoodSnapshotManager bizPortalGoodSnapshotManager) {
        this.bizPortalGoodSnapshotManager = bizPortalGoodSnapshotManager;
    }

    public void setBizPortalSectionDao(BizPortalSectionDao bizPortalSectionDao) {
        this.bizPortalSectionDao = bizPortalSectionDao;
    }

    public void setBizPortalElementConfigDao(BizPortalElementConfigDao bizPortalElementConfigDao) {
        this.bizPortalElementConfigDao = bizPortalElementConfigDao;
    }

    public void setDataSourceContextManager(DataSourceContextManager dataSourceContextManager) {
        this.dataSourceContextManager = dataSourceContextManager;
    }

    public void setBizPortalSpaceManager(BizPortalSpaceManager bizPortalSpaceManager) {
        this.bizPortalSpaceManager = bizPortalSpaceManager;
    }

    public void setBizPortalFileManager(BizPortalFileManager bizPortalFileManager) {
        this.bizPortalFileManager = bizPortalFileManager;
    }
}

