/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.manager;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.seeyon.apps.m3.api.M3Api;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.bean.BizPortalBusinessDataConfigJson;
import com.seeyon.cap4.bizportal.bean.BizPortalGoodSnapshotMeta;
import com.seeyon.cap4.bizportal.bean.BizPortalLayoutConfig;
import com.seeyon.cap4.bizportal.bean.BizPortalSectionConfigJson;
import com.seeyon.cap4.bizportal.bean.BizPortalSectionElement;
import com.seeyon.cap4.bizportal.bean.BizPortalSpaceConfigJson;
import com.seeyon.cap4.bizportal.bean.BizPortalSpaceLayoutConfig;
import com.seeyon.cap4.bizportal.bean.DownloadGoodInfo;
import com.seeyon.cap4.bizportal.bean.SimpleBizPortalSpace;
import com.seeyon.cap4.bizportal.bean.SimpleDataRelation;
import com.seeyon.cap4.bizportal.bean.SimpleElementConfig;
import com.seeyon.cap4.bizportal.bean.SimpleManifestFile;
import com.seeyon.cap4.bizportal.bean.SimpleSpaceLayout;
import com.seeyon.cap4.bizportal.bean.SimpleSpaceManifest;
import com.seeyon.cap4.bizportal.dao.BizPortalSpaceAuthDao;
import com.seeyon.cap4.bizportal.dao.BizPortalSpaceConfigDao;
import com.seeyon.cap4.bizportal.dao.BizPortalSpaceDao;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.exception.NotAcceptablePlatformException;
import com.seeyon.cap4.bizportal.function.Consumer;
import com.seeyon.cap4.bizportal.manager.BizPortalDataRelationManager;
import com.seeyon.cap4.bizportal.manager.BizPortalGoodSnapshotManager;
import com.seeyon.cap4.bizportal.manager.BizPortalGoodSnapshotManagerImpl;
import com.seeyon.cap4.bizportal.manager.BizPortalGoodsDownloadCallback;
import com.seeyon.cap4.bizportal.manager.BizPortalSectionManager;
import com.seeyon.cap4.bizportal.manager.BizPortalSpaceManager;
import com.seeyon.cap4.bizportal.manager.BizPortalThemeManager;
import com.seeyon.cap4.bizportal.manager.DataSourceContextManager;
import com.seeyon.cap4.bizportal.manager.OrganizationAdapterManager;
import com.seeyon.cap4.bizportal.param.BizPortalSpaceConfigParam;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.po.CAPPortalDataRelation;
import com.seeyon.cap4.bizportal.po.CAPPortalElementConfig;
import com.seeyon.cap4.bizportal.po.CAPPortalGoodSnapshot;
import com.seeyon.cap4.bizportal.po.CAPPortalSection;
import com.seeyon.cap4.bizportal.po.CAPPortalSpace;
import com.seeyon.cap4.bizportal.po.CAPPortalSpaceAuth;
import com.seeyon.cap4.bizportal.po.CAPPortalSpaceConfig;
import com.seeyon.cap4.bizportal.po.CAPPortalTheme;
import com.seeyon.cap4.bizportal.utils.BizPortalUtils;
import com.seeyon.cap4.form.modules.business.BizEnums;
import com.seeyon.cap4.form.modules.business.BusinessAuthorityManager;
import com.seeyon.cap4.form.modules.business.FormAppBO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.organization.dao.OrgHelper;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class BizPortalSpaceManagerImpl
implements BizPortalSpaceManager,
BizPortalGoodsDownloadCallback,
BusinessAuthorityManager {
    private BizPortalSpaceDao bizPortalSpaceDao;
    private BizPortalSpaceAuthDao bizPortalSpaceAuthDao;
    private BizPortalSpaceConfigDao bizPortalSpaceConfigDao;
    private BizPortalGoodSnapshotManager bizPortalGoodSnapshotManager;
    private BizPortalThemeManager bizPortalThemeManager;
    private BizPortalSectionManager bizPortalSectionManager;
    private BizPortalDataRelationManager bizPortalDataRelationManager;
    private DataSourceContextManager dataSourceContextManager;
    private M3Api m3Api;
    private OrganizationAdapterManager organizationAdapterManager;

    @Override
    public String goodsClass() {
        return BizPortalConstants.GoodsClassKey.PORTAL_SPACE.getKey();
    }

    @Override
    public Long doExecute(ContextParam contextParam, CAPPortalGoodSnapshot snapshot, DownloadGoodInfo downloadGoodInfo) throws BusinessException {
        BizPortalSpaceConfigJson configJson = this.bizPortalGoodSnapshotManager.getBizPortalConfigJson(snapshot, BizPortalSpaceConfigJson.class);
        BizPortalConstants.Platform platform = BizPortalUtils.getEnumByCode(BizPortalConstants.Platform.class, configJson.getPlatform());
        if (platform == null || !platform.contains(contextParam.getPlatform())) {
            throw new NotAcceptablePlatformException("\u4e1a\u52a1\u7a7a\u95f4\u7684\u9002\u914d\u7ec8\u7aef\u4e0d\u5339\u914d\uff01");
        }
        CAPPortalSpace portalSpace = this.createBizPortalSpace(snapshot, configJson, contextParam, snapshot.getGoodsName());
        return portalSpace.getId();
    }

    public Integer getSort() {
        return BizEnums.UnifiedAuthType.SOURCE_TYPE_SELFDESIGNPORTAL_NEW.getKey();
    }

    @Override
    public int getId() {
        return BizEnums.UnifiedAuthType.SOURCE_TYPE_SELFDESIGNPORTAL_NEW.getKey();
    }

    @Override
    public List<FormAppBO> getFormAppBOList(Long bizId) throws BusinessException {
        List<CAPPortalSpace> list = this.findCAPPortalSpaceByBizId(bizId);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList formApps = Lists.newArrayListWithCapacity((int)list.size());
        for (CAPPortalSpace portalSpace : list) {
            FormAppBO formApp = new FormAppBO();
            formApp.setId(portalSpace.getId().toString());
            formApp.setName(portalSpace.getName());
            formApp.setSourceType(this.getId());
            formApp.setSourctTypeName(BizEnums.UnifiedAuthType.SOURCE_TYPE_SELFDESIGNPORTAL_NEW.getText());
            formApp.setCategoryId(bizId.toString());
            formApp.setAuthId(portalSpace.getAuthInfo());
            formApp.setAuthName(OrgHelper.showOrgEntities((String)portalSpace.getAuthInfo(), (String)ResourceUtil.getString((String)"common.separator.label")));
            formApps.add(formApp);
        }
        return formApps;
    }

    @Override
    public boolean isEnableUsed() {
        return true;
    }

    @Override
    public void saveAuthority(FormAppBO formAppBO) throws Exception {
        ContextParam contextParam = ContextParam.of(AppContext.getCurrentUser(), Long.parseLong(formAppBO.getCategoryId()));
        this.updateBizPortalSpaceAuth(Lists.newArrayList((Object[])new Long[]{Long.parseLong(formAppBO.getId())}), formAppBO.getAuthId(), contextParam);
    }

    @Override
    public void removeAuthority(FormAppBO formAppBO) throws Exception {
        ContextParam contextParam = ContextParam.of(AppContext.getCurrentUser(), Long.parseLong(formAppBO.getCategoryId()));
        this.updateBizPortalSpaceAuth(Lists.newArrayList((Object[])new Long[]{Long.parseLong(formAppBO.getId())}), "", contextParam);
    }

    @Override
    public FlipInfo findCAPPortalSpace(FlipInfo fi, Map<String, Object> params, ContextParam contextParam) {
        return this.bizPortalSpaceDao.findCAPPortalSpaceByBizId(contextParam.getBizId(), fi, params);
    }

    @Override
    public void updateBizPortalSpaceName(Long spaceId, final String name, ContextParam contextParam) {
        this.doUpdateBizPortalSpace(spaceId, contextParam, new Consumer<CAPPortalSpace>(){

            @Override
            public void accept(CAPPortalSpace bizPortalSpace) {
                bizPortalSpace.setName(name);
            }
        });
    }

    @Override
    public void updateBizPortalSpaceSort(Long spaceId, final Integer sort, ContextParam contextParam) {
        this.doUpdateBizPortalSpace(spaceId, contextParam, new Consumer<CAPPortalSpace>(){

            @Override
            public void accept(CAPPortalSpace bizPortalSpace) {
                bizPortalSpace.setSort(sort);
            }
        });
    }

    @Override
    public void updateBizPortalSpaceState(Long spaceId, final BizPortalConstants.State state, ContextParam contextParam) {
        this.doUpdateBizPortalSpace(spaceId, contextParam, new Consumer<CAPPortalSpace>(){

            @Override
            public void accept(CAPPortalSpace bizPortalSpace) {
                bizPortalSpace.setState(state.getCode());
            }
        });
    }

    private void doUpdateBizPortalSpace(Long spaceId, ContextParam contextParam, Consumer<CAPPortalSpace> consumer) {
        CAPPortalSpace bizPortalSpace = this.bizPortalSpaceDao.getCAPPortalSpace(spaceId);
        consumer.accept(bizPortalSpace);
        bizPortalSpace.setModifyMember(contextParam.getUserId());
        bizPortalSpace.setModifyTime(new Date());
        this.bizPortalSpaceDao.updateCAPPortalSpace(bizPortalSpace);
    }

    @Override
    public void updateBizPortalSpaceAuth(List<Long> spaceIds, final String authInfo, ContextParam contextParam) {
        this.bizPortalSpaceAuthDao.deleteCAPPortalSpaceAuthBySpaceId(spaceIds);
        this.bizPortalSpaceAuthDao.saveCAPPortalSpaceAuth(this.createBizPortalSpaceAuths(spaceIds, authInfo));
        for (Long spaceId : spaceIds) {
            Consumer<CAPPortalSpace> consumer = new Consumer<CAPPortalSpace>(){

                @Override
                public void accept(CAPPortalSpace bizPortalSpace) {
                    bizPortalSpace.setAuthInfo(authInfo);
                }
            };
            this.doUpdateBizPortalSpace(spaceId, contextParam, consumer);
        }
    }

    @Override
    public void deleteBizPortalSpace(List<Long> spaceIds, ContextParam contextParam) throws BusinessException {
        List<CAPPortalSpace> portalSpaces = this.findCAPPortalSpace(spaceIds);
        if (CollectionUtils.isEmpty(portalSpaces)) {
            return;
        }
        for (CAPPortalSpace portalSpace : portalSpaces) {
            List<CAPPortalSpaceConfig> spaceConfigs = this.findCAPPortalSpaceConfigBySpaceId(portalSpace.getId());
            for (CAPPortalSpaceConfig spaceConfig : spaceConfigs) {
                spaceConfig.setDeleteFlag(true);
                this.bizPortalSectionManager.removeCAPPortalElementConfig(spaceConfig.getId(), contextParam);
            }
            this.bizPortalSpaceConfigDao.updateCAPPortalSpaceConfig(spaceConfigs);
            portalSpace.setDeleteFlag(true);
            portalSpace.setModifyTime(new Date());
            portalSpace.setModifyMember(contextParam.getUserId());
            this.bizPortalSpaceDao.updateCAPPortalSpace(portalSpace);
        }
    }

    @Override
    public BizPortalSpaceLayoutConfig getBizPortalSpaceConfig(Long configId) throws BusinessException {
        return new BizPortalSpaceLayoutConfig(this.bizPortalSpaceConfigDao.getCAPPortalSpaceConfig(configId));
    }

    @Override
    public CAPPortalSpace getCAPPortalSpace(Long spaceId) {
        return this.bizPortalSpaceDao.getCAPPortalSpace(spaceId);
    }

    @Override
    public CAPPortalSpaceConfig createEditBizPortalSpaceConfig(Long spaceId, ContextParam contextParam) throws BusinessException {
        return this.cloneBizPortalSpaceConfig(this.getBizPortalSpaceConfig(spaceId, BizPortalConstants.ConfigStatus.RUNNING), BizPortalConstants.ConfigStatus.EDITING, contextParam, new Date());
    }

    @Override
    public void saveBizPortalSpaceConfig(BizPortalSpaceConfigParam param, ContextParam contextParam) throws BusinessException {
        CAPPortalSpaceConfig capPortalSpaceConfig = this.bizPortalSpaceConfigDao.getCAPPortalSpaceConfig(param.getId());
        this.doUpdateBizPortalSpace(capPortalSpaceConfig.getSpaceId(), contextParam, new Consumer<CAPPortalSpace>(){

            @Override
            public void accept(CAPPortalSpace bizPortalSpace) {
            }
        });
        CAPPortalSpaceConfig running = this.getBizPortalSpaceConfig(capPortalSpaceConfig.getSpaceId(), BizPortalConstants.ConfigStatus.RUNNING);
        capPortalSpaceConfig.setThemeId(param.getThemeId());
        capPortalSpaceConfig.setLayoutId(param.getLayoutId());
        capPortalSpaceConfig.setLayout(JSONUtil.toJSONString(param.getLayout()));
        capPortalSpaceConfig.setLeftLayout(JSONUtil.toJSONString(param.getLeft()));
        capPortalSpaceConfig.setRightLayout(JSONUtil.toJSONString(param.getRight()));
        capPortalSpaceConfig.setTopLayout(JSONUtil.toJSONString(param.getTop()));
        capPortalSpaceConfig.setBottomLayout(JSONUtil.toJSONString(param.getBottom()));
        this.updateCAPPortalSpaceConfig(capPortalSpaceConfig);
        this.cloneBizPortalSpaceConfig(capPortalSpaceConfig, BizPortalConstants.ConfigStatus.RUNNING, contextParam, capPortalSpaceConfig.getCreateTime());
        running.setStatus(BizPortalConstants.ConfigStatus.HISTORY.getCode());
        this.updateCAPPortalSpaceConfig(running);
    }

    @Override
    public void resetInitialSpaceConfig(Long configId, ContextParam contextParam) throws BusinessException {
        CAPPortalSpaceConfig spaceConfig = this.bizPortalSpaceConfigDao.getCAPPortalSpaceConfig(configId);
        this.bizPortalSectionManager.removeCAPPortalElementConfig(configId, contextParam);
        CAPPortalSpaceConfig initial = this.getBizPortalSpaceConfig(spaceConfig.getSpaceId(), BizPortalConstants.ConfigStatus.Initial);
        spaceConfig.setThemeId(initial.getThemeId());
        spaceConfig.setLayoutId(initial.getLayoutId());
        spaceConfig.setLayout(initial.getLayout());
        spaceConfig.setLeftLayout(initial.getLeftLayout());
        spaceConfig.setRightLayout(initial.getRightLayout());
        spaceConfig.setTopLayout(initial.getTopLayout());
        spaceConfig.setBottomLayout(initial.getBottomLayout());
        this.updateCAPPortalSpaceConfig(spaceConfig);
        this.bizPortalSectionManager.cloneCAPPortalElementConfig(initial.getId(), configId);
    }

    @Override
    public Resource exportBizPortalSpace(Long bizId, Long spaceId, ContextParam contextParam) throws BusinessException {
        CAPPortalSpace space = this.getCAPPortalSpace(spaceId);
        BizPortalSpaceConfigJson configJson = new BizPortalSpaceConfigJson();
        configJson.setName(space.getName());
        configJson.setPlatform(space.getPlatform());
        configJson.setFrameType(space.getFrameType());
        configJson.setCreateBy(contextParam.getUserName());
        configJson.setCreateVendor(BizPortalUtils.getCustomName());
        configJson.setCreateTime(new Date());
        configJson.setV5Version(BizPortalUtils.getVersion());
        configJson.setCAP4Version("4.3");
        configJson.setBuiltId(BizPortalUtils.getBuiltId());
        configJson.setConfig(new SimpleSpaceLayout());
        configJson.setManifest(new SimpleSpaceManifest());
        CAPPortalSpaceConfig spaceConfig = this.getBizPortalSpaceConfig(spaceId, BizPortalConstants.ConfigStatus.RUNNING);
        configJson.getConfig().setThemeId(spaceConfig.getThemeId());
        configJson.getConfig().setLayoutId(spaceConfig.getLayoutId());
        configJson.getConfig().setLeft(this.eraseLayoutDataConfig(spaceConfig.getLeftLayout()));
        configJson.getConfig().setRight(this.eraseLayoutDataConfig(spaceConfig.getRightLayout()));
        configJson.getConfig().setTop(this.eraseLayoutDataConfig(spaceConfig.getTopLayout()));
        configJson.getConfig().setBottom(this.eraseLayoutDataConfig(spaceConfig.getBottomLayout()));
        configJson.getConfig().setLayout(this.eraseLayoutDataConfig(spaceConfig.getLayout()));
        File tempDir = this.getTempBizPortalSpaceDirectory(space, configJson.getCreateTime());
        SimpleManifestFile themeManifestFile = this.bizPortalThemeManager.createSimpleManifestFile(spaceConfig.getThemeId(), tempDir);
        configJson.getManifest().setTheme(Lists.newArrayList((Object[])new SimpleManifestFile[]{themeManifestFile}));
        HashMap sectionMap = Maps.newHashMap();
        List<CAPPortalSection> sections = this.bizPortalSectionManager.findCAPPortalSection(spaceConfig);
        for (CAPPortalSection section : sections) {
            SimpleManifestFile manifestFile = (SimpleManifestFile)sectionMap.get(section.getSourceId());
            if (manifestFile != null) {
                manifestFile.getRelateIds().add(section.getId());
                continue;
            }
            sectionMap.put(section.getSourceId(), this.bizPortalSectionManager.createBizPortalManifestFile(section.getId(), tempDir));
        }
        configJson.getManifest().setColumn(Lists.newArrayList(sectionMap.values()));
        BizPortalUtils.write(new File(tempDir, "config.json"), JSONUtil.toJSONString((Object)configJson));
        File spacePackage = this.getBizPortalSpacePackage(space);
        BizPortalUtils.zip(tempDir, spacePackage);
        BizPortalUtils.deleteDirectory(tempDir);
        return new FileSystemResource(spacePackage);
    }

    @Override
    public CAPPortalSpace createBizPortalSpace(File file, ContextParam contextParam) throws BusinessException {
        BizPortalGoodSnapshotMeta metadata = new BizPortalGoodSnapshotMeta();
        metadata.setSourceType(BizPortalConstants.SourceType.Local.getCode());
        metadata.setCreateTime(new Date());
        CAPPortalGoodSnapshot goodSnapshot = this.bizPortalGoodSnapshotManager.createGoodSnapshot(metadata, file, contextParam);
        BizPortalSpaceConfigJson configJson = this.bizPortalGoodSnapshotManager.getBizPortalConfigJson(goodSnapshot, BizPortalSpaceConfigJson.class);
        return this.createBizPortalSpace(goodSnapshot, configJson, contextParam, configJson.getName());
    }

    @Override
    public List<CAPPortalSpace> findCAPPortalSpaceByBizId(Long bizId) throws BusinessException {
        return this.findCAPPortalSpaceByBizId(bizId, new HashMap());
    }

    @Override
    public List<CAPPortalSpace> findCAPPortalSpaceByBizId(Long bizId, BizPortalConstants.Platform platform) throws BusinessException {
        return this.findCAPPortalSpaceByBizId(bizId, (Map<String, ?>)ImmutableMap.of((Object)"platform", (Object)platform.getCode()));
    }

    private List<CAPPortalSpace> findCAPPortalSpaceByBizId(Long bizId, Map<String, ?> params) {
        return this.bizPortalSpaceDao.findCAPPortalSpaceByBizId(bizId, this.getFlip(), params).getData();
    }

    private FlipInfo getFlip() {
        FlipInfo fi = new FlipInfo(-1, -1);
        fi.setNeedTotal(false);
        return fi;
    }

    @Override
    public CAPPortalSpaceConfig getBizPortalSpaceConfig(Long spaceId, BizPortalConstants.ConfigStatus configStatus) {
        List<CAPPortalSpaceConfig> list = this.bizPortalSpaceConfigDao.findCAPPortalSpaceConfig(spaceId, configStatus);
        return CollectionUtils.isNotEmpty(list) ? list.get(0) : null;
    }

    @Override
    public List<CAPPortalSpace> findCAPPortalSpace(List<Long> spaceIds) {
        return this.bizPortalSpaceDao.findCAPPortalSpace(spaceIds);
    }

    @Override
    public SimpleManifestFile createSimpleManifestFile(CAPPortalSpace portalSpace) throws BusinessException {
        CAPPortalGoodSnapshot goodsSnap = this.bizPortalGoodSnapshotManager.getCAPPortalGoodSnapshot(portalSpace.getSourceId());
        SimpleManifestFile manifestFile = new SimpleManifestFile();
        manifestFile.setId(goodsSnap.getId());
        manifestFile.setSourceType(portalSpace.getSourceType());
        manifestFile.setGoodsKey(goodsSnap.getGoodsKey());
        manifestFile.setSubGoodsKey(goodsSnap.getSubGoodsKey());
        manifestFile.setGoodsId(goodsSnap.getGoodsId());
        manifestFile.setGoodsName(goodsSnap.getGoodsName());
        manifestFile.setGoodUpdateTime(goodsSnap.getGoodUpdateTime());
        manifestFile.setInfoUrl(goodsSnap.getInfoUrl());
        return manifestFile;
    }

    @Override
    public void createBizPortalSpace(BizPortalBusinessDataConfigJson businessDataConfigJson, ContextParam contextParam) throws BusinessException {
        SimpleSpaceManifest manifest = businessDataConfigJson.getManifest();
        Map<Long, CAPPortalGoodSnapshot> spaceGoodSnapshot = this.createSpaceGoodSnapshot(manifest.getSpace(), contextParam);
        Map<Long, CAPPortalTheme> portalTheme = this.createPortalTheme(manifest.getTheme(), contextParam, businessDataConfigJson.getFilePath());
        Map<Long, CAPPortalSection> sectionMapping = this.createPortalSection(manifest.getColumn(), contextParam, businessDataConfigJson.getFilePath());
        ArrayList elementConfigs = Lists.newArrayListWithCapacity((int)100);
        for (SimpleBizPortalSpace simpleBizPortalSpace : businessDataConfigJson.getSpaces()) {
            Long sourceId = spaceGoodSnapshot.get(simpleBizPortalSpace.getId()).getId();
            Long themeId = portalTheme.get(simpleBizPortalSpace.getConfig().getThemeId()).getId();
            this.createBizPortalSpace(simpleBizPortalSpace, sourceId, themeId, sectionMapping, contextParam, elementConfigs);
        }
        this.bizPortalSectionManager.updateCAPPortalSection(Lists.newArrayList(sectionMapping.values()));
        this.mergeDataRelation(businessDataConfigJson, contextParam, elementConfigs);
    }

    @Override
    public void updateBizPortalSpace(BizPortalBusinessDataConfigJson businessDataConfigJson, ContextParam contextParam) throws BusinessException {
        SimpleSpaceManifest manifest = businessDataConfigJson.getManifest();
        Map<Long, CAPPortalGoodSnapshot> spaceGoodSnapshot = this.createSpaceGoodSnapshot(manifest.getSpace(), contextParam);
        Map<Long, CAPPortalTheme> portalTheme = this.createPortalTheme(manifest.getTheme(), contextParam, businessDataConfigJson.getFilePath());
        Map<Long, CAPPortalSection> sectionMapping = this.createPortalSection(manifest.getColumn(), contextParam, businessDataConfigJson.getFilePath());
        ArrayList elementConfigs = Lists.newArrayListWithCapacity((int)100);
        for (SimpleBizPortalSpace simpleBizPortalSpace : businessDataConfigJson.getSpaces()) {
            CAPPortalSpace portalSpace = this.getCAPPortalSpace(simpleBizPortalSpace.getNewId());
            if (portalSpace == null || portalSpace.getDeleteFlag().booleanValue()) {
                if (portalSpace != null) {
                    List<CAPPortalSpaceConfig> spaceConfigs = this.bizPortalSpaceConfigDao.findCAPPortalSpaceConfigBySpaceId(portalSpace.getId(), false);
                    for (CAPPortalSpaceConfig spaceConfig : spaceConfigs) {
                        this.bizPortalSectionManager.removeCAPPortalElementConfig(spaceConfig.getId(), contextParam);
                    }
                    this.bizPortalSpaceConfigDao.deleteCAPPortalSpaceConfig(spaceConfigs);
                    this.bizPortalSpaceDao.deleteCAPPortalSpace(Lists.newArrayList((Object[])new CAPPortalSpace[]{portalSpace}));
                }
                Long sourceId = spaceGoodSnapshot.get(simpleBizPortalSpace.getId()).getId();
                Long themeId = portalTheme.get(simpleBizPortalSpace.getConfig().getThemeId()).getId();
                this.createBizPortalSpace(simpleBizPortalSpace, sourceId, themeId, sectionMapping, contextParam, elementConfigs);
                continue;
            }
            portalSpace.setName(simpleBizPortalSpace.getName());
            portalSpace.setPlatform(simpleBizPortalSpace.getPlatform());
            portalSpace.setState(simpleBizPortalSpace.getState());
            portalSpace.setSourceType(simpleBizPortalSpace.getSourceType());
            portalSpace.setSourceId(spaceGoodSnapshot.get(simpleBizPortalSpace.getId()).getId());
            portalSpace.setFrameType(simpleBizPortalSpace.getFrameType());
            portalSpace.setSort(simpleBizPortalSpace.getSort());
            portalSpace.setAuthInfo(simpleBizPortalSpace.getAuthInfo());
            portalSpace.setModifyMember(contextParam.getUserId());
            portalSpace.setModifyTime(new Date());
            this.bizPortalSpaceAuthDao.deleteCAPPortalSpaceAuthBySpaceId(Lists.newArrayList((Object[])new Long[]{portalSpace.getId()}));
            this.bizPortalSpaceAuthDao.saveCAPPortalSpaceAuth(this.createBizPortalSpaceAuths(Lists.newArrayList((Object[])new Long[]{portalSpace.getId()}), portalSpace.getAuthInfo()));
            Long themeId = portalTheme.get(simpleBizPortalSpace.getConfig().getThemeId()).getId();
            CAPPortalSpaceConfig spaceConfig = this.buildCapPortalSpaceConfig(simpleBizPortalSpace, themeId, contextParam, portalSpace);
            this.dealWithLayoutIdChanges(spaceConfig, sectionMapping);
            if (CollectionUtils.isNotEmpty(simpleBizPortalSpace.getElementConfigs())) {
                HashMap map = Maps.newHashMap();
                for (SimpleElementConfig simpleElementConfig : simpleBizPortalSpace.getElementConfigs()) {
                    Long sectionId = simpleElementConfig.getSectionId();
                    ArrayList<SimpleElementConfig> list = (ArrayList<SimpleElementConfig>)map.get(sectionId);
                    if (list == null) {
                        list = new ArrayList<SimpleElementConfig>();
                        map.put(sectionId, list);
                    }
                    list.add(simpleElementConfig);
                }
                for (Map.Entry entry : map.entrySet()) {
                    CAPPortalSection capPortalSection = sectionMapping.get(entry.getKey());
                    if (capPortalSection == null) continue;
                    elementConfigs.addAll(this.bizPortalSectionManager.createCAPPortalElementConfig(spaceConfig.getId(), capPortalSection.getId(), (List)entry.getValue(), contextParam));
                }
            }
            CAPPortalSpaceConfig running = this.getBizPortalSpaceConfig(spaceConfig.getSpaceId(), BizPortalConstants.ConfigStatus.RUNNING);
            running.setStatus(BizPortalConstants.ConfigStatus.HISTORY.getCode());
            this.saveCAPPortalSpaceConfig(spaceConfig);
            this.updateCAPPortalSpaceConfig(running);
            CAPPortalSpaceConfig clone = BizPortalUtils.clone(spaceConfig);
            clone.setId(UUIDLong.longUUID());
            clone.setStatus(BizPortalConstants.ConfigStatus.Initial.getCode());
            this.bizPortalSectionManager.cloneCAPPortalElementConfig(spaceConfig.getId(), clone.getId());
            this.saveCAPPortalSpaceConfig(clone);
        }
        this.bizPortalSectionManager.updateCAPPortalSection(Lists.newArrayList(sectionMapping.values()));
        this.mergeDataRelation(businessDataConfigJson, contextParam, elementConfigs);
    }

    @Override
    public void deleteBizPortalSpaceAll(Long bizId, User user) throws BusinessException {
        List<CAPPortalSpace> portalSpaces = this.findCAPPortalSpaceByBizId(bizId);
        if (CollectionUtils.isEmpty(portalSpaces)) {
            return;
        }
        ContextParam contextParam = ContextParam.of(user, bizId);
        ArrayList spaceIds = Lists.newArrayListWithCapacity((int)portalSpaces.size());
        for (CAPPortalSpace portalSpace : portalSpaces) {
            List<CAPPortalSpaceConfig> spaceConfigs = this.findCAPPortalSpaceConfigBySpaceId(portalSpace.getId());
            for (CAPPortalSpaceConfig spaceConfig : spaceConfigs) {
                this.bizPortalSectionManager.removeCAPPortalElementConfig(spaceConfig.getId(), contextParam);
            }
            this.bizPortalSpaceConfigDao.deleteCAPPortalSpaceConfig(spaceConfigs);
            spaceIds.add(portalSpace.getId());
        }
        this.bizPortalSpaceDao.deleteCAPPortalSpace(portalSpaces);
        this.bizPortalSpaceAuthDao.deleteCAPPortalSpaceAuthBySpaceId(spaceIds);
        this.bizPortalDataRelationManager.deleteCAPPortalDataRelationByBizId(bizId);
    }

    private List<CAPPortalSpaceConfig> findCAPPortalSpaceConfigBySpaceId(Long spaceId) {
        return this.bizPortalSpaceConfigDao.findCAPPortalSpaceConfigBySpaceId(spaceId, false);
    }

    @Override
    public CAPPortalSpaceConfig getCAPPortalSpaceConfig(Long configId) throws BusinessException {
        return this.bizPortalSpaceConfigDao.getCAPPortalSpaceConfig(configId);
    }

    @Override
    public List<CAPPortalSpace> findAvailableCAPPortalSpace(ContextParam contextParam) throws BusinessException {
        ImmutableMap params = ImmutableMap.of((Object)"platform", (Object)contextParam.getPlatform().getCode(), (Object)"state", (Object)BizPortalConstants.State.ENABLE.getCode());
        List<CAPPortalSpace> list = this.findCAPPortalSpaceByBizId(contextParam.getBizId(), (Map<String, ?>)params);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        List<Long> allUserDomainIDs = this.organizationAdapterManager.getAllUserDomainIDs(contextParam.getUser());
        Iterator<CAPPortalSpace> iterator = list.iterator();
        while (iterator.hasNext()) {
            CAPPortalSpace space = iterator.next();
            if (this.bizPortalSpaceAuthDao.checkAuth(space.getId(), allUserDomainIDs)) continue;
            iterator.remove();
        }
        return list;
    }

    @Override
    public List<Long> findCAPPortalGoodSnapshotId(Long configId) throws BusinessException {
        CAPPortalSpaceConfig spaceConfig = this.bizPortalSpaceConfigDao.getCAPPortalSpaceConfig(configId);
        if (spaceConfig == null) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        CAPPortalTheme portalTheme = this.bizPortalThemeManager.getCAPPortalTheme(spaceConfig.getThemeId());
        list.add(portalTheme.getSourceId());
        BizPortalSpaceLayoutConfig layoutConfig = new BizPortalSpaceLayoutConfig(spaceConfig);
        List<BizPortalSectionConfigJson> allSections = layoutConfig.listSections();
        if (CollectionUtils.isNotEmpty(allSections)) {
            ArrayList sectionIds = Lists.newArrayListWithCapacity((int)allSections.size());
            for (BizPortalSectionConfigJson sectionConfigJson : allSections) {
                sectionIds.add(sectionConfigJson.getId());
            }
            HashSet set = Sets.newHashSet();
            for (CAPPortalSection section : this.bizPortalSectionManager.findCAPPortalSection(sectionIds)) {
                Long sourceId = section.getSourceId();
                if (set.contains(sourceId)) continue;
                set.add(sourceId);
                list.add(sourceId);
            }
        }
        return list;
    }

    @Override
    public boolean checkAuth(Long spaceId, User user) throws BusinessException {
        CAPPortalSpace portalSpace = this.getCAPPortalSpace(spaceId);
        if (portalSpace.getDeleteFlag().booleanValue()) {
            return false;
        }
        if (ObjectUtils.equals((Object)portalSpace.getState(), (Object)BizPortalConstants.State.DISABLE.getCode())) {
            return false;
        }
        List<Long> allUserDomainIDs = this.organizationAdapterManager.getAllUserDomainIDs(user);
        return this.bizPortalSpaceAuthDao.checkAuth(spaceId, allUserDomainIDs);
    }

    private String eraseLayoutDataConfig(String layout) {
        BizPortalLayoutConfig layoutConfig = new BizPortalLayoutConfig(layout);
        List<BizPortalSectionConfigJson> sectionConfigs = layoutConfig.listSectionConfig();
        for (BizPortalSectionConfigJson sectionConfigJson : sectionConfigs) {
            if (sectionConfigJson.isCopiable()) {
                CAPPortalSection portalSection = this.bizPortalSectionManager.getCAPPortalSection(sectionConfigJson.getId());
                BizPortalSectionConfigJson source = new BizPortalSectionConfigJson(portalSection.getConfigInfo());
                sectionConfigJson.setElements(source.getElements());
                continue;
            }
            List<BizPortalSectionElement> elements = sectionConfigJson.getElements();
            for (BizPortalSectionElement element : elements) {
                element.setDataId(null);
            }
            sectionConfigJson.setElements(elements);
        }
        return JSONUtil.toJSONString((Object)layoutConfig);
    }

    private Integer getNextBizPortalSpace(Long bizId) {
        Integer maxSort = this.bizPortalSpaceDao.getCAPPortalSpaceMaxSort(bizId);
        if (maxSort == null) {
            return BizPortalConstants.DEFAULT_SORT;
        }
        return maxSort % 10 == 0 ? maxSort + 10 : 10 * (1 + maxSort / 10);
    }

    private List<CAPPortalSpaceAuth> createBizPortalSpaceAuths(List<Long> spaceIds, String authInfo) {
        String[] arr;
        if (StringUtils.isEmpty((String)authInfo)) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        for (String typeAndId : arr = authInfo.split(",")) {
            String[] ss = typeAndId.split("\\|");
            String authType = ss[0];
            Long authId = Long.parseLong(ss[1]);
            for (Long spaceId : spaceIds) {
                CAPPortalSpaceAuth auth = new CAPPortalSpaceAuth();
                auth.setIdIfNew();
                auth.setSpaceId(spaceId);
                auth.setAuthType(authType);
                auth.setAuthId(authId);
                list.add(auth);
            }
        }
        return list;
    }

    private CAPPortalSpaceConfig cloneBizPortalSpaceConfig(CAPPortalSpaceConfig capPortalSpaceConfig, BizPortalConstants.ConfigStatus configStatus, ContextParam contextParam, Date createTime) throws BusinessException {
        CAPPortalSpaceConfig clone = BizPortalUtils.clone(capPortalSpaceConfig);
        clone.setId(UUIDLong.longUUID());
        clone.setStatus(configStatus.getCode());
        clone.setCreateMember(contextParam.getUserId());
        clone.setSessionId(contextParam.getSessionId());
        clone.setCreateTime(createTime);
        this.saveCAPPortalSpaceConfig(clone);
        this.bizPortalSectionManager.cloneCAPPortalElementConfig(capPortalSpaceConfig.getId(), clone.getId());
        return clone;
    }

    private CAPPortalSpace createBizPortalSpace(CAPPortalGoodSnapshot snapshot, BizPortalSpaceConfigJson configJson, ContextParam contextParam, String name) throws BusinessException {
        SimpleSpaceManifest manifest = configJson.getManifest();
        File directory = this.bizPortalGoodSnapshotManager.getBizPortalGoodSnapshotDir(snapshot.getId());
        Map<Long, CAPPortalTheme> portalTheme = this.createPortalTheme(manifest.getTheme(), contextParam, directory);
        Map<Long, CAPPortalSection> portalSection = this.createPortalSection(manifest.getColumn(), contextParam, directory);
        SimpleBizPortalSpace simpleBizPortalSpace = new SimpleBizPortalSpace();
        simpleBizPortalSpace.setNewId(UUIDLong.longUUID());
        simpleBizPortalSpace.setName(name);
        simpleBizPortalSpace.setPlatform(configJson.getPlatform());
        simpleBizPortalSpace.setState(BizPortalConstants.State.ENABLE.getCode());
        simpleBizPortalSpace.setSort(this.getNextBizPortalSpace(contextParam.getBizId()));
        simpleBizPortalSpace.setFrameType(configJson.getFrameType());
        simpleBizPortalSpace.setSourceType(snapshot.getSourceType());
        simpleBizPortalSpace.setSourceId(snapshot.getId());
        simpleBizPortalSpace.setConfig(configJson.getConfig());
        Long themeId = portalTheme.get(configJson.getConfig().getThemeId()).getId();
        CAPPortalSpace portalSpace = this.createBizPortalSpace(simpleBizPortalSpace, snapshot.getId(), themeId, portalSection, contextParam, Collections.<CAPPortalElementConfig>emptyList());
        this.bizPortalSectionManager.updateCAPPortalSection(Lists.newArrayList(portalSection.values()));
        return portalSpace;
    }

    private CAPPortalSpace createBizPortalSpace(SimpleBizPortalSpace simpleBizPortalSpace, Long sourceId, Long themeId, Map<Long, CAPPortalSection> sectionMapping, ContextParam contextParam, List<CAPPortalElementConfig> elementConfigs) throws BusinessException {
        CAPPortalSpace portalSpace = new CAPPortalSpace();
        portalSpace.setId(simpleBizPortalSpace.getNewId());
        portalSpace.setName(simpleBizPortalSpace.getName());
        portalSpace.setPlatform(simpleBizPortalSpace.getPlatform());
        portalSpace.setBizId(contextParam.getBizId());
        portalSpace.setPlatform(simpleBizPortalSpace.getPlatform());
        portalSpace.setState(simpleBizPortalSpace.getState());
        portalSpace.setSort(simpleBizPortalSpace.getSort());
        portalSpace.setFrameType(simpleBizPortalSpace.getFrameType());
        portalSpace.setSourceType(simpleBizPortalSpace.getSourceType());
        portalSpace.setAuthInfo(simpleBizPortalSpace.getAuthInfo());
        portalSpace.setSourceId(sourceId);
        portalSpace.setCreateMember(contextParam.getUserId());
        portalSpace.setCreateTime(new Date());
        portalSpace.setDeleteFlag(false);
        this.bizPortalSpaceDao.saveCAPPortalSpace(portalSpace);
        this.bizPortalSpaceAuthDao.saveCAPPortalSpaceAuth(this.createBizPortalSpaceAuths(Lists.newArrayList((Object[])new Long[]{portalSpace.getId()}), portalSpace.getAuthInfo()));
        CAPPortalSpaceConfig spaceConfig = this.buildCapPortalSpaceConfig(simpleBizPortalSpace, themeId, contextParam, portalSpace);
        this.dealWithLayoutIdChanges(spaceConfig, sectionMapping);
        if (CollectionUtils.isNotEmpty(simpleBizPortalSpace.getElementConfigs())) {
            HashMap map = Maps.newHashMap();
            for (SimpleElementConfig simpleElementConfig : simpleBizPortalSpace.getElementConfigs()) {
                Long sectionId = simpleElementConfig.getSectionId();
                ArrayList<SimpleElementConfig> list = (ArrayList<SimpleElementConfig>)map.get(sectionId);
                if (list == null) {
                    list = new ArrayList<SimpleElementConfig>();
                    map.put(sectionId, list);
                }
                list.add(simpleElementConfig);
            }
            for (Map.Entry entry : map.entrySet()) {
                CAPPortalSection capPortalSection = sectionMapping.get(entry.getKey());
                if (capPortalSection == null) continue;
                elementConfigs.addAll(this.bizPortalSectionManager.createCAPPortalElementConfig(spaceConfig.getId(), capPortalSection.getId(), (List)entry.getValue(), contextParam));
            }
        }
        this.saveCAPPortalSpaceConfig(spaceConfig);
        CAPPortalSpaceConfig clone = BizPortalUtils.clone(spaceConfig);
        clone.setId(UUIDLong.longUUID());
        clone.setStatus(BizPortalConstants.ConfigStatus.Initial.getCode());
        this.bizPortalSectionManager.cloneCAPPortalElementConfig(spaceConfig.getId(), clone.getId());
        this.saveCAPPortalSpaceConfig(clone);
        return portalSpace;
    }

    private void saveCAPPortalSpaceConfig(CAPPortalSpaceConfig spaceConfig) throws BusinessException {
        this.bizPortalSpaceConfigDao.saveCAPPortalSpaceConfig(spaceConfig);
        this.hotSwapApps(spaceConfig);
    }

    private void updateCAPPortalSpaceConfig(CAPPortalSpaceConfig spaceConfig) throws BusinessException {
        this.bizPortalSpaceConfigDao.updateCAPPortalSpaceConfig(spaceConfig);
        this.hotSwapApps(spaceConfig);
    }

    private void hotSwapApps(CAPPortalSpaceConfig spaceConfig) throws BusinessException {
        if (spaceConfig.getDeleteFlag().booleanValue() || ObjectUtils.notEqual((Object)spaceConfig.getStatus(), (Object)BizPortalConstants.ConfigStatus.RUNNING.getCode())) {
            return;
        }
        CAPPortalSpace space = this.getCAPPortalSpace(spaceConfig.getSpaceId());
        if (!ObjectUtils.equals((Object)space.getPlatform(), (Object)BizPortalConstants.Platform.MOBILE.getCode())) {
            return;
        }
        ArrayList appFiles = Lists.newArrayList();
        List<Long> snapshotIds = this.findCAPPortalGoodSnapshotId(spaceConfig.getId());
        for (Long snapId : snapshotIds) {
            CollectionUtils.addIgnoreNull((Collection)appFiles, (Object)this.bizPortalGoodSnapshotManager.createAppFile(snapId));
        }
        if (CollectionUtils.isNotEmpty((Collection)appFiles)) {
            this.m3Api.buildCap4App(appFiles.toArray(new File[0]));
        }
    }

    private void dealWithLayoutIdChanges(CAPPortalSpaceConfig capPortalSpaceConfig, Map<Long, CAPPortalSection> portalSections) throws BusinessException {
        capPortalSpaceConfig.setLayout(this.dealWithLayoutIdChanges(capPortalSpaceConfig.getLayout(), portalSections));
        capPortalSpaceConfig.setLeftLayout(this.dealWithLayoutIdChanges(capPortalSpaceConfig.getLeftLayout(), portalSections));
        capPortalSpaceConfig.setRightLayout(this.dealWithLayoutIdChanges(capPortalSpaceConfig.getRightLayout(), portalSections));
        capPortalSpaceConfig.setTopLayout(this.dealWithLayoutIdChanges(capPortalSpaceConfig.getTopLayout(), portalSections));
        capPortalSpaceConfig.setBottomLayout(this.dealWithLayoutIdChanges(capPortalSpaceConfig.getBottomLayout(), portalSections));
    }

    private String dealWithLayoutIdChanges(String layout, Map<Long, CAPPortalSection> portalSections) {
        BizPortalLayoutConfig layoutConfig = new BizPortalLayoutConfig(layout);
        for (BizPortalSectionConfigJson source : layoutConfig.listSectionConfig()) {
            CAPPortalSection portalSection = portalSections.get(source.getId());
            BizPortalSectionConfigJson target = new BizPortalSectionConfigJson(portalSection.getConfigInfo());
            List<BizPortalSectionElement> sElements = source.getElements();
            List<BizPortalSectionElement> tElements = target.getElements();
            int size = Math.min(sElements.size(), tElements.size());
            for (int i = 0; i < size; ++i) {
                BizPortalSectionElement sElement = sElements.get(i);
                BizPortalSectionElement tElement = tElements.get(i);
                tElement.setId(sElement.getId());
            }
            portalSection.setConfigInfo(JSONUtil.toJSONString((Object)target));
            source.setId(portalSection.getId());
            source.setSourceId(portalSection.getSourceId());
        }
        return JSONUtil.toJSONString((Object)layoutConfig);
    }

    private File getBizPortalSpacePackage(CAPPortalSpace portalSpace) throws BusinessException {
        return new File(this.getExportsDirectory(), this.getBizPortalPackageFileName(portalSpace));
    }

    private File getTempBizPortalSpaceDirectory(CAPPortalSpace portalSpace, Date date) throws BusinessException {
        return BizPortalUtils.createDirIfAbsent(this.getExportsDirectory(), portalSpace.getId() + "_" + date.getTime());
    }

    private String getBizPortalPackageFileName(CAPPortalSpace portalSpace) {
        Date modifyTime = portalSpace.getModifyTime();
        if (modifyTime == null) {
            modifyTime = portalSpace.getCreateTime();
        }
        return portalSpace.getId() + "_" + modifyTime.getTime();
    }

    private File getExportsDirectory() throws BusinessException {
        return BizPortalUtils.createDirIfAbsent(BizPortalGoodSnapshotManagerImpl.getCAPBizPortalBaseFile(), "exports");
    }

    private CAPPortalSpaceConfig buildCapPortalSpaceConfig(SimpleBizPortalSpace simpleBizPortalSpace, Long themeId, ContextParam contextParam, CAPPortalSpace portalSpace) {
        SimpleSpaceLayout spaceLayout = simpleBizPortalSpace.getConfig();
        CAPPortalSpaceConfig spaceConfig = new CAPPortalSpaceConfig();
        spaceConfig.setIdIfNew();
        spaceConfig.setThemeId(themeId);
        spaceConfig.setStatus(BizPortalConstants.ConfigStatus.RUNNING.getCode());
        spaceConfig.setSpaceId(portalSpace.getId());
        spaceConfig.setLayoutId(spaceLayout.getLayoutId());
        spaceConfig.setLayout(spaceLayout.getLayout());
        spaceConfig.setLeftLayout(spaceLayout.getLeft());
        spaceConfig.setRightLayout(spaceLayout.getRight());
        spaceConfig.setTopLayout(spaceLayout.getTop());
        spaceConfig.setBottomLayout(spaceLayout.getBottom());
        spaceConfig.setCreateTime(portalSpace.getCreateTime());
        spaceConfig.setCreateMember(contextParam.getUserId());
        spaceConfig.setSessionId(contextParam.getSessionId());
        spaceConfig.setCreateTime(new Date());
        spaceConfig.setCreateMember(contextParam.getUserId());
        spaceConfig.setDeleteFlag(false);
        return spaceConfig;
    }

    private void mergeDataRelation(BizPortalBusinessDataConfigJson businessDataConfigJson, ContextParam contextParam, List<CAPPortalElementConfig> elementConfigs) throws BusinessException {
        List<SimpleDataRelation> dataRelations = businessDataConfigJson.getDataRelations();
        if (CollectionUtils.isEmpty(dataRelations)) {
            return;
        }
        ArrayList dataRelationIds = Lists.newArrayListWithCapacity((int)dataRelations.size());
        for (SimpleDataRelation dataRelation : dataRelations) {
            dataRelationIds.add(dataRelation.getDataId());
        }
        dataRelationIds = Lists.newArrayList((Iterable)Sets.newHashSet((Iterable)dataRelationIds));
        List<CAPPortalDataRelation> portalDataRelations = this.bizPortalDataRelationManager.findCAPPortalDataRelation(contextParam.getBizId(), dataRelationIds);
        ArrayListMultimap immutableMap = ArrayListMultimap.create();
        for (CAPPortalDataRelation cAPPortalDataRelation : portalDataRelations) {
            immutableMap.put((Object)cAPPortalDataRelation.getDataId(), (Object)cAPPortalDataRelation);
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)dataRelations.size());
        for (SimpleDataRelation relation : dataRelations) {
            if (immutableMap.containsKey((Object)relation.getDataId())) continue;
            CAPPortalDataRelation dataRelation = new CAPPortalDataRelation();
            dataRelation.setId(UUIDLong.longUUID());
            dataRelation.setBizId(contextParam.getBizId());
            dataRelation.setDataId(relation.getDataId());
            dataRelation.setSourceId(relation.getSourceId());
            dataRelation.setTargetId(relation.getTargetId());
            list.add(dataRelation);
        }
        this.bizPortalDataRelationManager.createCAPPortalDataRelation(list);
        HashSet hashSet = Sets.newHashSet();
        HashMap dataIdMapping = Maps.newHashMap();
        if (!businessDataConfigJson.isResetId()) {
            elementConfigs = this.bizPortalSectionManager.findCAPPortalElementConfigByDataId(dataRelationIds);
        } else {
            Iterator<CAPPortalElementConfig> iterator = elementConfigs.iterator();
            while (iterator.hasNext()) {
                CAPPortalElementConfig elementConfig = iterator.next();
                if (dataRelationIds.contains(elementConfig.getDataId())) continue;
                iterator.remove();
            }
        }
        for (CAPPortalElementConfig elementConfig : elementConfigs) {
            String dataId = elementConfig.getDataId();
            String metadataInfo = elementConfig.getMetadataInfo();
            DataSetMetadata metadata = (DataSetMetadata)JSONUtil.parseJSONString((String)metadataInfo, DataSetMetadata.class);
            metadata.attr("bizId", contextParam.getBizId());
            String newDataId = this.dataSourceContextManager.getNewDataId(dataId, metadata);
            elementConfig.setDataId(newDataId);
            elementConfig.setMetadataInfo(JSONUtil.toJSONString((Object)metadata));
            hashSet.add(elementConfig.getConfigId());
            dataIdMapping.put(dataId, newDataId);
        }
        this.bizPortalSectionManager.updateCAPPortalElementConfig(elementConfigs);
        for (CAPPortalDataRelation dataRelation : list) {
            dataRelation.setDataId((String)dataIdMapping.get(dataRelation.getDataId()));
        }
        this.bizPortalDataRelationManager.updateCAPPortalDataRelation(list);
        if (CollectionUtils.isNotEmpty((Collection)hashSet)) {
            List<CAPPortalSpaceConfig> spaceConfigs = this.bizPortalSpaceConfigDao.findCAPPortalSpaceConfig(Lists.newArrayList((Iterable)hashSet));
            this.refreshSpaceConfigDataId(spaceConfigs, (Map<String, String>)dataIdMapping);
            this.bizPortalSpaceConfigDao.updateCAPPortalSpaceConfig(spaceConfigs);
        }
    }

    private void refreshSpaceConfigDataId(List<CAPPortalSpaceConfig> spaceConfigs, Map<String, String> dataIdMapping) throws BusinessException {
        for (CAPPortalSpaceConfig spaceConfig : spaceConfigs) {
            this.refreshSpaceConfigDataId(spaceConfig, dataIdMapping);
        }
    }

    private void refreshSpaceConfigDataId(CAPPortalSpaceConfig spaceConfig, Map<String, String> mapping) throws BusinessException {
        spaceConfig.setTopLayout(this.getNewLayout(spaceConfig.getTopLayout(), mapping));
        spaceConfig.setBottomLayout(this.getNewLayout(spaceConfig.getBottomLayout(), mapping));
        spaceConfig.setLeftLayout(this.getNewLayout(spaceConfig.getLeftLayout(), mapping));
        spaceConfig.setRightLayout(this.getNewLayout(spaceConfig.getRightLayout(), mapping));
        spaceConfig.setLayout(this.getNewLayout(spaceConfig.getLayout(), mapping));
    }

    private String getNewLayout(String layout, Map<String, String> mapping) {
        BizPortalLayoutConfig layoutConfig = new BizPortalLayoutConfig(layout);
        layoutConfig.resetDataId(mapping);
        return JSONUtil.toJSONString((Object)layoutConfig);
    }

    private Map<Long, CAPPortalGoodSnapshot> createSpaceGoodSnapshot(List<SimpleManifestFile> manifestFiles, ContextParam contextParam) throws BusinessException {
        HashMap map = Maps.newHashMap();
        for (SimpleManifestFile file : manifestFiles) {
            BizPortalGoodSnapshotMeta metadata = new BizPortalGoodSnapshotMeta();
            metadata.setGoodsKey(file.getGoodsKey());
            metadata.setSubGoodsKey(file.getSubGoodsKey());
            metadata.setGoodsId(file.getGoodsId());
            metadata.setGoodsName(file.getGoodsName());
            metadata.setInfoUrl(file.getInfoUrl());
            metadata.setGoodUpdateTime(file.getGoodUpdateTime());
            metadata.setCreateTime(new Date());
            metadata.setSourceType(file.getSourceType());
            CAPPortalGoodSnapshot goodSnapshot = this.bizPortalGoodSnapshotManager.createGoodSnapshot(metadata, contextParam);
            for (Long relateId : file.getRelateIds()) {
                map.put(relateId, goodSnapshot);
            }
            BizPortalUtils.deleteDirectory(this.bizPortalGoodSnapshotManager.getBizPortalGoodSnapshotDir(goodSnapshot.getId()));
        }
        return map;
    }

    private Map<Long, CAPPortalTheme> createPortalTheme(List<SimpleManifestFile> manifestFiles, ContextParam contextParam, File directory) throws BusinessException {
        if (CollectionUtils.isEmpty(manifestFiles)) {
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMap();
        for (SimpleManifestFile manifestFile : manifestFiles) {
            CAPPortalTheme portalTheme = this.bizPortalThemeManager.createCAPPortalTheme(manifestFile, directory, contextParam);
            for (Long relateId : manifestFile.getRelateIds()) {
                map.put(relateId, portalTheme);
            }
        }
        return map;
    }

    private Map<Long, CAPPortalSection> createPortalSection(List<SimpleManifestFile> manifestFiles, ContextParam contextParam, File directory) throws BusinessException {
        if (CollectionUtils.isEmpty(manifestFiles)) {
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMap();
        for (SimpleManifestFile file : manifestFiles) {
            map.putAll(this.bizPortalSectionManager.createCAPPortalSection(file, directory, contextParam));
        }
        return map;
    }

    public void setBizPortalSpaceDao(BizPortalSpaceDao bizPortalSpaceDao) {
        this.bizPortalSpaceDao = bizPortalSpaceDao;
    }

    public void setBizPortalSpaceAuthDao(BizPortalSpaceAuthDao bizPortalSpaceAuthDao) {
        this.bizPortalSpaceAuthDao = bizPortalSpaceAuthDao;
    }

    public void setBizPortalSpaceConfigDao(BizPortalSpaceConfigDao bizPortalSpaceConfigDao) {
        this.bizPortalSpaceConfigDao = bizPortalSpaceConfigDao;
    }

    public void setBizPortalGoodSnapshotManager(BizPortalGoodSnapshotManager bizPortalGoodSnapshotManager) {
        this.bizPortalGoodSnapshotManager = bizPortalGoodSnapshotManager;
    }

    public void setBizPortalThemeManager(BizPortalThemeManager bizPortalThemeManager) {
        this.bizPortalThemeManager = bizPortalThemeManager;
    }

    public void setBizPortalSectionManager(BizPortalSectionManager bizPortalSectionManager) {
        this.bizPortalSectionManager = bizPortalSectionManager;
    }

    public void setBizPortalDataRelationManager(BizPortalDataRelationManager bizPortalDataRelationManager) {
        this.bizPortalDataRelationManager = bizPortalDataRelationManager;
    }

    public void setDataSourceContextManager(DataSourceContextManager dataSourceContextManager) {
        this.dataSourceContextManager = dataSourceContextManager;
    }

    public void setM3Api(M3Api m3Api) {
        this.m3Api = m3Api;
    }

    public void setOrganizationAdapterManager(OrganizationAdapterManager organizationAdapterManager) {
        this.organizationAdapterManager = organizationAdapterManager;
    }
}

