/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.manager;

import com.google.common.collect.Lists;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.bean.BizPortalThemeConfigJson;
import com.seeyon.cap4.bizportal.bean.DownloadGoodInfo;
import com.seeyon.cap4.bizportal.bean.SimpleManifestFile;
import com.seeyon.cap4.bizportal.dao.BizPortalThemeDao;
import com.seeyon.cap4.bizportal.exception.NotAcceptablePlatformException;
import com.seeyon.cap4.bizportal.manager.BizPortalGoodSnapshotManager;
import com.seeyon.cap4.bizportal.manager.BizPortalGoodsDownloadCallback;
import com.seeyon.cap4.bizportal.manager.BizPortalThemeManager;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.po.CAPPortalGoodSnapshot;
import com.seeyon.cap4.bizportal.po.CAPPortalTheme;
import com.seeyon.cap4.bizportal.utils.BizPortalUtils;
import com.seeyon.ctp.common.exceptions.BusinessException;
import java.io.File;
import java.util.Date;
import org.apache.commons.lang3.tuple.Pair;

public class BizPortalThemeManagerImpl
implements BizPortalThemeManager,
BizPortalGoodsDownloadCallback {
    private BizPortalGoodSnapshotManager bizPortalGoodSnapshotManager;
    private BizPortalThemeDao bizPortalThemeDao;

    @Override
    public String goodsClass() {
        return BizPortalConstants.GoodsClassKey.PORTAL_SPACE_THEME.getKey();
    }

    @Override
    public Long doExecute(ContextParam contextParam, CAPPortalGoodSnapshot goodSnapshot, DownloadGoodInfo downloadGoodInfo) throws BusinessException {
        BizPortalThemeConfigJson configJson = this.bizPortalGoodSnapshotManager.getBizPortalConfigJson(goodSnapshot, BizPortalThemeConfigJson.class);
        BizPortalConstants.Platform platform = BizPortalUtils.getEnumByCode(BizPortalConstants.Platform.class, configJson.getPlatform());
        if (platform == null || !platform.contains(contextParam.getPlatform())) {
            throw new NotAcceptablePlatformException("\u4e3b\u9898\u7684\u9002\u914d\u7ec8\u7aef\u4e0d\u5339\u914d\uff01");
        }
        return this.createBizPortalTheme(goodSnapshot, contextParam).getId();
    }

    @Override
    public CAPPortalTheme getCAPPortalTheme(Long themeId) throws BusinessException {
        return this.bizPortalThemeDao.getCAPPortalTheme(themeId);
    }

    @Override
    public SimpleManifestFile createSimpleManifestFile(Long themeId, File directory) throws BusinessException {
        SimpleManifestFile manifestFile = new SimpleManifestFile();
        CAPPortalTheme bizPortalTheme = this.getCAPPortalTheme(themeId);
        CAPPortalGoodSnapshot goodsSnap = this.bizPortalGoodSnapshotManager.getCAPPortalGoodSnapshot(bizPortalTheme.getSourceId());
        manifestFile.setId(goodsSnap.getId());
        manifestFile.setUuid(bizPortalTheme.getUuidInfo());
        manifestFile.setSourceType(goodsSnap.getSourceType());
        manifestFile.setRelateIds(Lists.newArrayList((Object[])new Long[]{themeId}));
        manifestFile.setGoodsKey(goodsSnap.getGoodsKey());
        manifestFile.setSubGoodsKey(goodsSnap.getSubGoodsKey());
        manifestFile.setGoodsId(goodsSnap.getGoodsId());
        manifestFile.setGoodsName(goodsSnap.getGoodsName());
        manifestFile.setGoodUpdateTime(goodsSnap.getGoodUpdateTime());
        manifestFile.setInfoUrl(goodsSnap.getInfoUrl());
        Pair<String, File> paths = this.createPathIfNotExists(directory, goodsSnap.getId());
        manifestFile.setFile((String)paths.getLeft());
        this.bizPortalGoodSnapshotManager.copyGoodsSnapshotPackage(goodsSnap.getId(), (File)paths.getRight());
        return manifestFile;
    }

    @Override
    public CAPPortalTheme createCAPPortalTheme(SimpleManifestFile manifestFile, File parentDir, ContextParam contextParam) throws BusinessException {
        CAPPortalGoodSnapshot goodSnapshot = this.bizPortalGoodSnapshotManager.createGoodSnapshotIfNotExist(manifestFile, parentDir, contextParam);
        return this.createBizPortalTheme(goodSnapshot, contextParam);
    }

    private CAPPortalTheme createBizPortalTheme(CAPPortalGoodSnapshot goodSnapshot, ContextParam contextParam) throws BusinessException {
        CAPPortalTheme portalTheme = this.bizPortalThemeDao.getCAPPortalThemeBySourceId(goodSnapshot.getId());
        if (portalTheme == null) {
            BizPortalThemeConfigJson configJson = this.bizPortalGoodSnapshotManager.getBizPortalConfigJson(goodSnapshot, BizPortalThemeConfigJson.class);
            portalTheme = new CAPPortalTheme();
            portalTheme.setIdIfNew();
            portalTheme.setSourceId(goodSnapshot.getId());
            portalTheme.setName(configJson.getName());
            portalTheme.setUuidInfo(configJson.getUUID());
            portalTheme.setCreateMember(contextParam.getUserId());
            portalTheme.setCreateTime(new Date());
            portalTheme.setDeleteFlag(false);
            this.bizPortalThemeDao.saveCAPPortalTheme(portalTheme);
        }
        return portalTheme;
    }

    private Pair<String, File> createPathIfNotExists(File directory, Long sourceId) {
        String path = "/theme/" + sourceId + ".zip";
        File file = new File(directory, path);
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdir();
        }
        return Pair.of((Object)path, (Object)file);
    }

    public void setBizPortalGoodSnapshotManager(BizPortalGoodSnapshotManager bizPortalGoodSnapshotManager) {
        this.bizPortalGoodSnapshotManager = bizPortalGoodSnapshotManager;
    }

    public void setBizPortalThemeDao(BizPortalThemeDao bizPortalThemeDao) {
        this.bizPortalThemeDao = bizPortalThemeDao;
    }
}

