/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.manager;

import com.google.common.base.Function;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.bean.BizPortalBusinessDataConfigJson;
import com.seeyon.cap4.bizportal.bean.SimpleBizPortalSpace;
import com.seeyon.cap4.bizportal.bean.SimpleDataRelation;
import com.seeyon.cap4.bizportal.bean.SimpleElementConfig;
import com.seeyon.cap4.bizportal.bean.SimpleManifestFile;
import com.seeyon.cap4.bizportal.bean.SimpleSpaceLayout;
import com.seeyon.cap4.bizportal.bean.SimpleSpaceManifest;
import com.seeyon.cap4.bizportal.manager.BizPortalDataRelationManager;
import com.seeyon.cap4.bizportal.manager.BizPortalGoodSnapshotManagerImpl;
import com.seeyon.cap4.bizportal.manager.BizPortalSectionManager;
import com.seeyon.cap4.bizportal.manager.BizPortalSpaceManager;
import com.seeyon.cap4.bizportal.manager.BizPortalThemeManager;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.po.CAPPortalDataRelation;
import com.seeyon.cap4.bizportal.po.CAPPortalElementConfig;
import com.seeyon.cap4.bizportal.po.CAPPortalSection;
import com.seeyon.cap4.bizportal.po.CAPPortalSpace;
import com.seeyon.cap4.bizportal.po.CAPPortalSpaceConfig;
import com.seeyon.cap4.bizportal.po.CAPPortalTheme;
import com.seeyon.cap4.bizportal.utils.BizPortalUtils;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.importandexport.AbstractBusinessModuleExportManager;
import com.seeyon.cap4.form.modules.importandexport.AppUpgradeCacheBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessEnums;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectResultBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectResultBean4Authorization;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.organization.dao.OrgHelper;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class BusinessModuleExportManager4BizPortal
extends AbstractBusinessModuleExportManager {
    private static final String BIZPORTAL = "cap4portal";
    private BizPortalSpaceManager bizPortalSpaceManager;
    private BizPortalSectionManager bizPortalSectionManager;
    private BizPortalDataRelationManager bizPortalDataRelationManager;
    private BizPortalThemeManager bizPortalThemeManager;
    private OrgManager orgManager;

    public Integer getSort() {
        return Integer.MAX_VALUE;
    }

    public void exportData(BusinessDataBean businessDataBean, Map<String, Object> rootMap) throws BusinessException {
        BizConfigBean bizConfigBean = businessDataBean.getBizConfigBean();
        List<CAPPortalSpace> spaceList = this.bizPortalSpaceManager.findCAPPortalSpaceByBizId(bizConfigBean.getId());
        if (CollectionUtils.isEmpty(spaceList)) {
            return;
        }
        BizPortalBusinessDataConfigJson businessDataConfigJson = new BizPortalBusinessDataConfigJson();
        ArrayList list = Lists.newArrayListWithCapacity((int)spaceList.size());
        for (CAPPortalSpace portalSpace : spaceList) {
            SimpleBizPortalSpace simpleBizPortalSpace = new SimpleBizPortalSpace();
            simpleBizPortalSpace.setId(businessDataBean.getRealId4Export(portalSpace.getId()));
            simpleBizPortalSpace.setName(portalSpace.getName());
            simpleBizPortalSpace.setPlatform(portalSpace.getPlatform());
            simpleBizPortalSpace.setState(portalSpace.getState());
            simpleBizPortalSpace.setSourceType(portalSpace.getSourceType());
            simpleBizPortalSpace.setSourceId(portalSpace.getSourceId());
            simpleBizPortalSpace.setFrameType(portalSpace.getFrameType());
            simpleBizPortalSpace.setSort(portalSpace.getSort());
            simpleBizPortalSpace.setAuthInfo(portalSpace.getAuthInfo());
            simpleBizPortalSpace.setAuthInfoName(OrgHelper.showOrgEntities((String)portalSpace.getAuthInfo(), (String)","));
            CAPPortalSpaceConfig spaceConfig = this.bizPortalSpaceManager.getBizPortalSpaceConfig(portalSpace.getId(), BizPortalConstants.ConfigStatus.RUNNING);
            SimpleSpaceLayout simpleSpaceLayout = new SimpleSpaceLayout();
            simpleSpaceLayout.setThemeId(spaceConfig.getThemeId());
            simpleSpaceLayout.setLayoutId(spaceConfig.getLayoutId());
            simpleSpaceLayout.setLeft(spaceConfig.getLeftLayout());
            simpleSpaceLayout.setRight(spaceConfig.getRightLayout());
            simpleSpaceLayout.setTop(spaceConfig.getTopLayout());
            simpleSpaceLayout.setBottom(spaceConfig.getBottomLayout());
            simpleSpaceLayout.setLayout(spaceConfig.getLayout());
            simpleBizPortalSpace.setConfig(simpleSpaceLayout);
            this.createSpaceSimpleManifestFile(businessDataBean, businessDataConfigJson.getManifest(), portalSpace, simpleBizPortalSpace.getId());
            this.createThemeSimpleManifestFile(businessDataBean, businessDataConfigJson.getManifest(), spaceConfig.getThemeId());
            this.createSectionSimpleManifestFile(businessDataBean, businessDataConfigJson.getManifest(), spaceConfig);
            List<CAPPortalElementConfig> elementConfigList = this.bizPortalSectionManager.findCAPPortalElementConfig(spaceConfig.getId());
            ArrayList simpleElementConfigs = Lists.newArrayListWithCapacity((int)elementConfigList.size());
            for (CAPPortalElementConfig elementConfig : elementConfigList) {
                SimpleElementConfig simpleElementConfig = new SimpleElementConfig();
                simpleElementConfig.setSectionId(elementConfig.getSectionId());
                simpleElementConfig.setElementId(elementConfig.getElementId());
                simpleElementConfig.setDataId(elementConfig.getDataId());
                simpleElementConfig.setMetadataInfo(elementConfig.getMetadataInfo());
                simpleElementConfigs.add(simpleElementConfig);
            }
            simpleBizPortalSpace.setElementConfigs(simpleElementConfigs);
            list.add(simpleBizPortalSpace);
        }
        businessDataConfigJson.setSpaces(list);
        List<CAPPortalDataRelation> dataRelationList = this.bizPortalDataRelationManager.findCAPPortalDataRelationByBizId(bizConfigBean.getId());
        ArrayList dataRelations = Lists.newArrayListWithCapacity((int)dataRelationList.size());
        for (CAPPortalDataRelation dataRelation : dataRelationList) {
            SimpleDataRelation simpleDataRelation = new SimpleDataRelation();
            simpleDataRelation.setDataId(dataRelation.getDataId());
            simpleDataRelation.setSourceId(businessDataBean.getRealId4Export(dataRelation.getSourceId()));
            simpleDataRelation.setTargetId(dataRelation.getTargetId());
            dataRelations.add(simpleDataRelation);
        }
        businessDataConfigJson.setDataRelations(dataRelations);
        BizPortalUtils.write(new File(this.getBizPortalDir(businessDataBean), "config.json"), JSONUtil.toJSONString((Object)businessDataConfigJson));
        rootMap.put(BIZPORTAL, businessDataConfigJson);
    }

    public void importData(BusinessDataBean businessDataBean, Map<String, Object> dataMap) throws BusinessException {
        BizPortalBusinessDataConfigJson businessDataConfigJson = this.getBizPortalBusinessDataConfigJson(dataMap);
        if (businessDataConfigJson == null) {
            return;
        }
        List<SimpleBizPortalSpace> spaces = businessDataConfigJson.getSpaces();
        Map<Long, CAPPortalSpace> existPortalSpace = this.getExistPortalSpace(spaces);
        for (SimpleBizPortalSpace simpleBizPortalSpace : spaces) {
            Long spaceId = simpleBizPortalSpace.getId();
            if (businessDataBean.isUpgrade()) {
                spaceId = businessDataBean.getRealId4Upgrade(spaceId);
            }
            if (businessDataBean.isResetId()) {
                simpleBizPortalSpace.setNewId(businessDataBean.genNewIdByOldId(spaceId));
                continue;
            }
            boolean conflict = !businessDataBean.isUpgrade() && existPortalSpace.containsKey(spaceId);
            simpleBizPortalSpace.setNewId(businessDataBean.genNewIdByOldId(spaceId, conflict, false));
        }
        List<SimpleDataRelation> dataRelations = businessDataConfigJson.getDataRelations();
        for (SimpleDataRelation relation : dataRelations) {
            Long sourceId = relation.getSourceId();
            if (businessDataBean.isUpgrade()) {
                sourceId = businessDataBean.getRealId4Upgrade(sourceId);
            }
            Long newSourceId = businessDataBean.genNewIdByOldId(sourceId);
            relation.setSourceId(newSourceId);
        }
        File file = BizPortalGoodSnapshotManagerImpl.getCAPBizPortalBaseFile();
        File tempDir = BizPortalUtils.createDirIfAbsent(file, String.valueOf(UUIDLong.longUUID()));
        BizPortalUtils.copyDirectory(new File(businessDataBean.getFilePath(), BIZPORTAL), tempDir);
        businessDataConfigJson.setFilePath(tempDir);
        businessDataConfigJson.setResetId(businessDataBean.isResetId());
        this.putBizPortalBusinessDataConfigJson(businessDataBean.getBizConfigBean().getId(), businessDataConfigJson);
    }

    private void putBizPortalBusinessDataConfigJson(Long bizId, BizPortalBusinessDataConfigJson businessDataConfigJson) {
        AppContext.putSessionContext((String)(bizId + "_" + BIZPORTAL), (Object)businessDataConfigJson);
    }

    private void removeBizPortalBusinessDataConfigJson(Long bizId) {
        AppContext.removeSessionArrribute((String)(bizId + "_" + BIZPORTAL));
    }

    private BizPortalBusinessDataConfigJson getBizPortalBusinessDataConfigJson(Long bizId) {
        return (BizPortalBusinessDataConfigJson)AppContext.getSessionContext((String)(bizId + "_" + BIZPORTAL));
    }

    public void redirectBusiness(BusinessRedirectDataBean businessRedirectDataBean, BusinessDataBean businessDataBean) throws BusinessException {
        BizPortalBusinessDataConfigJson businessDataConfigJson = this.getBizPortalBusinessDataConfigJson(businessDataBean.getBizConfigBean().getId());
        if (businessDataConfigJson == null) {
            return;
        }
        for (SimpleBizPortalSpace space : businessDataConfigJson.getSpaces()) {
            if (StringUtils.isEmpty((String)space.getAuthInfo())) continue;
            String authInfo = space.getAuthInfo();
            String authInfoName = space.getAuthInfoName();
            String[] authArr = StringUtils.split((String)authInfo, (String)",");
            String[] nameArr = StringUtils.split((String)authInfoName, (String)",");
            int size = Math.min(authArr.length, nameArr.length);
            for (int i = 0; i < size; ++i) {
                String typeAndId = authArr[i];
                String[] ss = typeAndId.split("\\|");
                String orgName = nameArr[i];
                String authType = ss[0];
                Long authId = Long.parseLong(ss[1]);
                if (this.orgManager.getEntity(authType, authId) != null) continue;
                String key = BusinessRedirectDataBean.createKey((String)authType, (String)orgName);
                BusinessRedirectResultBean4Authorization authorization = new BusinessRedirectResultBean4Authorization();
                authorization.setAuthorizationType(BusinessRedirectResultBean4Authorization.AuthorizationType.BIZPORTAL.name());
                authorization.setSourceId(space.getId());
                authorization.setOldValue4Show(orgName);
                authorization.setOldValue4System(ss[1]);
                authorization.setOrgType(authType);
                businessRedirectDataBean.addResultBean(key, (BusinessRedirectResultBean)authorization);
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.put(BusinessEnums.AuthorizationDetailKey.LOCATION.getKey(), ResourceUtil.getString((String)"form.import.export.auth.details"));
                valueMap.put(BusinessEnums.AuthorizationDetailKey.TYPE.getKey(), ResourceUtil.getString((String)"cap.template.portal.template"));
                valueMap.put(BusinessEnums.AuthorizationDetailKey.AUTH_ITEM.getKey(), space.getName());
                businessRedirectDataBean.addRedirectDetail(key, authorization.getCategory(), valueMap);
            }
        }
    }

    public void mergeRedirectData(Map<String, List<Map<String, Object>>> redirectData, BizConfigBean bizConfigBean, AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        List<Map<String, Object>> authRedirects = redirectData.get(BusinessEnums.RedirectCategory.AUTHORIZATION.getKey());
        if (CollectionUtils.isEmpty(authRedirects)) {
            return;
        }
        BizPortalBusinessDataConfigJson businessDataConfigJson = this.getBizPortalBusinessDataConfigJson(bizConfigBean.getId());
        if (businessDataConfigJson == null) {
            return;
        }
        HashBasedTable table = HashBasedTable.create();
        for (Map<String, Object> map : authRedirects) {
            String authorizationType = MapUtils.getString(map, (Object)"authorizationType");
            if (!BusinessRedirectResultBean4Authorization.AuthorizationType.BIZPORTAL.name().equals(authorizationType)) continue;
            Long spaceId = MapUtils.getLong(map, (Object)"sourceId");
            String newValue4System = MapUtils.getString(map, (Object)"newValue4System");
            String oldValue4System = MapUtils.getString(map, (Object)"oldValue4System");
            String orgType = MapUtils.getString(map, (Object)"orgType");
            table.put((Object)spaceId, (Object)this.getOrgString(orgType, oldValue4System), (Object)this.getOrgString(orgType, newValue4System));
        }
        for (SimpleBizPortalSpace simpleBizPortalSpace : businessDataConfigJson.getSpaces()) {
            String authInfo = simpleBizPortalSpace.getAuthInfo();
            if (StringUtils.isEmpty((String)authInfo)) continue;
            Object[] authArr = StringUtils.split((String)authInfo, (String)",");
            int len = authArr.length;
            for (int i = 0; i < len; ++i) {
                String newAuth = (String)table.get((Object)simpleBizPortalSpace.getId(), authArr[i]);
                if (newAuth == null) continue;
                authArr[i] = newAuth;
            }
            simpleBizPortalSpace.setAuthInfo(StringUtils.join((Object[])authArr, (String)","));
        }
        this.putBizPortalBusinessDataConfigJson(bizConfigBean.getId(), businessDataConfigJson);
    }

    private String getOrgString(String orgType, String orgId) {
        return orgType + "|" + orgId;
    }

    public void finalSaveRedirectData(BizConfigBean bizConfigBean) throws BusinessException {
        BizPortalBusinessDataConfigJson businessDataConfigJson = this.getBizPortalBusinessDataConfigJson(bizConfigBean.getId());
        if (businessDataConfigJson == null) {
            return;
        }
        this.bizPortalSpaceManager.createBizPortalSpace(businessDataConfigJson, ContextParam.of(AppContext.getCurrentUser(), bizConfigBean.getId()));
        BizPortalUtils.deleteDirectory(businessDataConfigJson.getFilePath());
        this.removeBizPortalBusinessDataConfigJson(bizConfigBean.getId());
    }

    public void completeUpgrade(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        BizConfigBean bizConfigBean = appUpgradeCacheBean.getBizConfigBean();
        BizPortalBusinessDataConfigJson businessDataConfigJson = this.getBizPortalBusinessDataConfigJson(bizConfigBean.getId());
        if (businessDataConfigJson == null) {
            return;
        }
        this.bizPortalSpaceManager.updateBizPortalSpace(businessDataConfigJson, ContextParam.of(AppContext.getCurrentUser(), bizConfigBean.getId()));
        BizPortalUtils.deleteDirectory(businessDataConfigJson.getFilePath());
        this.removeBizPortalBusinessDataConfigJson(bizConfigBean.getId());
    }

    private Map<Long, CAPPortalSpace> getExistPortalSpace(List<SimpleBizPortalSpace> spaces) throws BusinessException {
        List oldSpaceIds = Lists.transform(spaces, (Function)new Function<SimpleBizPortalSpace, Long>(){

            public Long apply(SimpleBizPortalSpace input) {
                return input.getId();
            }
        });
        List<CAPPortalSpace> existSpaces = this.bizPortalSpaceManager.findCAPPortalSpace(oldSpaceIds);
        if (CollectionUtils.isEmpty(existSpaces)) {
            return Collections.emptyMap();
        }
        return Maps.uniqueIndex(existSpaces, (Function)new Function<CAPPortalSpace, Long>(){

            public Long apply(CAPPortalSpace input) {
                return input.getId();
            }
        });
    }

    private BizPortalBusinessDataConfigJson getBizPortalBusinessDataConfigJson(Map<String, Object> dataMap) {
        Object o = dataMap.get(BIZPORTAL);
        if (o == null) {
            return null;
        }
        if (o instanceof BizPortalBusinessDataConfigJson) {
            return (BizPortalBusinessDataConfigJson)o;
        }
        return BizPortalUtils.create((Map)o, BizPortalBusinessDataConfigJson.class);
    }

    private void createSpaceSimpleManifestFile(BusinessDataBean businessDataBean, SimpleSpaceManifest manifest, CAPPortalSpace portalSpace, Long realId) throws BusinessException {
        List<SimpleManifestFile> space = manifest.getSpace();
        for (SimpleManifestFile file : space) {
            if (!ObjectUtils.equals((Object)file.getId(), (Object)portalSpace.getSourceId())) continue;
            file.getRelateIds().add(realId);
            return;
        }
        SimpleManifestFile simpleManifestFile = this.bizPortalSpaceManager.createSimpleManifestFile(portalSpace);
        simpleManifestFile.getRelateIds().add(realId);
        space.add(simpleManifestFile);
    }

    private void createThemeSimpleManifestFile(BusinessDataBean businessDataBean, SimpleSpaceManifest manifest, Long themeId) throws BusinessException {
        CAPPortalTheme theme = this.bizPortalThemeManager.getCAPPortalTheme(themeId);
        for (SimpleManifestFile file : manifest.getTheme()) {
            if (!ObjectUtils.equals((Object)file.getId(), (Object)theme.getSourceId())) continue;
            file.getRelateIds().add(themeId);
            return;
        }
        manifest.getTheme().add(this.bizPortalThemeManager.createSimpleManifestFile(themeId, this.getBizPortalDir(businessDataBean)));
    }

    private void createSectionSimpleManifestFile(BusinessDataBean businessDataBean, SimpleSpaceManifest manifest, CAPPortalSpaceConfig capPortalSpaceConfig) throws BusinessException {
        List<CAPPortalSection> sections = this.bizPortalSectionManager.findCAPPortalSection(capPortalSpaceConfig);
        for (CAPPortalSection section : sections) {
            SimpleManifestFile manifestFile = null;
            for (SimpleManifestFile file : manifest.getColumn()) {
                if (!ObjectUtils.equals((Object)file.getId(), (Object)section.getSourceId())) continue;
                manifestFile = file;
                break;
            }
            if (manifestFile == null) {
                manifest.getColumn().add(this.bizPortalSectionManager.createBizPortalManifestFile(section.getId(), this.getBizPortalDir(businessDataBean)));
                continue;
            }
            manifestFile.getRelateIds().add(section.getId());
        }
    }

    private File getBizPortalDir(BusinessDataBean businessDataBean) {
        return BizPortalUtils.createDirIfAbsent(businessDataBean.getZipFolder(), BIZPORTAL);
    }

    public void setBizPortalSpaceManager(BizPortalSpaceManager bizPortalSpaceManager) {
        this.bizPortalSpaceManager = bizPortalSpaceManager;
    }

    public void setBizPortalSectionManager(BizPortalSectionManager bizPortalSectionManager) {
        this.bizPortalSectionManager = bizPortalSectionManager;
    }

    public void setBizPortalDataRelationManager(BizPortalDataRelationManager bizPortalDataRelationManager) {
        this.bizPortalDataRelationManager = bizPortalDataRelationManager;
    }

    public void setBizPortalThemeManager(BizPortalThemeManager bizPortalThemeManager) {
        this.bizPortalThemeManager = bizPortalThemeManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }
}

