/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.apps.cloudapp.api.MallApi;
import com.seeyon.apps.cloudapp.constant.MallEnum;
import com.seeyon.apps.cloudapp.po.CloudAppDatas;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.bean.DownloadGoodInfo;
import com.seeyon.cap4.bizportal.bean.GoodInfo;
import com.seeyon.cap4.bizportal.bean.GoodList;
import com.seeyon.cap4.bizportal.bean.OrderKey;
import com.seeyon.cap4.bizportal.exception.NetworkErrorException;
import com.seeyon.cap4.bizportal.manager.CloudAdapterAppManager;
import com.seeyon.cap4.bizportal.param.BizPortalGoodsListParam;
import com.seeyon.cap4.bizportal.utils.BizPortalUtils;
import com.seeyon.cap4.template.manager.CAPHttpRequestManager;
import com.seeyon.cap4.template.util.CAPBusinessUtil;
import com.seeyon.cap4.template.util.mall.Authcode;
import com.seeyon.cap4.template.util.mall.MallUtil;
import com.seeyon.cap4.validity.ValidityUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CloudAdapterAppManagerImpl
implements CloudAdapterAppManager {
    private MallApi mallApi;
    private OrgManager orgManager;
    private CAPHttpRequestManager capHttpRequestManager;

    @Override
    public GoodList findGoodInfoList(BizPortalGoodsListParam listParam) throws NetworkErrorException, BusinessException {
        Map<String, Object> queryParam = this.createQueryParam(MallEnum.MallAction.LIST);
        HashMap params = Maps.newHashMap();
        params.put("catAlias", listParam.getGoodsClass());
        params.put("page", listParam.getPage());
        params.put("pageSize", listParam.getPageSize());
        params.put("platform", listParam.getListType());
        params.put("corpId", ValidityUtil.getMplusCorpId());
        params.put("order", listParam.getOrderKey());
        params.put("by", listParam.getOrder().toLowerCase());
        if (StringUtils.isNotEmpty((CharSequence)listParam.getIncludeSubClass())) {
            params.put("includeSubClass", listParam.getIncludeSubClass());
        }
        if (StringUtils.isNotEmpty((CharSequence)listParam.getExcludeSubClass())) {
            params.put("excludeSubClass", listParam.getExcludeSubClass());
        }
        if (StringUtils.isNotEmpty((CharSequence)listParam.getGoodsName())) {
            params.put("keyword", listParam.getGoodsName());
        }
        queryParam.put("params", params);
        Map httpResult = this.capHttpRequestManager.postByFormPart(MallUtil.getRestApiUrl(MallEnum.RestApi.MALL_INDEX), queryParam, Map.class);
        if (httpResult == null) {
            throw new NetworkErrorException("\u83b7\u53d6\u5546\u54c1\u5217\u8868\u51fa\u9519!");
        }
        GoodList goodList = new GoodList();
        Map data = (Map)httpResult.get("data");
        if (data != null) {
            goodList.setTotal(MapUtils.getInteger((Map)data, (Object)"count"));
            goodList.setPage(MapUtils.getInteger((Map)data, (Object)"page"));
            goodList.setPageSize(MapUtils.getInteger((Map)data, (Object)"pageSize"));
            goodList.setList(BizPortalUtils.create((List)data.get("list"), GoodInfo.class));
            List order = (List)data.get("order");
            ArrayList orderKeys = Lists.newArrayListWithCapacity((int)order.size());
            for (Map map : order) {
                OrderKey orderKey = BizPortalUtils.create(map, OrderKey.class);
                if (orderKey.getKey().equals(listParam.getOrderKey())) {
                    orderKey.setOrder(listParam.getOrder());
                } else {
                    orderKey.setOrder(BizPortalConstants.Order.NONE.name());
                }
                orderKeys.add(orderKey);
            }
            goodList.setOrderKeys(orderKeys);
        } else {
            goodList.setTotal(0);
            goodList.setPage(1);
            goodList.setPageSize(listParam.getPageSize());
            goodList.setList(Collections.<GoodInfo>emptyList());
            goodList.setOrderKeys(Collections.<OrderKey>emptyList());
        }
        return goodList;
    }

    @Override
    public DownloadGoodInfo getDownLoadGoodInfo(String goodsId, User user) throws NetworkErrorException, BusinessException {
        Map<String, Object> queryParam = this.createQueryParam(MallEnum.MallAction.IS_FREE);
        HashMap params = Maps.newHashMap();
        params.put("memberInfo", this.getMemberInfo(user));
        params.put("goodsId", goodsId);
        params.put("corpId", ValidityUtil.getMplusCorpId());
        queryParam.put("params", params);
        Map httpResult = this.capHttpRequestManager.postByFormPart(MallUtil.getRestApiUrl(MallUtil.RestApi.MALL_INDEX), queryParam, Map.class);
        if (httpResult == null) {
            throw new NetworkErrorException("\u4e0b\u8f7d\u5546\u54c1\u5931\u8d25!");
        }
        return BizPortalUtils.create(httpResult, DownloadGoodInfo.class);
    }

    @Override
    public String getGoodsImg(String goodsId, User user) throws NetworkErrorException, BusinessException {
        Map<String, Object> queryParam = this.createQueryParam(MallEnum.MallAction.INFO);
        HashMap params = Maps.newHashMap();
        params.put("goodsId", goodsId);
        queryParam.put("params", params);
        Map httpResult = this.capHttpRequestManager.postByFormPart(MallUtil.getRestApiUrl(MallEnum.RestApi.MALL_INDEX), queryParam, Map.class);
        if (!MallUtil.isRequestSuccess(httpResult)) {
            throw new NetworkErrorException("\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u5931\u8d25!");
        }
        return MapUtils.getString((Map)((Map)httpResult.get("data")), (Object)"goodsImg");
    }

    private Map<String, Object> createQueryParam(MallEnum.MallAction mallAction) {
        HashMap queryParam = Maps.newHashMap();
        queryParam.put("action", mallAction.getAction());
        queryParam.put("actionDefine", mallAction.name().toLowerCase());
        queryParam.put("time", new Date().getTime() / 1000L);
        CloudAppDatas userData = this.mallApi.getBindMallUserData(Long.valueOf(AppContext.currentUserId()));
        if (userData != null) {
            queryParam.put("access_token", userData.getAccessToken());
        }
        queryParam.put("code", BizPortalUtils.encode(Authcode.encode(JSONUtil.toJSONString((Object)queryParam))));
        queryParam.put("appID", 9);
        return queryParam;
    }

    private String getMemberInfo(User user) throws NetworkErrorException, BusinessException {
        HashMap<String, String> map = new HashMap<String, String>();
        V3xOrgMember v3xOrgMember = this.orgManager.getMemberById(user.getId());
        map.put("memberId", user.getId().toString());
        map.put("memberName", user.getName());
        map.put("departName", this.orgManager.getDepartmentById(v3xOrgMember.getOrgDepartmentId()).getName());
        map.put("departId", v3xOrgMember.getOrgDepartmentId().toString());
        map.put("postName", this.orgManager.getPostById(v3xOrgMember.getOrgPostId()).getName());
        map.put("postID", v3xOrgMember.getOrgPostId().toString());
        map.put("telNum", v3xOrgMember.getTelNumber());
        map.put("orgName", this.orgManager.getUnitById(v3xOrgMember.getOrgAccountId()).getName());
        map.put("orgId", v3xOrgMember.getOrgAccountId().toString());
        map.put("accountName", v3xOrgMember.getLoginName());
        map.put("dogNo", CAPBusinessUtil.getDogNo());
        return Authcode.encode(BizPortalUtils.encode(JSONUtil.toJSONString(map)));
    }

    public void setMallApi(MallApi mallApi) {
        this.mallApi = mallApi;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setCapHttpRequestManager(CAPHttpRequestManager capHttpRequestManager) {
        this.capHttpRequestManager = capHttpRequestManager;
    }
}

