/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.manager;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.datasource.AbstractDataSourceProvider;
import com.seeyon.cap4.bizportal.datasource.ImportAndExportable;
import com.seeyon.cap4.bizportal.datasource.bean.Command;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.manager.DataSourceContextManager;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.vo.ServiceResult;
import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class DataSourceContextManagerImpl
extends AbstractSystemInitializer
implements DataSourceContextManager {
    private static final Log logger = CtpLogFactory.getLog(DataSourceContextManagerImpl.class);
    private Map<BizPortalConstants.DataFormat, List<AbstractDataSourceProvider>> mProviders;
    private Map<String, AbstractDataSourceProvider> uProviders;

    public void initialize() {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        HashMap uMap = Maps.newHashMap();
        Map beans = AppContext.getBeansOfType(AbstractDataSourceProvider.class);
        for (AbstractDataSourceProvider provider : beans.values()) {
            multimap.put((Object)provider.dataFormat(), (Object)provider);
            uMap.put(provider.uuid(), provider);
        }
        this.uProviders = Collections.unmodifiableMap(uMap);
        HashMap map = Maps.newHashMapWithExpectedSize((int)multimap.keySet().size());
        for (BizPortalConstants.DataFormat dataFormat : multimap.keySet()) {
            ArrayList providers = Lists.newArrayList((Iterable)multimap.get((Object)dataFormat));
            Collections.sort(providers, new Comparator<AbstractDataSourceProvider>(){

                @Override
                public int compare(AbstractDataSourceProvider o1, AbstractDataSourceProvider o2) {
                    return o1.getSortOrder() - o2.getSortOrder();
                }
            });
            map.put(dataFormat, providers);
        }
        this.mProviders = Collections.unmodifiableMap(map);
    }

    @Override
    public List<AbstractDataSourceProvider> availableProviders(BizPortalConstants.DataFormat dataFormat, String[] versions) throws BusinessException {
        List<AbstractDataSourceProvider> providers = this.mProviders.get(dataFormat);
        if (CollectionUtils.isEmpty(providers)) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)providers.size());
        for (AbstractDataSourceProvider provider : providers) {
            if (!this.validVersion(provider.versions(), versions)) continue;
            list.add(provider);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public ServiceResult getDataSetResult(ContextParam contextParam, DataSetMetadata metadata, String[] versions, Command command) throws BusinessException {
        AbstractDataSourceProvider provider = this.getDataSourceProvider(metadata.getUuid());
        if (!provider.isAllow(contextParam, metadata, command)) {
            return ServiceResult.notAuthorized();
        }
        try {
            return ServiceResult.success(provider.executeQuery(contextParam, metadata, versions, command));
        }
        catch (BusinessException e) {
            logger.error((Object)"\u83b7\u53d6\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            return ServiceResult.internalError(e.getMessage());
        }
    }

    @Override
    public DataSetMetadata saveBizPortalDataRelation(String dataId, DataSetMetadata metadata) throws BusinessException {
        AbstractDataSourceProvider provider = this.getDataSourceProvider(metadata.getUuid());
        if (provider instanceof ImportAndExportable) {
            metadata = ((ImportAndExportable)((Object)provider)).beforeDataSetMetaBind(dataId, metadata);
        }
        return metadata;
    }

    @Override
    public String getNewDataId(String dataId, DataSetMetadata metadata) throws BusinessException {
        AbstractDataSourceProvider provider = this.getDataSourceProvider(metadata.getUuid());
        if (provider instanceof ImportAndExportable) {
            return ((ImportAndExportable)((Object)provider)).getNewDataId(dataId, metadata);
        }
        return null;
    }

    @Override
    public AbstractDataSourceProvider getDataSourceProvider(String uuid) throws BusinessException {
        return this.uProviders.get(uuid);
    }

    private boolean validVersion(String[] source, String[] target) {
        for (String v : source) {
            for (String vv : target) {
                if (!v.equals(vv)) continue;
                return true;
            }
        }
        return false;
    }
}

