/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.manager;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.cap4.bizportal.function.Predicate;
import com.seeyon.cap4.bizportal.manager.OrganizationAdapterManager;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.organization.bo.CompareSortEntity;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgDepartment;
import com.seeyon.ctp.organization.bo.V3xOrgUnit;
import com.seeyon.ctp.organization.dao.OrgCache;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.organization.manager.OuterWorkerAuthUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class OrganizationAdapterManagerImpl
implements OrganizationAdapterManager {
    private OrgManager orgManager;
    private OrgCache orgCache;

    @Override
    public List<V3xOrgAccount> findAccessableAccount(User user) throws BusinessException {
        V3xOrgAccount rootAccount = this.orgManager.getRootAccount();
        List accounts = this.orgManager.accessableAccounts(user.getId());
        if (user.isAdmin()) {
            accounts.add(rootAccount);
        }
        ImmutableMap accoutIds = Maps.uniqueIndex((Iterable)accounts, (Function)new Function<V3xOrgAccount, Long>(){

            public Long apply(V3xOrgAccount input) {
                return input.getId();
            }
        });
        boolean isAccountInGroup = this.orgManager.isAccountInGroupTree(user.getLoginAccount());
        boolean isAccessRoot = accoutIds.containsKey(rootAccount.getId());
        Long rootId = isAccountInGroup && isAccessRoot ? rootAccount.getId() : UNAUTHORIZED_ROOT_ID;
        ArrayList list = Lists.newArrayListWithCapacity((int)accounts.size());
        for (V3xOrgAccount v3xOrgAccount : accounts) {
            if (user.isAdmin()) continue;
            V3xOrgAccount account = new V3xOrgAccount(v3xOrgAccount);
            if (account.getSuperior0() != -1L && !accoutIds.containsKey(account.getSuperior0())) {
                account.setSuperior(rootId);
            }
            list.add(account);
        }
        return list;
    }

    @Override
    public List<V3xOrgDepartment> findAccessableDepartment(User user, Long accountId) throws BusinessException {
        List departments = user.isV5External() ? OuterWorkerAuthUtil.getCanAccessDep((Long)user.getId(), (Long)user.getDepartmentId(), (Long)user.getAccountId(), (OrgManager)this.orgManager, (boolean)true) : this.orgCache.getAllV3xOrgEntityNoClone(V3xOrgDepartment.class, accountId);
        Collections.sort(departments, CompareSortEntity.getInstance());
        return departments;
    }

    @Override
    public List<V3xOrgDepartment> findAccessableDepartment(User user, Long accountId, Predicate predicate) throws BusinessException {
        List<V3xOrgDepartment> departments = this.findAccessableDepartment(user, accountId);
        HashMap map = Maps.newHashMap();
        ArrayList candidates = Lists.newArrayList();
        for (V3xOrgDepartment department : departments) {
            if (predicate.apply(department)) {
                candidates.add(department);
                continue;
            }
            map.put(department.getId(), department);
        }
        if (MapUtils.isEmpty((Map)map)) {
            return departments;
        }
        ArrayList list = Lists.newArrayList((Iterable)candidates);
        for (V3xOrgDepartment department : candidates) {
            Long superior = department.getSuperior();
            V3xOrgDepartment parent = (V3xOrgDepartment)map.get(superior);
            while (parent != null) {
                list.add(parent);
                parent = (V3xOrgDepartment)map.get(superior);
            }
        }
        Collections.sort(list, CompareSortEntity.getInstance());
        return list;
    }

    @Override
    public V3xOrgUnit getV3xOrgUnit(Long accountId) throws BusinessException {
        return this.orgManager.getAccountById(accountId);
    }

    @Override
    public List<Long> getAllUserDomainIDs(User user) throws BusinessException {
        return this.orgManager.getAllUserDomainIDs(user.getId());
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setOrgCache(OrgCache orgCache) {
        this.orgCache = orgCache;
    }
}

