/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.service;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.bean.BizPortalSectionConfigJson;
import com.seeyon.cap4.bizportal.bean.BizPortalSectionElement;
import com.seeyon.cap4.bizportal.bean.DownloadGoodInfo;
import com.seeyon.cap4.bizportal.datasource.AbstractDataSourceProvider;
import com.seeyon.cap4.bizportal.datasource.MultiStepable;
import com.seeyon.cap4.bizportal.datasource.bean.Command;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetList;
import com.seeyon.cap4.bizportal.datasource.bean.DataSetMetadata;
import com.seeyon.cap4.bizportal.datasource.bean.DefaultDataSetList;
import com.seeyon.cap4.bizportal.exception.DuplicateKeyException;
import com.seeyon.cap4.bizportal.exception.NetworkErrorException;
import com.seeyon.cap4.bizportal.exception.NotAuthorizedException;
import com.seeyon.cap4.bizportal.manager.BizPortalExternAdapterManager;
import com.seeyon.cap4.bizportal.manager.BizPortalFileManager;
import com.seeyon.cap4.bizportal.manager.BizPortalGoodSnapshotManager;
import com.seeyon.cap4.bizportal.manager.BizPortalLayoutManager;
import com.seeyon.cap4.bizportal.manager.BizPortalSectionManager;
import com.seeyon.cap4.bizportal.manager.BizPortalSpaceManager;
import com.seeyon.cap4.bizportal.manager.BizPortalThemeManager;
import com.seeyon.cap4.bizportal.manager.CloudAdapterAppManager;
import com.seeyon.cap4.bizportal.manager.DataSourceContextManager;
import com.seeyon.cap4.bizportal.param.BizPortalCollectLayoutParam;
import com.seeyon.cap4.bizportal.param.BizPortalFileListParam;
import com.seeyon.cap4.bizportal.param.BizPortalGoodsListParam;
import com.seeyon.cap4.bizportal.param.BizPortalSpaceBatchAuthParam;
import com.seeyon.cap4.bizportal.param.BizPortalSpaceConfigParam;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.param.ElementDataSetBinding;
import com.seeyon.cap4.bizportal.po.CAPPortalElementConfig;
import com.seeyon.cap4.bizportal.po.CAPPortalFile;
import com.seeyon.cap4.bizportal.po.CAPPortalGoodSnapshot;
import com.seeyon.cap4.bizportal.po.CAPPortalLayout;
import com.seeyon.cap4.bizportal.po.CAPPortalSection;
import com.seeyon.cap4.bizportal.po.CAPPortalSpace;
import com.seeyon.cap4.bizportal.po.CAPPortalSpaceConfig;
import com.seeyon.cap4.bizportal.po.CAPPortalTheme;
import com.seeyon.cap4.bizportal.utils.BizPortalUtils;
import com.seeyon.cap4.bizportal.vo.BizPortalSectionResult;
import com.seeyon.cap4.bizportal.vo.BizPortalSpaceConfigVO;
import com.seeyon.cap4.bizportal.vo.ServiceResult;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.template.service.CAPTemplateDataService;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.organization.dao.OrgHelper;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.io.Resource;

public class BizPortalService {
    private static final Log logger = CtpLogFactory.getLog(BizPortalService.class);
    private BizPortalSpaceManager bizPortalSpaceManager;
    private BizPortalThemeManager bizPortalThemeManager;
    private BizPortalLayoutManager bizPortalLayoutManager;
    private BizPortalSectionManager bizPortalSectionManager;
    private CloudAdapterAppManager cloudAdapterAppManager;
    private BizPortalGoodSnapshotManager bizPortalGoodSnapshotManager;
    private DataSourceContextManager dataSourceContextManager;
    private FileManager fileManager;
    private BizPortalFileManager bizPortalFileManager;
    private BizPortalExternAdapterManager bizPortalExternAdapterManager;
    private CAPTemplateDataService capTemplateDataService;

    @NeedBizOwnerPrivilege
    public ServiceResult findBizPortalSpaces(Long bizId, FlipInfo fi, Map<String, Object> param) throws BusinessException {
        ContextParam contextParam = this.contextParam(bizId);
        if (CollectionUtils.isNotEmpty((Collection)(fi = this.bizPortalSpaceManager.findCAPPortalSpace(fi, param, contextParam)).getData())) {
            fi.setData(Lists.transform((List)fi.getData(), (Function)new Function<CAPPortalSpace, Map<String, Object>>(){

                public Map<String, Object> apply(CAPPortalSpace input) {
                    HashMap map = Maps.newHashMap();
                    map.put("id", input.getId().toString());
                    map.put("name", input.getName());
                    map.put("platform", input.getPlatform().toString());
                    map.put("platformName", BizPortalUtils.getEnumByCode(BizPortalConstants.Platform.class, input.getPlatform()).getName());
                    map.put("frameType", input.getFrameType().toString());
                    map.put("frameTypeName", BizPortalUtils.getEnumByCode(BizPortalConstants.FrameType.class, input.getFrameType()).getName());
                    map.put("sourceType", input.getSourceType().toString());
                    map.put("sourceTypeName", BizPortalUtils.getEnumByCode(BizPortalConstants.SourceType.class, input.getSourceType()).getName());
                    map.put("authInfo", input.getAuthInfo());
                    map.put("authName", OrgHelper.showOrgEntities((String)input.getAuthInfo(), (String)ResourceUtil.getString((String)"common.separator.label")));
                    map.put("sort", input.getSort().toString());
                    map.put("createTime", input.getCreateTime());
                    map.put("state", input.getState().toString());
                    map.put("stateName", BizPortalUtils.getEnumByCode(BizPortalConstants.State.class, input.getState()).getName());
                    return map;
                }
            }));
        }
        return ServiceResult.success(fi);
    }

    public ServiceResult listAuthBizPortalSpace(Long bizId, Integer platformCode) throws BusinessException {
        List<CAPPortalSpace> spaceList = this.bizPortalSpaceManager.findAvailableCAPPortalSpace(this.contextParam(bizId, platformCode));
        ArrayList list = Lists.newArrayListWithCapacity((int)spaceList.size());
        for (CAPPortalSpace portalSpace : spaceList) {
            CAPPortalSpaceConfig spaceConfig = this.bizPortalSpaceManager.getBizPortalSpaceConfig(portalSpace.getId(), BizPortalConstants.ConfigStatus.RUNNING);
            HashMap entry = Maps.newHashMap();
            entry.put("bizId", bizId);
            entry.put("spaceId", portalSpace.getId());
            entry.put("name", portalSpace.getName());
            entry.put("configId", spaceConfig.getId());
            list.add(entry);
        }
        return ServiceResult.success(list);
    }

    public ServiceResult listAuthAllPortalSpace(Long bizId, Integer platformCode) throws BusinessException {
        ArrayList list = Lists.newArrayList();
        List<CAPPortalSpace> spaceList = this.bizPortalSpaceManager.findAvailableCAPPortalSpace(this.contextParam(bizId, platformCode));
        for (CAPPortalSpace portalSpace : spaceList) {
            CAPPortalSpaceConfig spaceConfig = this.bizPortalSpaceManager.getBizPortalSpaceConfig(portalSpace.getId(), BizPortalConstants.ConfigStatus.RUNNING);
            Map<String, Boolean> entry = Maps.newHashMap();
            entry.put("bizId", (Boolean)((Object)bizId));
            entry.put("spaceId", (Boolean)((Object)portalSpace.getId()));
            entry.put("name", (Boolean)((Object)portalSpace.getName()));
            entry.put("configId", (Boolean)((Object)spaceConfig.getId()));
            entry.put("newSpace", true);
            list.add(entry);
        }
        Map<String, Object> objectMap = this.capTemplateDataService.getTemplatesByCurrentUser(bizId.toString(), platformCode.toString());
        List datas = (List)objectMap.get("data");
        if (CollectionUtils.isNotEmpty((Collection)datas)) {
            for (Map<String, Boolean> entry : datas) {
                entry.put("newSpace", false);
                entry.put("bizId", (Boolean)((Object)bizId));
                list.add(entry);
            }
        }
        return ServiceResult.success(list);
    }

    @NeedBizOwnerPrivilege
    public ServiceResult renameBizPortalSpace(Long bizId, Long spaceId, String newName) throws BusinessException {
        ContextParam contextParam = this.contextParam(bizId);
        this.bizPortalSpaceManager.updateBizPortalSpaceName(spaceId, newName, contextParam);
        return ServiceResult.success();
    }

    @NeedBizOwnerPrivilege
    public ServiceResult resortBizPortalSpace(Long bizId, Long spaceId, Integer newSort) throws BusinessException {
        ContextParam contextParam = this.contextParam(bizId);
        this.bizPortalSpaceManager.updateBizPortalSpaceSort(spaceId, newSort, contextParam);
        return ServiceResult.success();
    }

    @NeedBizOwnerPrivilege
    public ServiceResult restateBizPortalSpace(Long bizId, Long spaceId, Integer newState) throws BusinessException {
        ContextParam contextParam = this.contextParam(bizId);
        BizPortalConstants.State state = BizPortalUtils.getEnumByCode(BizPortalConstants.State.class, newState);
        this.bizPortalSpaceManager.updateBizPortalSpaceState(spaceId, state, contextParam);
        return ServiceResult.success();
    }

    @NeedBizOwnerPrivilege
    public ServiceResult batchAuthBizPortalSpace(Long bizId, BizPortalSpaceBatchAuthParam batchAuthParam) throws BusinessException {
        ContextParam contextParam = this.contextParam(bizId);
        this.bizPortalSpaceManager.updateBizPortalSpaceAuth(batchAuthParam.getSpaceIds(), batchAuthParam.getAuthInfo(), contextParam);
        return ServiceResult.success();
    }

    @NeedBizOwnerPrivilege
    public ServiceResult batchRemoveBizPortalSpace(Long bizId, List<Long> spaceIds) throws BusinessException {
        ContextParam contextParam = this.contextParam(bizId);
        this.bizPortalSpaceManager.deleteBizPortalSpace(spaceIds, contextParam);
        return ServiceResult.success();
    }

    @NeedBizOwnerPrivilege
    public ServiceResult listGoods(Long bizId, BizPortalGoodsListParam listParam) throws BusinessException {
        return ServiceResult.success(this.cloudAdapterAppManager.findGoodInfoList(listParam));
    }

    @NeedBizOwnerPrivilege
    public ServiceResult downloadGoods(Long bizId, String goodsKey, String goodsId, Integer platformCode) throws BusinessException {
        User currentUser = AppContext.getCurrentUser();
        DownloadGoodInfo downLoadGoodInfo = this.cloudAdapterAppManager.getDownLoadGoodInfo(goodsId, currentUser);
        ContextParam contextParam = this.contextParam(bizId, platformCode);
        return ServiceResult.success(this.bizPortalGoodSnapshotManager.createGoodSnapshot(contextParam, goodsKey, downLoadGoodInfo));
    }

    public ServiceResult getBizPortalSectionConfig(Long bizId, Long configId, Long sectionId) throws BusinessException {
        CAPPortalSection portalSection = this.bizPortalSectionManager.getCAPPortalSection(sectionId);
        BizPortalSectionConfigJson configJson = (BizPortalSectionConfigJson)JSONUtil.parseJSONString((String)portalSection.getConfigInfo(), BizPortalSectionConfigJson.class);
        configJson.setId(portalSection.getId());
        configJson.setSrc(this.bizPortalSectionManager.getBizPortalSectionIndexJs(bizId, configId, configJson.getId()));
        configJson.setSourceId(portalSection.getSourceId());
        return ServiceResult.success(configJson);
    }

    public Resource getBizPortalSectionJS(Long snapshotId, String jsName) throws BusinessException {
        return this.bizPortalGoodSnapshotManager.getRelativeResource(snapshotId, jsName);
    }

    public Resource getBizPortalThemeCss(Long themeId) throws BusinessException {
        CAPPortalTheme portalTheme = this.bizPortalThemeManager.getCAPPortalTheme(themeId);
        return this.bizPortalGoodSnapshotManager.getRelativeResource(portalTheme.getSourceId(), "theme.css");
    }

    @NeedBizOwnerPrivilege
    public ServiceResult listBizPortalLayouts(Long bizId, Long configId, String basePath) throws BusinessException {
        List<CAPPortalLayout> layouts = this.bizPortalLayoutManager.findCAPPortalLayout(AppContext.getCurrentUser());
        ArrayList list = Lists.newArrayListWithCapacity((int)layouts.size());
        for (CAPPortalLayout layout : layouts) {
            list.add(this.convertLayoutVO(bizId, configId, basePath, layout));
        }
        return ServiceResult.success(list);
    }

    private Map<String, Object> convertLayoutVO(Long bizId, Long configId, String basePath, CAPPortalLayout layout) {
        HashMap map = Maps.newHashMap();
        map.put("id", layout.getId().toString());
        map.put("name", layout.getName());
        map.put("type", layout.getType().toString());
        map.put("cover", basePath + "cap4/bizportal/" + bizId + "/" + configId + "/layout/" + layout.getId() + "/cover");
        return map;
    }

    public Resource getBizPortalLayoutCover(Long layoutId) throws BusinessException {
        return this.bizPortalLayoutManager.getBizPortalLayoutCover(layoutId);
    }

    public ServiceResult getBizPortalSpaceConfig(Long bizId, Long configId) throws BusinessException {
        CAPPortalSpaceConfig spaceConfig = this.bizPortalSpaceManager.getCAPPortalSpaceConfig(configId);
        BizPortalSpaceConfigVO configVO = new BizPortalSpaceConfigVO(spaceConfig);
        for (BizPortalSectionConfigJson sectionConfigJson : configVO.listSections()) {
            sectionConfigJson.setSrc(this.bizPortalSectionManager.getBizPortalSectionIndexJs(bizId, spaceConfig.getId(), sectionConfigJson.getId()));
        }
        BizConfigBean bizConfigBean = this.bizPortalExternAdapterManager.getBizConfigBean(bizId);
        configVO.setBizName(bizConfigBean.getName());
        CAPPortalSpace portalSpace = this.bizPortalSpaceManager.getCAPPortalSpace(spaceConfig.getSpaceId());
        configVO.setSpaceName(portalSpace.getName());
        CAPPortalTheme portalTheme = this.bizPortalThemeManager.getCAPPortalTheme(spaceConfig.getThemeId());
        CAPPortalGoodSnapshot goodSnapshot = this.bizPortalGoodSnapshotManager.getCAPPortalGoodSnapshot(portalTheme.getSourceId());
        configVO.setThemeSourceId(portalTheme.getSourceId());
        configVO.setThemeGoodsId(goodSnapshot.getGoodsId());
        return ServiceResult.success(configVO);
    }

    public ServiceResult getBizPortalLayoutConfig(Long layoutId) throws BusinessException {
        CAPPortalLayout layout = this.bizPortalLayoutManager.getCAPPortalLayout(layoutId);
        return ServiceResult.success(layout.getLayoutInfo());
    }

    public ServiceResult collectBizPortalLayout(BizPortalCollectLayoutParam layoutParam) throws BusinessException {
        ServiceResult result;
        try {
            CAPPortalLayout bizPortalLayout = this.bizPortalLayoutManager.createCAPPortalLayout(layoutParam, AppContext.getCurrentUser());
            result = ServiceResult.success(bizPortalLayout.getId().toString());
        }
        catch (DuplicateKeyException e) {
            result = ServiceResult.duplicateKey(e.getMessage());
        }
        return result;
    }

    public ServiceResult removeBizPortalLayout(Long layoutId) throws BusinessException {
        this.bizPortalLayoutManager.removeCAPPortalLayout(layoutId, AppContext.getCurrentUser());
        return ServiceResult.success();
    }

    public ServiceResult getAvailableDataSourceProviders(Integer dataFormat, String versionStr) throws BusinessException {
        BizPortalConstants.DataFormat format = BizPortalUtils.getEnumByCode(BizPortalConstants.DataFormat.class, dataFormat);
        String[] versions = StringUtils.split((String)versionStr, (String)",");
        List<AbstractDataSourceProvider> providers = this.dataSourceContextManager.availableProviders(format, versions);
        ArrayList list = Lists.newArrayListWithCapacity((int)providers.size());
        for (AbstractDataSourceProvider provider : providers) {
            HashMap map = Maps.newHashMap();
            map.put("uuid", provider.uuid());
            map.put("name", provider.name());
            map.put("type", provider instanceof MultiStepable ? MultiStepable.class.getSimpleName() : "default");
            list.add(map);
        }
        return ServiceResult.success(list);
    }

    public ServiceResult getDataSetList(Long bizId, Long configId, Long sectionId, String uuid, String dataId, String versionStr, Integer platformCode) throws BusinessException {
        ContextParam contextParam = this.contextParam(bizId, platformCode);
        String[] versions = StringUtils.split((String)versionStr, (String)",");
        AbstractDataSourceProvider provider = this.dataSourceContextManager.getDataSourceProvider(uuid);
        DataSetList dataSetList = provider.getDataSetList(contextParam, versions);
        if (provider instanceof MultiStepable) {
            HashMap map = Maps.newHashMap();
            map.put("dataSetList", dataSetList);
            if (StringUtils.isNotEmpty((CharSequence)dataId)) {
                List<CAPPortalElementConfig> list = this.bizPortalSectionManager.findCAPPortalElementConfig(configId, sectionId);
                for (CAPPortalElementConfig elementConfig : list) {
                    if (!StringUtils.equals((CharSequence)elementConfig.getDataId(), (CharSequence)dataId)) continue;
                    MultiStepable multiStepable = (MultiStepable)((Object)provider);
                    DataSetMetadata metadata = (DataSetMetadata)JSONUtil.parseJSONString((String)elementConfig.getMetadataInfo(), DataSetMetadata.class);
                    if (!ObjectUtils.equals((Object)metadata.getUuid(), (Object)uuid)) continue;
                    DefaultDataSetList.Node stepNode = multiStepable.getStepNode(metadata);
                    map.put("stepNode", stepNode.getId());
                }
            }
            return ServiceResult.success(map);
        }
        return ServiceResult.success(dataSetList);
    }

    public ServiceResult getDataSetList(Long bizId, String uuid, String versionStr, Integer platformCode, DataSetMetadata dataSetMetadata) throws BusinessException {
        ContextParam contextParam = this.contextParam(bizId, platformCode);
        String[] versions = StringUtils.split((String)versionStr, (String)",");
        AbstractDataSourceProvider provider = this.dataSourceContextManager.getDataSourceProvider(uuid);
        if (provider instanceof MultiStepable) {
            MultiStepable multistepable = (MultiStepable)((Object)provider);
            DefaultDataSetList dataSetList = multistepable.getDataSetList(contextParam, dataSetMetadata, versions);
            return ServiceResult.success(dataSetList);
        }
        return ServiceResult.internalError("\u6570\u636e\u6e90[" + provider.name() + "]\u4e0d\u652f\u6301\u5206\u7ea7\u83b7\u53d6");
    }

    @NeedBizOwnerPrivilege
    public ServiceResult saveBizPortalSpaceConfig(Long bizId, BizPortalSpaceConfigParam spaceConfig) throws BusinessException {
        ContextParam contextParam = this.contextParam(bizId);
        this.bizPortalSpaceManager.saveBizPortalSpaceConfig(spaceConfig, contextParam);
        return ServiceResult.success();
    }

    @NeedBizOwnerPrivilege
    public ServiceResult resetInitialSpaceConfig(Long bizId, Long configId) throws BusinessException {
        ContextParam contextParam = this.contextParam(bizId);
        this.bizPortalSpaceManager.resetInitialSpaceConfig(configId, contextParam);
        return this.getBizPortalSpaceConfig(bizId, configId);
    }

    @NeedBizOwnerPrivilege
    public ServiceResult bindDataSet(Long bizId, Long configId, Long sectionId, List<ElementDataSetBinding> bindings) throws BusinessException {
        ContextParam contextParam = this.contextParam(bizId);
        this.bizPortalSectionManager.createOrUpdateCAPPortalElementConfig(configId, sectionId, bindings, contextParam);
        return ServiceResult.success();
    }

    @NeedBizOwnerPrivilege
    public ServiceResult unbindDataSet(Long bizId, Long configId, Long sectionId, List<Long> elementIds) throws BusinessException {
        ContextParam contextParam = this.contextParam(bizId);
        this.bizPortalSectionManager.removeCAPPortalElementConfig(configId, sectionId, elementIds, contextParam);
        return ServiceResult.success();
    }

    public ServiceResult getSectionData(Long bizId, Long configId, Long sectionId, Integer platformCode) throws BusinessException {
        ContextParam contextParam = this.contextParam(bizId, platformCode);
        BizPortalSectionResult sectionResult = this.bizPortalSectionManager.getBizPortalSectionResult(configId, sectionId, contextParam);
        return ServiceResult.success(sectionResult);
    }

    public ServiceResult getElementData(Long bizId, Long configId, Long sectionId, Long elementId, Integer platformCode, String op, String condition) throws BusinessException {
        ContextParam contextParam = this.contextParam(bizId, platformCode);
        Command command = Command.of(op, condition);
        return this.bizPortalSectionManager.getElementDataSetResult(configId, sectionId, elementId, contextParam, command);
    }

    @NeedBizOwnerPrivilege
    public Pair<String, Resource> getBizPortalSpacePackage(Long bizId, Long spaceId) throws BusinessException {
        ContextParam contextParam = this.contextParam(bizId);
        CAPPortalSpace bizPortalSpace = this.bizPortalSpaceManager.getCAPPortalSpace(spaceId);
        Resource resource = this.bizPortalSpaceManager.exportBizPortalSpace(bizId, spaceId, contextParam);
        return Pair.of((Object)bizPortalSpace.getName(), (Object)resource);
    }

    @NeedBizOwnerPrivilege
    public ServiceResult importBizPortalSpace(Long bizId, Long fileId) throws BusinessException {
        File zipFile = this.fileManager.getFile(fileId, new Date());
        ContextParam contextParam = this.contextParam(bizId);
        CAPPortalSpace bizPortalSpace = this.bizPortalSpaceManager.createBizPortalSpace(zipFile, contextParam);
        return ServiceResult.success(bizPortalSpace.getId());
    }

    @NeedBizOwnerPrivilege
    public ServiceResult importBizPortalSectionFile(Long bizId, Long fileId, Integer plaformCode) throws BusinessException {
        File zipFile = this.fileManager.getFile(fileId, new Date());
        ContextParam contextParam = this.contextParam(bizId, plaformCode);
        return ServiceResult.success(this.bizPortalFileManager.createCAPPortalSectionFile(contextParam, zipFile).getId());
    }

    @NeedBizOwnerPrivilege
    public ServiceResult createBizPortalSection(Long bizId, Long fileId) throws BusinessException {
        CAPPortalFile portalFile = this.bizPortalFileManager.getCAPPortalFile(fileId);
        ContextParam contextParam = this.contextParam(bizId);
        return ServiceResult.success(this.bizPortalSectionManager.createCAPPortalSection(portalFile, contextParam).getId());
    }

    public ServiceResult deleteBizPortalSectionFile(Long fileId) throws BusinessException {
        CAPPortalFile portalFile = this.bizPortalFileManager.getCAPPortalFile(fileId);
        User currentUser = AppContext.getCurrentUser();
        if (!ObjectUtils.equals((Object)portalFile.getCreateMember(), (Object)currentUser.getId())) {
            return ServiceResult.notAuthorized();
        }
        this.bizPortalFileManager.deleteCAPPortalFile(fileId);
        return ServiceResult.success();
    }

    @NeedBizOwnerPrivilege
    public ServiceResult listMyBizPortalSectionFiles(Long bizId, Integer platformCode, BizPortalFileListParam listParam) throws BusinessException {
        ContextParam contextParam = this.contextParam(bizId);
        BizPortalConstants.Platform platform = this.getPlatform(platformCode);
        FlipInfo fi = this.bizPortalFileManager.findCAPPortalFile(contextParam, BizPortalConstants.GoodsClassKey.PORTAL_SPACE_Section, listParam, platform, BizPortalConstants.Platform.ALL);
        return this.convertCAPPortalFilesFormat(fi);
    }

    @NeedBizOwnerPrivilege
    public ServiceResult listOthersBizPortalSectionFiles(Long bizId, Integer platformCode, BizPortalFileListParam listParam) throws BusinessException {
        ContextParam contextParam = this.contextParam(bizId);
        BizPortalConstants.Platform platform = this.getPlatform(platformCode);
        FlipInfo fi = this.bizPortalFileManager.findCAPPortalFileExcludeMember(contextParam, BizPortalConstants.GoodsClassKey.PORTAL_SPACE_Section, listParam, platform, BizPortalConstants.Platform.ALL);
        return this.convertCAPPortalFilesFormat(fi);
    }

    public ServiceResult getBizPortalSectionFile(Long fileId) throws BusinessException {
        return ServiceResult.success(this.convertPO2BizPortalFileVO(this.bizPortalFileManager.getCAPPortalFile(fileId)));
    }

    @NeedBizOwnerPrivilege
    public ServiceResult getBizPortalSectionVersionInfo(Long bizId, Long configId, Long sectionId) throws BusinessException {
        CAPPortalSection portalSection = this.bizPortalSectionManager.getCAPPortalSection(sectionId);
        CAPPortalGoodSnapshot goodSnapshot = this.bizPortalGoodSnapshotManager.getCAPPortalGoodSnapshot(portalSection.getSourceId());
        HashMap result = Maps.newHashMap();
        result.put("name", portalSection.getName());
        result.put("sourceType", goodSnapshot.getSourceType());
        result.put("sourceTypeName", BizPortalUtils.getEnumByCode(BizPortalConstants.SourceType.class, goodSnapshot.getSourceType()).getName());
        result.put("createTime", portalSection.getCreateTime());
        if (ObjectUtils.equals((Object)goodSnapshot.getSourceType(), (Object)BizPortalConstants.SourceType.CLOUD_CENTER.getCode())) {
            result.put("versionNo", goodSnapshot.getVersionNo());
            result.put("goodsUpdateTime", goodSnapshot.getGoodUpdateTime());
            try {
                DownloadGoodInfo downLoadGoodInfo = this.cloudAdapterAppManager.getDownLoadGoodInfo(goodSnapshot.getGoodsId(), AppContext.getCurrentUser());
                HashMap cloudInfo = Maps.newHashMap();
                cloudInfo.put("versionNo", downLoadGoodInfo.getVersionNo());
                cloudInfo.put("versionDesc", downLoadGoodInfo.getVersionDesc());
                cloudInfo.put("infoUrl", downLoadGoodInfo.getInfoUrl());
                cloudInfo.put("goodsId", downLoadGoodInfo.getGoodsId());
                cloudInfo.put("goodsUpdateTime", downLoadGoodInfo.getGoodUpdateTime());
                cloudInfo.put("goodsImg", this.cloudAdapterAppManager.getGoodsImg(goodSnapshot.getGoodsId(), AppContext.getCurrentUser()));
                result.put("cloudInfo", cloudInfo);
            }
            catch (NetworkErrorException e) {
                logger.error((Object)"\u8bf7\u6c42\u5546\u57ce\u5931\u8d25\uff1a", (Throwable)((Object)e));
            }
            List<CAPPortalGoodSnapshot> snapshots = this.bizPortalGoodSnapshotManager.findCAPPortalGoodSnapshot(goodSnapshot.getGoodsId());
            result.put("snapshots", Lists.transform(snapshots, (Function)new Function<CAPPortalGoodSnapshot, Map<String, Object>>(){

                public Map<String, Object> apply(CAPPortalGoodSnapshot input) {
                    HashMap map = Maps.newHashMap();
                    map.put("id", input.getId());
                    map.put("versionNo", input.getVersionNo());
                    map.put("versionDesc", input.getVersionDesc());
                    map.put("goodsUpdateTime", input.getGoodUpdateTime());
                    return map;
                }
            }));
        }
        return ServiceResult.success(result);
    }

    @NeedBizOwnerPrivilege
    public ServiceResult updateBizPortalSection(Long bizId, Long configId, Long sectionId, String goodsId) throws BusinessException {
        DownloadGoodInfo downLoadGoodInfo = this.cloudAdapterAppManager.getDownLoadGoodInfo(goodsId, AppContext.getCurrentUser());
        CAPPortalSpaceConfig spaceConfig = this.bizPortalSpaceManager.getCAPPortalSpaceConfig(configId);
        CAPPortalSpace portalSpace = this.bizPortalSpaceManager.getCAPPortalSpace(spaceConfig.getSpaceId());
        ContextParam contextParam = this.contextParam(bizId, portalSpace.getPlatform());
        Long newSectionId = this.bizPortalGoodSnapshotManager.createGoodSnapshot(contextParam, BizPortalConstants.GoodsClassKey.PORTAL_SPACE_Section.getKey(), downLoadGoodInfo);
        this.cloneBizPortalElementConfigFromOldSection(configId, sectionId, newSectionId);
        return ServiceResult.success(newSectionId);
    }

    @NeedBizOwnerPrivilege
    public ServiceResult updateBizPortalSection(Long bizId, Long configId, Long sectionId, Long snapshotId) throws BusinessException {
        CAPPortalSection capPortalSection = this.bizPortalSectionManager.createCAPPortalSection(this.bizPortalGoodSnapshotManager.getCAPPortalGoodSnapshot(snapshotId), this.contextParam(bizId));
        Long newSectionId = capPortalSection.getId();
        this.cloneBizPortalElementConfigFromOldSection(configId, sectionId, newSectionId);
        return ServiceResult.success(newSectionId);
    }

    private void cloneBizPortalElementConfigFromOldSection(Long configId, Long sectionId, Long newSectionId) throws BusinessException {
        List<CAPPortalElementConfig> elementConfigs = this.bizPortalSectionManager.findCAPPortalElementConfig(configId, sectionId);
        if (CollectionUtils.isEmpty(elementConfigs)) {
            return;
        }
        CAPPortalSection section = this.bizPortalSectionManager.getCAPPortalSection(sectionId);
        BizPortalSectionConfigJson configJson = new BizPortalSectionConfigJson(section.getConfigInfo());
        CAPPortalSection newSection = this.bizPortalSectionManager.getCAPPortalSection(newSectionId);
        BizPortalSectionConfigJson newConfigJson = new BizPortalSectionConfigJson(newSection.getConfigInfo());
        if (configJson.isCopiable() && newConfigJson.isCopiable()) {
            List<BizPortalSectionElement> newElements = newConfigJson.getElements();
            if (newElements.size() == 1) {
                Map<Long, CAPPortalElementConfig> map = this.uniqueIndex(elementConfigs);
                ArrayList list = Lists.newArrayListWithCapacity((int)elementConfigs.size());
                ArrayList constructElements = Lists.newArrayListWithCapacity((int)elementConfigs.size());
                for (CAPPortalElementConfig elementConfig : elementConfigs) {
                    BizPortalSectionElement clone = new BizPortalSectionElement(newElements.get(0));
                    clone.setId(UUIDLong.longUUID());
                    clone.setDataId(elementConfig.getDataId());
                    clone.remove("_index_");
                    constructElements.add(clone);
                    CAPPortalElementConfig cloneElementConfig = BizPortalUtils.clone(elementConfig);
                    cloneElementConfig.setId(UUIDLong.longUUID());
                    cloneElementConfig.setElementId(clone.getId());
                    cloneElementConfig.setSectionId(newSectionId);
                    list.add(cloneElementConfig);
                }
                newConfigJson.setElements(constructElements);
                this.bizPortalSectionManager.saveCAPPortalElementConfig(list);
                newSection.setConfigInfo(JSONUtil.toJSONString((Object)newConfigJson));
                this.bizPortalSectionManager.updateCAPPortalSection(Lists.newArrayList((Object[])new CAPPortalSection[]{newSection}));
            }
        } else {
            boolean elementsEquals;
            List<BizPortalSectionElement> elements = configJson.getElements();
            List<BizPortalSectionElement> newElements = newConfigJson.getElements();
            boolean bl = elementsEquals = elements.size() == newElements.size();
            if (elementsEquals) {
                int len = elements.size();
                for (int i = 0; i < len; ++i) {
                    BizPortalSectionElement element = elements.get(i);
                    BizPortalSectionElement element2 = newElements.get(i);
                    if (!ObjectUtils.notEqual((Object)element.getDataFormat(), (Object)element2.getDataFormat())) continue;
                    elementsEquals = false;
                    break;
                }
            }
            if (elementsEquals) {
                Map<Long, CAPPortalElementConfig> map = this.uniqueIndex(elementConfigs);
                ArrayList list = Lists.newArrayListWithCapacity((int)elementConfigs.size());
                for (int i = 0; i < elements.size(); ++i) {
                    BizPortalSectionElement element = elements.get(i);
                    BizPortalSectionElement newElement = newElements.get(i);
                    CAPPortalElementConfig elementConfig = map.get(element.getId());
                    if (elementConfig == null) continue;
                    CAPPortalElementConfig clone = BizPortalUtils.clone(elementConfig);
                    clone.setId(UUIDLong.longUUID());
                    clone.setElementId(newElement.getId());
                    clone.setSectionId(newSectionId);
                    list.add(clone);
                    newElement.setDataId(clone.getDataId());
                }
                newConfigJson.setElements(newElements);
                this.bizPortalSectionManager.saveCAPPortalElementConfig(list);
                newSection.setConfigInfo(JSONUtil.toJSONString((Object)newConfigJson));
                this.bizPortalSectionManager.updateCAPPortalSection(Lists.newArrayList((Object[])new CAPPortalSection[]{newSection}));
            }
        }
    }

    private Map<Long, CAPPortalElementConfig> uniqueIndex(List<CAPPortalElementConfig> elementConfigs) {
        return Maps.uniqueIndex(elementConfigs, (Function)new Function<CAPPortalElementConfig, Long>(){

            public Long apply(CAPPortalElementConfig input) {
                return input.getElementId();
            }
        });
    }

    private ServiceResult convertCAPPortalFilesFormat(FlipInfo fi) {
        HashMap map = Maps.newHashMap();
        map.put("total", fi.getTotal());
        map.put("page", fi.getPage());
        map.put("pageSize", fi.getSize());
        if (CollectionUtils.isEmpty((Collection)fi.getData())) {
            map.put("list", Collections.emptyList());
        } else {
            map.put("list", Lists.transform((List)fi.getData(), (Function)new Function(){

                public Object apply(Object input) {
                    return BizPortalService.this.convertPO2BizPortalFileVO((CAPPortalFile)((Object)input));
                }
            }));
        }
        return ServiceResult.success(map);
    }

    private Map<String, Object> convertPO2BizPortalFileVO(CAPPortalFile portalFile) {
        HashMap map = Maps.newHashMap();
        map.put("id", portalFile.getId());
        map.put("name", portalFile.getName());
        map.put("createMember", OrgHelper.showMemberName((Long)portalFile.getCreateMember()));
        map.put("createAccountId", OrgHelper.showOrgAccountName((Long)portalFile.getCreateAccountId()));
        map.put("createTime", portalFile.getCreateTime());
        return map;
    }

    public ServiceResult listSpaceConfigAppId(Long configId) throws BusinessException {
        return ServiceResult.success(this.bizPortalSpaceManager.findCAPPortalGoodSnapshotId(configId));
    }

    public ServiceResult isCAPPortalMenuChecked(Long bizId) throws BusinessException {
        return ServiceResult.success(this.bizPortalExternAdapterManager.isCAPPortalMenuChecked(bizId));
    }

    private ContextParam contextParam(Long bizId) {
        return ContextParam.of(AppContext.getCurrentUser(), bizId);
    }

    private ContextParam contextParam(Long bizId, Integer platformCode) {
        return ContextParam.of(AppContext.getCurrentUser(), bizId, this.getPlatform(platformCode));
    }

    private BizPortalConstants.Platform getPlatform(int platformCode) {
        return BizPortalUtils.getEnumByCode(BizPortalConstants.Platform.class, platformCode);
    }

    public void setBizPortalSpaceManager(BizPortalSpaceManager bizPortalSpaceManager) {
        this.bizPortalSpaceManager = bizPortalSpaceManager;
    }

    public void setBizPortalThemeManager(BizPortalThemeManager bizPortalThemeManager) {
        this.bizPortalThemeManager = bizPortalThemeManager;
    }

    public void setBizPortalLayoutManager(BizPortalLayoutManager bizPortalLayoutManager) {
        this.bizPortalLayoutManager = bizPortalLayoutManager;
    }

    public void setBizPortalSectionManager(BizPortalSectionManager bizPortalSectionManager) {
        this.bizPortalSectionManager = bizPortalSectionManager;
    }

    public void setCloudAdapterAppManager(CloudAdapterAppManager cloudAdapterAppManager) {
        this.cloudAdapterAppManager = cloudAdapterAppManager;
    }

    public void setBizPortalGoodSnapshotManager(BizPortalGoodSnapshotManager bizPortalGoodSnapshotManager) {
        this.bizPortalGoodSnapshotManager = bizPortalGoodSnapshotManager;
    }

    public void setDataSourceContextManager(DataSourceContextManager dataSourceContextManager) {
        this.dataSourceContextManager = dataSourceContextManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public void setBizPortalFileManager(BizPortalFileManager bizPortalFileManager) {
        this.bizPortalFileManager = bizPortalFileManager;
    }

    public void setBizPortalExternAdapterManager(BizPortalExternAdapterManager bizPortalExternAdapterManager) {
        this.bizPortalExternAdapterManager = bizPortalExternAdapterManager;
    }

    public void setCapTemplateDataService(CAPTemplateDataService capTemplateDataService) {
        this.capTemplateDataService = capTemplateDataService;
    }

    @Aspect
    public static class BizPortalServiceAspect {
        private BusinessManager businessManager4;

        public void setBusinessManager4(BusinessManager businessManager4) {
            this.businessManager4 = businessManager4;
        }

        @Around(value="execution(* com.seeyon.cap4.bizportal.service.BizPortalService.*(..))")
        public Object aroundMethod(ProceedingJoinPoint joinPoint) throws Throwable {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            try {
                if (method.isAnnotationPresent(NeedBizOwnerPrivilege.class)) {
                    NeedBizOwnerPrivilege needBizOwnerPrivilege = method.getAnnotation(NeedBizOwnerPrivilege.class);
                    Long bizId = (Long)joinPoint.getArgs()[needBizOwnerPrivilege.value()];
                    if (!this.checkBizAuth(bizId, AppContext.getCurrentUser())) {
                        if (ServiceResult.class.isAssignableFrom(method.getReturnType())) {
                            return ServiceResult.notAuthorized();
                        }
                        throw new NotAuthorizedException("\u7528\u6237\u4e0d\u662f\u4e1a\u52a1\u5305\u7ba1\u7406\u5458\uff0c\u65e0\u6743\u9650\u64cd\u4f5c!");
                    }
                }
                return joinPoint.proceed();
            }
            catch (Throwable e) {
                logger.error((Object)("\u4e1a\u52a1\u7a7a\u95f4\u51fa\u73b0\u5f02\u5e38,\u53c2\u6570\u4e3a\uff1a" + JSONUtil.toJSONString((Object)joinPoint.getArgs())), e);
                if (ServiceResult.class.isAssignableFrom(method.getReturnType())) {
                    return ServiceResult.internalError(e.getMessage());
                }
                throw e;
            }
        }

        private boolean checkBizAuth(Long bizId, User user) throws BusinessException {
            BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(bizId);
            if (bizConfigBean == null) {
                return false;
            }
            return bizConfigBean.getOwnerId().equals(user.getId());
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NeedBizOwnerPrivilege {
        public int value() default 0;
    }
}

