/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.bizportal.utils;

import com.google.common.collect.Lists;
import com.seeyon.cap4.bizportal.utils.EnumCode;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.cglib.CglibCopier;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.init.MclclzUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.ZipUtil;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class BizPortalUtils {
    private static final Log logger = CtpLogFactory.getLog(BizPortalUtils.class);
    private static final Objenesis objenesis = new ObjenesisStd();

    public static void zip(File directory, File zipFile) throws BusinessException {
        try {
            ZipUtil.zip((File)directory, (File)zipFile, (boolean)true);
        }
        catch (IOException e) {
            logger.error((Object)"\u538b\u7f29\u6587\u4ef6\u51fa\u9519:", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
    }

    public static void zip(File[] files, File zipFile) throws BusinessException {
        try {
            ZipUtil.zip(Arrays.asList(files), (File)zipFile);
        }
        catch (IOException e) {
            logger.error((Object)"\u538b\u7f29\u6587\u4ef6\u51fa\u9519:", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
    }

    public static void unzip(File zipFile, File directory) throws BusinessException {
        try {
            ZipUtil.unzip((File)zipFile, (File)directory);
            File[] files = directory.listFiles();
            if (files.length == 1) {
                File dDir = files[0];
                BizPortalUtils.copyDirectory(dDir, directory);
                FileUtils.deleteDirectory((File)dDir);
            }
        }
        catch (IOException e) {
            logger.error((Object)"\u538b\u7f29\u5305\u89e3\u538b\u51fa\u9519:", (Throwable)e);
            throw new BusinessException("\u538b\u7f29\u5305\u89e3\u538b\u51fa\u9519\uff01");
        }
    }

    public static void copyDirectory(File src, File dest) throws BusinessException {
        try {
            FileUtils.copyDirectory((File)src, (File)dest);
        }
        catch (IOException e) {
            logger.error((Object)"\u62f7\u8d1d\u6587\u4ef6\u51fa\u9519:", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
    }

    public static void copyFile(File src, File dest) throws BusinessException {
        try {
            FileUtils.copyFile((File)src, (File)dest);
        }
        catch (IOException e) {
            logger.error((Object)"\u62f7\u8d1d\u6587\u4ef6\u51fa\u9519:", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
    }

    public static String getCustomName() {
        Class clazz = MclclzUtil.ioiekc((String)"com.seeyon.ctp.product.ProductInfo");
        return (String)MclclzUtil.invoke((Class)clazz, (String)"getCustomName", null, null, null);
    }

    public static String getBuiltId() {
        return "B" + Datetimes.format((Date)SystemEnvironment.getProductBuildDate(), (String)"yyMMdd") + "." + SystemEnvironment.getProductBuildVersion() + ".CTP" + SystemEnvironment.getCtpProductBuildVersion();
    }

    public static String getVersion() {
        return Functions.getVersion();
    }

    public static File createDirIfAbsent(File parent, String filename) {
        File file = new File(parent, filename);
        if (!file.exists()) {
            file.mkdir();
        }
        return file;
    }

    public static File createDirIfAbsent(String parent, String filename) {
        File parentFile = new File(parent);
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        return BizPortalUtils.createDirIfAbsent(parentFile, filename);
    }

    public static File getRelative(File parent, String relativePath) {
        return new File(parent, relativePath);
    }

    public static void write(File file, String string) throws BusinessException {
        try {
            FileUtils.write((File)file, (CharSequence)string, (String)"UTF-8");
        }
        catch (IOException e) {
            logger.error((Object)"\u538b\u7f29\u6587\u4ef6\u51fa\u9519:", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
    }

    public static void deleteDirectory(File directory) throws BusinessException {
        try {
            FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException e) {
            logger.error((Object)"\u5220\u9664\u6587\u4ef6\u5939\u51fa\u9519:", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
    }

    public static <T> T create(Map<String, Object> map, Class<T> clazz) {
        return (T)JSONUtil.parseJSONString((String)JSONUtil.toJSONString(map), clazz);
    }

    public static <T> List<T> create(List<Map<String, Object>> list, Class<T> clazz) {
        ArrayList ll = Lists.newArrayListWithCapacity((int)list.size());
        for (Map<String, Object> map : list) {
            ll.add(BizPortalUtils.create(map, clazz));
        }
        return ll;
    }

    public static <T> T clone(T object) {
        Object clone = objenesis.getInstantiatorOf(object.getClass()).newInstance();
        CglibCopier.copy(object, (Object)clone);
        return (T)clone;
    }

    public static <T> T get(File file, Class<T> clazz) {
        Object object;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            object = JSONUtil.parseJSONString((String)IOUtils.toString((Reader)reader), clazz);
        }
        catch (IOException e) {
            try {
                logger.error((Object)"\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return (T)object;
    }

    public static <T extends EnumCode> T getEnumByCode(Class<T> clazz, int code) {
        EnumCode[] constants;
        for (EnumCode e : constants = (EnumCode[])clazz.getEnumConstants()) {
            if (e.getCode() != code) continue;
            return (T)e;
        }
        return null;
    }

    public static String encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"urlencode excpetion:", (Throwable)e);
            return "";
        }
    }

    public static void copyProperties(Object dest, Object orgin) {
        try {
            BeanUtils.copyProperties((Object)dest, (Object)orgin);
        }
        catch (Exception e) {
            logger.error((Object)"\u5c5e\u6027\u514b\u9686\u51fa\u9519", (Throwable)e);
        }
    }
}

