/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache;

import com.seeyon.cap4.cache.CacheEngineConfig;
import com.seeyon.cap4.cache.CacheType;
import com.seeyon.cap4.cache.ConfigItem;
import com.seeyon.cap4.cache.ConfigItem_LocalCache;
import com.seeyon.cap4.cache.ConfigItem_RemoteCache;
import com.seeyon.cap4.cache.impl.CacheManagerUtils;
import com.seeyon.cap4.cache.impl.CompositeCacheManager;
import com.seeyon.cap4.cache.inf.ICacheManager;
import com.seeyon.cap4.cache.inf.ICacheObj;
import java.util.concurrent.ConcurrentHashMap;
import org.songjian.utils.ExceptionUtils;
import org.songjian.utils.JSONUtils;
import org.songjian.utils.StreamUtils;
import org.songjian.utils.StringUtils;
import org.songjian.utils.json.JSONObject;

public class CacheEngine {
    private static final String PROPERTY_FILE_URL = "com/seeyon/cap4/cache/CacheEngineConfig.properties";
    private CacheEngineConfig engineConfig;
    private ConcurrentHashMap<String, ICacheManager<?, ?>> managerHashMap = new ConcurrentHashMap();
    private static ThreadLocal<String> debugState = new ThreadLocal();
    private static boolean debugFlag = true;
    private static final CacheEngine cacheEngineInstance = new CacheEngine();

    private CacheEngine() {
    }

    public static CacheEngine getInstance() {
        return cacheEngineInstance;
    }

    public final void init() throws Exception {
        String jSonStr = StreamUtils.readResourceText_UTF8((String)PROPERTY_FILE_URL);
        JSONObject jsonObject = JSONUtils.parseJSon((String)jSonStr);
        this.engineConfig = new CacheEngineConfig();
        this.engineConfig.importFromJSon(jsonObject);
        this.initByConfig(this.engineConfig);
    }

    private void initByConfig(CacheEngineConfig aConfig) throws Exception {
        this.engineConfig = aConfig;
        for (ConfigItem fConfigItem : this.engineConfig.getCongfigList()) {
            ICacheManager<?, ?> fManagerItem = this.initManagerItem(fConfigItem);
            this.managerHashMap.put(fConfigItem.getCacheName(), fManagerItem);
        }
    }

    private ICacheManager<?, ?> initManagerItem(ConfigItem aConfigItem) throws Exception {
        ICacheManager<?, ?> result;
        String temp = aConfigItem.getCacheType();
        ExceptionUtils.checkNull_Str((String)temp, (String)"CacheType");
        int cacheType = CacheType.str2CacheType(temp);
        switch (cacheType) {
            case 0: {
                result = this.newLocalManager(aConfigItem);
                ExceptionUtils.checkNull_Message(result.getObjectLoader(), (String)"ObjectLoader is null,cache name=%s", (Object[])new Object[]{aConfigItem.getCacheName()});
                break;
            }
            case 1: {
                result = this.newRemoteManager(aConfigItem);
                break;
            }
            case 2: {
                result = this.newCompositeManager(aConfigItem);
                break;
            }
            case 3: {
                result = this.newCustomManager(aConfigItem);
                break;
            }
            default: {
                ExceptionUtils.raiseExceptionFormat((String)"error cache type,type=%d", (Object[])new Object[]{cacheType});
                result = null;
            }
        }
        return result;
    }

    private ICacheManager<?, ?> newLocalManager(ConfigItem aConfigItem) throws Exception {
        ConfigItem_LocalCache fLocalCacheInfo = aConfigItem.getLocalCacheInfo();
        ExceptionUtils.checkBlankStr((String)fLocalCacheInfo.getManagerClassName(), (String)"local ManagerClassName");
        ICacheManager result = CacheManagerUtils.newClassNameObj(fLocalCacheInfo.getManagerClassName(), ICacheManager.class);
        result.init(aConfigItem);
        return result;
    }

    private ICacheManager<?, ?> newRemoteManager(ConfigItem aConfigItem) throws Exception {
        ConfigItem_RemoteCache fRemoteCacheInfo = aConfigItem.getRemoteCacheInfo();
        ExceptionUtils.checkNull_Message((Object)fRemoteCacheInfo, (String)"remote cache info is null,cache name=%s", (Object[])new Object[]{aConfigItem.getCacheName()});
        ExceptionUtils.checkBlankStr((String)fRemoteCacheInfo.getManagerClassName(), (String)"remote ManagerClassName");
        ICacheManager result = CacheManagerUtils.newClassNameObj(fRemoteCacheInfo.getManagerClassName(), ICacheManager.class);
        result.init(aConfigItem);
        return result;
    }

    private ICacheManager<?, ?> newCompositeManager(ConfigItem aConfigItem) throws Exception {
        ICacheManager<?, ?> fLocalManager = this.newLocalManager(aConfigItem);
        ICacheManager<?, ?> fRemoteManager = this.newRemoteManager(aConfigItem);
        CompositeCacheManager result = new CompositeCacheManager();
        result.setLocalManager(fLocalManager);
        result.setRemoteManager(fRemoteManager);
        result.init(aConfigItem);
        return result;
    }

    private ICacheManager<?, ?> newCustomManager(ConfigItem aConfigItem) throws Exception {
        ExceptionUtils.checkBlankStr((String)aConfigItem.getCustomManagerClass(), (String)"custommanagerclass");
        ICacheManager result = CacheManagerUtils.newClassNameObj(aConfigItem.getCustomManagerClass(), ICacheManager.class);
        result.init(aConfigItem);
        return result;
    }

    public <T extends ICacheObj, C> ICacheManager<T, C> getCacheManager(Class<T> aClassT, Class<C> aClassC) {
        ExceptionUtils.checkNull_Message(aClassT, (String)"ClassT is null!", (Object[])new Object[0]);
        ExceptionUtils.checkNull_Message(aClassC, (String)"ClassC is null!", (Object[])new Object[0]);
        return this.managerHashMap.get(aClassT.getName());
    }

    public static void setDebugState(String aState) {
        if (!debugFlag) {
            return;
        }
        if (aState == null) {
            debugState.remove();
        } else {
            debugState.set(aState);
        }
    }

    public static void setDebugStateIfNull(String aState) {
        if (!debugFlag) {
            return;
        }
        if (debugState.get() == null) {
            debugState.set(aState);
        }
    }

    public static String getDebugState() {
        String result = !debugFlag ? null : debugState.get();
        return StringUtils.getBlankStr((String)result);
    }
}

