/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl;

import com.seeyon.cap4.cache.ConfigItem;
import com.seeyon.cap4.cache.ConfigItem_RemoteCache;
import com.seeyon.cap4.cache.SynchronizeSignInfo;
import com.seeyon.cap4.cache.TrackTableListener_CAP4Dynamic;
import com.seeyon.cap4.cache.impl.AbsCacheManager;
import com.seeyon.cap4.cache.impl.CAP4DataCacheMonitor;
import com.seeyon.cap4.cache.impl.CacheManagerUtils;
import com.seeyon.cap4.cache.impl.DirectLoadCacheManager_Id2;
import com.seeyon.cap4.cache.impl.LocalCacheManager_Id2;
import com.seeyon.cap4.cache.impl.RedisCacheManager;
import com.seeyon.cap4.cache.impl.RedisDataVersionManager;
import com.seeyon.cap4.cache.impl.redisobj.CacheLogUtils;
import com.seeyon.cap4.cache.impl.redisobj.IRedisClusterInfo;
import com.seeyon.cap4.cache.impl.redisobj.IV5Environment;
import com.seeyon.cap4.cache.impl.redisobj.RedisClusterInfo;
import com.seeyon.cap4.cache.impl.redisobj.RedisConfigObj;
import com.seeyon.cap4.cache.impl.redisobj.RedisConnection;
import com.seeyon.cap4.cache.impl.redisobj.RedisUtils;
import com.seeyon.cap4.cache.inf.ICacheManagerId2;
import com.seeyon.cap4.cache.inf.ICacheObj;
import com.seeyon.cap4.cache.inf.ICacheObjectLoader;
import com.seeyon.cap4.cache.inf.IRedisDataVersionManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.IJMTrackCallback;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMProxyDriver;
import com.seeyon.ctp.util.Strings;
import java.util.List;
import org.songjian.utils.ExceptionUtils;
import org.songjian.utils.ResultTwoValue;
import org.songjian.utils.json.JSONObject;

public class CAP4DataCacheManager<T extends ICacheObj, C>
extends AbsCacheManager<T, C>
implements ICacheManagerId2<T, C>,
IRedisDataVersionManager {
    private static final String ENGINE_CLASS = "v5envclass";
    private ICacheManagerId2<T, C> cacheManager;
    private ConfigItem configItem;
    private CacheLogUtils cacheLogUtils = new CacheLogUtils();
    private TrackTableListener_CAP4Dynamic trackTableListener;
    private CAP4DataCacheMonitor cacheMonitor = new CAP4DataCacheMonitor();
    private boolean localCache = false;
    private boolean fHasDataVersionManager;
    private boolean fDirect;
    private RedisDataVersionManager fRedisDataVersionManager;

    public CAP4DataCacheManager() {
        this.trackTableListener = new TrackTableListener_CAP4Dynamic();
        JMProxyDriver.getTrackCallback().addTrackTableListener((IJMTrackCallback.ITrackTableEvent)this.trackTableListener);
    }

    private final boolean isDirect(ConfigItem aConfigItem) {
        JSONObject fCustomInfo = aConfigItem.getCustomInfo();
        if (fCustomInfo == null) {
            return false;
        }
        Boolean result = fCustomInfo.getBoolean("direct");
        if (result == null) {
            return false;
        }
        return result;
    }

    private final boolean isDataVersionManager(ConfigItem aConfigItem) {
        JSONObject fCustomInfo = aConfigItem.getCustomInfo();
        if (fCustomInfo == null) {
            return false;
        }
        Boolean result = fCustomInfo.getBoolean("dataversionmanager");
        if (result == null) {
            return false;
        }
        return result;
    }

    private final ICacheManagerId2<T, C> initManager(ConfigItem aConfigItem) throws Exception {
        ICacheManagerId2<T, C> result;
        this.fDirect = this.isDirect(aConfigItem);
        this.fHasDataVersionManager = this.isDataVersionManager(aConfigItem);
        RedisCacheManager<T, C> fRedisCacheManager = null;
        if (this.fDirect) {
            result = this.initDirectLoad(aConfigItem, RedisUtils.getV5Environment().hasV5Cluster(), true);
        } else if (this.hasRedisConfig()) {
            fRedisCacheManager = this.initRedisCache(aConfigItem);
            result = fRedisCacheManager;
        } else if (RedisUtils.getV5Environment().hasV5Cluster()) {
            result = this.initDirectLoad(aConfigItem, true, false);
        } else {
            this.localCache = true;
            result = this.initLocalCache(aConfigItem);
        }
        if (this.fHasDataVersionManager) {
            this.fRedisDataVersionManager = this.initRedisDataVersionManager(aConfigItem, fRedisCacheManager == null ? null : fRedisCacheManager.getCon());
        }
        return result;
    }

    @Override
    public void init(ConfigItem aConfigItem) throws Exception {
        this.configItem = aConfigItem;
        this.initV5Environment();
        this.cacheLogUtils.init();
        this.cacheManager = this.initManager(aConfigItem);
        this.trackTableListener.setCacheManager(this.cacheManager);
        RedisUtils.notifyEvent(this.cacheMonitor, 3, "inited");
    }

    public boolean isLocalCache() {
        return this.localCache;
    }

    private void initV5Environment() throws BusinessException {
        JSONObject fCustomInfo = this.configItem.getCustomInfo();
        if (fCustomInfo == null) {
            return;
        }
        String fClassName = fCustomInfo.getString(ENGINE_CLASS);
        if (Strings.isBlank((String)fClassName)) {
            return;
        }
        try {
            IV5Environment fV5Environment = CacheManagerUtils.newClassNameObj(fClassName, IV5Environment.class);
            RedisUtils.setV5Environment(fV5Environment);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    private boolean hasRedisConfig() {
        ConfigItem_RemoteCache fRemoteCacheConfig = this.configItem.getRemoteCacheInfo();
        if (fRemoteCacheConfig == null || fRemoteCacheConfig.getTTL() < 0) {
            return false;
        }
        IV5Environment fV5Environment = RedisUtils.getV5Environment();
        return fV5Environment.hasRedis();
    }

    private RedisCacheManager<T, C> initRedisCache(ConfigItem aConfigItem) throws Exception {
        RedisCacheManager result = new RedisCacheManager(this.cacheLogUtils, this.cacheMonitor);
        result.init(aConfigItem);
        RedisUtils.notifyEvent(this.cacheMonitor, 1, "redis");
        return result;
    }

    private RedisDataVersionManager initRedisDataVersionManager(ConfigItem aConfigItem, RedisConnection aCon) {
        RedisConnection fCon;
        boolean fSalfCon;
        boolean bl = fSalfCon = aCon == null;
        if (fSalfCon) {
            ResultTwoValue<RedisConfigObj, RedisClusterInfo> fConfigs = RedisUtils.makeRedisConConfigs(aConfigItem, this.cacheLogUtils, this.cacheMonitor);
            fCon = RedisUtils.newConnection((RedisConfigObj)fConfigs.Value1, (IRedisClusterInfo)fConfigs.Value2);
        } else {
            fCon = aCon;
        }
        RedisDataVersionManager reuslt = new RedisDataVersionManager(fCon, fSalfCon);
        if (fSalfCon) {
            fCon.initStartId();
        }
        return reuslt;
    }

    private ICacheManagerId2<T, C> initLocalCache(ConfigItem aConfigItem) throws Exception {
        LocalCacheManager_Id2 result = new LocalCacheManager_Id2(this.cacheLogUtils, this.cacheMonitor);
        result.init(aConfigItem);
        this.fObjectLoader = CacheManagerUtils.newRemoteObjectLoader(aConfigItem, ICacheObjectLoader.class);
        result.setObjectLoader(this.fObjectLoader);
        RedisUtils.notifyEvent(this.cacheMonitor, 1, "local");
        return result;
    }

    private ICacheManagerId2<T, C> initDirectLoad(ConfigItem aConfigItem, boolean aCluster, boolean aDirect) throws Exception {
        DirectLoadCacheManager_Id2 result = new DirectLoadCacheManager_Id2();
        result.init(aConfigItem);
        this.fObjectLoader = CacheManagerUtils.newRemoteObjectLoader(aConfigItem, ICacheObjectLoader.class);
        result.setObjectLoader(this.fObjectLoader);
        RedisUtils.notifyEvent(this.cacheMonitor, 1, "direct");
        JSONObject fConfigJSON = new JSONObject();
        fConfigJSON.put("direct", (Object)aDirect);
        fConfigJSON.put("cluster", (Object)aCluster);
        RedisUtils.notifyEvent(this.cacheMonitor, 4, fConfigJSON.toJSONString());
        return result;
    }

    @Override
    public void unInit() throws Exception {
        this.cacheManager.unInit();
        this.cacheManager = null;
        if (this.fRedisDataVersionManager != null) {
            this.fRedisDataVersionManager.uninit();
        }
        RedisUtils.notifyEvent(this.cacheMonitor, 3, "uninited");
    }

    @Override
    public T getFromCache(String aKey, C aContext) {
        return this.cacheManager.getFromCache(aKey, aContext);
    }

    @Override
    public void put2Cache(String aKey, T aDataObject) {
        this.cacheManager.put2Cache(aKey, aDataObject);
    }

    @Override
    public void remove(String key) {
        this.cacheManager.remove(key);
    }

    @Override
    public boolean containsKey(String key) {
        ExceptionUtils.newUnsupportedOperationException((String)"containsKey()");
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        ExceptionUtils.newUnsupportedOperationException((String)"containsValue()");
        return false;
    }

    @Override
    public void synchronizeSigns(List<SynchronizeSignInfo> aList) {
        this.cacheManager.synchronizeSigns(aList);
    }

    @Override
    public void removeAllId2Keys(String aId2) {
        this.cacheManager.removeAllId2Keys(aId2);
    }

    @Override
    public void postDataAsync(Exception aPos) {
        this.cacheManager.postDataAsync(aPos);
    }

    public CAP4DataCacheMonitor getCAP4DataCacheMonitor() {
        return this.cacheMonitor;
    }

    @Override
    public final void sendNotification(int aDataType, long aDataId) {
        if (this.fRedisDataVersionManager == null) {
            return;
        }
        this.fRedisDataVersionManager.sendNotification(aDataType, aDataId);
    }

    @Override
    public final void sendNotifications(int aDataType, long ... aDataIds) {
        if (this.fRedisDataVersionManager == null) {
            return;
        }
        this.fRedisDataVersionManager.sendNotifications(aDataType, aDataIds);
    }

    @Override
    public final boolean checkDataVersion(int aDataType, long aDataId) {
        if (this.fRedisDataVersionManager == null) {
            return true;
        }
        return this.fRedisDataVersionManager.checkDataVersion(aDataType, aDataId);
    }

    @Override
    public void syncLocalDataVersion(int aDataType, long aDataId) {
        if (this.fRedisDataVersionManager == null) {
            return;
        }
        this.fRedisDataVersionManager.syncLocalDataVersion(aDataType, aDataId);
    }

    @Override
    public final void regAsyncDataVerEvent(IRedisDataVersionManager.IOnAsyncDataVerEvent aEvent, int aDataType) {
        if (this.fRedisDataVersionManager == null) {
            return;
        }
        this.fRedisDataVersionManager.regAsyncDataVerEvent(aEvent, aDataType);
    }

    @Override
    public void setPrintDebug(IRedisDataVersionManager.IPrintDebug aPrintDebug) {
        if (this.fRedisDataVersionManager == null) {
            return;
        }
        this.fRedisDataVersionManager.setPrintDebug(aPrintDebug);
    }

    @Override
    public boolean isUseRedisDataVersion() {
        if (this.fRedisDataVersionManager == null) {
            return false;
        }
        return this.fRedisDataVersionManager.isUseRedisDataVersion();
    }

    @Override
    public long getDoCustomEventCount() {
        if (this.fRedisDataVersionManager == null) {
            return 0L;
        }
        return this.fRedisDataVersionManager.getDoCustomEventCount();
    }
}

