/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl;

import com.seeyon.cap4.cache.inf.CacheManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CacheManagerMapImpl
implements CacheManager,
Runnable {
    private static final long scantime = 10000L;
    private ConcurrentHashMap<Object, Object> dataMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Object, Long> timeMap = new ConcurrentHashMap();
    private boolean running;

    @Override
    public <K> boolean contains(K key) {
        return this.dataMap.contains(key);
    }

    @Override
    public <K, V> boolean put(K key, V value) {
        this.dataMap.put(key, value);
        return true;
    }

    @Override
    public <K, V> boolean putList(K key, List<V> values) {
        this.dataMap.put(key, values);
        return true;
    }

    @Override
    public <K, V> boolean put(K key, V value, Long timeout) {
        this.setTimeout(key, timeout);
        this.start();
        return this.put(key, value);
    }

    private <K> void setTimeout(K key, Long timeout) {
        if (timeout != null && timeout > 0L) {
            this.timeMap.put(key, timeout * 1000L + System.currentTimeMillis());
        }
    }

    private void start() {
        if (!this.running) {
            new Thread(this).start();
        }
    }

    @Override
    public void run() {
        this.running = true;
        while (!this.timeMap.isEmpty()) {
            ArrayList<Object> temps = new ArrayList<Object>();
            for (Map.Entry<Object, Long> entry : this.timeMap.entrySet()) {
                if (entry.getValue() >= System.currentTimeMillis()) continue;
                temps.add(entry.getKey());
            }
            if (!temps.isEmpty()) {
                for (Map.Entry<Object, Long> entry : temps) {
                    this.remove(entry);
                }
            }
            try {
                Thread.sleep(10000L * (long)(this.timeMap.size() / 10000 + 1));
            }
            catch (InterruptedException interruptedException) {}
        }
        this.running = false;
    }

    @Override
    public <K, V> boolean putList(K key, List<V> values, Long timeout) {
        this.start();
        return this.putList(key, values);
    }

    @Override
    public <K, V> V get(K key, Class<V> type) {
        Object val;
        if (!this.isTimeout(key) && (val = this.dataMap.get(key)) != null) {
            return (V)val;
        }
        return null;
    }

    private <K> boolean isTimeout(K key) {
        Long time = this.timeMap.get(key);
        return time != null && time < System.currentTimeMillis();
    }

    @Override
    public <K, V> List<V> getList(K key, Class<V> type) {
        Object val;
        if (!this.isTimeout(key) && (val = this.dataMap.get(key)) != null) {
            return (List)val;
        }
        return null;
    }

    @Override
    public <K> boolean remove(K key) {
        this.dataMap.remove(key);
        this.timeMap.remove(key);
        return true;
    }
}

