/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl;

import com.seeyon.cap4.cache.ConfigItem;
import com.seeyon.cap4.cache.SynchronizeSignInfo;
import com.seeyon.cap4.cache.inf.ICacheObj;
import java.util.List;
import java.util.Map;
import org.songjian.utils.StringUtils;

public class CacheManagerUtils {
    public static final <T> T newClassNameObj(String aClassName, Class<T> aClass) throws Exception {
        Class<?> fManagerClass = Class.forName(aClassName);
        return (T)fManagerClass.newInstance();
    }

    public static void synchronizeSigns(List<SynchronizeSignInfo> aList, Map<String, ? extends ICacheObj> aMap) {
        for (SynchronizeSignInfo fSignInfo : aList) {
            ICacheObj fItem;
            if (fSignInfo == null || (fItem = aMap.get(fSignInfo.getKey())) == null || StringUtils.sameString((String)fSignInfo.getSign(), (String)fItem.getSign())) continue;
            aMap.remove(fSignInfo.getKey());
        }
    }

    public static final boolean testOutTime(long aStartTime, long aCurrentTime, long aStep) {
        return aCurrentTime - aStartTime > aStep;
    }

    public static final <T> T newRemoteObjectLoader(ConfigItem aConfigItem, Class<T> aClass) throws Exception {
        String fLoaderClassName = aConfigItem.getRemoteCacheInfo().getObjectLoaderName();
        if (StringUtils.isNoBlank((String)fLoaderClassName)) {
            return CacheManagerUtils.newClassNameObj(fLoaderClassName, aClass);
        }
        return null;
    }

    public static final <T> T newLocalObjectLoader(ConfigItem aConfigItem, Class<T> aClass) throws Exception {
        String fLoaderClassName = aConfigItem.getLocalCacheInfo().getObjectLoaderName();
        if (StringUtils.isNoBlank((String)fLoaderClassName)) {
            return CacheManagerUtils.newClassNameObj(fLoaderClassName, aClass);
        }
        return null;
    }
}

