/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl;

import com.seeyon.cap4.cache.ConfigItem;
import com.seeyon.cap4.cache.SynchronizeSignInfo;
import com.seeyon.cap4.cache.impl.ObjectLoaerBridgeManager;
import com.seeyon.cap4.cache.inf.ICacheManager;
import com.seeyon.cap4.cache.inf.ICacheObj;
import com.seeyon.cap4.cache.inf.ICacheObjectLoader;
import java.util.List;
import org.songjian.utils.ExceptionUtils;

public class CompositeCacheManager<T extends ICacheObj, C>
implements ICacheManager<T, C> {
    private ICacheManager<T, C> fLocalManager = null;
    private ICacheManager<T, C> fRemoteManager = null;
    protected ICacheObjectLoader<T, C> fObjectLoader;

    @Override
    public void init(ConfigItem aConfigItem) throws Exception {
        ExceptionUtils.checkNull_Message(this.fLocalManager, (String)"localManager is null!cache name is %s", (Object[])new Object[]{aConfigItem.getCacheName()});
        ExceptionUtils.checkNull_Message(this.fRemoteManager, (String)"RemoteManager is null!cache name is %s", (Object[])new Object[]{aConfigItem.getCacheName()});
        ExceptionUtils.checkNull_Message(this.fRemoteManager.getObjectLoader(), (String)"RemoteManager ObjectLoader() is null,cache name=%s", (Object[])new Object[]{aConfigItem.getCacheName()});
        ObjectLoaerBridgeManager<T, C> fBridgeLoader = new ObjectLoaerBridgeManager<T, C>();
        fBridgeLoader.setManager(this.fRemoteManager);
        this.fObjectLoader = fBridgeLoader;
        this.fLocalManager.setObjectLoader(fBridgeLoader);
    }

    @Override
    public T getFromCache(String aKey, C aContext) {
        return this.fLocalManager.getFromCache(aKey, aContext);
    }

    @Override
    public void put2Cache(String aKey, T aDataObject) {
        this.fLocalManager.put2Cache(aKey, aDataObject);
        this.fRemoteManager.put2Cache(aKey, aDataObject);
    }

    @Override
    public void remove(String key) {
        this.fLocalManager.remove(key);
        this.fRemoteManager.remove(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.fRemoteManager.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.fRemoteManager.containsValue(value);
    }

    @Override
    public void synchronizeSigns(List<SynchronizeSignInfo> aList) {
        this.fLocalManager.synchronizeSigns(aList);
        this.fRemoteManager.synchronizeSigns(aList);
    }

    @Override
    public ICacheObjectLoader<T, C> getObjectLoader() {
        return this.fObjectLoader;
    }

    @Override
    public void setObjectLoader(ICacheObjectLoader<T, C> aObjectLoader) {
        ExceptionUtils.raiseUnsupportedOperationException((String)"setObjectLoader()");
    }

    @Override
    public Class<T> getCacheObjectClass() {
        return this.fLocalManager.getCacheObjectClass();
    }

    @Override
    public void setCacheObjectClass(Class<T> aClass) {
        this.fLocalManager.setCacheObjectClass(aClass);
    }

    public ICacheManager<T, C> getLocalManager() {
        return this.fLocalManager;
    }

    public void setLocalManager(ICacheManager<?, ?> aLocalManager) {
        this.fLocalManager = aLocalManager;
    }

    public ICacheManager<T, C> getRemoteManager() {
        return this.fRemoteManager;
    }

    public void setRemoteManager(ICacheManager<?, ?> aRemoteManager) {
        this.fRemoteManager = aRemoteManager;
    }

    @Override
    public void unInit() throws Exception {
        try {
            if (this.fLocalManager != null) {
                this.fLocalManager.unInit();
            }
        }
        finally {
            if (this.fRemoteManager != null) {
                this.fRemoteManager.unInit();
            }
        }
    }
}

