/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl;

import com.seeyon.cap4.cache.CacheEngine;
import com.seeyon.cap4.cache.inf.ICacheObj;
import com.seeyon.cap4.cache.inf.ICacheObjectLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.songjian.utils.ResultTwoValue;
import org.songjian.utils.VarParam;

public class LoaderBlockedTools<T extends ICacheObj, C> {
    private ConcurrentHashMap<String, Object> fLockHash = new ConcurrentHashMap();
    private AtomicInteger fCallCount = new AtomicInteger();
    private ConcurrentHashMap<String, ResultTwoValue<T, Long>> fCacheMap = new ConcurrentHashMap();
    private ICacheObjectLoader<T, C> fObjectLoader;
    public static final int C_iFrom_Data = 0;
    public static final int C_iFrom_Cache = 1;

    public ICacheObjectLoader<T, C> getObjectLoader() {
        return this.fObjectLoader;
    }

    public void setObjectLoader(ICacheObjectLoader<T, C> aObjectLoader) {
        this.fObjectLoader = aObjectLoader;
    }

    private final boolean isVaildData(String aKey, ResultTwoValue<T, Long> aItem) {
        if (aItem == null) {
            return false;
        }
        if (aItem.Value1 == null) {
            return false;
        }
        if (this.outOfTime((Long)aItem.Value2, System.currentTimeMillis())) {
            this.fCacheMap.remove(aKey);
            return false;
        }
        return true;
    }

    private final boolean outOfTime(long aTime, long aNow) {
        long ftemp = aNow - aTime;
        return ftemp > 500L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final int loadObject(String aKey, C aContext, VarParam<T> aValue) {
        ResultTwoValue fItem;
        block9: {
            if (this.fObjectLoader == null) {
                return 0;
            }
            Object fLockObj = this.fLockHash.putIfAbsent(aKey, aKey);
            if (fLockObj == null) {
                fLockObj = aKey;
            }
            this.fCallCount.incrementAndGet();
            try {
                Object object = fLockObj;
                // MONITORENTER : object
                fItem = this.fCacheMap.get(aKey);
                if (!this.isVaildData(aKey, fItem)) break block9;
                CacheEngine.setDebugStateIfNull("from loader cache on loaded");
                aValue.fValue = fItem.Value1;
                int n = 1;
                // MONITOREXIT : object
                if (this.fCallCount.decrementAndGet() != 0) return n;
                this.fLockHash.clear();
                this.fCacheMap.clear();
                return n;
            }
            catch (Throwable throwable) {
                if (this.fCallCount.decrementAndGet() != 0) throw throwable;
                this.fLockHash.clear();
                this.fCacheMap.clear();
                throw throwable;
            }
        }
        fItem = new ResultTwoValue();
        fItem.Value1 = this.fObjectLoader.loadObject(aKey, aContext);
        CacheEngine.setDebugStateIfNull("from src data loaded");
        if (fItem.Value1 != null) {
            fItem.Value2 = System.currentTimeMillis();
            this.fCacheMap.put(aKey, fItem);
        }
        aValue.fValue = fItem.Value1;
        int n = 0;
        // MONITOREXIT : object
        if (this.fCallCount.decrementAndGet() != 0) return n;
        this.fLockHash.clear();
        this.fCacheMap.clear();
        return n;
    }
}

