/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl;

import com.seeyon.cap4.cache.CacheEngine;
import com.seeyon.cap4.cache.ConfigItem;
import com.seeyon.cap4.cache.SynchronizeSignInfo;
import com.seeyon.cap4.cache.impl.AbsCacheManager;
import com.seeyon.cap4.cache.impl.CacheManagerUtils;
import com.seeyon.cap4.cache.inf.ICacheObj;
import com.seeyon.cap4.cache.inf.ICacheObjectLoader;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import org.songjian.utils.LRUMap_ReadWriteLock;
import org.songjian.utils.StringUtils;

public class LocalCacheManager<T extends ICacheObj, C>
extends AbsCacheManager<T, C> {
    private LRUMap_ReadWriteLock<String, T> fCacheMap = new LRUMap_ReadWriteLock(100000);
    private ConcurrentHashMap<String, Object> fLockHash = new ConcurrentHashMap();
    private AtomicInteger fCallCount = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T LRUMap_putIfAbsent(String aKey, T aData) {
        Lock fLock = this.fCacheMap.getWriteLock();
        fLock.lock();
        try {
            if (this.fCacheMap.containsKey((Object)aKey)) {
                ICacheObj iCacheObj = (ICacheObj)this.fCacheMap.get((Object)aKey);
                return (T)iCacheObj;
            }
            this.fCacheMap.put((Object)aKey, aData);
            T t = null;
            return t;
        }
        finally {
            fLock.unlock();
        }
    }

    @Override
    public T getFromCache(String aKey, C aContext) {
        CacheEngine.setDebugState(null);
        ICacheObj result = (ICacheObj)this.fCacheMap.get((Object)aKey);
        if (result != null) {
            CacheEngine.setDebugStateIfNull("from local cache");
            return (T)result;
        }
        result = this.loadObject(aKey, aContext);
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T loadObject(String aKey, C aContext) {
        ICacheObj result;
        if (this.fObjectLoader == null) {
            return null;
        }
        Object fLockObj = this.fLockHash.putIfAbsent(aKey, aKey);
        if (fLockObj == null) {
            fLockObj = aKey;
        }
        this.fCallCount.incrementAndGet();
        try {
            Object object = fLockObj;
            synchronized (object) {
                block12: {
                    result = (ICacheObj)this.fCacheMap.get((Object)aKey);
                    if (result == null) break block12;
                    CacheEngine.setDebugStateIfNull("from local cache on loaded");
                    ICacheObj iCacheObj = result;
                    return (T)iCacheObj;
                }
                result = this.fObjectLoader.loadObject(aKey, aContext);
                CacheEngine.setDebugStateIfNull("local loaded");
                if (result != null) {
                    this.LRUMap_putIfAbsent(aKey, result);
                }
            }
        }
        finally {
            if (this.fCallCount.decrementAndGet() == 0) {
                this.fLockHash.clear();
            }
        }
        return (T)result;
    }

    @Override
    public void put2Cache(String aKey, T aDataObject) {
        if (aDataObject == null) {
            return;
        }
        this.fCacheMap.put((Object)aKey, aDataObject);
    }

    @Override
    public void remove(String key) {
        this.fCacheMap.remove((Object)key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.fCacheMap.containsKey((Object)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.fCacheMap.containsValue(value);
    }

    @Override
    public void synchronizeSigns(List<SynchronizeSignInfo> aList) {
        this.fCacheMap.getWriteLock().lock();
        try {
            CacheManagerUtils.synchronizeSigns(aList, this.fCacheMap);
        }
        finally {
            this.fCacheMap.getWriteLock().unlock();
        }
    }

    @Override
    public void init(ConfigItem aConfigItem) throws Exception {
        this.fCacheMap = new LRUMap_ReadWriteLock(aConfigItem.getLocalCacheInfo().getMaxSize());
        this.fLockHash = new ConcurrentHashMap();
        this.fCallCount = new AtomicInteger();
        String fLoaderClassName = aConfigItem.getLocalCacheInfo().getObjectLoaderName();
        this.fObjectLoader = null;
        if (StringUtils.isNoBlank((String)fLoaderClassName)) {
            this.fObjectLoader = CacheManagerUtils.newClassNameObj(fLoaderClassName, ICacheObjectLoader.class);
        }
    }

    public LocalCacheManager() {
        this.fObjectLoader = null;
    }

    @Override
    public void unInit() throws Exception {
        this.fCacheMap.clear();
        this.fLockHash.clear();
        this.fCallCount.set(0);
    }
}

