/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl;

import com.seeyon.cap4.cache.CacheEngine;
import com.seeyon.cap4.cache.ConfigItem;
import com.seeyon.cap4.cache.SynchronizeSignInfo;
import com.seeyon.cap4.cache.impl.AbsCacheManager;
import com.seeyon.cap4.cache.impl.CacheManagerUtils;
import com.seeyon.cap4.cache.inf.ICacheObj;
import com.seeyon.cap4.cache.inf.ICacheObjectLoader;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.songjian.utils.IClassCreater;
import org.songjian.utils.LRUMap_ReadWriteLock;
import org.songjian.utils.NotFoundObj;
import org.songjian.utils.StringUtils;

public class LocalCacheManager1<T extends ICacheObj, C>
extends AbsCacheManager<T, C> {
    private LRUMap_ReadWriteLock<String, AtomicReference<Object>> fCacheMap;
    private prvItemCreater fItemCreater;

    @Override
    public void init(ConfigItem aConfigItem) throws Exception {
        this.fCacheMap = new LRUMap_ReadWriteLock(aConfigItem.getLocalCacheInfo().getMaxSize());
        this.fItemCreater = new prvItemCreater();
        String fLoaderClassName = aConfigItem.getLocalCacheInfo().getObjectLoaderName();
        this.fObjectLoader = null;
        if (StringUtils.isNoBlank((String)fLoaderClassName)) {
            this.fObjectLoader = CacheManagerUtils.newClassNameObj(fLoaderClassName, ICacheObjectLoader.class);
        }
    }

    @Override
    public T getFromCache(String aKey, C aContext) {
        CacheEngine.setDebugState(null);
        AtomicReference result = (AtomicReference)this.fCacheMap.getAndNew((Object)aKey, (IClassCreater)this.fItemCreater);
        if (result.get() != null) {
            CacheEngine.setDebugStateIfNull("from local cache");
            if (NotFoundObj.isNotFoundObj(result.get())) {
                return null;
            }
            return (T)((ICacheObj)result.get());
        }
        if (this.fObjectLoader == null) {
            return null;
        }
        this.loadObject(aKey, aContext, result);
        if (NotFoundObj.isNotFoundObj(result.get())) {
            return null;
        }
        return (T)((ICacheObj)result.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadObject(String aKey, C aContext, AtomicReference<Object> aItem) {
        Object fItem;
        AtomicReference<Object> atomicReference = aItem;
        synchronized (atomicReference) {
            if (aItem.get() != null) {
                CacheEngine.setDebugStateIfNull("from local cache on loaded");
                return;
            }
            fItem = this.fObjectLoader.loadObject(aKey, aContext);
            if (fItem != null) {
                aItem.set(fItem);
            } else {
                aItem.set(NotFoundObj.getNotFound());
            }
            CacheEngine.setDebugStateIfNull("local loaded");
        }
        if (fItem == null) {
            this.fCacheMap.remove((Object)aKey);
        }
    }

    @Override
    public void put2Cache(String aKey, T aDataObject) {
        if (aDataObject == null) {
            return;
        }
        this.fCacheMap.put((Object)aKey, new AtomicReference<T>(aDataObject));
    }

    @Override
    public void remove(String key) {
        this.fCacheMap.remove((Object)key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.fCacheMap.containsKey((Object)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.fCacheMap.containsValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronizeSigns(List<SynchronizeSignInfo> aList) {
        this.fCacheMap.getWriteLock().lock();
        try {
            for (SynchronizeSignInfo fSignInfo : aList) {
                AtomicReference fItem;
                if (fSignInfo == null || (fItem = (AtomicReference)this.fCacheMap.get((Object)fSignInfo.getKey())) == null) continue;
                Object fItemObj = fItem.get();
                if (fItemObj == null) {
                    aList.remove(fSignInfo);
                    continue;
                }
                if (NotFoundObj.isNotFoundObj(fItemObj)) {
                    aList.remove(fSignInfo);
                    continue;
                }
                if (StringUtils.sameString((String)fSignInfo.getSign(), (String)((ICacheObj)fItemObj).getSign())) continue;
                this.fCacheMap.remove((Object)fSignInfo.getKey());
            }
        }
        finally {
            this.fCacheMap.getWriteLock().unlock();
        }
    }

    @Override
    public void unInit() throws Exception {
        this.fCacheMap.clear();
    }

    private class prvItemCreater
    implements IClassCreater<AtomicReference<Object>> {
        private prvItemCreater() {
        }

        public AtomicReference<Object> createObject() {
            return new AtomicReference<Object>();
        }
    }
}

