/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl;

import com.seeyon.cap4.cache.CacheEngine;
import com.seeyon.cap4.cache.ConfigItem;
import com.seeyon.cap4.cache.SynchronizeSignInfo;
import com.seeyon.cap4.cache.impl.AbsCacheManager;
import com.seeyon.cap4.cache.impl.CacheManagerUtils;
import com.seeyon.cap4.cache.inf.ICacheObj;
import com.seeyon.cap4.cache.inf.ICacheObjectLoader;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.songjian.utils.LRUMap_ReadWriteLock;
import org.songjian.utils.NotFoundObj;
import org.songjian.utils.StringUtils;

public class LocalCacheManager2<T extends ICacheObj, C>
extends AbsCacheManager<T, C> {
    private static final Log LOGGER = CtpLogFactory.getLog(LocalCacheManager2.class);
    private LRUMap_ReadWriteLock<String, T> fCacheMap;
    private ConcurrentHashMap<String, Object> fLockHash;
    private AtomicInteger fCallCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T LRUMap_putIfAbsent(String aKey, T aData) {
        Lock fLock = this.fCacheMap.getWriteLock();
        fLock.lock();
        try {
            if (this.fCacheMap.containsKey((Object)aKey)) {
                ICacheObj iCacheObj = (ICacheObj)this.fCacheMap.get((Object)aKey);
                return (T)iCacheObj;
            }
            this.fCacheMap.put((Object)aKey, aData);
            T t = null;
            return t;
        }
        finally {
            fLock.unlock();
        }
    }

    @Override
    public T getFromCache(String aKey, C aContext) {
        CacheEngine.setDebugState(null);
        ICacheObj result = (ICacheObj)this.fCacheMap.get((Object)aKey);
        if (result != null) {
            CacheEngine.setDebugStateIfNull("from local cache");
            return (T)result;
        }
        result = this.loadObject1(aKey, aContext);
        return (T)result;
    }

    private final AtomicReference<Object> getLockInfo(String aKey) {
        AtomicReference result = null;
        do {
            Object fLockObj;
            if ((fLockObj = this.fLockHash.putIfAbsent(aKey, aKey)) == null) {
                fLockObj = aKey;
                result = new AtomicReference();
                this.fLockHash.put(aKey, result);
                return result;
            }
            if (!(fLockObj instanceof AtomicReference)) continue;
            result = (AtomicReference)fLockObj;
            return result;
        } while (result == null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private T loadObject(String aKey, C aContext) {
        AtomicReference<Object> fLockInfo;
        block12: {
            block13: {
                if (this.fObjectLoader == null) {
                    return null;
                }
                fLockInfo = this.getLockInfo(aKey);
                this.fCallCount.incrementAndGet();
                AtomicReference<Object> atomicReference = fLockInfo;
                // MONITORENTER : atomicReference
                if (fLockInfo.get() == null) break block12;
                CacheEngine.setDebugStateIfNull("from local cache on loaded");
                if (!NotFoundObj.isNotFoundObj((Object)fLockInfo.get())) break block13;
                T t = null;
                // MONITOREXIT : atomicReference
                if (this.fCallCount.decrementAndGet() != 0) return t;
                this.fLockHash.clear();
                return t;
            }
            ICacheObj iCacheObj = (ICacheObj)fLockInfo.get();
            // MONITOREXIT : atomicReference
            if (this.fCallCount.decrementAndGet() != 0) return (T)iCacheObj;
            this.fLockHash.clear();
            return (T)iCacheObj;
        }
        try {
            Object result = this.fObjectLoader.loadObject(aKey, aContext);
            CacheEngine.setDebugStateIfNull("local loaded");
            if (result == null) {
                fLockInfo.set(NotFoundObj.getNotFound());
            } else {
                fLockInfo.set(result);
            }
            // MONITOREXIT : atomicReference
            if (result == null) return result;
            this.LRUMap_putIfAbsent(aKey, result);
            return result;
        }
        finally {
            if (this.fCallCount.decrementAndGet() == 0) {
                this.fLockHash.clear();
            }
        }
    }

    @Override
    public void put2Cache(String aKey, T aDataObject) {
        if (aDataObject == null) {
            return;
        }
        this.fCacheMap.put((Object)aKey, aDataObject);
    }

    @Override
    public void remove(String key) {
        this.fCacheMap.remove((Object)key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.fCacheMap.containsKey((Object)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.fCacheMap.containsValue(value);
    }

    @Override
    public void synchronizeSigns(List<SynchronizeSignInfo> aList) {
        this.fCacheMap.getWriteLock().lock();
        try {
            CacheManagerUtils.synchronizeSigns(aList, this.fCacheMap);
        }
        finally {
            this.fCacheMap.getWriteLock().unlock();
        }
    }

    @Override
    public void init(ConfigItem aConfigItem) throws Exception {
        this.fCacheMap = new LRUMap_ReadWriteLock(aConfigItem.getLocalCacheInfo().getMaxSize());
        this.fLockHash = new ConcurrentHashMap();
        this.fCallCount = new AtomicInteger();
        String fLoaderClassName = aConfigItem.getLocalCacheInfo().getObjectLoaderName();
        this.fObjectLoader = null;
        if (StringUtils.isNoBlank((String)fLoaderClassName)) {
            this.fObjectLoader = CacheManagerUtils.newClassNameObj(fLoaderClassName, ICacheObjectLoader.class);
        }
    }

    private final LockInfo getLockInfo1(String aKey) {
        LockInfo result = null;
        do {
            Object fLockObj;
            if ((fLockObj = this.fLockHash.putIfAbsent(aKey, aKey)) == null) {
                fLockObj = aKey;
                result = new LockInfo();
                this.fLockHash.put(aKey, result);
                return result;
            }
            if (fLockObj instanceof LockInfo) {
                result = (LockInfo)fLockObj;
                return result;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        } while (result == null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private T loadObject1(String aKey, C aContext) {
        block18: {
            block17: {
                block16: {
                    if (this.fObjectLoader == null) {
                        return null;
                    }
                    fLockInfo = this.getLockInfo1(aKey);
                    this.fCallCount.incrementAndGet();
                    var5_4 = fLockInfo;
                    synchronized (var5_4) {
                        if (LockInfo.access$000(fLockInfo).get() == null) ** GOTO lbl32
                        if (CacheManagerUtils.testOutTime(LockInfo.access$100(fLockInfo), System.currentTimeMillis(), 4000L)) ** break block14
                        CacheEngine.setDebugStateIfNull("from local cache on loaded");
                        if (!NotFoundObj.isNotFoundObj(LockInfo.access$000(fLockInfo).get())) ** break block15
                        var6_5 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl15 : MonitorExitStatement: MONITOREXIT : var5_4
                        if (this.fCallCount.decrementAndGet() != 0) break block16;
                        this.fLockHash.clear();
                    }
                }
                return var6_5;
                {
                    var6_6 = (ICacheObj)LockInfo.access$000(fLockInfo).get();
                    // MONITOREXIT @DISABLED, blocks:[2, 5] lbl21 : MonitorExitStatement: MONITOREXIT : var5_4
                    if (this.fCallCount.decrementAndGet() != 0) break block17;
                    this.fLockHash.clear();
                }
            }
            return (T)var6_6;
            {
                CacheEngine.setDebugStateIfNull("from local cache reloaded");
lbl32:
                // 2 sources

                result = this.fObjectLoader.loadObject(aKey, aContext);
                CacheEngine.setDebugStateIfNull("local loaded");
                if (result == null) {
                    LockInfo.access$000(fLockInfo).set(NotFoundObj.getNotFound());
                } else {
                    LockInfo.access$000(fLockInfo).set(result);
                    LockInfo.access$102(fLockInfo, System.currentTimeMillis());
                }
                // MONITOREXIT @DISABLED, blocks:[3, 4, 5] lbl36 : MonitorExitStatement: MONITOREXIT : var5_4
                {
                    catch (Throwable var7_8) {
                        throw var7_8;
                    }
                }
                if (result != null) {
                    this.LRUMap_putIfAbsent(aKey, result);
                }
                break block18;
            }
            {
                finally {
                    if (this.fCallCount.decrementAndGet() == 0) {
                        this.fLockHash.clear();
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void unInit() throws Exception {
        this.fCacheMap.clear();
        this.fLockHash.clear();
        this.fCallCount.set(0);
    }

    private class LockInfo {
        private volatile long fLockTime = System.currentTimeMillis();
        private AtomicReference<Object> fData = new AtomicReference();

        static /* synthetic */ AtomicReference access$000(LockInfo x0) {
            return x0.fData;
        }

        static /* synthetic */ long access$100(LockInfo x0) {
            return x0.fLockTime;
        }

        static /* synthetic */ long access$102(LockInfo x0, long x1) {
            x0.fLockTime = x1;
            return x0.fLockTime;
        }
    }
}

