/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl;

import com.seeyon.cap4.cache.CacheEngine;
import com.seeyon.cap4.cache.ConfigItem;
import com.seeyon.cap4.cache.SynchronizeSignInfo;
import com.seeyon.cap4.cache.impl.AbsCacheManager;
import com.seeyon.cap4.cache.impl.CacheManagerUtils;
import com.seeyon.cap4.cache.impl.ICacheMonitor;
import com.seeyon.cap4.cache.impl.LoaderBlockedTools;
import com.seeyon.cap4.cache.impl.redisobj.CacheLogUtils;
import com.seeyon.cap4.cache.impl.redisobj.ConnectLogObj;
import com.seeyon.cap4.cache.impl.redisobj.RedisUtils;
import com.seeyon.cap4.cache.inf.ICacheManagerId2;
import com.seeyon.cap4.cache.inf.ICacheObj;
import com.seeyon.cap4.cache.inf.ICacheObjId2;
import com.seeyon.cap4.cache.inf.ICacheObjectLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.songjian.utils.ArrayListFixType;
import org.songjian.utils.ArrayUtils;
import org.songjian.utils.LRUMap_ReadWriteLock;
import org.songjian.utils.VarParam;
import org.songjian.utils.json.JSONObject;

public class LocalCacheManager_Id2<T extends ICacheObj, C>
extends AbsCacheManager<T, C>
implements ICacheManagerId2<T, C> {
    private AtomicBoolean fDataAsync;
    private LoaderBlockedTools<T, C> fLoaderBlocked;
    private LRUMap_ReadWriteLock<String, T> fCacheMap;
    private Id2HashMap fId2HashMap;
    private ConcurrentHashMap<String, Object> fLockHash;
    private CacheLogUtils fCacheLogUtils;
    private ICacheMonitor fMonitor;
    private long fTTL;

    private static final boolean outOfTime(long aOldTime, long aNow, long aTTL) {
        if (aOldTime == 0L) {
            return false;
        }
        long fTemp = aNow - aOldTime;
        return fTemp > aTTL * 1000L;
    }

    public LocalCacheManager_Id2(CacheLogUtils aCacheLogUtils, ICacheMonitor aMonitor) {
        this();
        this.fCacheLogUtils = aCacheLogUtils;
        this.fMonitor = aMonitor;
    }

    public LocalCacheManager_Id2() {
        RedisUtils.notifyEvent(this.fMonitor, 3, "none");
        this.fLoaderBlocked = new LoaderBlockedTools();
        this.fCacheMap = new LRUMap_ReadWriteLock(100000);
        this.fId2HashMap = new Id2HashMap();
        this.fObjectLoader = null;
        this.fDataAsync = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T LRUMap_putIfAbsent(String aKey, T aData) {
        Lock fLock = this.fCacheMap.getWriteLock();
        fLock.lock();
        try {
            if (this.fCacheMap.containsKey((Object)aKey)) {
                ICacheObj iCacheObj = (ICacheObj)this.fCacheMap.get((Object)aKey);
                return (T)iCacheObj;
            }
            this.fCacheMap.put((Object)aKey, aData);
            T t = null;
            return t;
        }
        finally {
            fLock.unlock();
        }
    }

    @Override
    public T getFromCache(String aKey, C aContext) {
        CacheEngine.setDebugState(null);
        if (this.fDataAsync.get()) {
            return this.dirctloadObject(this.fLoaderBlocked, aKey, aContext);
        }
        ICacheObj result = (ICacheObj)this.fCacheMap.get((Object)aKey);
        if (this.fDataAsync.get()) {
            return this.dirctloadObject(this.fLoaderBlocked, aKey, aContext);
        }
        if (result != null) {
            CacheEngine.setDebugStateIfNull("from local cache");
            this.fId2HashMap.updataId2Time(result);
            return (T)result;
        }
        this.fId2HashMap.clearByTime();
        result = this.loadObject(aKey, aContext);
        RedisUtils.notifyEvent(this.fMonitor, 3, "running");
        return (T)result;
    }

    private final void doPutToCache(String aKey, T aDataObject) {
        if (aDataObject == null) {
            return;
        }
        this.LRUMap_putIfAbsent(aKey, aDataObject);
        if (aDataObject instanceof ICacheObjId2) {
            ICacheObjId2 fItem = (ICacheObjId2)aDataObject;
            Id2HashMap_Item fList = this.fId2HashMap.get(fItem.getId2());
            this.fId2HashMap.putKeyToId2(fItem.getId2(), fList);
        }
        this.putRunInfo();
    }

    private final void putRunInfo() {
        JSONObject fRuninfoObj = new JSONObject();
        fRuninfoObj.put("form_count", (Object)this.fId2HashMap.size());
        fRuninfoObj.put("data_count", (Object)this.fCacheMap.size());
        RedisUtils.notifyEvent(this.fMonitor, 5, fRuninfoObj.toJSONString());
    }

    private final T loadObject(String aKey, C aContext) {
        VarParam fLoadData = new VarParam();
        int fFrom = this.fLoaderBlocked.loadObject(aKey, aContext, fLoadData);
        ICacheObj result = (ICacheObj)fLoadData.fValue;
        if (result == null) {
            return null;
        }
        if (fFrom == 0) {
            this.doPutToCache(aKey, result);
        }
        return (T)result;
    }

    @Override
    public void put2Cache(String aKey, T aDataObject) {
        this.doPutToCache(aKey, aDataObject);
    }

    @Override
    public void remove(String key) {
        this.fCacheMap.remove((Object)key);
        this.putRunInfo();
    }

    @Override
    public boolean containsKey(String key) {
        return this.fCacheMap.containsKey((Object)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.fCacheMap.containsValue(value);
    }

    @Override
    public void synchronizeSigns(List<SynchronizeSignInfo> aList) {
        this.fCacheMap.getWriteLock().lock();
        try {
            CacheManagerUtils.synchronizeSigns(aList, this.fCacheMap);
        }
        finally {
            this.fCacheMap.getWriteLock().unlock();
        }
        this.putRunInfo();
    }

    @Override
    public void init(ConfigItem aConfigItem) throws Exception {
        this.fCacheMap = new LRUMap_ReadWriteLock(aConfigItem.getLocalCacheInfo().getMaxSize());
        this.fLockHash = new ConcurrentHashMap();
        this.fObjectLoader = CacheManagerUtils.newLocalObjectLoader(aConfigItem, ICacheObjectLoader.class);
        if (this.fObjectLoader != null) {
            this.fLoaderBlocked.setObjectLoader(this.fObjectLoader);
        }
        if (this.fCacheLogUtils == null) {
            this.fCacheLogUtils = new CacheLogUtils();
            this.fCacheLogUtils.init();
        }
        this.fTTL = aConfigItem.getRemoteCacheInfo().getTTL().intValue();
        if (this.fTTL < 0L) {
            this.fTTL = 3600L;
        }
        JSONObject fConfigObj = new JSONObject();
        fConfigObj.put("max_size", (Object)aConfigItem.getLocalCacheInfo().getMaxSize());
        fConfigObj.put("ttl", (Object)this.fTTL);
        fConfigObj.put("logfile", (Object)CacheLogUtils.makeSaveFile());
        RedisUtils.notifyEvent(this.fMonitor, 4, fConfigObj.toJSONString());
        RedisUtils.notifyEvent(this.fMonitor, 3, "inited");
    }

    @Override
    public void unInit() throws Exception {
        this.fCacheMap.clear();
        this.fLockHash.clear();
        this.fId2HashMap.clear();
        RedisUtils.notifyEvent(this.fMonitor, 3, "uninited");
    }

    @Override
    public final void setObjectLoader(ICacheObjectLoader<T, C> aObjectLoader) {
        this.fLoaderBlocked.setObjectLoader(aObjectLoader);
        this.fObjectLoader = aObjectLoader;
    }

    @Override
    public void removeAllId2Keys(String aId2) {
        Id2HashMap_Item fItem = this.fId2HashMap.get(aId2);
        if (fItem == null) {
            return;
        }
        Object[] fArray = fItem.exportArrayAndClear();
        if (ArrayUtils.isBlankArray((Object[])fArray)) {
            return;
        }
        for (Object fId : fArray) {
            this.fCacheMap.remove(fId);
        }
        this.putRunInfo();
    }

    @Override
    public void postDataAsync(Exception aPos) {
        boolean fOldState = this.fDataAsync.getAndSet(true);
        if (!CacheLogUtils.isSQLiteOK()) {
            return;
        }
        ConnectLogObj fConnectLogObj = new ConnectLogObj();
        fConnectLogObj.setConnectid("loacal");
        fConnectLogObj.setTime(System.currentTimeMillis());
        fConnectLogObj.setState("dataasync");
        fConnectLogObj.setEx(aPos);
        fConnectLogObj.setConfigObj(null);
        if (fOldState) {
            this.fCacheLogUtils.saveDataAsyncObj(fConnectLogObj);
        } else {
            RedisUtils.notifyEvent(this.fMonitor, 2, "DataAsync");
            this.fCacheLogUtils.saveLogAndDataAsyncObj(fConnectLogObj);
        }
    }

    private class Id2HashMap {
        private long fClearTime;
        private ConcurrentHashMap<String, Id2HashMap_Item> fMap = new ConcurrentHashMap();

        private Id2HashMap() {
            this.fClearTime = System.currentTimeMillis();
        }

        private final Id2HashMap_Item get(String aKey) {
            Id2HashMap_Item fItem = this.fMap.get(aKey);
            return fItem;
        }

        private final void putKeyToId2(String aKey, Id2HashMap_Item aValue) {
            if (aValue == null) {
                Id2HashMap_Item fItem = new Id2HashMap_Item();
                Id2HashMap_Item fTemp = this.fMap.putIfAbsent(aKey, fItem);
                aValue = fTemp != null ? fTemp : fItem;
            }
            aValue.add(aKey);
        }

        private final int size() {
            return this.fMap.size();
        }

        private final void clear() {
            this.fClearTime = System.currentTimeMillis();
            this.fMap.clear();
        }

        private final void updataId2Time(ICacheObj aObj) {
            if (!(aObj instanceof ICacheObjId2)) {
                return;
            }
            ICacheObjId2 fId2Item = (ICacheObjId2)aObj;
            Id2HashMap_Item fItem = this.fMap.get(fId2Item.getId2());
            if (fItem == null) {
                return;
            }
            fItem.updateTime();
        }

        private final void clearByTime() {
            long fNow = System.currentTimeMillis();
            if (!LocalCacheManager_Id2.outOfTime(this.fClearTime, fNow, LocalCacheManager_Id2.this.fTTL)) {
                return;
            }
            ArrayList<Id2HashMap_Item> fId2List = new ArrayList<Id2HashMap_Item>(this.fMap.size());
            for (Id2HashMap_Item fItem : this.fMap.values()) {
                if (fItem == null) continue;
                fId2List.add(fItem);
            }
            for (Id2HashMap_Item fItem : fId2List) {
                fItem.clearId2Data(fNow);
            }
        }
    }

    private class Id2HashMap_Item {
        private long fLastTime = System.currentTimeMillis();
        private ArrayListFixType<String> fList = new ArrayListFixType(String.class);

        private Id2HashMap_Item() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void add(String aId2) {
            ArrayListFixType<String> arrayListFixType = this.fList;
            synchronized (arrayListFixType) {
                this.fList.add((Object)aId2);
            }
            this.fLastTime = System.currentTimeMillis();
        }

        private final void updateTime() {
            this.fLastTime = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String[] exportArrayAndClear() {
            String[] result;
            ArrayListFixType<String> arrayListFixType = this.fList;
            synchronized (arrayListFixType) {
                result = (String[])this.fList.exportArray();
                this.fList.clear();
            }
            return result;
        }

        private final void clearId2Data(long aNow) {
            if (!LocalCacheManager_Id2.outOfTime(this.fLastTime, aNow, LocalCacheManager_Id2.this.fTTL)) {
                return;
            }
            for (String fKey : this.fList) {
                LocalCacheManager_Id2.this.fCacheMap.remove((Object)fKey);
            }
        }
    }
}

