/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl;

import com.seeyon.cap4.cache.CacheEngine;
import com.seeyon.cap4.cache.ConfigItem;
import com.seeyon.cap4.cache.ConfigItem_RemoteCache;
import com.seeyon.cap4.cache.SynchronizeSignInfo;
import com.seeyon.cap4.cache.impl.AbsCacheManager;
import com.seeyon.cap4.cache.impl.CacheManagerUtils;
import com.seeyon.cap4.cache.impl.CompositeCacheManager;
import com.seeyon.cap4.cache.impl.ICacheMonitor;
import com.seeyon.cap4.cache.impl.LoaderBlockedTools;
import com.seeyon.cap4.cache.impl.redisobj.CacheLogUtils;
import com.seeyon.cap4.cache.impl.redisobj.IRedisClusterInfo;
import com.seeyon.cap4.cache.impl.redisobj.IV5Environment;
import com.seeyon.cap4.cache.impl.redisobj.RedisClientInfo;
import com.seeyon.cap4.cache.impl.redisobj.RedisClusterInfo;
import com.seeyon.cap4.cache.impl.redisobj.RedisConfigObj;
import com.seeyon.cap4.cache.impl.redisobj.RedisConnection;
import com.seeyon.cap4.cache.impl.redisobj.RedisServerTime;
import com.seeyon.cap4.cache.impl.redisobj.RedisTaskObj;
import com.seeyon.cap4.cache.impl.redisobj.RedisUtils;
import com.seeyon.cap4.cache.inf.ICacheManager;
import com.seeyon.cap4.cache.inf.ICacheManagerId2;
import com.seeyon.cap4.cache.inf.ICacheObj;
import com.seeyon.cap4.cache.inf.ICacheObjId2;
import com.seeyon.cap4.cache.inf.ICacheObjectLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.songjian.utils.ArrayUtils;
import org.songjian.utils.ExceptionUtils;
import org.songjian.utils.StringUtils;
import org.songjian.utils.VarParam;
import org.songjian.utils.json.JSONObject;

public class RedisCacheManager<T extends ICacheObj, C>
extends AbsCacheManager<T, C>
implements ICacheManagerId2<T, C> {
    private CacheLogUtils fCacheLogUtils;
    private RedisConfigObj fConfig;
    private RedisConnection fCon;
    private IRedisClusterInfo fRedisClusterInfo;
    private int fTTL;
    private int fHalfTTL;
    private Map<String, prvExpireInfo> fExpireHash = new ConcurrentHashMap<String, prvExpireInfo>();
    private LoaderBlockedTools<T, C> fLoaderBlocked;
    public static final int C_iKeyState_OK = 0;
    public static final int C_iKeyState_Exp = -2;
    private AtomicInteger fUpdateTTLCount = new AtomicInteger(0);
    private RedisClientInfo fSalfClientInfo;
    private RedisClientInfo fMasterClientInfo;
    private RedisClientInfo[] fSlaveArryClientInfo;
    private ICacheMonitor fMonitor;

    public RedisClientInfo[] getSlaveArryClientInfo() {
        return this.fSlaveArryClientInfo;
    }

    public IRedisClusterInfo getRedisClusterInfo() {
        return this.fRedisClusterInfo;
    }

    public RedisClientInfo getSalfClientInfo() {
        return this.fSalfClientInfo;
    }

    public RedisConnection getCon() {
        return this.fCon;
    }

    public RedisClientInfo getMasterClientInfo() {
        return this.fMasterClientInfo;
    }

    public RedisCacheManager(CacheLogUtils aCacheLogUtils, ICacheMonitor aCacheMonitor) {
        this();
        this.fCacheLogUtils = aCacheLogUtils;
        this.fMonitor = aCacheMonitor;
    }

    public RedisCacheManager() {
        this.fLoaderBlocked = new LoaderBlockedTools();
    }

    private final void init_JedisConnetion() {
        if (!this.fConfig.isVaild()) {
            ExceptionUtils.raiseException((String)"vaild redis config!");
        }
        this.fCon = RedisUtils.newConnection(this.fConfig, this.fRedisClusterInfo);
        this.fCon.initStartId();
    }

    private void initTestData() {
        IV5Environment fV5Environment = RedisUtils.getV5Environment();
        this.fConfig = new RedisConfigObj();
        this.fConfig.setHost(fV5Environment.getRedisHost());
        this.fConfig.setPort(fV5Environment.getRedisPort());
        this.fConfig.setPassword(fV5Environment.getRedisPass());
        this.fConfig.setName(fV5Environment.getRedisServerName());
        this.fConfig.setDatabase(fV5Environment.getRedisDB());
        this.fConfig.setNotifyHost(fV5Environment.getNotifyHost());
        this.fConfig.setNotifyPort(fV5Environment.getNotifyPort());
        this.fSalfClientInfo.setId(fV5Environment.getServerId());
    }

    @Override
    public void init(ConfigItem aConfigItem) throws Exception {
        this.fSalfClientInfo = new RedisClientInfo();
        ConfigItem_RemoteCache fConfigItem_RemoteCache = aConfigItem.getRemoteCacheInfo();
        this.initTestData();
        this.fConfig.setTTL(fConfigItem_RemoteCache.getTTL());
        this.fTTL = this.fConfig.getTTLSec();
        this.fHalfTTL = this.fConfig.getTTLSec() / 2;
        this.fSalfClientInfo.setMaster(fConfigItem_RemoteCache.isMaster());
        this.fSalfClientInfo.setNotifyUrl(this.fConfig.parseNotifyUrl(fConfigItem_RemoteCache.getNotifyUrl()));
        this.fObjectLoader = CacheManagerUtils.newRemoteObjectLoader(aConfigItem, ICacheObjectLoader.class);
        this.fLoaderBlocked.setObjectLoader(this.fObjectLoader);
        this.fRedisClusterInfo = new RedisClusterInfo(this.fSalfClientInfo, this.fConfig, new RedisServerTime(), this.fCacheLogUtils, RedisConnection.getInitScripts());
        this.fRedisClusterInfo.setCacheMonitor(this.fMonitor);
        IV5Environment fEnvironment = RedisUtils.getV5Environment();
        JSONObject fConfigObj = new JSONObject();
        fConfigObj.put("redis_host", (Object)fEnvironment.getRedisHost());
        fConfigObj.put("redis_port", (Object)fEnvironment.getRedisPort());
        fConfigObj.put("serverid", (Object)fEnvironment.getServerId());
        fConfigObj.put("logfile", (Object)CacheLogUtils.makeSaveFile());
        RedisUtils.notifyEvent(this.fMonitor, 4, fConfigObj.toJSONString());
        this.init_JedisConnetion();
    }

    private final void putExpireInfo_Key(String aKey) {
        String fKey = this.fRedisClusterInfo.getDataKey(aKey);
        prvExpireInfo fExpireInfo = new prvExpireInfo();
        fExpireInfo.fPutTime = System.currentTimeMillis() / 1000L;
        this.fExpireHash.put(fKey, fExpireInfo);
    }

    @Override
    public T getFromCache(String aKey, C aContext) {
        CacheEngine.setDebugState(null);
        if (this.fCon.isDataAsync()) {
            return this.dirctloadObject(this.fLoaderBlocked, aKey, aContext);
        }
        VarParam<T> result = this.getFromRedisResult_Key(aKey);
        if (this.fCon.isDataAsync()) {
            return this.dirctloadObject(this.fLoaderBlocked, aKey, aContext);
        }
        if (result != null) {
            CacheEngine.setDebugStateIfNull("from redis cache");
            prvExpireInfo fExpireInfo = this.fExpireHash.get(aKey);
            if (fExpireInfo != null) {
                fExpireInfo.restCallTTL(System.currentTimeMillis() / 1000L);
            }
            this.expireTTL();
            return (T)((ICacheObj)result.getValue());
        }
        VarParam fLoadData = new VarParam();
        int fFrom = this.fLoaderBlocked.loadObject(aKey, aContext, fLoadData);
        if (!this.fCon.inConnectError() && fFrom == 0) {
            this.putToRedis_Key(aKey, (ICacheObj)fLoadData.fValue, false);
            this.putExpireInfo_Key(aKey);
        }
        return (T)((ICacheObj)fLoadData.fValue);
    }

    private void expireTTL() {
        if (this.fUpdateTTLCount.get() <= 0) {
            return;
        }
        ArrayList<String> fRemoveList = new ArrayList<String>();
        ArrayList<RedisTaskObj> fUpdateList = new ArrayList<RedisTaskObj>();
        long fNowTime = System.currentTimeMillis() / 1000L;
        for (Map.Entry<String, prvExpireInfo> fEntry : this.fExpireHash.entrySet()) {
            int fNowTTL = fEntry.getValue().testState(fNowTime);
            if (fNowTTL == 0) continue;
            if (fNowTTL == -2) {
                fRemoveList.add(fEntry.getKey());
            }
            if (fNowTTL < 0) continue;
            RedisTaskObj fTask = RedisTaskObj.newExpireTTLObj(fEntry.getKey(), fNowTTL);
            fUpdateList.add(fTask);
            fTask.setSendLog(RedisUtils.getClassDebug(RedisCacheManager.class) ? String.format("[%s] expire redis ttl,key='%s'\r\n", RedisCacheManager.class.getName(), fEntry.getKey()) : null);
            fEntry.getValue().expireTTL();
        }
        if (fUpdateList.size() > 0) {
            this.fCon.doTasksNoWait((RedisTaskObj[])ArrayUtils.listToArray(fUpdateList, RedisTaskObj.class));
        }
        for (String fKey : fRemoveList) {
            this.fExpireHash.remove(fKey);
        }
        this.fUpdateTTLCount.set(0);
    }

    private final void putToRedis_Key(String aKey, T aData, boolean aSyn) {
        String fKey = this.fRedisClusterInfo.getDataKey(aKey);
        RedisTaskObj fId2Task = null;
        String ftemp = aData == null ? "" : this.fObjectLoader.object2JsonStr(aData);
        RedisTaskObj fTask = RedisTaskObj.newWriteStrObj(fKey, ftemp);
        if (aData instanceof ICacheObjId2) {
            ICacheObjId2 fItem = (ICacheObjId2)aData;
            fId2Task = RedisTaskObj.newWriteId2Obj(this.fRedisClusterInfo.getId2Key(fItem.getId2()), aKey, this.fCon.getCachedServerTime() + "");
        }
        fTask.setSendLog(RedisUtils.getClassDebug(RedisCacheManager.class) ? String.format("[%s] put data to redis,key='%s'\r\n", RedisCacheManager.class.getName(), fKey) : null);
        if (aSyn) {
            if (fId2Task == null) {
                this.fCon.doTasks(fTask);
            } else {
                this.fCon.doTasks(fTask, fId2Task);
            }
        } else if (fId2Task == null) {
            this.fCon.doTasksNoWait(fTask);
        } else {
            this.fCon.doTasksNoWait(fTask, fId2Task);
        }
    }

    private final VarParam<T> getFromRedisResult_Key(String aKey) {
        if (this.fCon.inConnectError()) {
            return null;
        }
        String fKey = this.fRedisClusterInfo.getDataKey(aKey);
        RedisTaskObj fTask = RedisTaskObj.newReadStrObj(fKey);
        fTask.setSendLog(RedisUtils.getClassDebug(RedisCacheManager.class) ? String.format("[%s] get data from redis ,key='%s'\r\n", RedisCacheManager.class.getName(), fKey) : null);
        this.fCon.doTasks(fTask);
        if (fTask.isConnectionError()) {
            return null;
        }
        fTask.checkResultError();
        String fResult = (String)fTask.getResult();
        if (fResult == null) {
            return null;
        }
        if (StringUtils.isBlank((String)fResult)) {
            return new VarParam(null);
        }
        return new VarParam(this.fObjectLoader.jsonStr2Object(fResult));
    }

    @Override
    public void put2Cache(String aKey, T aDataObject) {
        this.putToRedis_Key(aKey, aDataObject, true);
        this.putExpireInfo_Key(aKey);
    }

    @Override
    public void remove(String aKey) {
        String fKey = this.fRedisClusterInfo.getDataKey(aKey);
        RedisTaskObj fTask = RedisTaskObj.newDelKeysObj(fKey);
        fTask.setSendLog(RedisUtils.getClassDebug(RedisCacheManager.class) ? String.format("[%s] remove data to redis,key='%s'\r\n", RedisCacheManager.class.getName(), fKey) : null);
        this.fCon.doTasksNoWait(fTask);
    }

    @Override
    public boolean containsKey(String key) {
        ExceptionUtils.newUnsupportedOperationException((String)"containsKey()");
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        ExceptionUtils.newUnsupportedOperationException((String)"containsValue()");
        return false;
    }

    @Override
    public void synchronizeSigns(List<SynchronizeSignInfo> aList) {
        Object[] fKeys = SynchronizeSignInfo.list2Keys(aList);
        if (ArrayUtils.isBlankArray((Object[])fKeys)) {
            return;
        }
        RedisTaskObj fTask = RedisTaskObj.newDelKeysObj((String[])fKeys);
        this.fCon.doTasks(fTask);
        fTask.checkResultError();
        for (Object fKey : fKeys) {
            this.fExpireHash.remove(fKey);
        }
    }

    @Override
    public void unInit() throws Exception {
        if (this.fCon != null) {
            this.fCon.uninit();
        }
    }

    public static final <F extends ICacheObj, L> RedisCacheManager<F, L> findRedisCacheManager(ICacheManager<F, L> aManager) {
        if (aManager == null) {
            return null;
        }
        ICacheManager<Object, Object> result = aManager;
        if (result instanceof CompositeCacheManager) {
            CompositeCacheManager fCompositeCacheManager = (CompositeCacheManager)result;
            result = fCompositeCacheManager.getRemoteManager();
        }
        if (result instanceof RedisCacheManager) {
            return (RedisCacheManager)result;
        }
        return null;
    }

    @Override
    public void removeAllId2Keys(String aId2) {
        RedisTaskObj fTask = RedisTaskObj.newHGetAll(this.fRedisClusterInfo.getId2Key(aId2));
        this.fCon.doTasks(fTask);
        if (fTask.getResult() == null) {
            return;
        }
        Map fResultMap = (Map)fTask.getResult();
        if (fResultMap.size() <= 0) {
            return;
        }
        String[] fDelKeys = new String[fResultMap.size()];
        int fIndex = 0;
        for (Map.Entry fEntry : fResultMap.entrySet()) {
            fDelKeys[fIndex++] = this.fRedisClusterInfo.getDataKey((String)fEntry.getKey());
        }
        fTask = RedisTaskObj.newDelKeysObj(this.fRedisClusterInfo.getId2Key(aId2));
        this.fCon.doTasksNoWait(RedisTaskObj.newDelKeysObj(fDelKeys), fTask);
    }

    @Override
    public final void setObjectLoader(ICacheObjectLoader<T, C> aObjectLoader) {
        this.fLoaderBlocked.setObjectLoader(this.fObjectLoader);
        this.fObjectLoader = aObjectLoader;
    }

    @Override
    public void postDataAsync(Exception aPos) {
        boolean fSaveToLog = !this.fCon.setDataAsync(true);
        this.fRedisClusterInfo.saveDataAsyncInfo(fSaveToLog, System.currentTimeMillis(), aPos);
    }

    private class prvExpireInfo {
        private long fPutTime;
        private int fCallTTL;

        private prvExpireInfo() {
        }

        private int testState(long aTime) {
            long fNowTTL = aTime - this.fPutTime;
            if (fNowTTL > (long)RedisCacheManager.this.fTTL) {
                return -2;
            }
            if (fNowTTL > (long)RedisCacheManager.this.fHalfTTL) {
                return RedisCacheManager.this.fTTL - this.fCallTTL;
            }
            return 0;
        }

        private void restCallTTL(long aTime) {
            this.fCallTTL = (int)(aTime - this.fPutTime);
            int fAddTTL = this.testState(aTime);
            if (fAddTTL > 0) {
                RedisCacheManager.this.fUpdateTTLCount.incrementAndGet();
            }
        }

        private void expireTTL() {
            this.fPutTime += (long)this.fCallTTL;
            this.fCallTTL = 0;
        }
    }
}

