/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl;

import com.seeyon.cap4.cache.impl.redisobj.RedisConnection;
import com.seeyon.cap4.cache.impl.redisobj.RedisTaskObj;
import com.seeyon.cap4.cache.inf.IRedisDataVersionManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.songjian.utils.ExceptionUtils;
import org.songjian.utils.StringUtils;
import redis.clients.jedis.Jedis;

public class RedisDataVersionManager
implements IRedisDataVersionManager {
    private static final Log LOGGER = CtpLogFactory.getLog(RedisDataVersionManager.class);
    public static final String C_sKey_DataVersion = "#dataversion:%d";
    public static final String C_sKey_DataVersion_HeartBread = "#dataverheartbread";
    public static final String C_sKey_DataVersionSync = "#versync:";
    private ConcurrentHashMap<Integer, prvDataVerSelect> fDataVersionMap;
    private ConcurrentHashMap<String, prvLoadinfo> fLoaddingMap;
    private RedisConnection fCon;
    private IRedisDataVersionManager.IPrintDebug fPrintDebug;
    private AtomicBoolean fRunSynDataFalge = new AtomicBoolean(false);
    private boolean fSelfCon;
    private volatile long fCustomEventCount;
    private RedisConnection.IHeartBreadTasksEvent fHeartBreadTasksEvent;

    public static String getDataVersionSyncKey(int aDataType, long aDataId) {
        return String.format("%s%d:%d", C_sKey_DataVersionSync, aDataType, aDataId);
    }

    public static String getTTLHead(int aDataType, long aDataId) {
        return String.format("%d:%d", aDataType, aDataId);
    }

    private final int getLocalVersion(prvDataVerSelect aLocalSelect, long aDataId) {
        Integer fLocalVerInteger = (Integer)aLocalSelect.fDataVersionMap.get(aDataId);
        int fLocalVer = fLocalVerInteger == null ? 0 : fLocalVerInteger;
        return fLocalVer;
    }

    private static final int str2Int(String aStr, int aDefault) {
        if (StringUtils.isBlank((String)aStr)) {
            return aDefault;
        }
        try {
            return Integer.parseInt(aStr);
        }
        catch (Exception ex) {
            return aDefault;
        }
    }

    private static final long str2Long(String aStr, int aDefault) {
        if (StringUtils.isBlank((String)aStr)) {
            return aDefault;
        }
        try {
            return Long.parseLong(aStr);
        }
        catch (Exception ex) {
            return aDefault;
        }
    }

    private static String[] split2Arr(String aStr) {
        String[] result = new String[3];
        if (aStr == null) {
            return result;
        }
        int fLen = aStr.length();
        StringBuilder fb = new StringBuilder(20);
        int fIndex = 0;
        for (int i = 0; i < fLen; ++i) {
            char ftemp = aStr.charAt(i);
            if (ftemp == ':') {
                result[fIndex] = fb.toString();
                if (++fIndex == 2) {
                    result[fIndex] = aStr.substring(i + 1, fLen);
                    return result;
                }
                fb = new StringBuilder(20);
                continue;
            }
            fb.append(ftemp);
        }
        result[fIndex] = fb.toString();
        return result;
    }

    public RedisDataVersionManager(RedisConnection aCon, boolean aSelfCon) {
        this.fDataVersionMap = new ConcurrentHashMap();
        this.fLoaddingMap = new ConcurrentHashMap();
        this.fCon = aCon;
        this.fSelfCon = aSelfCon;
        this.fHeartBreadTasksEvent = new prvHeartBreadTasksEvent();
        this.fCon.setHeartBreadTasksEvent(this.fHeartBreadTasksEvent);
    }

    private final String getDataVerKey(int aDataType) {
        return String.format(C_sKey_DataVersion, aDataType);
    }

    private final String getFieldKey(long aField) {
        return String.format("%d", aField);
    }

    private final int toIncValue(Object aValue) {
        if (aValue == null) {
            return 0;
        }
        return Integer.parseInt((String)aValue);
    }

    private final int dataVersionInc(int aDataType, long aDataId) {
        RedisTaskObj fTask = RedisTaskObj.newPutDataVersion(this.getDataVerKey(aDataType), this.getFieldKey(aDataId), RedisDataVersionManager.getDataVersionSyncKey(aDataType, aDataId), RedisDataVersionManager.getTTLHead(aDataType, aDataId));
        this.fCon.doTasks(fTask);
        return this.toIncValue(fTask.getResult());
    }

    private final int[] dataVersionsInc(int aDataType, long[] aDataId) {
        RedisTaskObj[] fTasks = new RedisTaskObj[aDataId.length];
        String fDataKey = this.getDataVerKey(aDataType);
        for (int i = 0; i < fTasks.length; ++i) {
            RedisTaskObj fItem;
            fTasks[i] = fItem = RedisTaskObj.newPutDataVersion(fDataKey, this.getFieldKey(aDataId[i]), RedisDataVersionManager.getDataVersionSyncKey(aDataType, aDataId[i]), RedisDataVersionManager.getTTLHead(aDataType, aDataId[i]));
        }
        this.fCon.doTasks(fTasks);
        int[] result = new int[fTasks.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.toIncValue(fTasks[i].getResult());
        }
        return result;
    }

    public final int getDataVersion(int aDataType, long aDataId) {
        RedisTaskObj fTask = RedisTaskObj.newHGet(this.getDataVerKey(aDataType), this.getFieldKey(aDataId));
        this.fCon.doTasks(fTask);
        if (fTask.getResult() == null) {
            return 0;
        }
        String fValue = (String)fTask.getResult();
        return Integer.parseInt(fValue);
    }

    @Override
    public final void sendNotification(int aDataType, long aDataId) {
        prvDataVerSelect fLocalSelect = this.fDataVersionMap.get(aDataType);
        ExceptionUtils.checkNull_Message((Object)fLocalSelect, (String)"not found bind event,datatype=%d", (Object[])new Object[]{aDataType});
        Integer fLocalVerInteger = (Integer)fLocalSelect.fDataVersionMap.get(aDataId);
        int fLocalVer = fLocalVerInteger == null ? 0 : fLocalVerInteger;
        int fRedisVer = this.dataVersionInc(aDataType, aDataId);
        this.printDebug("sendNotification,datatype=%d,dataid=%d#increase local=%d,redis=%d\r\n", aDataType, aDataId, fLocalVer, fRedisVer);
    }

    @Override
    public final void sendNotifications(int aDataType, long ... aDataIds) {
        prvDataVerSelect fLocalSelect = this.fDataVersionMap.get(aDataType);
        ExceptionUtils.checkNull_Message((Object)fLocalSelect, (String)"not found bind event,datatype=%d", (Object[])new Object[]{aDataType});
        int[] result = this.dataVersionsInc(aDataType, aDataIds);
        StringBuilder fb = new StringBuilder();
        fb.append(String.format("sendNotifications,datatype=%d\r\n", aDataType));
        for (int i = 0; i < result.length; ++i) {
            Integer fLocalVar = (Integer)fLocalSelect.fDataVersionMap.get(aDataIds[i]);
            fb.append(String.format("\tdataid=%d#increase local=%d,redis=%d\r\n", aDataIds[i], fLocalVar, result[i]));
        }
        this.printDebug(fb.toString(), new Object[0]);
    }

    private final String makeLoaddingKey(int aDataType, long aDataId) {
        return String.format("%d:%d", aDataType, aDataId);
    }

    private final prvLoadinfo checkLoadLockOrReturn(String aLoaddingKey) {
        prvLoadinfo fLoadinfo = this.fLoaddingMap.get(aLoaddingKey);
        while (fLoadinfo == null) {
            fLoadinfo = new prvLoadinfo();
            if (this.fLoaddingMap.putIfAbsent(aLoaddingKey, fLoadinfo) == null) {
                this.printDebug("checkLoadLockOrReturn,aLoaddingKey=%s,lock key to load data\r\n", aLoaddingKey);
                return fLoadinfo;
            }
            fLoadinfo = this.fLoaddingMap.get(aLoaddingKey);
        }
        if (fLoadinfo.fLockThread == Thread.currentThread()) {
            this.printDebug("checkLoadLockOrReturn,aLoaddingKey=%s,same thread skip load data\r\n", aLoaddingKey);
            return null;
        }
        this.doLoadWait(fLoadinfo, aLoaddingKey);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doLoadWait(prvLoadinfo aLoadinfo, String aKey) {
        boolean flage = true;
        this.printDebug("doLoadWait,aLoaddingKey=%s,lock thread=%s,wait notify\r\n", aKey, aLoadinfo.fLockThread.getName());
        while (flage) {
            Object object = aLoadinfo.fNotifyObj;
            synchronized (object) {
                try {
                    aLoadinfo.fNotifyObj.wait(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                prvLoadinfo fNowInfo = this.fLoaddingMap.get(aKey);
                if (fNowInfo == null) {
                    return;
                }
                if (fNowInfo.fNotifyObj != aLoadinfo.fNotifyObj) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doNotifyLoadWait(prvLoadinfo aLoadinfo, String aKey) {
        this.fLoaddingMap.remove(aKey);
        Object object = aLoadinfo.fNotifyObj;
        synchronized (object) {
            this.printDebug("doNotifyLoadWait,aLoaddingKey=%s,notify all\r\n", aKey);
            aLoadinfo.fNotifyObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean loadDataAndSetVer(prvDataVerSelect fLocalSelect, prvAsyncDataVerItem aAsyncDataItem, String aPos, boolean aSkipLoad) {
        boolean result = true;
        if (!aSkipLoad) {
            String fLoaddingKey = this.makeLoaddingKey(aAsyncDataItem.fDataType, aAsyncDataItem.fDataId);
            prvLoadinfo fLoadinfo = this.checkLoadLockOrReturn(fLoaddingKey);
            if (fLoadinfo == null) {
                return true;
            }
            try {
                result = fLocalSelect.fEvent.doEvent(aAsyncDataItem);
            }
            finally {
                this.doNotifyLoadWait(fLoadinfo, fLoaddingKey);
            }
            if (!result) {
                return false;
            }
        }
        if (aAsyncDataItem.fRedisVersion == 0) {
            aAsyncDataItem.fRedisVersion = this.dataVersionInc(aAsyncDataItem.fDataType, aAsyncDataItem.fDataId);
        }
        fLocalSelect.fDataVersionMap.put(aAsyncDataItem.fDataId, aAsyncDataItem.fRedisVersion);
        this.printDebug("checkDataVersion,datatype=%d,dataid=%d#loadandsetver local=%d,redis=%d,pos=%s\r\n", aAsyncDataItem.fDataType, aAsyncDataItem.fDataId, aAsyncDataItem.fLocalVersion, aAsyncDataItem.fRedisVersion, aPos);
        return result;
    }

    private final boolean innerCheckDataVersion(int aDataType, long aDataId, boolean aSkipLoad) {
        int fRedisVer = this.getDataVersion(aDataType, aDataId);
        prvDataVerSelect fLocalSelect = this.fDataVersionMap.get(aDataType);
        ExceptionUtils.checkNull_Message((Object)fLocalSelect, (String)"not found bind event,datatype=%d", (Object[])new Object[]{aDataType});
        Integer fLocalVer = (Integer)fLocalSelect.fDataVersionMap.get(aDataId);
        if (fLocalVer != null) {
            int fLocalValue = fLocalVer;
            if (fLocalValue == fRedisVer && fRedisVer != 0) {
                this.printDebug("checkDataVersion,datatype=%d,dataid=%d#sameversion local=%d,redis=%d\r\n", aDataType, aDataId, fLocalValue, fRedisVer);
                return true;
            }
            prvAsyncDataVerItem fAsyncDataItem = new prvAsyncDataVerItem(fLocalValue, aDataType, fRedisVer, aDataId);
            boolean result = this.loadDataAndSetVer(fLocalSelect, fAsyncDataItem, "a", aSkipLoad);
            return result;
        }
        prvAsyncDataVerItem fAsyncDataItem = new prvAsyncDataVerItem(0, aDataType, fRedisVer, aDataId);
        return this.loadDataAndSetVer(fLocalSelect, fAsyncDataItem, "b", aSkipLoad);
    }

    @Override
    public final boolean checkDataVersion(int aDataType, long aDataId) {
        return this.innerCheckDataVersion(aDataType, aDataId, false);
    }

    @Override
    public void syncLocalDataVersion(int aDataType, long aDataId) {
        this.innerCheckDataVersion(aDataType, aDataId, true);
    }

    @Override
    public final void regAsyncDataVerEvent(IRedisDataVersionManager.IOnAsyncDataVerEvent aEvent, int aDataType) {
        ExceptionUtils.checkNull_Message((Object)aEvent, (String)"event is null!", (Object[])new Object[0]);
        prvDataVerSelect fItem = new prvDataVerSelect(aEvent, aDataType);
        prvDataVerSelect fTemp = this.fDataVersionMap.putIfAbsent(aDataType, fItem);
        if (fTemp != null) {
            fTemp.fEvent = aEvent;
        }
    }

    @Override
    public void setPrintDebug(IRedisDataVersionManager.IPrintDebug aPrintDebug) {
        this.fPrintDebug = aPrintDebug;
    }

    private final void printDebug(String aFmt, Object ... args) {
        if (this.fPrintDebug == null) {
            return;
        }
        this.fPrintDebug.printDebug(aFmt, args);
    }

    public final void uninit() {
        if (!this.fSelfCon) {
            return;
        }
        this.fCon.uninit();
    }

    @Override
    public boolean isUseRedisDataVersion() {
        return true;
    }

    @Override
    public long getDoCustomEventCount() {
        return this.fCustomEventCount;
    }

    private class prvSyncTask
    implements Runnable {
        private ArrayList<?> fResultList;

        private prvSyncTask(ArrayList<?> aResultList) {
            this.fResultList = aResultList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RedisDataVersionManager.this.fRunSynDataFalge.set(true);
            try {
                for (Object fObject : this.fResultList) {
                    String fLine;
                    if (fObject == null || StringUtils.isBlank((String)(fLine = (String)fObject))) continue;
                    String[] fStrArry = RedisDataVersionManager.split2Arr(fLine);
                    int fDataType = RedisDataVersionManager.str2Int(fStrArry[0], -1);
                    long fDataId = RedisDataVersionManager.str2Long(fStrArry[1], -1);
                    int fRedisVersion = RedisDataVersionManager.str2Int(fStrArry[2], -1);
                    if (fDataType < 0 || fDataId < 0L || fRedisVersion < 0) continue;
                    prvDataVerSelect fLocalSelect = (prvDataVerSelect)RedisDataVersionManager.this.fDataVersionMap.get(fDataType);
                    ExceptionUtils.checkNull_Message((Object)fLocalSelect, (String)"not found bind event,datatype=%d", (Object[])new Object[]{fDataType});
                    int fLocalValue = RedisDataVersionManager.this.getLocalVersion(fLocalSelect, fDataId);
                    if (fLocalValue == fRedisVersion) {
                        RedisDataVersionManager.this.printDebug("prvSyncTask.run skip local=%d,redis=%d\r\n", new Object[]{fLocalValue, fRedisVersion});
                        continue;
                    }
                    prvAsyncDataVerItem fAsyncDataItem = new prvAsyncDataVerItem(fLocalValue, fDataType, fRedisVersion, fDataId);
                    RedisDataVersionManager.this.loadDataAndSetVer(fLocalSelect, fAsyncDataItem, "prvSyncTask", false);
                }
            }
            finally {
                RedisDataVersionManager.this.fRunSynDataFalge.set(false);
            }
        }
    }

    private class prvHeartBreadTasksEvent
    implements RedisConnection.IHeartBreadTasksEvent {
        private String fScriptKey;
        private ExecutorService fRunSyncThread;
        private volatile long fOldCustom;

        @Override
        public final void uninit() {
            if (this.fRunSyncThread != null) {
                this.fRunSyncThread.shutdownNow();
            }
        }

        private prvHeartBreadTasksEvent() {
            this.fRunSyncThread = Executors.newSingleThreadExecutor(new ThreadFactory(){
                private AtomicInteger threadNum = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "Cap4RedisData_Thread_" + this.threadNum.getAndIncrement());
                }
            });
            this.fScriptKey = "#versync:*";
            this.fOldCustom = -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doCustomEvent(Jedis aJedis, long aHeatBeatCount, long aModifyVersion) {
            if (this.fOldCustom == aModifyVersion && aHeatBeatCount % 10L != 1L) {
                return;
            }
            RedisDataVersionManager.this.fCustomEventCount++;
            if (RedisDataVersionManager.this.fCustomEventCount > 2000000000L && RedisDataVersionManager.this.fCustomEventCount % 100000L == 0L) {
                RedisDataVersionManager.this.fCustomEventCount = RedisDataVersionManager.this.fCustomEventCount - 2000000000L;
            }
            try {
                ArrayList<String> fResultList;
                try {
                    RedisDataVersionManager.this.printDebug("do custom event,HeatBeatCount=%d,old=%d,now=%d\r\n", new Object[]{aHeatBeatCount, this.fOldCustom, aModifyVersion});
                    fResultList = RedisDataVersionManager.this.fCon.doGetLikeKeyValues(this.fScriptKey, aJedis);
                }
                catch (Exception ex) {
                    RedisDataVersionManager.this.fCon.setScriptError(true);
                    throw ex;
                }
                this.runSyncThread(fResultList);
            }
            catch (Throwable ex) {
                LOGGER.error((Object)ex.getMessage(), ex);
            }
            finally {
                this.fOldCustom = aModifyVersion;
            }
        }

        private final void runSyncThread(ArrayList<?> aResultList) {
            if (aResultList == null || aResultList.size() <= 0) {
                return;
            }
            if (RedisDataVersionManager.this.fRunSynDataFalge.get()) {
                RedisDataVersionManager.this.printDebug("runSyncThread skip RunSynDataFalge=true\r\n", new Object[0]);
                return;
            }
            RedisDataVersionManager.this.printDebug("runSyncThread count=%d\r\n", new Object[]{aResultList.size()});
            prvSyncTask fTaskItem = new prvSyncTask(aResultList);
            this.fRunSyncThread.submit(fTaskItem);
        }

        @Override
        public String getModifyKey() {
            return RedisDataVersionManager.C_sKey_DataVersion_HeartBread;
        }
    }

    private static class prvAsyncDataVerItem
    implements IRedisDataVersionManager.IAsyncDataVerItem {
        private int fLocalVersion;
        private int fDataType;
        private int fRedisVersion;
        private long fDataId;

        private prvAsyncDataVerItem(int aLocalVersion, int aDataType, int aRedisVersion, long aDataId) {
            this.fLocalVersion = aLocalVersion;
            this.fDataType = aDataType;
            this.fRedisVersion = aRedisVersion;
            this.fDataId = aDataId;
        }

        @Override
        public int getLocalVersion() {
            return this.fLocalVersion;
        }

        @Override
        public int getDataType() {
            return this.fDataType;
        }

        @Override
        public int getRedisVersion() {
            return this.fRedisVersion;
        }

        @Override
        public long getDataId() {
            return this.fDataId;
        }
    }

    private static class prvDataVerSelect {
        private IRedisDataVersionManager.IOnAsyncDataVerEvent fEvent;
        private ConcurrentHashMap<Long, Integer> fDataVersionMap;

        public prvDataVerSelect(IRedisDataVersionManager.IOnAsyncDataVerEvent aEvent, int aDataType) {
            this.fEvent = aEvent;
            this.fDataVersionMap = new ConcurrentHashMap();
        }
    }

    private static class prvLoadinfo {
        private Thread fLockThread = Thread.currentThread();
        private Object fNotifyObj = new Object();

        private prvLoadinfo() {
        }
    }
}

