/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl;

import com.seeyon.cap4.cache.CacheEngine;
import com.seeyon.cap4.cache.ConfigItem;
import com.seeyon.cap4.cache.ConfigItem_RemoteCache;
import com.seeyon.cap4.cache.SynchronizeSignInfo;
import com.seeyon.cap4.cache.impl.AbsCacheManager;
import com.seeyon.cap4.cache.impl.CacheManagerUtils;
import com.seeyon.cap4.cache.inf.ICacheObj;
import com.seeyon.cap4.cache.inf.ICacheObjectLoader;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.songjian.utils.ExceptionUtils;
import org.songjian.utils.StringUtils;

public class RemoteCacheManager<T extends ICacheObj, C>
extends AbsCacheManager<T, C> {
    private ConcurrentHashMap<String, byte[]> fDataHash;
    private String fLoadCallFormat;
    private String fSaveCallFormat;
    private String fRemoveCallFormat;
    private String fObjType;

    @Override
    public void init(ConfigItem aConfigItem) throws Exception {
        this.fDataHash = new ConcurrentHashMap();
        ConfigItem_RemoteCache fRemoteCache = aConfigItem.getRemoteCacheInfo();
        this.fObjType = fRemoteCache.getObjType();
        this.fLoadCallFormat = fRemoteCache.getLoadCallFormat();
        this.fSaveCallFormat = fRemoteCache.getSaveCallFormat();
        this.fRemoveCallFormat = fRemoteCache.getRemoveCallFormat();
        this.fObjectLoader = CacheManagerUtils.newClassNameObj(fRemoteCache.getObjectLoaderName(), ICacheObjectLoader.class);
    }

    private final byte[] loadFromRemote(String aKey) {
        return this.fDataHash.get(aKey);
    }

    private final void saveToRemote(String aKey, byte[] aData, String aSign) {
        String fCallUrl = String.format(this.fSaveCallFormat, this.fObjType, aKey, aSign);
        if (aData == null) {
            return;
        }
        this.fDataHash.put(aKey, aData);
    }

    private final void removeToRemote(List<SynchronizeSignInfo> aList) {
        String fKeys = "";
        for (SynchronizeSignInfo fSignInfo : aList) {
            if (fSignInfo == null) continue;
            if (StringUtils.isNoBlank((String)fKeys)) {
                fKeys = fKeys + ",";
            }
            fKeys = fKeys + fSignInfo.getKey();
            this.fDataHash.remove(fSignInfo.getKey());
        }
        String fCallUrl = String.format(this.fRemoveCallFormat, this.fObjType, fKeys);
    }

    @Override
    public T getFromCache(String aKey, C aContext) {
        byte[] fData = this.loadFromRemote(aKey);
        if (fData != null) {
            Object result = this.fObjectLoader.bytes2Object(fData);
            CacheEngine.setDebugStateIfNull("from remote cache");
            return result;
        }
        T result = this.loadObject(aKey, aContext);
        CacheEngine.setDebugState("remote loaded");
        if (result == null) {
            return null;
        }
        this.fDataHash.put(aKey, this.fObjectLoader.object2Bytes(result));
        return result;
    }

    private T loadObject(String aKey, C aContext) {
        if (this.fObjectLoader == null) {
            return null;
        }
        Object result = this.fObjectLoader.loadObject(aKey, aContext);
        return result;
    }

    @Override
    public void put2Cache(String aKey, T aDataObject) {
        if (aDataObject == null) {
            return;
        }
        try {
            this.saveToRemote(aKey, this.fObjectLoader.object2Bytes(aDataObject), aDataObject.getSign());
        }
        catch (Exception ex) {
            ExceptionUtils.raiseException((Exception)ex);
        }
    }

    @Override
    public void remove(String key) {
        this.fDataHash.remove(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.fDataHash.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.fDataHash.containsValue(value);
    }

    @Override
    public void synchronizeSigns(List<SynchronizeSignInfo> aList) {
        this.removeToRemote(aList);
    }

    @Override
    public void unInit() throws Exception {
    }
}

