/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl.redisobj;

import com.seeyon.cap4.cache.impl.redisobj.ConnectLogObj;
import com.seeyon.cap4.cache.impl.redisobj.IV5Environment;
import com.seeyon.cap4.cache.impl.redisobj.RedisUtils;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Datetimes;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.songjian.utils.ArrayListEx;
import org.songjian.utils.BackgroundExecutor;
import org.songjian.utils.sql.SQLUtils;

public class CacheLogUtils {
    private static final Log LOGGER = CtpLogFactory.getLog(CacheLogUtils.class);
    private static boolean fSqliteOK;
    private volatile String fCurrentTimeStr;
    private volatile long fLastTableTime;
    private static final long C_lMod_Day = 151200000L;
    private BackgroundExecutor fBackgroundExecutor = BackgroundExecutor.getBackgroundExecutor();
    private ConcurrentHashMap<String, Integer> fDataAsyncMap = new ConcurrentHashMap();
    private static final String C_sSQL_SelectDataAsync = "select sid,pos from dataasync";
    private volatile boolean fInited;
    private static final String C_sFileName_CacheInfo = "capcache/cacheinfo.db";
    private static final String C_sSQL_InsertConnectLog = "insert into connectlog_%s(connectid,dstate,dtime,ddata)  values(?,?,?,?)";
    private static final String C_sSQL_InsertDataAsync = "insert into dataasync(dtime,pos)  values(?,?)";
    private prvSaveTask fSaveTask;

    private void testAndCreateLogTableName() throws Exception {
        long ftemp = System.currentTimeMillis() / 151200000L;
        if (ftemp == this.fLastTableTime) {
            return;
        }
        Date fNow = new Date();
        this.fLastTableTime = fNow.getTime();
        this.fCurrentTimeStr = Datetimes.format((Date)fNow, (String)"yyyy_MM_dd");
        this.createSaveTables(this.fCurrentTimeStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadDataAsyncMap(Connection aCon) throws Exception {
        PreparedStatement fPs = null;
        ResultSet fRs = null;
        fPs = aCon.prepareStatement(C_sSQL_SelectDataAsync);
        try {
            fRs = SQLUtils.queryPs((PreparedStatement)fPs, (Object[])new Object[0]);
            while (fRs.next()) {
                int fIndex = 1;
                Integer fSid = fRs.getInt(fIndex);
                String fKey = fRs.getString(++fIndex).trim();
                this.fDataAsyncMap.put(fKey, fSid);
            }
        }
        finally {
            if (fRs != null) {
                fRs.close();
            }
            if (fPs != null) {
                fPs.close();
            }
        }
    }

    public static boolean isSQLiteOK() {
        return fSqliteOK;
    }

    public CacheLogUtils() {
        try {
            Class.forName("org.sqlite.JDBC");
            fSqliteOK = true;
        }
        catch (Exception ex) {
            fSqliteOK = false;
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.fSaveTask = new prvSaveTask();
        this.fBackgroundExecutor.addTask((Runnable)((Object)this.fSaveTask));
    }

    public void init() throws Exception {
        if (this.fInited) {
            return;
        }
        this.testAndCreateLogTableName();
        this.fInited = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createSaveTables(String aTimeStr) throws Exception {
        String fFileName = CacheLogUtils.makeSaveFile();
        String fConUrl = "jdbc:sqlite:" + fFileName;
        Connection fCon = DriverManager.getConnection(fConUrl);
        try {
            fCon.setAutoCommit(false);
            try {
                try {
                    SQLUtils.execResourceSQLFmt((Connection)fCon, CacheLogUtils.class, (String)"SQL_Createtables.properties", (Object[])new Object[]{aTimeStr});
                    SQLUtils.execResourceSQLFmt((Connection)fCon, CacheLogUtils.class, (String)"SQL_CreatetablesPos.properties", (Object[])new Object[0]);
                    this.loadDataAsyncMap(fCon);
                    fCon.commit();
                }
                catch (Exception ex) {
                    fCon.rollback();
                    throw ex;
                }
            }
            finally {
                fCon.setAutoCommit(true);
            }
        }
        finally {
            fCon.close();
        }
    }

    public static final String makeSaveFile() {
        IV5Environment f5Environment = RedisUtils.getV5Environment();
        File result = new File(f5Environment.getLocalSavePath(), "monitor");
        if (!(result = new File(result, C_sFileName_CacheInfo)).getParentFile().exists()) {
            result.getParentFile().mkdirs();
        }
        return result.getAbsolutePath();
    }

    private final void saveDataAsync(Connection fCon, List<ConnectLogObj> aList) throws Exception {
        if (aList == null || aList.size() <= 0) {
            return;
        }
        SQLUtils.doSQLListItem(aList, (Connection)fCon, (String)C_sSQL_InsertDataAsync, aList, (SQLUtils.ISQLTask)new SQLUtils.ISQLTask<Object, ConnectLogObj>(){

            public void doTask(Object aContext, PreparedStatement aPs, ConnectLogObj aItem) throws Exception {
                int fIndex = 1;
                aPs.setString(fIndex, aItem.getTime());
                String fData = CacheLogUtils.this.getExStr(aItem.getEx());
                aPs.setString(++fIndex, fData);
                ++fIndex;
            }
        });
    }

    private final void saveLogs(Connection fCon, List<ConnectLogObj> aList) throws Exception {
        if (aList == null || aList.size() <= 0) {
            return;
        }
        String fSQL = String.format(C_sSQL_InsertConnectLog, this.fCurrentTimeStr);
        SQLUtils.doSQLListItem(aList, (Connection)fCon, (String)fSQL, aList, (SQLUtils.ISQLTask)new SQLUtils.ISQLTask<Object, ConnectLogObj>(){

            public void doTask(Object aContext, PreparedStatement aPs, ConnectLogObj aItem) throws Exception {
                int fIndex = 1;
                aPs.setString(fIndex, aItem.getConnectid());
                aPs.setString(++fIndex, aItem.getState());
                aPs.setString(++fIndex, aItem.getTime());
                ++fIndex;
                String fData = "";
                if (aItem.getConfigObj() != null) {
                    fData = String.format(" host=%s,port=%d,db=%d\r\n", aItem.getConfigObj().getHost(), aItem.getConfigObj().getPort(), aItem.getConfigObj().getDatabase());
                }
                fData = aItem.getEx() != null ? fData + CacheLogUtils.this.getExStr(aItem.getEx()) : fData + aItem.getData();
                aPs.setString(fIndex, fData);
                ++fIndex;
            }
        });
    }

    private static final SocketException getConnectException(Exception aEx) {
        Throwable fEx = aEx;
        for (int i = 0; i < 10; ++i) {
            if (fEx == null) {
                return null;
            }
            if (fEx instanceof SocketException) {
                return (SocketException)fEx;
            }
            fEx = fEx.getCause();
        }
        return null;
    }

    private final String getExStr(Exception aEx) {
        SocketException fSocketException = CacheLogUtils.getConnectException(aEx);
        if (fSocketException != null) {
            return fSocketException.getMessage();
        }
        StringWriter fWriter = new StringWriter(1000);
        if (null != aEx) {
            aEx.printStackTrace(new PrintWriter(fWriter));
        }
        return fWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doSaveLog(List<ConnectLogObj> aLogList, List<ConnectLogObj> aDataAsyncList) throws Exception {
        this.init();
        String fFileName = CacheLogUtils.makeSaveFile();
        String fConUrl = "jdbc:sqlite:" + fFileName;
        Connection fCon = DriverManager.getConnection(fConUrl);
        try {
            fCon.setAutoCommit(false);
            try {
                try {
                    this.saveLogs(fCon, aLogList);
                    this.saveDataAsync(fCon, aDataAsyncList);
                    fCon.commit();
                }
                catch (Exception ex) {
                    fCon.rollback();
                    throw ex;
                }
            }
            finally {
                fCon.setAutoCommit(true);
            }
        }
        finally {
            fCon.close();
        }
    }

    public final void saveConnectLogObj(ConnectLogObj aConnectLogObj) {
        this.fSaveTask.addToList(aConnectLogObj);
        this.fBackgroundExecutor.getWait().notifyInactiveWait();
    }

    public final void saveDataAsyncObj(ConnectLogObj aConnectLogObj) {
        if (!this.fSaveTask.addDataAsyncToList(aConnectLogObj)) {
            return;
        }
        this.fBackgroundExecutor.getWait().notifyInactiveWait();
    }

    public final void saveLogAndDataAsyncObj(ConnectLogObj aConnectLogObj) {
        this.fSaveTask.addToList(aConnectLogObj);
        this.fSaveTask.addDataAsyncToList(aConnectLogObj);
        this.fBackgroundExecutor.getWait().notifyInactiveWait();
    }

    private class prvSaveTask
    implements BackgroundExecutor.RunnableEnd {
        private ArrayListEx<ConnectLogObj> fThreadList = new ArrayListEx(50);
        private ArrayListEx<ConnectLogObj> fDataAsyncList = new ArrayListEx(50);

        private prvSaveTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void addToList(ConnectLogObj aObj) {
            ArrayListEx<ConnectLogObj> arrayListEx = this.fThreadList;
            synchronized (arrayListEx) {
                this.fThreadList.add((Object)aObj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean addDataAsyncToList(ConnectLogObj aObj) {
            String fKey = CacheLogUtils.this.getExStr(aObj.getEx());
            fKey = fKey.trim();
            if (CacheLogUtils.this.fDataAsyncMap.containsKey(fKey)) {
                return false;
            }
            CacheLogUtils.this.fDataAsyncMap.put(fKey, 0);
            ArrayListEx<ConnectLogObj> arrayListEx = this.fDataAsyncList;
            synchronized (arrayListEx) {
                this.fDataAsyncList.add((Object)aObj);
            }
            return true;
        }

        public void run() {
            this.doSave();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doSave() {
            ArrayListEx fTemp_LogList = null;
            ArrayListEx fTemp_DataAsyn = null;
            ArrayListEx<ConnectLogObj> arrayListEx = this.fThreadList;
            synchronized (arrayListEx) {
                if (this.fThreadList.size() > 0) {
                    fTemp_LogList = new ArrayListEx(this.fThreadList);
                    this.fThreadList.reNew(50);
                }
            }
            arrayListEx = this.fDataAsyncList;
            synchronized (arrayListEx) {
                if (this.fDataAsyncList.size() > 0) {
                    fTemp_DataAsyn = new ArrayListEx(this.fDataAsyncList);
                    this.fDataAsyncList.reNew(50);
                }
            }
            try {
                CacheLogUtils.this.doSaveLog((List<ConnectLogObj>)fTemp_LogList, (List<ConnectLogObj>)fTemp_DataAsyn);
            }
            catch (Exception ex) {
                LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }

        public void onEnd() {
            try {
                CacheLogUtils.this.doSaveLog((List<ConnectLogObj>)this.fThreadList, (List<ConnectLogObj>)this.fDataAsyncList);
            }
            catch (Exception ex) {
                LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            }
            this.fThreadList.clear();
            this.fDataAsyncList.clear();
        }
    }
}

