/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl.redisobj;

import com.seeyon.cap4.cache.impl.ICacheMonitor;
import com.seeyon.cap4.cache.impl.redisobj.CacheLogUtils;
import com.seeyon.cap4.cache.impl.redisobj.ConnectLogObj;
import com.seeyon.cap4.cache.impl.redisobj.IRedisClusterInfo;
import com.seeyon.cap4.cache.impl.redisobj.IV5Environment;
import com.seeyon.cap4.cache.impl.redisobj.RedisClientInfo;
import com.seeyon.cap4.cache.impl.redisobj.RedisConfigObj;
import com.seeyon.cap4.cache.impl.redisobj.RedisConnection;
import com.seeyon.cap4.cache.impl.redisobj.RedisLuaScriprt;
import com.seeyon.cap4.cache.impl.redisobj.RedisServerTime;
import com.seeyon.cap4.cache.impl.redisobj.RedisUtils;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.songjian.utils.ArrayListFixType;
import org.songjian.utils.ArrayUtils;
import org.songjian.utils.ExceptionUtils;
import org.songjian.utils.JSONUtils;
import org.songjian.utils.StringUtils;
import org.songjian.utils.json.JSONArray;
import org.songjian.utils.json.JSONObject;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisClusterInfo
implements IRedisClusterInfo {
    private static final Log LOGGER = CtpLogFactory.getLog(RedisClusterInfo.class);
    public static final int C_iState_StartConnect = 1;
    public static final int C_iState_Connected = 2;
    public static final int C_iState_ConnectError = 3;
    public static final int C_iState_ReConnect = 4;
    public static final int C_iState_NotUseCache = 5;
    public static final int C_iState_ModifyData = 6;
    public static final int C_iState_DisConnect = 7;
    public static final int C_iState_DataAsync = 8;
    public static final String C_sState_StartConnect = "startconnect";
    public static final String C_sState_Connected = "connected";
    public static final String C_sState_ConnectError = "connecterror";
    public static final String C_sState_ReConnect = "reconnect";
    public static final String C_sState_NotUseCache = "notusecache";
    public static final String C_sState_ModifyData = "modifydata";
    public static final String C_sState_DisConnect = "disconnect";
    public static final String C_sState_DataAsync = "dataasync";
    private RedisClientInfo fRedisClientInfo;
    private String fStartId;
    private long fStartTime;
    private RedisServerTime fServerTimeUtils;
    private RedisClientInfo fMasterInfo;
    private RedisClientInfo[] fSlaveArray;
    private CacheLogUtils fCacheLogUtils;
    private ICacheMonitor fCacheMonitor;
    private ConcurrentHashMap<String, Long> fModifyData;
    private volatile long fHeatBeatCount;
    private Long fConnectTime;
    private RedisConfigObj fConfigObj;
    public static final int C_iLen_StartIdLen = 40;
    private RedisLuaScriprt[] fInitScripts;
    private static final int C_lTime_OutOfStartTime = 60000;

    @Override
    public ICacheMonitor getCacheMonitor() {
        return this.fCacheMonitor;
    }

    public RedisClientInfo getRedisClientInfo() {
        return this.fRedisClientInfo;
    }

    @Override
    public void setCacheMonitor(ICacheMonitor aCacheMonitor) {
        this.fCacheMonitor = aCacheMonitor;
    }

    public RedisClusterInfo(RedisClientInfo aRedisClientInfo, RedisConfigObj aConfigObj, RedisServerTime aServerTimeUtils, CacheLogUtils aCacheLogUtils, RedisLuaScriprt[] aInitScripts) {
        this.fInitScripts = aInitScripts;
        this.fRedisClientInfo = aRedisClientInfo;
        this.fServerTimeUtils = aServerTimeUtils;
        this.fConfigObj = aConfigObj;
        this.fCacheLogUtils = aCacheLogUtils;
        if (this.fCacheLogUtils == null) {
            this.fCacheLogUtils = new CacheLogUtils();
            try {
                this.fCacheLogUtils.init();
            }
            catch (Exception ex) {
                ExceptionUtils.raiseException((Exception)ex);
            }
        }
        this.fModifyData = new ConcurrentHashMap();
    }

    @Override
    public final String getDataKey(String aKey) {
        return "#data:" + aKey;
    }

    @Override
    public final String getDataAsyncKey() {
        return "#dataasync";
    }

    @Override
    public String getId2Key(String aKey) {
        return "#id2:" + aKey;
    }

    public CacheLogUtils getCacheLogUtils() {
        return this.fCacheLogUtils;
    }

    public void setCacheLogUtils(CacheLogUtils aCacheLogUtils) {
        this.fCacheLogUtils = aCacheLogUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T doRedisCall(Jedis aJedis, IRedisCalls<T> aCalls) {
        if (aCalls == null) {
            return null;
        }
        ArrayList fRsList = new ArrayList();
        Pipeline fPL = aJedis.pipelined();
        try {
            aCalls.doCalls(fPL, fRsList);
            fPL.sync();
            T t = aCalls.onResult(fRsList);
            return t;
        }
        finally {
            try {
                fPL.close();
            }
            catch (IOException e) {
                throw new JedisConnectionException((Throwable)e);
            }
        }
    }

    public final long getCurrentTime_Server() {
        return this.fServerTimeUtils.getServerTime();
    }

    public final Long toServerTime(Long aTime) {
        return this.fServerTimeUtils.toServerTime(aTime);
    }

    public final Long toLocalTime(Long aTime) {
        return this.fServerTimeUtils.toLocalTime(aTime);
    }

    @Override
    public final boolean initStartId(Jedis aJedis) {
        final long fServerTime = RedisClusterInfo.parseSeverTime(aJedis.time(), false);
        long fLocalTime = System.currentTimeMillis();
        this.fServerTimeUtils.updateServerTime(System.currentTimeMillis(), fServerTime);
        this.fRedisClientInfo.setTime(fLocalTime);
        this.fHeatBeatCount = 0L;
        String fOldStartId = this.fStartId;
        RedisUtils.loadLuaScript(aJedis, this.fInitScripts);
        this.doRedisCall(aJedis, new IRedisCalls<String>(){
            private String fCurrentStartId = "";

            @Override
            public void doCalls(Pipeline aPL, List<Response<?>> aRsList) {
                this.fCurrentStartId = StringUtils.createValueName((int)40);
                aRsList.add(aPL.setnx("#capstartid", this.fCurrentStartId));
                aRsList.add(aPL.get("#capstartid"));
                aRsList.add(RedisClusterInfo.plSetNx(aPL, "#capstarttime", fServerTime));
                aRsList.add(RedisClusterInfo.plget(aPL, "#capstarttime"));
                aRsList.add(RedisClusterInfo.plHset(aPL, "#capconnecttime", RedisClusterInfo.this.fRedisClientInfo.getId(), fServerTime));
                String fClientInfo = RedisClusterInfo.this.fRedisClientInfo.toJSONString();
                if (RedisClusterInfo.this.fRedisClientInfo.isMaster()) {
                    aRsList.add(aPL.set("#capmasterserver", fClientInfo));
                } else {
                    aRsList.add(aPL.hset("#capslaveserver", RedisClusterInfo.this.fRedisClientInfo.getId(), fClientInfo));
                }
            }

            @Override
            public String onResult(List<Response<?>> aRsList) {
                boolean C_iIndex_getStratId = true;
                int C_iIndex_StartTime = 3;
                RedisClusterInfo.this.fStartId = (String)RedisClusterInfo.getResultValue(aRsList.get(1), String.class);
                RedisClusterInfo.this.fStartTime = RedisClusterInfo.getResultValueLong(aRsList.get(3));
                RedisClusterInfo.this.fConnectTime = fServerTime;
                IV5Environment fEnvironment = RedisUtils.getV5Environment();
                JSONObject fConfigJSON = new JSONObject();
                fConfigJSON.put("redis_host", (Object)fEnvironment.getRedisHost());
                fConfigJSON.put("redis_port", (Object)fEnvironment.getRedisPort());
                fConfigJSON.put("serverid", (Object)fEnvironment.getServerId());
                fConfigJSON.put("ttl", (Object)RedisClusterInfo.this.fConfigObj.getTTLSec());
                fConfigJSON.put("startid", (Object)RedisClusterInfo.this.fStartId);
                fConfigJSON.put("connectime", (Object)StringUtils.getDateStrFromLong((long)RedisClusterInfo.this.fConnectTime));
                fConfigJSON.put("logfile", (Object)CacheLogUtils.makeSaveFile());
                RedisUtils.notifyEvent(RedisClusterInfo.this.fCacheMonitor, 4, fConfigJSON.toJSONString());
                return this.fCurrentStartId;
            }
        });
        boolean result = StringUtils.sameString((String)this.fStartId, (String)fOldStartId);
        String fConnectedData = String.format("serverid=%s,ModifyData=%d,ConnectTime=%s", this.fRedisClientInfo.getId(), this.fModifyData.size(), ConnectLogObj.getTimeStr(this.fStartTime));
        if (result) {
            this.addConnectLog(this.fStartId, System.currentTimeMillis(), C_sState_ReConnect, fConnectedData);
        } else {
            if (fOldStartId != null) {
                fConnectedData = fConnectedData + ",oldConnectid=" + fOldStartId;
            }
            this.addConnectLog(this.fStartId, System.currentTimeMillis(), C_sState_Connected, fConnectedData);
        }
        return result;
    }

    @Override
    public boolean sendHeartBeat(Jedis aJedis, RedisConnection.IHeartBreadTasksEvent aHeartBreadTasksEvent) {
        String fOldStartId = this.fStartId;
        final RedisConnection.IHeartBreadTasksEvent fHeartBreadTasksEvent = aHeartBreadTasksEvent;
        final Jedis fThisJedis = aJedis;
        Boolean fReInit = this.doRedisCall(aJedis, new IRedisCalls<Boolean>(){
            private boolean fDoCustomFlage;

            private final boolean doGetClientServerInfo() {
                return RedisClusterInfo.this.fHeatBeatCount % 20L == 0L;
            }

            @Override
            public void doCalls(Pipeline aPL, List<Response<?>> aRsList) {
                this.fDoCustomFlage = fHeartBreadTasksEvent != null;
                aRsList.add(RedisClusterInfo.plHset(aPL, "#capheatbeat", RedisClusterInfo.this.fRedisClientInfo.getId(), RedisClusterInfo.this.getCurrentTime_Server()));
                aRsList.add(aPL.get("#capstartid"));
                aRsList.add(aPL.time());
                if (this.doGetClientServerInfo()) {
                    aRsList.add(aPL.get("#capmasterserver"));
                    aRsList.add(aPL.hgetAll("#capslaveserver"));
                }
                if (this.fDoCustomFlage) {
                    aRsList.add(aPL.get(fHeartBreadTasksEvent.getModifyKey()));
                }
            }

            private void doCustomHeartBreadEvent(Jedis aJedis, long aModifyVersion) {
                if (fHeartBreadTasksEvent == null) {
                    return;
                }
                try {
                    fHeartBreadTasksEvent.doCustomEvent(aJedis, RedisClusterInfo.this.fHeatBeatCount, aModifyVersion);
                }
                catch (Throwable ex) {
                    LOGGER.error((Object)ex.getMessage(), ex);
                }
            }

            @Override
            public Boolean onResult(List<Response<?>> aRsList) {
                int C_iIndex_CustomModify;
                boolean C_iIndex_getStartId = true;
                int C_iIndex_getTime = 2;
                int C_iIndex_MasterServer = 3;
                int C_iIndex_SlaveServer = 4;
                String fCurrentStartId = (String)RedisClusterInfo.getResultValue(aRsList.get(1), String.class);
                Long fServerTime = RedisClusterInfo.parseSeverTime((List)RedisClusterInfo.getResultValue(aRsList.get(2), List.class), false);
                RedisClusterInfo.this.fServerTimeUtils.updateServerTime(System.currentTimeMillis(), fServerTime);
                if (this.doGetClientServerInfo()) {
                    String fMasterStr = (String)RedisClusterInfo.getResultValue(aRsList.get(3), String.class);
                    RedisClusterInfo.this.fMasterInfo = (RedisClientInfo)JSONUtils.parseJSonStr_Class((String)fMasterStr, RedisClientInfo.class);
                    ArrayListFixType fSaveList = new ArrayListFixType(RedisClientInfo.class);
                    Map fSlaveMap = (Map)RedisClusterInfo.getResultValue(aRsList.get(4), Map.class);
                    for (Map.Entry fEntry : fSlaveMap.entrySet()) {
                        RedisClientInfo ftemp = (RedisClientInfo)JSONUtils.parseJSonStr_Class((String)((String)fEntry.getValue()), RedisClientInfo.class);
                        if (ftemp == null) continue;
                        fSaveList.add((Object)ftemp);
                    }
                    RedisClusterInfo.access$1402(RedisClusterInfo.this, (RedisClientInfo[])fSaveList.exportArray());
                    JSONObject fRuninfoObj = new JSONObject();
                    fRuninfoObj.put("heartbeat_time", (Object)StringUtils.getDateStrFromLong((long)fServerTime));
                    fRuninfoObj.put("master", (Object)fMasterStr);
                    fRuninfoObj.put("master_info", (Object)RedisClusterInfo.this.getRunInfo(RedisClusterInfo.this.fMasterInfo));
                    fRuninfoObj.put("slave_list", (Object)RedisClusterInfo.this.getSlaveArrayRunInfo(RedisClusterInfo.this.fSlaveArray));
                    RedisUtils.notifyEvent(RedisClusterInfo.this.fCacheMonitor, 5, fRuninfoObj.toJSONString());
                    C_iIndex_CustomModify = 5;
                } else {
                    C_iIndex_CustomModify = 3;
                }
                if (this.fDoCustomFlage) {
                    long fCustomModify = RedisUtils.getResultStrLong(aRsList.get(C_iIndex_CustomModify), -1L);
                    this.doCustomHeartBreadEvent(fThisJedis, fCustomModify);
                }
                RedisClusterInfo.this.fHeatBeatCount++;
                RedisClusterInfo.this.fHeatBeatCount = RedisUtils.resetlong(RedisClusterInfo.this.fHeatBeatCount);
                return !StringUtils.sameString((String)RedisClusterInfo.this.fStartId, (String)fCurrentStartId);
            }
        });
        if (fReInit.booleanValue()) {
            this.reInit(aJedis, fOldStartId);
        }
        return fReInit;
    }

    private final JSONObject getRunInfo(RedisClientInfo aInfo) {
        if (aInfo == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put("id", (Object)aInfo.getId());
        result.put("ismaster", (Object)aInfo.isMaster());
        return result;
    }

    private final JSONArray getSlaveArrayRunInfo(RedisClientInfo[] aSlaveArray) {
        JSONArray result = new JSONArray();
        if (ArrayUtils.isBlankArray((Object[])aSlaveArray)) {
            return result;
        }
        for (RedisClientInfo fInfo : aSlaveArray) {
            if (fInfo == null) continue;
            result.add((Object)this.getRunInfo(fInfo));
        }
        return result;
    }

    public Boolean cacheDowngrade(Jedis aJedis, String aStartId) {
        this.addConnectLog(aStartId, System.currentTimeMillis(), C_sState_NotUseCache, "");
        return null;
    }

    @Override
    public void saveOnErrorInfo(long aTime, Exception aEx) {
        if (!CacheLogUtils.isSQLiteOK()) {
            return;
        }
        ConnectLogObj fConnectLogObj = new ConnectLogObj();
        fConnectLogObj.setConnectid(this.fStartId);
        fConnectLogObj.setTime(aTime);
        fConnectLogObj.setState(C_sState_ConnectError);
        fConnectLogObj.setEx(aEx);
        fConnectLogObj.setConfigObj(this.fConfigObj);
        this.fCacheLogUtils.saveConnectLogObj(fConnectLogObj);
    }

    @Override
    public void saveDataAsyncInfo(boolean aSaveLog, long aTime, Exception aEx) {
        if (!CacheLogUtils.isSQLiteOK()) {
            return;
        }
        ConnectLogObj fConnectLogObj = new ConnectLogObj();
        fConnectLogObj.setConnectid(this.fStartId);
        fConnectLogObj.setTime(aTime);
        fConnectLogObj.setState(C_sState_DataAsync);
        fConnectLogObj.setEx(aEx);
        fConnectLogObj.setConfigObj(this.fConfigObj);
        if (aSaveLog) {
            this.fCacheLogUtils.saveLogAndDataAsyncObj(fConnectLogObj);
        } else {
            this.fCacheLogUtils.saveDataAsyncObj(fConnectLogObj);
        }
    }

    @Override
    public void saveDisConnectInfo(long aTime) {
        if (!CacheLogUtils.isSQLiteOK()) {
            return;
        }
        ConnectLogObj fConnectLogObj = new ConnectLogObj();
        fConnectLogObj.setConnectid(this.fStartId);
        fConnectLogObj.setTime(aTime);
        fConnectLogObj.setState(C_sState_DisConnect);
        fConnectLogObj.setConfigObj(this.fConfigObj);
        fConnectLogObj.setData("serverid=" + this.fRedisClientInfo.getId());
        this.fCacheLogUtils.saveConnectLogObj(fConnectLogObj);
    }

    private final void addConnectLog(String aStartId, long aTime, String aState, String aData) {
        if (!CacheLogUtils.isSQLiteOK()) {
            return;
        }
        ConnectLogObj fConnectLogObj = new ConnectLogObj();
        fConnectLogObj.setConnectid(aStartId);
        fConnectLogObj.setTime(aTime);
        fConnectLogObj.setState(aState);
        fConnectLogObj.setData(aData);
        fConnectLogObj.setConfigObj(this.fConfigObj);
        this.fCacheLogUtils.saveConnectLogObj(fConnectLogObj);
    }

    private final void saveLostConnectModifyData(String aStartId) {
        if (this.fModifyData == null || this.fModifyData.size() <= 0) {
            return;
        }
        StringBuilder fb = new StringBuilder();
        for (Map.Entry<String, Long> fEntry : this.fModifyData.entrySet()) {
            fb.append(fEntry.getKey());
            fb.append(":");
            fb.append(ConnectLogObj.getTimeStr(fEntry.getValue()));
            fb.append(";");
        }
        this.addConnectLog(aStartId, System.currentTimeMillis(), C_sState_ModifyData, fb.toString());
        this.fModifyData.clear();
    }

    private final boolean outOfStartTime(long aTime) {
        long ftemp = System.currentTimeMillis() - aTime;
        return ftemp > 60000L;
    }

    private final void reInit(Jedis aJedis, String aOldStartId) {
        this.saveLostConnectModifyData(aOldStartId);
        this.fConnectTime = null;
        this.fHeatBeatCount = 0L;
        this.initStartId(aJedis);
    }

    private final void resetDB(Jedis aJedis, String aStartId) {
        aJedis.flushDB();
        this.reInit(aJedis, aStartId);
    }

    private List<String> getClearCacheData(long aOutOfTime) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Long> fItem : this.fModifyData.entrySet()) {
            if (this.outOfStartTime(fItem.getValue())) continue;
            result.add(fItem.getKey());
        }
        return result;
    }

    private Long sendClearCacheData(Jedis aJedis, long aOutOfTime) {
        final List<String> fClearCacheData = this.getClearCacheData(aOutOfTime);
        if (fClearCacheData.size() <= 0) {
            return 0L;
        }
        Long resultCount = this.doRedisCall(aJedis, new IRedisCalls<Long>(){

            @Override
            public void doCalls(Pipeline aPL, List<Response<?>> aRsList) {
                String[] fDelKeys;
                int fStep = 300;
                ArrayListFixType fList = new ArrayListFixType(fStep, String.class);
                for (int i = 0; i < fClearCacheData.size(); ++i) {
                    if (i % fStep != 0 && i != 0) {
                        fDelKeys = (String[])fList.exportArray();
                        fList.clear();
                        aRsList.add(aPL.del(fDelKeys));
                    }
                    fList.add(fClearCacheData.get(i));
                }
                if (fList.size() > 0) {
                    fDelKeys = (String[])fList.exportArray();
                    aRsList.add(aPL.del(fDelKeys));
                }
            }

            @Override
            public Long onResult(List<Response<?>> aRsList) {
                Long result = 0L;
                for (Response<?> fItem : aRsList) {
                    if (fItem == null) continue;
                    result = result + (Long)fItem.get();
                }
                return result;
            }
        });
        return resultCount;
    }

    public final boolean reConnectRedisServer(Jedis aJedis) {
        String fOldStartId = this.fStartId;
        boolean result = this.fModifyData.size() <= 0;
        Long fOtherStartTime = this.toLocalTime(RedisClusterInfo.jedisGetLong(aJedis, "#capstarttime"));
        String fNowId = aJedis.get("#capstartid");
        if (StringUtils.isBlank((String)fNowId)) {
            this.reInit(aJedis, fOldStartId);
            return true;
        }
        if (!StringUtils.sameString((String)fNowId, (String)this.fStartId)) {
            if (fOtherStartTime == null) {
                this.reInit(aJedis, fOldStartId);
                return result;
            }
            if (this.outOfStartTime(fOtherStartTime)) {
                this.resetDB(aJedis, fOldStartId);
                return result;
            }
        }
        this.sendClearCacheData(aJedis, fOtherStartTime);
        this.reInit(aJedis, this.fStartId);
        return result;
    }

    private static final byte[] getKeyBytes(String aKey) {
        return RedisUtils.getKeyBytes(aKey);
    }

    private static final <T> T getResultValue(Response<?> aResponse, Class<T> aClass) {
        return RedisUtils.getResultValue(aResponse, aClass);
    }

    private static final Long getResultValueLong(Response<?> aResponse) {
        Object result = aResponse.get();
        if (result == null) {
            return null;
        }
        return RedisClusterInfo.bytesToLong((byte[])result);
    }

    private static final Long bytesToLong(byte[] aValue) {
        return RedisUtils.bytesToLong(aValue);
    }

    public static final byte[] long2Bytes(Long aValue) {
        return RedisUtils.long2Bytes(aValue);
    }

    public static final Long parseSeverTime(List<String> aData, boolean aNanoTime) {
        return RedisUtils.parseSeverTime(aData, aNanoTime);
    }

    private static final Response<Long> plSetNx(Pipeline aPL, String aKey, long aValue) {
        return aPL.setnx(RedisClusterInfo.getKeyBytes(aKey), RedisClusterInfo.long2Bytes(aValue));
    }

    private static final Response<Long> plHset(Pipeline aPL, String aKey, String aField, long aValue) {
        return aPL.hset(RedisClusterInfo.getKeyBytes(aKey), RedisClusterInfo.getKeyBytes(aField), RedisClusterInfo.long2Bytes(aValue));
    }

    protected static final Response<byte[]> plHget(Pipeline aPL, String aKey, String aField) {
        return aPL.hget(RedisClusterInfo.getKeyBytes(aKey), RedisClusterInfo.getKeyBytes(aField));
    }

    protected static final Response<byte[]> plget(Pipeline aPL, String aKey) {
        return aPL.get(RedisClusterInfo.getKeyBytes(aKey));
    }

    private static final Long jedisGetLong(Jedis aJedis, String aKey) {
        return RedisClusterInfo.bytesToLong(aJedis.get(RedisClusterInfo.getKeyBytes(aKey)));
    }

    public String getStartId() {
        return this.fStartId;
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    public Long getConnectTime() {
        return this.fConnectTime;
    }

    public long getHeatBeatCount() {
        return this.fHeatBeatCount;
    }

    public RedisClientInfo getMasterInfo() {
        return this.fMasterInfo;
    }

    public void setMasterInfo(RedisClientInfo aMasterInfo) {
        this.fMasterInfo = aMasterInfo;
    }

    public RedisClientInfo[] getSlaveArray() {
        return this.fSlaveArray;
    }

    public void setSlaveArray(RedisClientInfo[] aSlaveArray) {
        this.fSlaveArray = aSlaveArray;
    }

    static /* synthetic */ RedisClientInfo[] access$1402(RedisClusterInfo x0, RedisClientInfo[] x1) {
        x0.fSlaveArray = x1;
        return x1;
    }

    private static interface IRedisCalls<T> {
        public void doCalls(Pipeline var1, List<Response<?>> var2);

        public T onResult(List<Response<?>> var1);
    }
}

