/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl.redisobj;

import com.seeyon.cap4.cache.impl.redisobj.IRedisClusterInfo;
import com.seeyon.cap4.cache.impl.redisobj.RedisConfigObj;
import com.seeyon.cap4.cache.impl.redisobj.RedisLuaScriprt;
import com.seeyon.cap4.cache.impl.redisobj.RedisScriptException;
import com.seeyon.cap4.cache.impl.redisobj.RedisServerTime;
import com.seeyon.cap4.cache.impl.redisobj.RedisTaskObj;
import com.seeyon.cap4.cache.impl.redisobj.RedisUtils;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.songjian.utils.ArrayUtils;
import org.songjian.utils.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisConnection {
    private static final Log LOGGER = CtpLogFactory.getLog(RedisConnection.class);
    private RedisConfigObj fConfig;
    private IRedisClusterInfo fRedisClusterInfo;
    private String fName;
    private JedisPool fPool;
    private int fTTLSec;
    private int fMaxTaskLen;
    private LinkedBlockingQueue<RedisTaskObj> fQueue;
    private prvRedisThread fRedisThread;
    private AtomicInteger fTaskNo;
    private AtomicBoolean fDataAsync;
    private RedisServerTime fServerTime;
    private prvReconnectInfo fReconnectInfo;
    private AtomicBoolean fScriptError;
    private IHeartBreadTasksEvent fHeartBreadTasksEvent;
    public static final int C_iConnectState_None = 0;
    public static final int C_iConnectState_Connected = 1;
    public static final int C_iConnectState_Error = 2;
    public static final int C_iConnectState_Connecting = 3;
    private static final long C_lTime_Step = 4000L;
    public static final long fErrorReconnectTime = 16500L;
    private static RedisLuaScriprt[] fInitScripts;
    private static RedisLuaScriprt fPutDataVersion;
    private static RedisLuaScriprt fIncModifyCount;
    private static RedisLuaScriprt fGetLikeKeyValues;

    public String getName() {
        return this.fName;
    }

    public void setName(String aName) {
        this.fName = aName;
    }

    private void init() {
        this.fDataAsync = new AtomicBoolean(false);
        this.fReconnectInfo = new prvReconnectInfo();
        this.initPool();
        this.fTaskNo = new AtomicInteger(0);
        this.fMaxTaskLen = 100;
        this.fQueue = new LinkedBlockingQueue();
        this.fRedisThread = new prvRedisThread();
        this.fRedisThread.start();
        this.fServerTime = new RedisServerTime();
    }

    private void initPool() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxIdle(10);
        config.setMaxTotal(30);
        config.setMaxWaitMillis(3000L);
        this.fPool = new JedisPool((GenericObjectPoolConfig)config, this.fConfig.getHost(), this.fConfig.getPort(), 3000, this.fConfig.getPassword(), this.fConfig.getDatabase());
    }

    private void unInitPool() {
        if (this.fPool == null) {
            return;
        }
        this.fPool.close();
        this.fPool = null;
    }

    public RedisConnection(RedisConfigObj aConfig, IRedisClusterInfo aRedisClusterInfo) {
        this.fConfig = aConfig;
        this.fRedisClusterInfo = aRedisClusterInfo;
        this.fTTLSec = this.fConfig.getTTLSec();
        if (this.fTTLSec <= 0) {
            this.fTTLSec = 60;
        }
        this.fScriptError = new AtomicBoolean();
        this.init();
    }

    public boolean initStartId() {
        boolean bl;
        Jedis fJedis = null;
        fJedis = this.getJedisFromPool(false);
        if (fJedis == null) {
            return false;
        }
        try {
            bl = this.fRedisClusterInfo.initStartId(fJedis);
        }
        catch (Throwable throwable) {
            try {
                fJedis.close();
                throw throwable;
            }
            catch (JedisConnectionException ex) {
                this.fReconnectInfo.putOnErrorNoRaise(ex);
                return false;
            }
        }
        fJedis.close();
        return bl;
    }

    public int getMaxTaskLen() {
        return this.fMaxTaskLen;
    }

    public void setMaxTaskLen(int aMaxTaskLen) {
        this.fMaxTaskLen = aMaxTaskLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBatch(Jedis aJedis, RedisTaskObj[] aTasks, boolean aUseTTL) {
        ArrayList fRsList = new ArrayList();
        if (this.fScriptError.get()) {
            RedisUtils.loadLuaScript(aJedis, fInitScripts);
            this.fScriptError.set(false);
        }
        boolean fHasPutDataVersion = false;
        Pipeline fPL = aJedis.pipelined();
        try {
            block20: {
                fRsList.add(fPL.get(this.fRedisClusterInfo.getDataAsyncKey()));
                for (RedisTaskObj fTask : aTasks) {
                    block19: {
                        try {
                            if (RedisUtils.addRedisTask2Pl(fPL, fRsList, fTask, this.fTTLSec, aUseTTL)) {
                                fHasPutDataVersion = true;
                            }
                        }
                        catch (Exception ex) {
                            fTask.assignException(ex, 60000);
                            if (!RedisUtils.getClassDebug(RedisConnection.class)) break block19;
                            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                    }
                    RedisUtils.outDebug(StringUtils.isNoBlank((String)fTask.getSendLog()) ? "runBatch " + fTask.getSendLog() : null);
                }
                if (fHasPutDataVersion) {
                    try {
                        if (this.fHeartBreadTasksEvent != null) {
                            RedisUtils.addRedisTask2Pl(fPL, fRsList, RedisTaskObj.newIncModifyCount(this.fHeartBreadTasksEvent.getModifyKey()), this.fTTLSec, aUseTTL);
                        }
                    }
                    catch (Exception ex) {
                        if (!RedisUtils.getClassDebug(RedisConnection.class)) break block20;
                        LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            fPL.sync();
            this.readDataAsyn((Response)fRsList.get(0));
            for (int i = 0; i < aTasks.length; ++i) {
                RedisTaskObj fItem = aTasks[i];
                try {
                    RedisUtils.setTaskResult(fItem, (Response)fRsList.get(i + 1));
                }
                catch (RedisScriptException ex) {
                    this.fScriptError.set(true);
                    LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
                }
                fItem.notifyWaitTaskObj();
            }
        }
        finally {
            try {
                fPL.close();
            }
            catch (IOException iOException) {}
        }
    }

    public final int doTasksNoWait(RedisTaskObj ... aTasks) {
        return this.innerDoTasks(false, aTasks);
    }

    public final int innerDoTasks(boolean aWaitEnd, RedisTaskObj ... aTasks) {
        if (aTasks == null) {
            return -1;
        }
        RedisTaskObj fTaskObj = null;
        int fLen = aTasks.length - 1;
        for (int i = 0; i <= fLen; ++i) {
            fTaskObj = aTasks[i];
            RedisUtils.checkNull_Format(fTaskObj, "task is null,index=%d", i);
            if (i == fLen) {
                fTaskObj.setWaitNotify(true);
            }
            this.fQueue.add(fTaskObj);
        }
        if (fTaskObj == null) {
            return -1;
        }
        int result = this.fTaskNo.get();
        this.fRedisThread.notifyRunTask();
        if (aWaitEnd) {
            fTaskObj.waitTaskEnd();
        }
        return result;
    }

    public final int doTasks(RedisTaskObj ... aTasks) {
        return this.innerDoTasks(true, aTasks);
    }

    private void notifyWaitTaskObjs(RedisTaskObj[] aTasks, Exception aEx) {
        for (RedisTaskObj fItem : aTasks) {
            if (fItem == null) continue;
            fItem.assignException(aEx, 60000);
            fItem.notifyWaitTaskObj();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Jedis getJedisFromPool(boolean aRaise) {
        try {
            RedisConnection redisConnection = this;
            synchronized (redisConnection) {
                return this.fPool.getResource();
            }
        }
        catch (JedisConnectionException ex) {
            if (aRaise) {
                this.fReconnectInfo.putOnError(ex);
            } else {
                this.fReconnectInfo.putOnErrorNoRaise(ex);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callRedisTasks(RedisTaskObj ... aTasks) {
        if (aTasks == null) {
            return;
        }
        if (this.inConnectError()) {
            this.notifyWaitTaskObjs(aTasks, (Exception)((Object)new JedisConnectionException("inConnectError")));
            return;
        }
        Jedis fJedis = null;
        try {
            fJedis = this.getJedisFromPool(true);
        }
        catch (JedisConnectionException ex) {
            this.notifyWaitTaskObjs(aTasks, (Exception)((Object)ex));
            return;
        }
        this.fTaskNo.incrementAndGet();
        try {
            try {
                try {
                    this.runBatch(fJedis, aTasks, this.fTTLSec > 0);
                    this.fReconnectInfo.putConnectOK();
                }
                catch (JedisConnectionException jex) {
                    this.fReconnectInfo.putOnError(jex);
                }
            }
            catch (Exception ex) {
                for (RedisTaskObj fTask : aTasks) {
                    if (fTask == null) continue;
                    fTask.assignException(ex, 60000);
                    fTask.notifyWaitTaskObj();
                }
            }
        }
        finally {
            fJedis.close();
        }
    }

    public void uninit() {
        this.fRedisClusterInfo.saveDisConnectInfo(System.currentTimeMillis());
        this.fRedisThread.fShutdownHook.fThreadRun = false;
        this.fRedisThread.notifyRunTask();
        if (this.fHeartBreadTasksEvent != null) {
            this.fHeartBreadTasksEvent.uninit();
        }
        this.unInitPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getServerTime(boolean aNanoTime) {
        long l;
        block9: {
            Jedis fJedis = null;
            fJedis = this.getJedisFromPool(true);
            try {
                long result = 0L;
                for (String fStr : fJedis.time()) {
                    if (result == 0L) {
                        result = Long.parseLong(fStr);
                        continue;
                    }
                    if (aNanoTime) {
                        result = result * 1000000L + Long.parseLong(fStr);
                        continue;
                    }
                    result = result * 1000L + Long.parseLong(fStr) / 1000L;
                }
                l = result;
                if (fJedis == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fJedis != null) {
                        fJedis.close();
                    }
                    throw throwable;
                }
                catch (JedisConnectionException jex) {
                    this.fReconnectInfo.putOnError(jex);
                    return 0L;
                }
            }
            fJedis.close();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping() {
        boolean bl;
        long fTime = System.currentTimeMillis();
        Jedis fJedis = this.getJedisFromPool(false);
        if (fJedis == null) {
            return false;
        }
        try {
            if (this.fRedisClusterInfo == null) {
                fJedis.ping();
            } else {
                this.fRedisClusterInfo.sendHeartBeat(fJedis, this.fHeartBreadTasksEvent);
            }
            fTime = System.currentTimeMillis() - fTime;
            RedisUtils.notifyEvent(this.fRedisClusterInfo.getCacheMonitor(), 6, DateUtil.format((Date)DateUtil.currentDate()));
            this.fReconnectInfo.putHeartOK(fTime);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                fJedis.close();
                throw throwable;
            }
            catch (JedisConnectionException jex) {
                this.fReconnectInfo.putOnErrorNoRaise(jex);
                return false;
            }
        }
        fJedis.close();
        return bl;
    }

    public final long getCachedServerTime() {
        return this.fServerTime.getServerTime();
    }

    public final long toLocalTime(long aServerTime) {
        return this.fServerTime.toLocalTime(aServerTime);
    }

    public final boolean inConnectError() {
        return this.fReconnectInfo.inConnectError();
    }

    public boolean isDataAsync() {
        return this.fDataAsync.get();
    }

    private void readDataAsyn(Response<?> aResponse) {
        boolean flage;
        if (aResponse == null) {
            return;
        }
        if (aResponse.get() == null) {
            return;
        }
        String ftemp = (String)aResponse.get();
        if (StringUtils.isBlank((String)ftemp)) {
            return;
        }
        boolean result = Boolean.parseBoolean(ftemp);
        if (result && !(flage = this.fDataAsync.getAndSet(result))) {
            RedisUtils.notifyEvent(this.fRedisClusterInfo.getCacheMonitor(), 2, "DataAsync");
            this.fRedisClusterInfo.saveOnErrorInfo(System.currentTimeMillis(), new Exception("Data is asynchronized from redis server!"));
        }
    }

    private void writeDataAsync(boolean aDataAsyn) {
        if (!aDataAsyn) {
            return;
        }
        try {
            Jedis fJedis = null;
            fJedis = this.getJedisFromPool(true);
            try {
                fJedis.set(this.fRedisClusterInfo.getDataAsyncKey(), "true");
            }
            finally {
                if (fJedis != null) {
                    fJedis.close();
                }
            }
        }
        catch (JedisConnectionException jex) {
            this.fReconnectInfo.putOnError(jex);
        }
    }

    public boolean setDataAsync(boolean aDataAsyn) {
        boolean result = this.fDataAsync.getAndSet(aDataAsyn);
        if (!result && aDataAsyn) {
            RedisUtils.notifyEvent(this.fRedisClusterInfo.getCacheMonitor(), 2, "DataAsync");
        }
        this.writeDataAsync(aDataAsyn);
        return result;
    }

    public final IHeartBreadTasksEvent getHeartBreadTasksEvent() {
        return this.fHeartBreadTasksEvent;
    }

    public final void setHeartBreadTasksEvent(IHeartBreadTasksEvent aHeartBreadTasksEvent) {
        this.fHeartBreadTasksEvent = aHeartBreadTasksEvent;
    }

    public static final RedisLuaScriprt getPutDataVersion() {
        return fPutDataVersion;
    }

    public static final RedisLuaScriprt getIncModifyCount() {
        return fIncModifyCount;
    }

    public static final RedisLuaScriprt getGetLikeKeyValues() {
        return fGetLikeKeyValues;
    }

    private static final void initBaseScript() {
        fPutDataVersion = RedisUtils.initLuaScript(RedisConnection.class, "PutDataVersion.lua");
        fIncModifyCount = RedisUtils.initLuaScript(RedisConnection.class, "IncModifyCount.lua");
        fGetLikeKeyValues = RedisUtils.initLuaScript(RedisConnection.class, "GetLikeKeyValues.lua");
        fInitScripts = new RedisLuaScriprt[]{fPutDataVersion, fIncModifyCount, fGetLikeKeyValues};
    }

    public static final RedisLuaScriprt[] getInitScripts() {
        if (fInitScripts == null) {
            RedisConnection.initBaseScript();
        }
        return fInitScripts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> doGetLikeKeyValues(String aKey, Jedis aJedis) {
        Jedis fNow = aJedis == null ? this.fPool.getResource() : aJedis;
        try {
            ArrayList result;
            Object fTemp = null;
            fTemp = fNow.evalsha(fGetLikeKeyValues.getEvalSha(), 1, new String[]{aKey});
            ArrayList arrayList = result = (ArrayList)fTemp;
            return arrayList;
        }
        finally {
            if (aJedis == null) {
                fNow.close();
            }
        }
    }

    public final void setScriptError(boolean aValue) {
        this.fScriptError.set(aValue);
    }

    public final long getHeartBeatCost() {
        if (this.fReconnectInfo == null) {
            return -1L;
        }
        return this.fReconnectInfo.fHeartBeatCost;
    }

    public static interface IHeartBreadTasksEvent {
        public void doCustomEvent(Jedis var1, long var2, long var4);

        public String getModifyKey();

        public void uninit();
    }

    private class prvRedisThread
    extends Thread {
        prvShutdownHook fShutdownHook;

        private prvRedisThread() {
            this.setDaemon(true);
        }

        public final void notifyRunTask() {
            RedisUtils.notifyObject(this.fShutdownHook, true);
        }

        @Override
        public void run() {
            this.fShutdownHook = new prvShutdownHook();
            RedisUtils.addTerminalTask(this.fShutdownHook);
            ArrayList<RedisTaskObj> fList = new ArrayList<RedisTaskObj>(RedisConnection.this.fMaxTaskLen);
            RedisUtils.waitObject(this.fShutdownHook, 0L);
            while (this.fShutdownHook.fThreadRun) {
                try {
                    if (this.testIsEmpty()) {
                        RedisUtils.waitObject(this.fShutdownHook, 4000L);
                    }
                    RedisConnection.this.fReconnectInfo.doHeartBeat();
                    this.readTasks(fList);
                    if (fList.size() <= 0) continue;
                    RedisTaskObj[] fArray = (RedisTaskObj[])ArrayUtils.listToArray(fList, RedisTaskObj.class);
                    fList.clear();
                    RedisConnection.this.callRedisTasks(fArray);
                }
                catch (Throwable ex) {
                    LOGGER.error((Object)ex.getMessage(), ex);
                }
            }
        }

        private boolean testIsEmpty() {
            return RedisConnection.this.fQueue.isEmpty();
        }

        private void readTasks(ArrayList<RedisTaskObj> fList) {
            int i = 0;
            boolean result = true;
            do {
                RedisTaskObj fItem;
                if (result = RedisConnection.this.fQueue.isEmpty()) {
                    return;
                }
                try {
                    fItem = (RedisTaskObj)RedisConnection.this.fQueue.poll(1L, TimeUnit.MICROSECONDS);
                }
                catch (InterruptedException e) {
                    return;
                }
                fList.add(fItem);
            } while (++i < RedisConnection.this.fMaxTaskLen && !result);
        }
    }

    private class prvShutdownHook
    implements Runnable {
        private volatile boolean fThreadRun = true;

        @Override
        public void run() {
            this.fThreadRun = false;
        }
    }

    private class prvReconnectInfo {
        private long fPoolErrorTime;
        private int fConnectState;
        private long fHeartBeatTime;
        private long fHeartBeatCost;

        private prvReconnectInfo() {
            this.rest();
        }

        public final boolean inConnectError() {
            if (this.fConnectState != 2) {
                return false;
            }
            long ftemp = System.currentTimeMillis() - this.fPoolErrorTime;
            return 16500L > ftemp;
        }

        private void rest() {
            this.fPoolErrorTime = 0L;
            this.fConnectState = 0;
            this.fHeartBeatCost = -1L;
            RedisUtils.notifyEvent(RedisConnection.this.fRedisClusterInfo.getCacheMonitor(), 3, "redis_none");
            this.fHeartBeatTime = 0L;
        }

        private void putOnError(JedisConnectionException aEx) {
            this.putOnErrorNoRaise(aEx);
            throw aEx;
        }

        private void putOnErrorNoRaise(JedisConnectionException aEx) {
            this.fPoolErrorTime = System.currentTimeMillis();
            this.fConnectState = 2;
            RedisUtils.notifyEvent(RedisConnection.this.fRedisClusterInfo.getCacheMonitor(), 3, "redis_error");
            RedisConnection.this.fRedisClusterInfo.saveOnErrorInfo(System.currentTimeMillis(), (Exception)aEx);
            this.reConnect();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reConnect() {
            RedisConnection redisConnection = RedisConnection.this;
            synchronized (redisConnection) {
                try {
                    if (RedisConnection.this.fPool != null) {
                        RedisConnection.this.fPool.close();
                        RedisConnection.this.fPool = null;
                    }
                }
                catch (Exception ex) {
                    LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
                }
                try {
                    RedisConnection.this.initPool();
                }
                catch (Exception ex) {
                    LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }

        private void putConnectOK() {
            this.fConnectState = 1;
            RedisUtils.notifyEvent(RedisConnection.this.fRedisClusterInfo.getCacheMonitor(), 3, "redis_connected");
        }

        private void putHeartOK(long aCost) {
            this.fConnectState = 1;
            RedisUtils.notifyEvent(RedisConnection.this.fRedisClusterInfo.getCacheMonitor(), 3, "redis_connected");
            this.fHeartBeatTime = System.currentTimeMillis();
            this.fHeartBeatCost = aCost;
        }

        private void doHeartBeat() {
            long temp = System.currentTimeMillis() - this.fHeartBeatTime;
            if (4000L > temp) {
                RedisUtils.outDebug(RedisUtils.getClassDebug(RedisConnection.class) ? "skip hearBeat\r\n" : null);
                return;
            }
            boolean result = RedisConnection.this.ping();
            RedisUtils.outDebug(RedisUtils.getClassDebug(RedisConnection.class) ? String.format("hearBeat %s\r\n", result ? "ok" : "fail") : null);
        }
    }
}

