/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl.redisobj;

import com.seeyon.cap4.cache.impl.redisobj.RedisUtils;
import org.songjian.utils.ArrayUtils;
import org.songjian.utils.ErrorCodeException;
import org.songjian.utils.ExceptionUtils;

public class RedisTaskObj {
    private int fAction = 0;
    private String[] fKey;
    private String fKey2;
    private Object fValue;
    private Object fResult;
    private String fErrorMsg;
    private int fErrorCode = 0;
    private boolean fSuccess = true;
    private volatile boolean fWaitNotify;
    private volatile boolean fEndTask = false;
    private StackTraceElement[] fStackTrace = null;
    private String fSendLog;

    public String getKey2() {
        return this.fKey2;
    }

    public void setKey2(String aKey2) {
        this.fKey2 = aKey2;
    }

    public StackTraceElement[] getStackTrace() {
        return this.fStackTrace;
    }

    public void setStackTrace(StackTraceElement[] aStackTrace) {
        this.fStackTrace = aStackTrace;
    }

    public boolean isWaitNotify() {
        return this.fWaitNotify;
    }

    public void setWaitNotify(boolean aWaitNotify) {
        this.fWaitNotify = aWaitNotify;
    }

    public boolean isEndTask() {
        return this.fEndTask;
    }

    public void setEndTask(boolean aEndTask) {
        this.fEndTask = aEndTask;
    }

    public int getAction() {
        return this.fAction;
    }

    public void setAction(int aAction) {
        this.fAction = aAction;
    }

    public String getKey() {
        if (this.fKey == null) {
            return null;
        }
        return this.fKey[0];
    }

    public void setKey(String aKey) {
        this.fKey = aKey == null ? null : new String[]{aKey};
    }

    public void setKeys(String[] aKey) {
        this.fKey = aKey;
    }

    public String[] getKeys() {
        return this.fKey;
    }

    public Object getValue() {
        return this.fValue;
    }

    public void setValue(Object aValue) {
        this.fValue = aValue;
    }

    public Object getResult() {
        return this.fResult;
    }

    public void setResult(Object aResult) {
        this.fResult = aResult;
    }

    public String getErrorMsg() {
        return this.fErrorMsg;
    }

    public void setErrorMsg(String aErrorMsg) {
        this.fErrorMsg = aErrorMsg;
    }

    public int getErrorCode() {
        return this.fErrorCode;
    }

    public void setErrorCode(int aErrorCode) {
        this.fErrorCode = aErrorCode;
    }

    public boolean isSuccess() {
        return this.fSuccess;
    }

    public void setSuccess(boolean aSuccess) {
        this.fSuccess = aSuccess;
    }

    public String getSendLog() {
        return this.fSendLog;
    }

    public void setSendLog(String aSendLog) {
        this.fSendLog = aSendLog;
    }

    public static final RedisTaskObj newReadStrObj(String aKey) {
        RedisTaskObj result = new RedisTaskObj();
        result.setAction(2);
        result.setKey(aKey);
        return result;
    }

    public static final RedisTaskObj newReadId2Obj(String aId2, String aKey) {
        RedisTaskObj result = new RedisTaskObj();
        result.setAction(3);
        result.setKey(aId2);
        result.setKey2(aKey);
        return result;
    }

    public static final RedisTaskObj newHIncrBy(String aHKey, String aField, long aInc) {
        RedisTaskObj result = new RedisTaskObj();
        result.setAction(6);
        result.setKey(aHKey);
        result.setKey2(aField);
        result.setValue(aInc);
        return result;
    }

    public static final RedisTaskObj newHGet(String aHKey, String aField) {
        RedisTaskObj result = new RedisTaskObj();
        result.setAction(3);
        result.setKey(aHKey);
        result.setKey2(aField);
        return result;
    }

    public static final RedisTaskObj newHDel(String aHKey, String aField) {
        RedisTaskObj result = new RedisTaskObj();
        result.setAction(5);
        result.setKey(aHKey);
        result.setKey2(aField);
        return result;
    }

    public static final RedisTaskObj newWriteId2Obj(String aId2, String aKey, String aValue) {
        RedisTaskObj result = new RedisTaskObj();
        result.setAction(4);
        result.setKey(aId2);
        result.setKey2(aKey);
        result.fValue = aValue;
        return result;
    }

    public static final RedisTaskObj newHGetAll(String aHKey) {
        RedisTaskObj result = new RedisTaskObj();
        result.setAction(7);
        result.setKey(aHKey);
        return result;
    }

    public static final RedisTaskObj newDelId2Obj(String aId2, String aKey) {
        RedisTaskObj result = new RedisTaskObj();
        result.setAction(5);
        result.setKey(aId2);
        result.setKey2(aKey);
        return result;
    }

    public static final RedisTaskObj newDelKeysObj(String ... aKeys) {
        ExceptionUtils.assertFormatNot((boolean)ArrayUtils.isBlankArray((Object[])aKeys), (String)"keys is blank string array!", (Object[])new Object[0]);
        RedisTaskObj result = new RedisTaskObj();
        result.setAction(8);
        result.setKeys(aKeys);
        return result;
    }

    public static final RedisTaskObj newWriteStrObj(String aKey, String aValue) {
        RedisTaskObj result = new RedisTaskObj();
        result.setAction(1);
        result.setKey(aKey);
        result.fValue = aValue;
        return result;
    }

    public static final RedisTaskObj newReadLongObj(String aKey) {
        RedisTaskObj result = new RedisTaskObj();
        result.setAction(10);
        result.setKey(aKey);
        return result;
    }

    public static final RedisTaskObj newExpireTTLObj(String aKey, int aTTL) {
        RedisTaskObj result = new RedisTaskObj();
        result.setAction(11);
        result.setKey(aKey);
        result.setValue(aTTL);
        return result;
    }

    public static final RedisTaskObj newWriteLongObj(String aKey, Long aValue) {
        RedisTaskObj result = new RedisTaskObj();
        result.setAction(9);
        result.setKey(aKey);
        result.fValue = aValue;
        return result;
    }

    public static final RedisTaskObj newIncModifyCount(String aKey) {
        RedisTaskObj result = new RedisTaskObj();
        result.setAction(13);
        result.setKey(aKey);
        return result;
    }

    public static final RedisTaskObj newPutDataVersion(String aDataTypeKey, String aDataId, String aTTLKey, String aTTLHead) {
        RedisTaskObj result = new RedisTaskObj();
        result.setAction(14);
        String[] fKeys = new String[]{aDataTypeKey, aDataId, aTTLKey, aTTLHead};
        result.setKeys(fKeys);
        return result;
    }

    public final String asStringValue() {
        if (this.fValue == null) {
            return null;
        }
        return (String)this.fValue;
    }

    public final Long asLongValue() {
        if (this.fValue == null) {
            return null;
        }
        return (Long)this.fValue;
    }

    public final byte[] getLongValueBytes() {
        if (this.fValue == null) {
            return null;
        }
        return RedisUtils.long2Bytes((Long)this.fValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitTaskEnd() {
        this.fWaitNotify = true;
        while (!this.fEndTask) {
            RedisTaskObj redisTaskObj = this;
            synchronized (redisTaskObj) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public final void assignException(Exception aEx, int aErrorCode) {
        if (aEx instanceof ErrorCodeException) {
            this.setErrorCode(((ErrorCodeException)aEx).getErrorCode());
        } else {
            this.setErrorCode(aErrorCode);
        }
        this.fErrorMsg = aEx.getMessage();
        this.fSuccess = false;
        this.fEndTask = true;
        this.fStackTrace = aEx.getStackTrace();
    }

    public final void assignException(Exception aEx) {
        this.assignException(aEx, 99999);
    }

    public final void notifyWaitTaskObj() {
        if (!this.fWaitNotify) {
            return;
        }
        this.fEndTask = true;
        RedisUtils.notifyObject(this, true);
    }

    public final boolean isConnectionError() {
        if (this.fSuccess) {
            return false;
        }
        return this.fErrorCode == 60000;
    }

    public final void checkResultError() {
        if (this.fSuccess) {
            return;
        }
        ErrorCodeException fEx = RedisUtils.newErrorCodeExceptionStackTrace(this.fErrorCode, this.fErrorMsg, this.fStackTrace);
        ExceptionUtils.raiseException((Exception)fEx);
    }

    public final long toLongValue() {
        if (this.fValue == null) {
            return 0L;
        }
        return (Long)this.fValue;
    }
}

