/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl.redisobj;

import com.seeyon.cap4.cache.ConfigItem;
import com.seeyon.cap4.cache.ConfigItem_RemoteCache;
import com.seeyon.cap4.cache.impl.ICacheMonitor;
import com.seeyon.cap4.cache.impl.redisobj.CacheLogUtils;
import com.seeyon.cap4.cache.impl.redisobj.IRedisClusterInfo;
import com.seeyon.cap4.cache.impl.redisobj.IV5Environment;
import com.seeyon.cap4.cache.impl.redisobj.RedisClientInfo;
import com.seeyon.cap4.cache.impl.redisobj.RedisClusterInfo;
import com.seeyon.cap4.cache.impl.redisobj.RedisConfigObj;
import com.seeyon.cap4.cache.impl.redisobj.RedisConnection;
import com.seeyon.cap4.cache.impl.redisobj.RedisLuaScriprt;
import com.seeyon.cap4.cache.impl.redisobj.RedisScriptException;
import com.seeyon.cap4.cache.impl.redisobj.RedisServerTime;
import com.seeyon.cap4.cache.impl.redisobj.RedisTaskObj;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.songjian.utils.ErrorCodeException;
import org.songjian.utils.ExceptionUtils;
import org.songjian.utils.LogUtils;
import org.songjian.utils.ResultTwoValue;
import org.songjian.utils.StreamUtils;
import org.songjian.utils.json.JSONObject;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

public class RedisUtils {
    private static final Log LOGGER = CtpLogFactory.getLog(RedisUtils.class);
    private static boolean fDebug = false;
    public static final int C_iErrorCode_Network = 60000;
    public static final int C_iLogType_Message = 0;
    public static final int C_iLogType_Info = 1;
    public static final int C_iLogType_Trace = 2;
    public static final int C_iLogType_Debug = 3;
    public static final int C_iLogType_Warn = 4;
    public static final int C_iLogType_Error = 5;
    private static IV5Environment fV5Environment;
    private static final long C_lMax_Long = 9200000000000000000L;
    private static final long C_lMax_Setp = 100000L;
    private static prvTerminalThread fThread;

    public static IV5Environment getV5Environment() {
        return fV5Environment;
    }

    public static void setV5Environment(IV5Environment aV5Environment) {
        fV5Environment = aV5Environment;
    }

    public static RedisConnection newConnection(RedisConfigObj aConfig, IRedisClusterInfo aRedisClusterInfo) {
        return new RedisConnection(aConfig, aRedisClusterInfo);
    }

    public static String readString(RedisConnection aCon, String aKey) {
        RedisTaskObj fTask = RedisTaskObj.newReadStrObj(aKey);
        aCon.doTasks(fTask);
        if (!fTask.isSuccess()) {
            RedisUtils.raiseErrorCodeException(fTask.getErrorCode(), fTask.getErrorMsg());
        }
        try {
            return (String)fTask.getResult();
        }
        catch (Exception ex) {
            ExceptionUtils.raiseException((Exception)ex);
            return null;
        }
    }

    public static void writeString(RedisConnection aCon, String aKey, String aValue) {
        RedisTaskObj fTask = RedisTaskObj.newWriteStrObj(aKey, aValue);
        aCon.doTasks(fTask);
        if (!fTask.isSuccess()) {
            RedisUtils.raiseErrorCodeException(fTask.getErrorCode(), fTask.getErrorMsg());
        }
    }

    public static void doBatch(RedisConnection aCon, RedisTaskObj ... aTasks) {
        aCon.doTasks(aTasks);
        for (RedisTaskObj fTaskObj : aTasks) {
            if (fTaskObj.isSuccess()) continue;
            RedisUtils.raiseErrorCodeException(fTaskObj.getErrorCode(), fTaskObj.getErrorMsg());
        }
    }

    public static void postTask(RedisConnection aCon, RedisTaskObj ... aTasks) {
    }

    public static void delKeys(RedisConnection aCon, String ... aKeys) {
        RedisTaskObj fTask = RedisTaskObj.newDelKeysObj(aKeys);
        aCon.doTasks(fTask);
        if (!fTask.isSuccess()) {
            RedisUtils.raiseErrorCodeException(fTask.getErrorCode(), fTask.getErrorMsg());
        }
    }

    public static long getServerTime(RedisConnection aCon, boolean aNano) {
        return aCon.getServerTime(aNano);
    }

    public static byte[] long2Bytes(Long aValue) {
        ByteBuffer fBuffer = ByteBuffer.allocate(8);
        fBuffer.putLong(0, aValue);
        byte[] result = fBuffer.array();
        return result;
    }

    public static byte[] getKeyBytes(String aKey) {
        ExceptionUtils.checkBlankStr((String)aKey, (String)"key");
        try {
            return aKey.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Long parseSeverTime(List<String> aData, boolean aNanoTime) {
        if (aData == null) {
            return null;
        }
        Long result = 0L;
        for (String fStr : aData) {
            if (result == 0L) {
                result = Long.parseLong(fStr);
                continue;
            }
            if (aNanoTime) {
                result = result * 1000000L + Long.parseLong(fStr);
                continue;
            }
            result = result * 1000L + Long.parseLong(fStr) / 1000L;
        }
        return result;
    }

    public static <T> T getResultValue(Response<?> aResponse, Class<T> aClass) {
        if (aResponse == null) {
            return null;
        }
        return (T)aResponse.get();
    }

    public static long getResultStrLong(Response<?> aResponse, long aDefault) {
        if (aResponse == null) {
            return aDefault;
        }
        String fValue = (String)aResponse.get();
        try {
            return Long.parseLong(fValue);
        }
        catch (Exception ex) {
            return aDefault;
        }
    }

    public static final long resetlong(long aValue) {
        if (aValue < 9200000000000000000L) {
            return aValue;
        }
        if (aValue % 100000L == 0L) {
            return 0L;
        }
        return aValue;
    }

    public static Long bytesToLong(byte[] aValue) {
        if (aValue == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(aValue, 0, aValue.length);
        buffer.flip();
        Long result = buffer.getLong();
        return result;
    }

    public static void raiseErrorCodeException(int aErrorCode, String aMessage) {
        throw new ErrorCodeException(aErrorCode, aMessage);
    }

    public static void checkNull_Format(Object aValue, String aFormat, Object ... args) {
        if (aValue == null) {
            ExceptionUtils.raiseExceptionFormat((String)aFormat, (Object[])args);
        }
    }

    public static boolean getClassDebug(Class<?> aClass) {
        return fDebug;
    }

    public static void outDebug(String aMsg) {
        if (aMsg == null) {
            return;
        }
        RedisUtils.outLog(aMsg, 3);
    }

    public static void outLog(String aMsg, int aType) {
        switch (aType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                LogUtils.outDebugFmt((String)aMsg, (Object[])new Object[0]);
                break;
            }
            default: {
                LogUtils.outLog((int)LogUtils.C_iOutType_Error, (String)aMsg);
            }
        }
    }

    public static void outDebugClass(Class<?> aClass, String aMsg, boolean ... aFlags) {
        if (aMsg == null) {
            return;
        }
        RedisUtils.outDebug("[" + aClass.getName() + "]" + aMsg);
    }

    public static ErrorCodeException newErrorCodeExceptionStackTrace(int aErrorCode, String aMsg, StackTraceElement[] aStackTrace) {
        ErrorCodeException result = new ErrorCodeException(aErrorCode, aMsg);
        result.setStackTrace(aStackTrace);
        return result;
    }

    public static synchronized void addTerminalTask(Runnable aRunnable) {
        if (aRunnable == null) {
            return;
        }
        if (fThread == null) {
            fThread = new prvTerminalThread();
            Runtime.getRuntime().addShutdownHook(fThread);
        }
        fThread.fList.add(aRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitObject(Object aObj, long aTime) {
        try {
            Object object = aObj;
            synchronized (object) {
                aObj.wait(aTime);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyObject(Object aObj, boolean aAll) {
        Object object = aObj;
        synchronized (object) {
            if (aAll) {
                aObj.notifyAll();
            } else {
                aObj.notify();
            }
        }
    }

    public static void notifyEvent(ICacheMonitor aMonitor, int aEvent, String aState) {
        if (aMonitor == null) {
            return;
        }
        aMonitor.notifyEvent(aEvent, aState);
    }

    public static ResultTwoValue<RedisConfigObj, RedisClusterInfo> makeRedisConConfigs(ConfigItem aConfigItem, CacheLogUtils aCacheLogUtils, ICacheMonitor aCacheMonitor) {
        ResultTwoValue result = new ResultTwoValue();
        RedisClientInfo fSalfClientInfo = new RedisClientInfo();
        ConfigItem_RemoteCache fConfigItem_RemoteCache = aConfigItem.getRemoteCacheInfo();
        IV5Environment fEnvironment = RedisUtils.getV5Environment();
        RedisConfigObj fConfig = new RedisConfigObj();
        fConfig.setHost(fEnvironment.getRedisHost());
        fConfig.setPort(fEnvironment.getRedisPort());
        fConfig.setPassword(fEnvironment.getRedisPass());
        fConfig.setName(fEnvironment.getRedisServerName());
        fConfig.setDatabase(fEnvironment.getRedisDB());
        fConfig.setNotifyHost(fEnvironment.getNotifyHost());
        fConfig.setNotifyPort(fEnvironment.getNotifyPort());
        fConfig.setTTL(fConfigItem_RemoteCache.getTTL());
        result.Value1 = fConfig;
        if (!fConfig.isVaild()) {
            ExceptionUtils.raiseException((String)"vaild redis config!");
        }
        fSalfClientInfo.setId(fEnvironment.getServerId());
        RedisClusterInfo fRedisClusterInfo = new RedisClusterInfo(fSalfClientInfo, fConfig, new RedisServerTime(), aCacheLogUtils, RedisConnection.getInitScripts());
        fRedisClusterInfo.setCacheMonitor(aCacheMonitor);
        JSONObject fConfigObj = new JSONObject();
        fConfigObj.put("redis_host", (Object)fEnvironment.getRedisHost());
        fConfigObj.put("redis_port", (Object)fEnvironment.getRedisPort());
        fConfigObj.put("serverid", (Object)fEnvironment.getServerId());
        fConfigObj.put("logfile", (Object)CacheLogUtils.makeSaveFile());
        RedisUtils.notifyEvent(aCacheMonitor, 4, fConfigObj.toJSONString());
        result.Value2 = fRedisClusterInfo;
        return result;
    }

    public static final boolean addRedisTask2Pl(Pipeline aPL, List<Response<?>> aRsList, RedisTaskObj aTask, int aTTLSec, boolean aUseTTL) throws UnsupportedEncodingException {
        boolean result = false;
        switch (aTask.getAction()) {
            case 1: {
                if (aUseTTL) {
                    aRsList.add(aPL.setex(aTask.getKey(), aTTLSec, aTask.asStringValue()));
                    break;
                }
                aRsList.add(aPL.set(aTask.getKey(), aTask.asStringValue()));
                break;
            }
            case 2: {
                aRsList.add(aPL.get(aTask.getKey()));
                break;
            }
            case 8: {
                aRsList.add(aPL.del(aTask.getKeys()));
                break;
            }
            case 3: {
                aRsList.add(aPL.hget(aTask.getKey(), aTask.getKey2()));
                break;
            }
            case 4: {
                aRsList.add(aPL.hset(aTask.getKey(), aTask.getKey2(), aTask.asStringValue()));
                break;
            }
            case 5: {
                aRsList.add(aPL.hdel(aTask.getKey(), new String[]{aTask.getKey2()}));
                break;
            }
            case 6: {
                aRsList.add(aPL.hincrBy(aTask.getKey(), aTask.getKey2(), aTask.toLongValue()));
                break;
            }
            case 7: {
                aRsList.add(aPL.hgetAll(aTask.getKey()));
                break;
            }
            case 9: {
                if (aUseTTL) {
                    aRsList.add(aPL.setex(aTask.getKey().getBytes("UTF-8"), aTTLSec, aTask.getLongValueBytes()));
                    break;
                }
                aRsList.add(aPL.set(aTask.getKey().getBytes("UTF-8"), aTask.getLongValueBytes()));
                break;
            }
            case 10: {
                aRsList.add(aPL.get(aTask.getKey().getBytes("UTF-8")));
                break;
            }
            case 11: {
                aRsList.add(aPL.expire(aTask.getKey(), ((Integer)aTask.getValue()).intValue()));
                break;
            }
            case 12: {
                aRsList.add(aPL.evalsha(RedisConnection.getGetLikeKeyValues().getEvalSha(), 1, new String[]{aTask.getKey()}));
                break;
            }
            case 13: {
                aRsList.add(aPL.evalsha(RedisConnection.getIncModifyCount().getEvalSha(), 1, new String[]{aTask.getKey()}));
                break;
            }
            case 14: {
                result = true;
                aRsList.add(aPL.evalsha(RedisConnection.getPutDataVersion().getEvalSha(), 4, aTask.getKeys()));
                break;
            }
            default: {
                ExceptionUtils.raiseExceptionUnkownType((String)("action " + aTask.getAction()));
            }
        }
        return result;
    }

    private static final Object getResultValue(Response<?> aResponse) {
        if (aResponse == null) {
            return null;
        }
        return aResponse.get();
    }

    public static final void setTaskResult(RedisTaskObj aTask, Response<?> aResult) {
        switch (aTask.getAction()) {
            case 10: {
                aTask.setResult(RedisUtils.bytesToLong((byte[])RedisUtils.getResultValue(aResult)));
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                try {
                    aTask.setResult(RedisUtils.getResultValue(aResult));
                    break;
                }
                catch (RuntimeException ex) {
                    throw new RedisScriptException(ex);
                }
            }
            default: {
                aTask.setResult(RedisUtils.getResultValue(aResult));
            }
        }
    }

    public static final RedisLuaScriprt initLuaScript(Class<?> aClass, String aResourceName) {
        RedisLuaScriprt result = new RedisLuaScriprt();
        result.setScriptName(aResourceName);
        String fFileName = StreamUtils.getPackageResourceName(aClass, (String)aResourceName);
        String fLuaScript = StreamUtils.readResourceText((String)fFileName, (String)"UTF-8", (boolean)true);
        ExceptionUtils.assertBlank((String)fLuaScript, (String)fFileName);
        result.setScriptText(fLuaScript);
        return result;
    }

    public static void loadLuaScript(Jedis aJedis, RedisLuaScriprt[] aInitScripts) {
        if (aInitScripts == null) {
            return;
        }
        for (RedisLuaScriprt fLuaSciprt : aInitScripts) {
            String fSha = aJedis.scriptLoad(fLuaSciprt.getScriptText());
            fLuaSciprt.setEvalSha(fSha);
        }
    }

    private static class prvTerminalThread
    extends Thread {
        private List<Runnable> fList;

        private prvTerminalThread() {
            this.setName("TerminalTaskThread");
            this.fList = new ArrayList<Runnable>();
        }

        @Override
        public void run() {
            for (Runnable fRunnable : this.fList) {
                if (fRunnable == null) continue;
                try {
                    fRunnable.run();
                }
                catch (Exception ex) {
                    LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }
}

