/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.impl.redisobj;

import com.seeyon.cap4.cache.impl.redisobj.IV5Environment;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.cache.redis.RedisConfig;
import com.seeyon.ctp.common.cache.redis.RedisHandler;
import java.io.File;
import java.io.IOException;
import org.songjian.utils.ExceptionUtils;
import org.songjian.utils.StreamUtils;
import org.songjian.utils.StringUtils;

public class V5Environment_Run
implements IV5Environment {
    private RedisConfig fRedisConfig;
    private String fNotifyHost;
    private int fNotifyPort;
    private String fServerId;

    public V5Environment_Run() {
        this.init();
    }

    @Override
    public String getServerId() {
        return this.fServerId;
    }

    @Override
    public String getRedisHost() {
        return this.fRedisConfig == null ? null : this.fRedisConfig.getIpAddress();
    }

    @Override
    public int getRedisPort() {
        return this.fRedisConfig == null ? -1 : this.fRedisConfig.getPort();
    }

    @Override
    public String getRedisPass() {
        return this.fRedisConfig == null ? null : this.fRedisConfig.getPassword();
    }

    @Override
    public String getRedisServerName() {
        return "CAP4_DataCache";
    }

    @Override
    public int getRedisDB() {
        return this.fRedisConfig == null ? -1 : this.fRedisConfig.getDbIndex();
    }

    @Override
    public String getNotifyHost() {
        return this.fNotifyHost;
    }

    @Override
    public int getNotifyPort() {
        return this.fNotifyPort;
    }

    @Override
    public boolean hasV5Cluster() {
        return SystemEnvironment.isClusterEnabled();
    }

    @Override
    public String getLocalSavePath() {
        return SystemEnvironment.getBaseFolder();
    }

    @Override
    public boolean hasRedis() {
        if (this.fRedisConfig == null) {
            return false;
        }
        if (StringUtils.isBlank((String)this.fRedisConfig.getIpAddress())) {
            return false;
        }
        if (StringUtils.isBlank((String)this.fServerId)) {
            return false;
        }
        if (StringUtils.isBlank((String)this.fRedisConfig.getIpAddress())) {
            return false;
        }
        if (this.fRedisConfig.getPort() <= 0) {
            return false;
        }
        return this.fRedisConfig.getDbIndex() >= 0;
    }

    private final void init() {
        this.fRedisConfig = RedisHandler.getRedisConfigForCAP();
        this.fServerId = this.initServerId();
    }

    private static final String getTimeStampStr() {
        StringBuilder result = new StringBuilder(10);
        long fTime = System.currentTimeMillis();
        do {
            int ftemp = (int)(fTime % 62L);
            ftemp = ftemp < 10 ? 48 + ftemp : (ftemp < 36 ? 55 + ftemp : 61 + ftemp);
            result.append((char)ftemp);
        } while ((fTime /= 62L) != 0L);
        return result.toString();
    }

    private final String initServerId() {
        String result = null;
        File fServerIdFile = new File(SystemEnvironment.getBaseFolder());
        if (!(fServerIdFile = new File(fServerIdFile, "capcache")).exists()) {
            fServerIdFile.mkdirs();
        }
        if ((fServerIdFile = new File(fServerIdFile, "serverid.properties")).exists()) {
            result = StringUtils.readFileString((File)fServerIdFile, (String)"UTF-8").trim();
        }
        if (StringUtils.isBlank(result)) {
            result = StringUtils.createValueName((int)10) + V5Environment_Run.getTimeStampStr();
            try {
                StreamUtils.writeStringToFile((String)fServerIdFile.getPath(), (String)result, (String)"UTF-8");
            }
            catch (IOException ex) {
                ExceptionUtils.raiseException((Exception)ex);
            }
        }
        return result;
    }
}

