/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.map;

import com.seeyon.cap4.cache.bean.BeanCacheObject;
import com.seeyon.cap4.cache.impl.LocalCacheManager;
import com.seeyon.cap4.cache.inf.ICacheManager;
import com.seeyon.cap4.cache.inf.ICacheObjectLoader;
import com.seeyon.cap4.cache.map.MapEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class BeanCacheMap<K, T extends BeanCacheObject<V>, V, C>
implements ConcurrentMap<K, V> {
    private ICacheManager<T, C> cmgr = new LocalCacheManager();
    private ConcurrentMap<K, K> keyMap;
    private C context;

    public BeanCacheMap(ICacheObjectLoader<T, C> loader, C context) {
        this.cmgr.setObjectLoader(loader);
        this.keyMap = new ConcurrentHashMap<K, K>();
        this.context = context;
    }

    @Override
    public int size() {
        return this.keyMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keyMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        BeanCacheObject<Object> t = new BeanCacheObject<Object>();
        t.setV(value);
        return this.cmgr.containsValue(t);
    }

    @Override
    public V get(Object key) {
        if (!this.keyMap.containsKey(key)) {
            return null;
        }
        return this.getFromCache(key);
    }

    private V getFromCache(Object key) {
        BeanCacheObject t = (BeanCacheObject)this.cmgr.getFromCache(key.toString(), this.context);
        if (t != null) {
            return t.getV();
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        this.putToCache(key, value);
        return null;
    }

    private void putToCache(K key, V value) {
        BeanCacheObject<V> t = new BeanCacheObject<V>();
        t.setV(value);
        t.setSign(String.valueOf(System.currentTimeMillis()));
        this.cmgr.put2Cache(key.toString(), t);
        this.keyMap.put(key, key);
    }

    @Override
    public V remove(Object key) {
        if (this.cmgr.containsKey(key.toString())) {
            this.keyMap.remove(key);
            this.cmgr.remove(key.toString());
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> et : m.entrySet()) {
            this.putToCache(et.getKey(), et.getValue());
        }
    }

    @Override
    public void clear() {
        for (Object key : this.keyMap.keySet()) {
            this.cmgr.remove(key.toString());
        }
        this.keyMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.keyMap.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> list = new ArrayList<V>();
        for (Object key : this.keyMap.keySet()) {
            list.add(this.get(key));
        }
        return list;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>();
        for (Object key : this.keyMap.keySet()) {
            set.add(new MapEntry(key, this.get(key)));
        }
        return set;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (this.containsKey(key)) {
            return this.get(key);
        }
        return this.put(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (this.keyMap.containsKey(key) && this.containsValue(value)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (this.keyMap.containsKey(key) && this.containsValue(oldValue)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        if (this.keyMap.containsKey(key)) {
            return this.put(key, value);
        }
        return null;
    }
}

