/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cache.map;

import com.seeyon.cap4.cache.map.MapEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class SubBeanCacheMap<K, V>
implements ConcurrentMap<K, V> {
    private ConcurrentMap<K, Long> keyIdMap = new ConcurrentHashMap<K, Long>();

    public ConcurrentMap<K, Long> getKeyIdMap() {
        return this.keyIdMap;
    }

    @Override
    public int size() {
        return this.keyIdMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keyIdMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyIdMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    public abstract V getBeanFromMasterMap(K var1, Long var2);

    @Override
    public V get(Object key) {
        return this.keyIdMap.get(key) == null ? null : (V)this.getBeanFromMasterMap(key, (Long)this.keyIdMap.get(key));
    }

    @Override
    @Deprecated
    public V put(K key, V value) {
        return null;
    }

    public V put(K key, V value, Long formId) {
        this.keyIdMap.put(key, formId);
        if (this.containsKey(key)) {
            return value;
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        this.keyIdMap.remove(key);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> et : m.entrySet()) {
            this.put(et.getKey(), et.getValue());
        }
    }

    @Override
    public void clear() {
        this.keyIdMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.keyIdMap.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> list = new ArrayList<V>();
        for (Object key : this.keyIdMap.keySet()) {
            list.add(this.get(key));
        }
        return list;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>();
        for (Object key : this.keyIdMap.keySet()) {
            set.add(new MapEntry(key, this.get(key)));
        }
        return set;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (this.containsKey(key)) {
            return this.get(key);
        }
        return this.put(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.keyIdMap.remove(key);
        return false;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.replace(key, newValue);
        return true;
    }

    @Override
    public V replace(K key, V value) {
        if (this.keyIdMap.containsKey(key)) {
            this.put(key, value);
        }
        return null;
    }
}

