/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.cluster.listener;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.control.ControlManager;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.service.CAP4FormCache;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateClusterManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.bean.FormSerialNumberBean;
import com.seeyon.ctp.form.po.FormCustomFunction;
import com.seeyon.ctp.form.po.FormOwner;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.HandleNotification;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;

public class FormNotificationHandler {
    private CAP4FormCacheManager cap4FormCacheManager;
    private FormCacheManager formCacheManager;
    private CAPBusinessTemplateClusterManager capBusinessTemplateClusterManager;
    private ControlManager controlManager;
    private BusinessManager businessManager4;
    private static final Log LOGGER = CtpLogFactory.getLog(FormNotificationHandler.class);

    @HandleNotification(type=NotificationType.CapFormAppReload)
    public void updateFormCache(Object obj) throws BusinessException {
        LOGGER.info((Object)"===========================\u6536\u5230\u901a\u77e5=================================");
        LOGGER.info((Object)("CAP4\u63a5\u53d7\u8868\u5355\u7f13\u5b58\u540c\u6b65\u901a\u77e5:type-" + ((CAP4FormCache.FormCacheType)((Object)((List)obj).get(0))).name() + "  obj:" + JSONUtil.toJSONString(((List)obj).get(1))));
        LOGGER.info((Object)"===========================\u5f00\u59cb\u6267\u884c=================================");
        if (this.cap4FormCacheManager.initTag) {
            LOGGER.info((Object)"\u5f53\u524d\u73af\u5883\u6b63\u5728\u542f\u52a8CAP4\u8868\u5355\u8fc7\u7a0b\u4e2d\uff0c\u6d88\u606f\u5148\u653e\u5165\u4e34\u65f6\u5217\u8868\uff0c\u542f\u52a8\u4e4b\u540e\u518d\u505a\u5904\u7406");
            this.cap4FormCacheManager.initUndoMessages.add(obj);
            return;
        }
        if (obj instanceof List) {
            CAP4FormCache.FormCacheType type = (CAP4FormCache.FormCacheType)((Object)((List)obj).get(0));
            Object o = ((List)obj).get(1);
            switch (type) {
                case CustomControl_Reload: {
                    this.controlManager.reloadControl(o.toString(), false);
                    break;
                }
                case CustomFunction_Reload: {
                    String[] param;
                    if (StringUtil.checkNull((String)((String)o)) || (param = ((String)o).split("_")).length <= 1) break;
                    Long formId = Long.parseLong(param[0]);
                    Long customFunId = Long.parseLong(param[1]);
                    int auditState = Integer.parseInt(param[2]);
                    FormBean form = this.cap4FormCacheManager.getForm(formId);
                    List<FormCustomFunction> list = form.getCustomFunctionList();
                    if (!Strings.isNotEmpty((Collection)list)) break;
                    for (FormCustomFunction function : list) {
                        if (!customFunId.equals(function.getId())) continue;
                        function.setAuditState(Integer.valueOf(auditState));
                    }
                    list = this.cap4FormCacheManager.getFormCustomFunction(form.getId());
                    if (!Strings.isNotEmpty(list)) break;
                    for (FormCustomFunction function : list) {
                        if (!customFunId.equals(function.getId())) continue;
                        function.setAuditState(Integer.valueOf(auditState));
                    }
                    break;
                }
                case Form_init: {
                    this.cap4FormCacheManager.initForm((Long)o, false);
                    break;
                }
                case Form_remove: {
                    this.cap4FormCacheManager.removeFormBean((Long)o, false);
                    break;
                }
                case SerialNum_add: {
                    FormSerialNumberBean fsnb = (FormSerialNumberBean)o;
                    this.formCacheManager.addFormSerialNumberBean(fsnb.getId().longValue(), fsnb, false);
                    break;
                }
                case SerialNum_remove: {
                    this.formCacheManager.removeFormSerialNumberBean(((Long)o).longValue(), false);
                    break;
                }
                case Change_owner: {
                    String[] param;
                    if (StringUtil.checkNull((String)((String)o)) || (param = ((String)o).split("_")).length <= 1) break;
                    Long formId = Long.parseLong(param[0]);
                    Long newOwnerId = Long.parseLong(param[1]);
                    FormOwner formOwner = this.cap4FormCacheManager.getFormOwner(formId);
                    FormBean form = this.cap4FormCacheManager.getForm(formId);
                    formOwner.setOwnerId(newOwnerId);
                    form.setOwnerId(newOwnerId.longValue());
                    break;
                }
                case FromBizConfig_Reload: {
                    this.businessManager4.initBizConfig((Long)o, false);
                    break;
                }
                case CustomTemplate_Delete_Template: {
                    this.capBusinessTemplateClusterManager.receiveDeleteTemplate(o);
                    break;
                }
                case CustomTemplate_Download_Template: {
                    this.capBusinessTemplateClusterManager.receiveDownloadTemplate(o);
                    break;
                }
                case CustomTemplate_Modify_Config: {
                    this.capBusinessTemplateClusterManager.receiveModifyConfig(o);
                    break;
                }
                case CustomTemplate_Import_Business: {
                    this.capBusinessTemplateClusterManager.receiveImportBusiness(o);
                    break;
                }
                case CustomTemplate_Copy_Template: {
                    this.capBusinessTemplateClusterManager.receiveCopyTemplate(o);
                    break;
                }
                case CustomTemplate_Save_Editable_Template: {
                    this.capBusinessTemplateClusterManager.receiveSaveEditableTemplate(o);
                    break;
                }
                case BizConfig_Valid_ModiFied: {
                    BizConfigBean bizConfigBean = (BizConfigBean)o;
                    BizConfigBean bizConfigBean1 = this.businessManager4.findBizConfigById(bizConfigBean.getId());
                    if (bizConfigBean1 == null) break;
                    bizConfigBean1.setValid(bizConfigBean.isValid());
                }
            }
        }
        LOGGER.info((Object)"===========================\u6267\u884c\u7ed3\u675f=================================");
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public void setCapBusinessTemplateClusterManager(CAPBusinessTemplateClusterManager capBusinessTemplateClusterManager) {
        this.capBusinessTemplateClusterManager = capBusinessTemplateClusterManager;
    }

    public void setControlManager(ControlManager controlManager) {
        this.controlManager = controlManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }
}

